"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsSceneContextMenuEvent(PySide6.QtWidgets.QGraphicsSceneEvent):
    """
    https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html

    **Detailed Description**

    A **QContextMenuEvent**  received by a **QGraphicsView**  is translated into
    a QGraphicsSceneContextMenuEvent. The **QContextMenuEvent::globalPos** () is
    translated into item, scene, and screen coordinates (**pos** (),
    **scenePos** (), and **screenPos** ()).

    **See also** **QGraphicsSceneMouseEvent** , **QGraphicsSceneWheelEvent** ,
    and **QContextMenuEvent** .
    """

    Mouse: QGraphicsSceneContextMenuEvent.Reason = ...
    Keyboard: QGraphicsSceneContextMenuEvent.Reason = ...
    Other: QGraphicsSceneContextMenuEvent.Reason = ...

    class Reason(Enum):
        Mouse: QGraphicsSceneContextMenuEvent.Reason = ...
        Keyboard: QGraphicsSceneContextMenuEvent.Reason = ...
        Other: QGraphicsSceneContextMenuEvent.Reason = ...

    def __init__(self, type: Optional[PySide6.QtCore.QEvent.Type] = ...) -> None:
        ...

    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#modifiers

        **Qt::KeyboardModifiers QGraphicsSceneContextMenuEvent::modifiers()
        const**

        Returns the keyboard modifiers in use when the context menu was
        requested.
        """
        ...

    def pos(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#pos

        **QPointF QGraphicsSceneContextMenuEvent::pos() const**

        Returns the position of the mouse cursor in item coordinates at the
        moment the context menu was requested.

        **See also** **scenePos** () and **screenPos** ().
        """
        ...

    def reason(self) -> PySide6.QtWidgets.QGraphicsSceneContextMenuEvent.Reason:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#reason

        **QGraphicsSceneContextMenuEvent::Reason
        QGraphicsSceneContextMenuEvent::reason() const**

        Returns the reason for the context menu event.

        **See also** **QGraphicsSceneContextMenuEvent::Reason** .
        """
        ...

    def scenePos(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#scenePos

        **QPointF QGraphicsSceneContextMenuEvent::scenePos() const**

        Returns the position of the mouse cursor in scene coordinates at the
        moment the context menu was requested.

        **See also** **pos** () and **screenPos** ().
        """
        ...

    def screenPos(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#screenPos

        **QPoint QGraphicsSceneContextMenuEvent::screenPos() const**

        Returns the position of the mouse cursor in screen coordinates at the
        moment the context menu was requested.

        **See also** **pos** () and **scenePos** ().
        """
        ...

    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifiers) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#modifiers

        **Qt::KeyboardModifiers QGraphicsSceneContextMenuEvent::modifiers()
        const**

        Returns the keyboard modifiers in use when the context menu was
        requested.
        """
        ...

    def setPos(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#pos

        **QPointF QGraphicsSceneContextMenuEvent::pos() const**

        Returns the position of the mouse cursor in item coordinates at the
        moment the context menu was requested.

        **See also** **scenePos** () and **screenPos** ().
        """
        ...

    def setReason(
        self, reason: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent.Reason
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#reason

        **QGraphicsSceneContextMenuEvent::Reason
        QGraphicsSceneContextMenuEvent::reason() const**

        Returns the reason for the context menu event.

        **See also** **QGraphicsSceneContextMenuEvent::Reason** .
        """
        ...

    def setScenePos(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#scenePos

        **QPointF QGraphicsSceneContextMenuEvent::scenePos() const**

        Returns the position of the mouse cursor in scene coordinates at the
        moment the context menu was requested.

        **See also** **pos** () and **screenPos** ().
        """
        ...

    def setScreenPos(self, pos: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenecontextmenuevent.html#screenPos

        **QPoint QGraphicsSceneContextMenuEvent::screenPos() const**

        Returns the position of the mouse cursor in screen coordinates at the
        moment the context menu was requested.

        **See also** **pos** () and **scenePos** ().
        """
        ...
