"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsAnchorLayout(PySide6.QtWidgets.QGraphicsLayout):
    """
    https://doc.qt.io/qt-6/qgraphicsanchorlayout.html

    **Detailed Description**

    The anchor layout allows developers to specify how widgets should be placed
    relative to each other, and to the layout itself. The specification is made
    by adding anchors to the layout by calling **addAnchor** (), **addAnchors**
    () or **addCornerAnchors** ().

    Existing anchors in the layout can be accessed with the **anchor** ()
    function. Items that are anchored are automatically added to the layout, and
    if items are removed, all their anchors will be automatically removed.

    ![Using an anchor layout to align simple colored
    widgets.](images/simpleanchorlayout-example.png)

    Anchors are always set up between edges of an item, where the "center" is
    also considered to be an edge. Consider the following example:

    layout->addAnchor(b, Qt::AnchorLeft, a, Qt::AnchorRight);
    layout->addAnchor(b, Qt::AnchorTop, a, Qt::AnchorBottom);

    Here, the right edge of item `a` is anchored to the left edge of item `b`
    and the bottom edge of item `a` is anchored to the top edge of item `b`,
    with the result that item `b` will be placed diagonally to the right and
    below item `b`.

    The **addCornerAnchors** () function provides a simpler way of anchoring the
    corners of two widgets than the two individual calls to **addAnchor** ()
    shown in the code above. Here, we see how a widget can be anchored to the
    top-left corner of the enclosing layout:

    layout->addCornerAnchors(a, Qt::TopLeftCorner, layout, Qt::TopLeftCorner);

    In cases where anchors are used to match the widths or heights of widgets,
    it is convenient to use the **addAnchors** () function. As with the other
    functions for specifying anchors, it can also be used to anchor a widget to
    a layout.

    **Size Hints and Size Policies in an Anchor Layout**

    QGraphicsAnchorLayout respects each item's size hints and size policies.
    Note that there are some properties of **QSizePolicy**  that are **not
    respected** .

    **Spacing within an Anchor Layout**

    The layout may distribute some space between the items. If the spacing has
    not been explicitly specified, the actual amount of space will usually be 0.

    However, if the first edge is the **opposite** of the second edge (e.g., the
    right edge of the first widget is anchored to the left edge of the second
    widget), the size of the anchor will be queried from the style through a
    pixel metric: **PM_LayoutHorizontalSpacing**  for horizontal anchors and
    **PM_LayoutVerticalSpacing**  for vertical anchors.

    If the spacing is negative, the items will overlap to some extent.

    **Known Issues**

    There are some features that QGraphicsAnchorLayout currently does not
    support. This might change in the future, so avoid using these features if
    you want to avoid any future regressions in behaviour:

    * Stretch factors are not respected.
      * **QSizePolicy::ExpandFlag**  is not
    respected.
      * Height for width is not respected.

    **See also** **QGraphicsLinearLayout** , **QGraphicsGridLayout** , and
    **QGraphicsLayout** .
    """

    def __init__(
        self, parent: Optional[PySide6.QtWidgets.QGraphicsLayoutItem] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#QGraphicsAnchorLayout

        **QGraphicsAnchorLayout::QGraphicsAnchorLayout(QGraphicsLayoutItem *
        parent = nullptr)**

        Constructs a QGraphicsAnchorLayout instance. **parent** is passed to
        **QGraphicsLayout** 's constructor.
        """
        ...

    def addAnchor(
        self,
        firstItem: PySide6.QtWidgets.QGraphicsLayoutItem,
        firstEdge: PySide6.QtCore.Qt.AnchorPoint,
        secondItem: PySide6.QtWidgets.QGraphicsLayoutItem,
        secondEdge: PySide6.QtCore.Qt.AnchorPoint,
    ) -> PySide6.QtWidgets.QGraphicsAnchor:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#addAnchor

        **QGraphicsAnchor *QGraphicsAnchorLayout::addAnchor(QGraphicsLayoutItem
        * firstItem , Qt::AnchorPoint firstEdge , QGraphicsLayoutItem *
        secondItem , Qt::AnchorPoint secondEdge )**

        Creates an anchor between the edge **firstEdge** of item **firstItem**
        and the edge **secondEdge** of item **secondItem**. The spacing of the
        anchor is picked up from the style. Anchors between a layout edge and an
        item edge will have a size of 0. If there is already an anchor between
        the edges, the new anchor will replace the old one.

        **firstItem** and **secondItem** are automatically added to the layout
        if they are not part of the layout. This means that **count** () can
        increase by up to 2.

        The spacing an anchor will get depends on the type of anchor. For
        instance, anchors from the Right edge of one item to the Left edge of
        another (or vice versa) will use the default horizontal spacing. The
        same behaviour applies to Bottom to Top anchors, (but they will use the
        default vertical spacing). For all other anchor combinations, the
        spacing will be 0. All anchoring functions will follow this rule.

        The spacing can also be set manually by using
        **QGraphicsAnchor::setSpacing** () method.

        Calling this function where **firstItem** or **secondItem** are
        ancestors of the layout have undefined behaviour.

        **See also** **addAnchors** () and **addCornerAnchors** ().
        """
        ...

    def addAnchors(
        self,
        firstItem: PySide6.QtWidgets.QGraphicsLayoutItem,
        secondItem: PySide6.QtWidgets.QGraphicsLayoutItem,
        orientations: PySide6.QtCore.Qt.Orientations = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#addAnchors

        **void QGraphicsAnchorLayout::addAnchors(QGraphicsLayoutItem * firstItem
        , QGraphicsLayoutItem * secondItem , Qt::Orientations orientations =
        Qt::Horizontal | Qt::Vertical)**

        Anchors two or four edges of **firstItem** with the corresponding edges
        of **secondItem** , so that **firstItem** has the same size as
        **secondItem** in the dimensions specified by **orientations**.

        For example, the following example anchors the left and right edges of
        two items to match their widths:

        layout->addAnchor(b, Qt::AnchorLeft, c, Qt::AnchorLeft);
        layout->addAnchor(b, Qt::AnchorRight, c, Qt::AnchorRight);

        This can also be achieved using the following line of code:

        layout->addAnchors(b, c, Qt::Horizontal);

        **See also** **addAnchor** () and **addCornerAnchors** ().
        """
        ...

    def addCornerAnchors(
        self,
        firstItem: PySide6.QtWidgets.QGraphicsLayoutItem,
        firstCorner: PySide6.QtCore.Qt.Corner,
        secondItem: PySide6.QtWidgets.QGraphicsLayoutItem,
        secondCorner: PySide6.QtCore.Qt.Corner,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#addCornerAnchors

        **void QGraphicsAnchorLayout::addCornerAnchors(QGraphicsLayoutItem *
        firstItem , Qt::Corner firstCorner , QGraphicsLayoutItem * secondItem ,
        Qt::Corner secondCorner )**

        Creates two anchors between **firstItem** and **secondItem** specified
        by the corners, **firstCorner** and **secondCorner** , where one is for
        the horizontal edge and another one for the vertical edge.

        This is a convenience function, since anchoring corners can be expressed
        as anchoring two edges. For instance:

        layout->addAnchor(a, Qt::AnchorTop, layout, Qt::AnchorTop);
        layout->addAnchor(a, Qt::AnchorLeft, layout, Qt::AnchorLeft);

        This can also be achieved with the following line of code:

        layout->addCornerAnchors(a, Qt::TopLeftCorner, layout,
        Qt::TopLeftCorner);

        If there is already an anchor between the edge pairs, it will be
        replaced by the anchors that this function specifies.

        **firstItem** and **secondItem** are automatically added to the layout
        if they are not part of the layout. This means that **count** () can
        increase by up to 2.

        **See also** **addAnchor** () and **addAnchors** ().
        """
        ...

    def anchor(
        self,
        firstItem: PySide6.QtWidgets.QGraphicsLayoutItem,
        firstEdge: PySide6.QtCore.Qt.AnchorPoint,
        secondItem: PySide6.QtWidgets.QGraphicsLayoutItem,
        secondEdge: PySide6.QtCore.Qt.AnchorPoint,
    ) -> PySide6.QtWidgets.QGraphicsAnchor:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#anchor

        **QGraphicsAnchor *QGraphicsAnchorLayout::anchor(QGraphicsLayoutItem *
        firstItem , Qt::AnchorPoint firstEdge , QGraphicsLayoutItem * secondItem
        , Qt::AnchorPoint secondEdge )**

        Returns the anchor between the anchor points defined by **firstItem**
        and **firstEdge** and **secondItem** and **secondEdge**. If there is no
        such anchor, the function will return 0.
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#count

        **[override virtual] int QGraphicsAnchorLayout::count() const**

        Reimplements: **QGraphicsLayout::count() const** .
        """
        ...

    def horizontalSpacing(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#horizontalSpacing

        **qreal QGraphicsAnchorLayout::horizontalSpacing() const**

        Returns the default horizontal spacing for the anchor layout.

        **See also** **verticalSpacing** () and **setHorizontalSpacing** ().
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#invalidate

        **[override virtual] void QGraphicsAnchorLayout::invalidate()**

        Reimplements: **QGraphicsLayout::invalidate** ().
        """
        ...

    def itemAt(self, index: int) -> PySide6.QtWidgets.QGraphicsLayoutItem:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#itemAt

        **[override virtual] QGraphicsLayoutItem
        *QGraphicsAnchorLayout::itemAt(int index ) const**

        Reimplements: **QGraphicsLayout::itemAt(int i) const** .
        """
        ...

    def removeAt(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#removeAt

        **[override virtual] void QGraphicsAnchorLayout::removeAt(int index )**

        Reimplements: **QGraphicsLayout::removeAt** (int index).

        Removes the layout item at **index** without destroying it. Ownership of
        the item is transferred to the caller.

        Removing an item will also remove any of the anchors associated with it.

        **See also** **itemAt** () and **count** ().
        """
        ...

    def setGeometry(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#setGeometry

        **[override virtual] void QGraphicsAnchorLayout::setGeometry(const
        QRectF & geom )**

        Reimplements: **QGraphicsLayoutItem::setGeometry** (const QRectF &rect).
        """
        ...

    def setHorizontalSpacing(self, spacing: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#setHorizontalSpacing

        **void QGraphicsAnchorLayout::setHorizontalSpacing(qreal spacing )**

        Sets the default horizontal spacing for the anchor layout to
        **spacing**.

        **See also** **horizontalSpacing** (), **setVerticalSpacing** (), and
        **setSpacing** ().
        """
        ...

    def setSpacing(self, spacing: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#setSpacing

        **void QGraphicsAnchorLayout::setSpacing(qreal spacing )**

        Sets the default horizontal and the default vertical spacing for the
        anchor layout to **spacing**.

        If an item is anchored with no spacing associated with the anchor, it
        will use the default spacing.

        **QGraphicsAnchorLayout**  does not support negative spacings. Setting a
        negative value will unset the previous spacing and make the layout use
        the spacing provided by the current widget style.

        **See also** **setHorizontalSpacing** () and **setVerticalSpacing** ().
        """
        ...

    def setVerticalSpacing(self, spacing: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#setVerticalSpacing

        **void QGraphicsAnchorLayout::setVerticalSpacing(qreal spacing )**

        Sets the default vertical spacing for the anchor layout to **spacing**.

        **See also** **verticalSpacing** (), **setHorizontalSpacing** (), and
        **setSpacing** ().
        """
        ...

    def sizeHint(
        self,
        which: PySide6.QtCore.Qt.SizeHint,
        constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...,
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#sizeHint

        **[override virtual protected] QSizeF
        QGraphicsAnchorLayout::sizeHint(Qt::SizeHint which , const QSizeF &
        constraint = QSizeF()) const**

        Reimplements: **QGraphicsLayoutItem::sizeHint(Qt::SizeHint which, const
        QSizeF &constraint) const** .
        """
        ...

    def verticalSpacing(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsanchorlayout.html#verticalSpacing

        **qreal QGraphicsAnchorLayout::verticalSpacing() const**

        Returns the default vertical spacing for the anchor layout.

        **See also** **horizontalSpacing** () and **setVerticalSpacing** ().
        """
        ...
