"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsAnchor(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qgraphicsanchor.html

    **Detailed Description**

    The graphics anchor provides an API that enables you to query and manipulate
    the properties an anchor has. When an anchor is added to the layout with
    **QGraphicsAnchorLayout::addAnchor** (), a QGraphicsAnchor instance is
    returned where the properties are initialized to their default values. The
    properties can then be further changed, and they will be picked up the next
    time the layout is activated.

    **See also** **QGraphicsAnchorLayout::anchor** ().
    """

    def setSizePolicy(self, policy: PySide6.QtWidgets.QSizePolicy.Policy) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchor.html#sizePolicy-prop

        **sizePolicy : QSizePolicy::Policy**

        This property holds the size policy for the **QGraphicsAnchor** .

        By setting the size policy on an anchor you can configure how the anchor
        can resize itself from its preferred spacing. For instance, if the
        anchor has the size policy **QSizePolicy::Minimum** , the spacing is the
        minimum size of the anchor. However, its size can grow up to the anchors
        maximum size. If the default size policy is **QSizePolicy::Fixed** , the
        anchor can neither grow or shrink, which means that the only size the
        anchor can have is the spacing. **QSizePolicy::Fixed**  is the default
        size policy. **QGraphicsAnchor**  always has a minimum spacing of 0 and
        a very large maximum spacing.

        **Access functions:**

        QSizePolicy::Policy **sizePolicy** () const
        void **setSizePolicy**
        (QSizePolicy::Policy **policy** )

        **See also** **QGraphicsAnchor::spacing** .
        """
        ...

    def setSpacing(self, spacing: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsanchor.html#spacing-prop

        **spacing : qreal**

        This property holds the preferred space between items in the
        **QGraphicsAnchorLayout** .

        Depending on the anchor type, the default spacing is either 0 or a value
        returned from the style.

        **Access functions:**

        qreal **spacing** () const
        void **setSpacing** (qreal **spacing** )
        void **unsetSpacing** ()

        **See also** **QGraphicsAnchorLayout::addAnchor** ().

        **Member Function Documentation**
        """
        ...

    def sizePolicy(self) -> PySide6.QtWidgets.QSizePolicy.Policy:
        """
        https://doc.qt.io/qt-6/qgraphicsanchor.html#sizePolicy-prop

        **sizePolicy : QSizePolicy::Policy**

        This property holds the size policy for the **QGraphicsAnchor** .

        By setting the size policy on an anchor you can configure how the anchor
        can resize itself from its preferred spacing. For instance, if the
        anchor has the size policy **QSizePolicy::Minimum** , the spacing is the
        minimum size of the anchor. However, its size can grow up to the anchors
        maximum size. If the default size policy is **QSizePolicy::Fixed** , the
        anchor can neither grow or shrink, which means that the only size the
        anchor can have is the spacing. **QSizePolicy::Fixed**  is the default
        size policy. **QGraphicsAnchor**  always has a minimum spacing of 0 and
        a very large maximum spacing.

        **Access functions:**

        QSizePolicy::Policy **sizePolicy** () const
        void **setSizePolicy**
        (QSizePolicy::Policy **policy** )

        **See also** **QGraphicsAnchor::spacing** .
        """
        ...

    def spacing(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsanchor.html#spacing-prop

        **spacing : qreal**

        This property holds the preferred space between items in the
        **QGraphicsAnchorLayout** .

        Depending on the anchor type, the default spacing is either 0 or a value
        returned from the style.

        **Access functions:**

        qreal **spacing** () const
        void **setSpacing** (qreal **spacing** )
        void **unsetSpacing** ()

        **See also** **QGraphicsAnchorLayout::addAnchor** ().

        **Member Function Documentation**
        """
        ...

    def unsetSpacing(self) -> None:
        ...
