"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGestureEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qgestureevent.html

    **Detailed Description**

    The QGestureEvent class contains a list of gestures, which can be obtained
    using the **gestures** () function.

    The gestures are either active or canceled. A list of those that are
    currently being executed can be obtained using the **activeGestures** ()
    function. A list of those which were previously active and have been
    canceled can be accessed using the **canceledGestures** () function. A
    gesture might be canceled if the current window loses focus, for example, or
    because of a timeout, or for other reasons.

    If the event handler does not accept the event by calling the generic
    **QEvent::accept** () function, all individual **QGesture**  object that
    were not accepted and in the **Qt::GestureStarted**  state will be
    propagated up the parent widget chain until a widget accepts them
    individually, by calling **QGestureEvent::accept** () for each of them, or
    an event filter consumes the event.

    **Further Reading**

    For an overview of gesture handling in Qt and information on using gestures
    in your applications, see the **Gestures in Widgets and Graphics View**
    document.

    **See also** **QGesture** , **QGestureRecognizer** ,
    **QWidget::grabGesture** (), and **QGraphicsObject::grabGesture** ().
    """

    def __init__(self, gestures: Sequence[PySide6.QtWidgets.QGesture]) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#QGestureEvent

        **QGestureEvent::QGestureEvent(const QList<QGesture *> & gestures )**

        Creates new QGestureEvent containing a list of **gestures**.
        """
        ...

    @overload
    def accept(self) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#accept

        **void QGestureEvent::accept(QGesture * gesture )**

        Sets the accept flag of the given **gesture** object, the equivalent of
        calling **setAccepted** (gesture, true).

        Setting the accept flag indicates that the event receiver wants the
        gesture. Unwanted gestures may be propagated to the parent widget.

        **See also** **QGestureEvent::ignore** ().
        """
        ...

    @overload
    def accept(self, arg__1: PySide6.QtCore.Qt.GestureType) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#accept-1

        **void QGestureEvent::accept(Qt::GestureType gestureType )**

        Sets the accept flag of the given **gestureType** , the equivalent of
        calling **setAccepted** (gestureType, true).

        Setting the accept flag indicates that the event receiver wants the
        gesture. Unwanted gestures may be propagated to the parent widget.

        **See also** **QGestureEvent::ignore** ().
        """
        ...

    @overload
    def accept(self, arg__1: PySide6.QtWidgets.QGesture) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#accept

        **void QGestureEvent::accept(QGesture * gesture )**

        Sets the accept flag of the given **gesture** object, the equivalent of
        calling **setAccepted** (gesture, true).

        Setting the accept flag indicates that the event receiver wants the
        gesture. Unwanted gestures may be propagated to the parent widget.

        **See also** **QGestureEvent::ignore** ().
        """
        ...

    def activeGestures(self) -> List[PySide6.QtWidgets.QGesture]:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#activeGestures

        **QList<QGesture *> QGestureEvent::activeGestures() const**

        Returns a list of active (not canceled) gestures.
        """
        ...

    def canceledGestures(self) -> List[PySide6.QtWidgets.QGesture]:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#canceledGestures

        **QList<QGesture *> QGestureEvent::canceledGestures() const**

        Returns a list of canceled gestures.
        """
        ...

    def gesture(
        self, type: PySide6.QtCore.Qt.GestureType
    ) -> PySide6.QtWidgets.QGesture:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#gesture

        **QGesture *QGestureEvent::gesture(Qt::GestureType type ) const**

        Returns a gesture object by **type**.
        """
        ...

    def gestures(self) -> List[PySide6.QtWidgets.QGesture]:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#gestures

        **QList<QGesture *> QGestureEvent::gestures() const**

        Returns all gestures that are delivered in the event.
        """
        ...

    @overload
    def ignore(self) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#ignore

        **void QGestureEvent::ignore(QGesture * gesture )**

        Clears the accept flag parameter of the given **gesture** object, the
        equivalent of calling **setAccepted** (gesture, false).

        Clearing the accept flag indicates that the event receiver does not want
        the gesture. Unwanted gestures may be propagated to the parent widget.

        **See also** **QGestureEvent::accept** ().
        """
        ...

    @overload
    def ignore(self, arg__1: PySide6.QtCore.Qt.GestureType) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#ignore-1

        **void QGestureEvent::ignore(Qt::GestureType gestureType )**

        Clears the accept flag parameter of the given **gestureType** , the
        equivalent of calling **setAccepted** (gesture, false).

        Clearing the accept flag indicates that the event receiver does not want
        the gesture. Unwanted gestures may be propagated to the parent widget.

        **See also** **QGestureEvent::accept** ().
        """
        ...

    @overload
    def ignore(self, arg__1: PySide6.QtWidgets.QGesture) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#ignore

        **void QGestureEvent::ignore(QGesture * gesture )**

        Clears the accept flag parameter of the given **gesture** object, the
        equivalent of calling **setAccepted** (gesture, false).

        Clearing the accept flag indicates that the event receiver does not want
        the gesture. Unwanted gestures may be propagated to the parent widget.

        **See also** **QGestureEvent::accept** ().
        """
        ...

    @overload
    def isAccepted(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#isAccepted

        **bool QGestureEvent::isAccepted(QGesture * gesture ) const**

        Returns `true` if the **gesture** is accepted; otherwise returns
        `false`.
        """
        ...

    @overload
    def isAccepted(self, arg__1: PySide6.QtCore.Qt.GestureType) -> bool:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#isAccepted-1

        **bool QGestureEvent::isAccepted(Qt::GestureType gestureType ) const**

        Returns `true` if the gesture of type **gestureType** is accepted;
        otherwise returns `false`.
        """
        ...

    @overload
    def isAccepted(self, arg__1: PySide6.QtWidgets.QGesture) -> bool:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#isAccepted

        **bool QGestureEvent::isAccepted(QGesture * gesture ) const**

        Returns `true` if the **gesture** is accepted; otherwise returns
        `false`.
        """
        ...

    def mapToGraphicsScene(
        self,
        gesturePoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#mapToGraphicsScene

        **QPointF QGestureEvent::mapToGraphicsScene(const QPointF & gesturePoint
        ) const**

        Returns the scene-local coordinates if the **gesturePoint** is inside a
        graphics view.

        This functional might be useful when the gesture event is delivered to a
        **QGraphicsObject**  to translate a point in screen coordinates to
        scene-local coordinates.

        **See also** **QPointF::isNull** ().
        """
        ...

    @overload
    def setAccepted(self, accepted: bool) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#setAccepted

        **void QGestureEvent::setAccepted(QGesture * gesture , bool value )**

        Sets the accept flag of the given **gesture** object to the specified
        **value**.

        Setting the accept flag indicates that the event receiver wants the
        **gesture**. Unwanted gestures may be propagated to the parent widget.

        By default, gestures in events of type **QEvent::Gesture**  are
        accepted, and gestures in **QEvent::GestureOverride**  events are
        ignored.

        For convenience, the accept flag can also be set with **accept**
        (gesture), and cleared with **ignore** (gesture).

        **See also** **isAccepted** ().
        """
        ...

    @overload
    def setAccepted(self, arg__1: PySide6.QtCore.Qt.GestureType, arg__2: bool) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#setAccepted-1

        **void QGestureEvent::setAccepted(Qt::GestureType gestureType , bool
        value )**

        Sets the accept flag of the given **gestureType** object to the
        specified **value**.

        Setting the accept flag indicates that the event receiver wants to
        receive gestures of the specified type, **gestureType**. Unwanted
        gestures may be propagated to the parent widget.

        By default, gestures in events of type **QEvent::Gesture**  are
        accepted, and gestures in **QEvent::GestureOverride**  events are
        ignored.

        For convenience, the accept flag can also be set with **accept**
        (gestureType), and cleared with **ignore** (gestureType).
        """
        ...

    @overload
    def setAccepted(self, arg__1: PySide6.QtWidgets.QGesture, arg__2: bool) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#setAccepted

        **void QGestureEvent::setAccepted(QGesture * gesture , bool value )**

        Sets the accept flag of the given **gesture** object to the specified
        **value**.

        Setting the accept flag indicates that the event receiver wants the
        **gesture**. Unwanted gestures may be propagated to the parent widget.

        By default, gestures in events of type **QEvent::Gesture**  are
        accepted, and gestures in **QEvent::GestureOverride**  events are
        ignored.

        For convenience, the accept flag can also be set with **accept**
        (gesture), and cleared with **ignore** (gesture).

        **See also** **isAccepted** ().
        """
        ...

    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#widget

        **QWidget *QGestureEvent::widget() const**

        Returns the widget on which the event occurred.
        """
        ...

    def widget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qgestureevent.html#widget

        **QWidget *QGestureEvent::widget() const**

        Returns the widget on which the event occurred.
        """
        ...
