"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QDockWidget(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qdockwidget.html

    **Detailed Description**

    QDockWidget provides the concept of dock widgets, also know as tool palettes
    or utility windows. Dock windows are secondary windows placed in the **dock
    widget area** around the **central widget**  in a **QMainWindow** .

    ![](images/mainwindow-docks.png)

    Dock windows can be moved inside their current area, moved into new areas
    and floated (e.g., undocked) by the end-user. The QDockWidget API allows the
    programmer to restrict the dock widgets ability to move, float and close, as
    well as the areas in which they can be placed.

    **Appearance**

    A QDockWidget consists of a title bar and the content area. The title bar
    displays the dock widgets **window title** , a **float** button and a
    **close** button. Depending on the state of the QDockWidget, the **float**
    and **close** buttons may be either disabled or not shown at all.

    The visual appearance of the title bar and buttons is dependent on the
    **style**  in use.

    A QDockWidget acts as a wrapper for its child widget, set with **setWidget**
    (). Custom size hints, minimum and maximum sizes and size policies should be
    implemented in the child widget. QDockWidget will respect them, adjusting
    its own constraints to include the frame and title. Size constraints should
    not be set on the QDockWidget itself, because they change depending on
    whether it is docked; a docked QDockWidget has no frame and a smaller title
    bar.

    **Note:** On macOS, if the QDockWidget has a native window handle (for
    example, if **winId** () is called on it or the child widget), then due to a
    limitation it will not be possible to drag the dock widget when undocking.
    Starting the drag will undock the dock widget, but a second drag will be
    needed to move the dock widget itself.

    **See also** **QMainWindow**  and **Dock Widgets Example** .
    """

    NoDockWidgetFeatures: QDockWidget.DockWidgetFeature = ...
    DockWidgetClosable: QDockWidget.DockWidgetFeature = ...
    DockWidgetMovable: QDockWidget.DockWidgetFeature = ...
    DockWidgetFloatable: QDockWidget.DockWidgetFeature = ...
    DockWidgetVerticalTitleBar: QDockWidget.DockWidgetFeature = ...
    DockWidgetFeatureMask: QDockWidget.DockWidgetFeature = ...
    Reserved: QDockWidget.DockWidgetFeature = ...

    class DockWidgetFeature(Enum):
        NoDockWidgetFeatures: QDockWidget.DockWidgetFeature = ...
        DockWidgetClosable: QDockWidget.DockWidgetFeature = ...
        DockWidgetMovable: QDockWidget.DockWidgetFeature = ...
        DockWidgetFloatable: QDockWidget.DockWidgetFeature = ...
        DockWidgetVerticalTitleBar: QDockWidget.DockWidgetFeature = ...
        DockWidgetFeatureMask: QDockWidget.DockWidgetFeature = ...
        Reserved: QDockWidget.DockWidgetFeature = ...

    class DockWidgetFeatures(object):
        ...

    @overload
    def __init__(
        self,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
        flags: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#QDockWidget

        **QDockWidget::QDockWidget(const QString & title , QWidget * parent =
        nullptr, Qt::WindowFlags flags = Qt::WindowFlags())**

        Constructs a QDockWidget with parent **parent** and window flags
        **flags**. The dock widget will be placed in the left dock widget area.

        The window title is set to **title**. This title is used when the
        QDockWidget is docked and undocked. It is also used in the context menu
        provided by **QMainWindow** .

        **See also** **setWindowTitle** ().
        """
        ...

    @overload
    def __init__(
        self,
        title: str,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
        flags: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#QDockWidget-1

        **QDockWidget::QDockWidget(QWidget * parent = nullptr, Qt::WindowFlags
        flags = Qt::WindowFlags())**

        Constructs a QDockWidget with parent **parent** and window flags
        **flags**. The dock widget will be placed in the left dock widget area.
        """
        ...

    def allowedAreas(self) -> PySide6.QtCore.Qt.DockWidgetAreas:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#allowedAreas-prop

        **allowedAreas : Qt::DockWidgetAreas**

        areas where the dock widget may be placed

        The default is **Qt::AllDockWidgetAreas** .

        **Access functions:**

        Qt::DockWidgetAreas **allowedAreas** () const
        void **setAllowedAreas**
        (Qt::DockWidgetAreas **areas** )

        **Notifier signal:**

        void ****allowedAreasChanged** ** (Qt::DockWidgetAreas **allowedAreas**
        )

        **See also** **Qt::DockWidgetArea** .
        """
        ...

    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#changeEvent

        **[override virtual protected] void QDockWidget::changeEvent(QEvent *
        event )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def closeEvent(self, event: PySide6.QtGui.QCloseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#closeEvent

        **[override virtual protected] void QDockWidget::closeEvent(QCloseEvent
        * event )**

        Reimplements: **QWidget::closeEvent** (QCloseEvent *event).
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#event

        **[override virtual protected] bool QDockWidget::event(QEvent * event
        )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def features(self) -> PySide6.QtWidgets.QDockWidget.DockWidgetFeatures:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#features-prop

        **features : DockWidgetFeatures**

        This property holds whether the dock widget is movable, closable, and
        floatable

        By default, this property is set to a combination of
        **DockWidgetClosable** , **DockWidgetMovable**  and
        **DockWidgetFloatable** .

        **Access functions:**

        QDockWidget::DockWidgetFeatures **features** () const
        void
        **setFeatures** (QDockWidget::DockWidgetFeatures **features** )

        **Notifier signal:**

        void ****featuresChanged** ** (QDockWidget::DockWidgetFeatures
        **features** )

        **See also** **DockWidgetFeature** .
        """
        ...

    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionDockWidget) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#initStyleOption

        **[virtual protected] void
        QDockWidget::initStyleOption(QStyleOptionDockWidget * option ) const**

        Initialize **option** with the values from this **QDockWidget** . This
        method is useful for subclasses when they need a
        **QStyleOptionDockWidget** , but don't want to fill in all the
        information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def isAreaAllowed(self, area: PySide6.QtCore.Qt.DockWidgetArea) -> bool:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#isAreaAllowed

        **bool QDockWidget::isAreaAllowed(Qt::DockWidgetArea area ) const**

        Returns `true` if this dock widget can be placed in the given **area** ;
        otherwise returns `false`.
        """
        ...

    def isFloating(self) -> bool:
        ...

    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#paintEvent

        **[override virtual protected] void QDockWidget::paintEvent(QPaintEvent
        * event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def setAllowedAreas(self, areas: PySide6.QtCore.Qt.DockWidgetAreas) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#allowedAreas-prop

        **allowedAreas : Qt::DockWidgetAreas**

        areas where the dock widget may be placed

        The default is **Qt::AllDockWidgetAreas** .

        **Access functions:**

        Qt::DockWidgetAreas **allowedAreas** () const
        void **setAllowedAreas**
        (Qt::DockWidgetAreas **areas** )

        **Notifier signal:**

        void ****allowedAreasChanged** ** (Qt::DockWidgetAreas **allowedAreas**
        )

        **See also** **Qt::DockWidgetArea** .
        """
        ...

    def setFeatures(
        self, features: PySide6.QtWidgets.QDockWidget.DockWidgetFeatures
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#features-prop

        **features : DockWidgetFeatures**

        This property holds whether the dock widget is movable, closable, and
        floatable

        By default, this property is set to a combination of
        **DockWidgetClosable** , **DockWidgetMovable**  and
        **DockWidgetFloatable** .

        **Access functions:**

        QDockWidget::DockWidgetFeatures **features** () const
        void
        **setFeatures** (QDockWidget::DockWidgetFeatures **features** )

        **Notifier signal:**

        void ****featuresChanged** ** (QDockWidget::DockWidgetFeatures
        **features** )

        **See also** **DockWidgetFeature** .
        """
        ...

    def setFloating(self, floating: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#floating-prop

        **floating : bool**

        This property holds whether the dock widget is floating

        A floating dock widget is presented to the user as an independent window
        "on top" of its parent **QMainWindow** , instead of being docked in the
        **QMainWindow** .

        By default, this property is `true`.

        When this property changes, the `topLevelChanged()` signal is emitted.

        **Access functions:**

        bool **isFloating** () const
        void **setFloating** (bool **floating** )

        **See also** **isWindow** () and **topLevelChanged** ().
        """
        ...

    def setTitleBarWidget(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#setTitleBarWidget

        **void QDockWidget::setTitleBarWidget(QWidget * widget )**

        Sets an arbitrary **widget** as the dock widget's title bar. If
        **widget** is `nullptr`, any custom title bar widget previously set on
        the dock widget is removed, but not deleted, and the default title bar
        will be used instead.

        If a title bar widget is set, **QDockWidget**  will not use native
        window decorations when it is floated.

        Here are some tips for implementing custom title bars:

        * Mouse events that are not explicitly handled by the title bar widget
        must be ignored by calling **QMouseEvent::ignore** (). These events then
        propagate to the **QDockWidget**  parent, which handles them in the
        usual manner, moving when the title bar is dragged, docking and
        undocking when it is double-clicked, etc.
          * When
        **DockWidgetVerticalTitleBar**  is set on **QDockWidget** , the title
        bar widget is repositioned accordingly. In **resizeEvent** (), the title
        bar should check what orientation it should assume:
        **QDockWidget**  *dockWidget = qobject_cast<**QDockWidget**
        \\*>(parentWidget());
            if (dockWidget->features() & **QDockWidget**
        ::DockWidgetVerticalTitleBar) {
                // I need to be vertical
            }
        else {
                // I need to be horizontal
            }

          * The title bar
        widget must have a valid **QWidget::sizeHint** () and
        **QWidget::minimumSizeHint** (). These functions should take into
        account the current orientation of the title bar.
          * It is not possible
        to remove a title bar from a dock widget. However, a similar effect can
        be achieved by setting a default constructed **QWidget**  as the title
        bar widget.

        Using **qobject_cast** () as shown above, the title bar widget has full
        access to its parent **QDockWidget** . Hence it can perform such
        operations as docking and hiding in response to user actions.

        **See also** **titleBarWidget** () and **DockWidgetVerticalTitleBar** .
        """
        ...

    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#setWidget

        **void QDockWidget::setWidget(QWidget * widget )**

        Sets the widget for the dock widget to **widget**.

        If the dock widget is visible when **widget** is added, you must
        **show** () it explicitly.

        Note that you must add the layout of the **widget** before you call this
        function; if not, the **widget** will not be visible.

        **See also** **widget** ().
        """
        ...

    def titleBarWidget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#titleBarWidget

        **QWidget *QDockWidget::titleBarWidget() const**

        Returns the custom title bar widget set on the **QDockWidget** , or
        `nullptr` if no custom title bar has been set.

        **See also** **setTitleBarWidget** ().
        """
        ...

    def toggleViewAction(self) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#toggleViewAction

        **QAction *QDockWidget::toggleViewAction() const**

        Returns a checkable action that can be added to menus and toolbars so
        that the user can show or close this dock widget.

        The action's text is set to the dock widget's window title.

        **Note:** The action can not be used to programmatically show or hide
        the dock widget. Use the **visible**  property for that.

        **See also** **QAction::text**  and **QWidget::windowTitle** .
        """
        ...

    def widget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#widget

        **QWidget *QDockWidget::widget() const**

        Returns the widget for the dock widget. This function returns zero if
        the widget has not been set.

        **See also** **setWidget** ().
        """
        ...

    @property
    def allowedAreasChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#allowedAreasChanged

        **[signal] void QDockWidget::allowedAreasChanged(Qt::DockWidgetAreas
        allowedAreas )**

        This signal is emitted when the **allowedAreas**  property changes. The
        **allowedAreas** parameter gives the new value of the property.

        **Note:** Notifier signal for property **allowedAreas** .
        """
        ...

    @property
    def dockLocationChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#dockLocationChanged

        **[signal] void QDockWidget::dockLocationChanged(Qt::DockWidgetArea area
        )**

        This signal is emitted when the dock widget is moved to another dock
        **area** , or is moved to a different location in its current dock area.
        This happens when the dock widget is moved programmatically or is
        dragged to a new location by the user.
        """
        ...

    @property
    def featuresChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#featuresChanged

        **[signal] void
        QDockWidget::featuresChanged(QDockWidget::DockWidgetFeatures features
        )**

        This signal is emitted when the **features**  property changes. The
        **features** parameter gives the new value of the property.

        **Note:** Notifier signal for property **features** .
        """
        ...

    @property
    def topLevelChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#topLevelChanged

        **[signal] void QDockWidget::topLevelChanged(bool topLevel )**

        This signal is emitted when the **floating**  property changes. The
        **topLevel** parameter is true if the dock widget is now floating;
        otherwise it is false.

        **See also** **isWindow** ().
        """
        ...

    @property
    def visibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdockwidget.html#visibilityChanged

        **[signal] void QDockWidget::visibilityChanged(bool visible )**

        This signal is emitted when the dock widget becomes **visible** (or
        invisible). This happens when the widget is hidden or shown, as well as
        when it is docked in a tabbed dock area and its tab becomes selected or
        unselected.
        """
        ...
