"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QDateEdit(PySide6.QtWidgets.QDateTimeEdit):
    """
    https://doc.qt.io/qt-6/qdateedit.html

    **Detailed Description**

    ![](images/windows-dateedit.png)

    Many of the properties and functions provided by QDateEdit are implemented
    in **QDateTimeEdit** . These are the relevant properties of this class:

    * **date**  holds the date displayed by the widget.
      * **minimumDate**
    defines the minimum (earliest) date that can be set by the user.
      *
    **maximumDate**  defines the maximum (latest) date that can be set by the
    user.
      * **displayFormat**  contains a string that is used to format the
    date displayed in the widget.

    **See also** **QTimeEdit**  and **QDateTimeEdit** .
    """

    @overload
    def __init__(
        self,
        date: PySide6.QtCore.QDate,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdateedit.html#QDateEdit

        **QDateEdit::QDateEdit(QWidget * parent = nullptr)**

        Constructs an empty date editor with a **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdateedit.html#QDateEdit-1

        **QDateEdit::QDateEdit(QDate date , QWidget * parent = nullptr)**

        Constructs an empty date editor with a **parent**. The date is set to
        **date**.
        """
        ...
