"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Sequence, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QColumnView(PySide6.QtWidgets.QAbstractItemView):
    """
    https://doc.qt.io/qt-6/qcolumnview.html

    **Detailed Description**

    QColumnView displays a model in a number of QListViews, one for each
    hierarchy in the tree. This is sometimes referred to as a cascading list.

    The QColumnView class is one of the **Model/View Classes**  and is part of
    Qt's **model/view framework** .

    QColumnView implements the interfaces defined by the **QAbstractItemView**
    class to allow it to display data provided by models derived from the
    **QAbstractItemModel**  class.

    ![](images/qcolumnview.png)

    **See also** **Model/View Programming** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#QColumnView

        **QColumnView::QColumnView(QWidget * parent = nullptr)**

        Constructs a column view with a **parent** to represent a model's data.
        Use **setModel** () to set the model.

        **See also** **QAbstractItemModel** .
        """
        ...

    def columnWidths(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#columnWidths

        **QList<int> QColumnView::columnWidths() const**

        Returns a list of the width of all the columns in this view.

        **See also** **setColumnWidths** ().
        """
        ...

    def createColumn(
        self,
        rootIndex: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> PySide6.QtWidgets.QAbstractItemView:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#createColumn

        **[virtual protected] QAbstractItemView *QColumnView::createColumn(const
        QModelIndex & index )**

        To use a custom widget for the final column when you select an item
        overload this function and return a widget. **index** is the root index
        that will be assigned to the view.

        Return the new view. **QColumnView**  will automatically take ownership
        of the widget.

        **See also** **setPreviewWidget** ().
        """
        ...

    def currentChanged(
        self,
        current: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        previous: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#currentChanged

        **[override virtual protected] void QColumnView::currentChanged(const
        QModelIndex & current , const QModelIndex & previous )**

        Reimplements: **QAbstractItemView::currentChanged** (const QModelIndex
        &current, const QModelIndex &previous).
        """
        ...

    def horizontalOffset(self) -> int:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#horizontalOffset

        **[override virtual protected] int QColumnView::horizontalOffset()
        const**

        Reimplements: **QAbstractItemView::horizontalOffset() const** .
        """
        ...

    def indexAt(self, point: PySide6.QtCore.QPoint) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#indexAt

        **[override virtual] QModelIndex QColumnView::indexAt(const QPoint &
        point ) const**

        Reimplements: **QAbstractItemView::indexAt(const QPoint &point) const**
        .
        """
        ...

    def initializeColumn(self, column: PySide6.QtWidgets.QAbstractItemView) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#initializeColumn

        **[protected] void QColumnView::initializeColumn(QAbstractItemView *
        column ) const**

        Copies the behavior and options of the column view and applies them to
        the **column** such as the **iconSize** (), **textElideMode** () and
        **alternatingRowColors** (). This can be useful when reimplementing
        **createColumn** ().

        **See also** **createColumn** ().
        """
        ...

    def isIndexHidden(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#isIndexHidden

        **[override virtual protected] bool QColumnView::isIndexHidden(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemView::isIndexHidden(const QModelIndex
        &index) const** .
        """
        ...

    def moveCursor(
        self,
        cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers,
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#moveCursor

        **[override virtual protected] QModelIndex
        QColumnView::moveCursor(QAbstractItemView::CursorAction cursorAction ,
        Qt::KeyboardModifiers modifiers )**

        Reimplements: **QAbstractItemView::moveCursor**
        (QAbstractItemView::CursorAction cursorAction, Qt::KeyboardModifiers
        modifiers).

        Move left should go to the parent index Move right should go to the
        child index or down if there is no child
        """
        ...

    def previewWidget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#previewWidget

        **QWidget *QColumnView::previewWidget() const**

        Returns the preview widget, or `nullptr` if there is none.

        **See also** **setPreviewWidget** () and **updatePreviewWidget** ().
        """
        ...

    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#resizeEvent

        **[override virtual protected] void
        QColumnView::resizeEvent(QResizeEvent * event )**

        Reimplements: **QAbstractItemView::resizeEvent** (QResizeEvent *event).
        """
        ...

    def resizeGripsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#resizeGripsVisible-prop

        **resizeGripsVisible : bool**

        This property holds the way to specify if the list views gets resize
        grips or not

        By default, `visible` is set to true

        **Access functions:**

        bool **resizeGripsVisible** () const
        void **setResizeGripsVisible**
        (bool **visible** )

        **See also** **setRootIndex** ().

        **Member Function Documentation**
        """
        ...

    def rowsInserted(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        start: int,
        end: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#rowsInserted

        **[override virtual protected] void QColumnView::rowsInserted(const
        QModelIndex & parent , int start , int end )**

        Reimplements: **QAbstractItemView::rowsInserted** (const QModelIndex
        &parent, int start, int end).
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#scrollContentsBy

        **[override virtual protected] void QColumnView::scrollContentsBy(int dx
        , int dy )**

        Reimplements: **QAbstractScrollArea::scrollContentsBy** (int dx, int
        dy).
        """
        ...

    def scrollTo(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#scrollTo

        **[override virtual] void QColumnView::scrollTo(const QModelIndex &
        index , QAbstractItemView::ScrollHint hint = EnsureVisible)**

        Reimplements: **QAbstractItemView::scrollTo** (const QModelIndex &index,
        QAbstractItemView::ScrollHint hint).
        """
        ...

    def selectAll(self) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#selectAll

        **[override virtual] void QColumnView::selectAll()**

        Reimplements: **QAbstractItemView::selectAll** ().
        """
        ...

    def setColumnWidths(self, list: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#setColumnWidths

        **void QColumnView::setColumnWidths(const QList<int> & list )**

        Sets the column widths to the values given in the **list**. Extra values
        in the list are kept and used when the columns are created.

        If list contains too few values, only width of the rest of the columns
        will not be modified.

        **See also** **columnWidths** () and **createColumn** ().
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#setModel

        **[override virtual] void QColumnView::setModel(QAbstractItemModel *
        model )**

        Reimplements: **QAbstractItemView::setModel** (QAbstractItemModel
        *model).
        """
        ...

    def setPreviewWidget(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#setPreviewWidget

        **void QColumnView::setPreviewWidget(QWidget * widget )**

        Sets the preview **widget**.

        The **widget** becomes a child of the column view, and will be destroyed
        when the column area is deleted or when a new widget is set.

        **See also** **previewWidget** () and **updatePreviewWidget** ().
        """
        ...

    def setResizeGripsVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#resizeGripsVisible-prop

        **resizeGripsVisible : bool**

        This property holds the way to specify if the list views gets resize
        grips or not

        By default, `visible` is set to true

        **Access functions:**

        bool **resizeGripsVisible** () const
        void **setResizeGripsVisible**
        (bool **visible** )

        **See also** **setRootIndex** ().

        **Member Function Documentation**
        """
        ...

    def setRootIndex(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#setRootIndex

        **[override virtual] void QColumnView::setRootIndex(const QModelIndex &
        index )**

        Reimplements: **QAbstractItemView::setRootIndex** (const QModelIndex
        &index).
        """
        ...

    def setSelection(
        self,
        rect: PySide6.QtCore.QRect,
        command: PySide6.QtCore.QItemSelectionModel.SelectionFlags,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#setSelection

        **[override virtual protected] void QColumnView::setSelection(const
        QRect & rect , QItemSelectionModel::SelectionFlags command )**

        Reimplements: **QAbstractItemView::setSelection** (const QRect &rect,
        QItemSelectionModel::SelectionFlags flags).
        """
        ...

    def setSelectionModel(
        self, selectionModel: PySide6.QtCore.QItemSelectionModel
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#setSelectionModel

        **[override virtual] void
        QColumnView::setSelectionModel(QItemSelectionModel * newSelectionModel
        )**

        Reimplements: **QAbstractItemView::setSelectionModel**
        (QItemSelectionModel *selectionModel).
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#sizeHint

        **[override virtual] QSize QColumnView::sizeHint() const**

        Reimplements: **QAbstractScrollArea::sizeHint() const** .
        """
        ...

    def verticalOffset(self) -> int:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#verticalOffset

        **[override virtual protected] int QColumnView::verticalOffset() const**

        Reimplements: **QAbstractItemView::verticalOffset() const** .
        """
        ...

    def visualRect(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#visualRect

        **[override virtual] QRect QColumnView::visualRect(const QModelIndex &
        index ) const**

        Reimplements: **QAbstractItemView::visualRect(const QModelIndex &index)
        const** .
        """
        ...

    def visualRegionForSelection(
        self, selection: PySide6.QtCore.QItemSelection
    ) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#visualRegionForSelection

        **[override virtual protected] QRegion
        QColumnView::visualRegionForSelection(const QItemSelection & selection )
        const**

        Reimplements: **QAbstractItemView::visualRegionForSelection(const
        QItemSelection &selection) const** .
        """
        ...

    @property
    def updatePreviewWidget(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcolumnview.html#updatePreviewWidget

        **[signal] void QColumnView::updatePreviewWidget(const QModelIndex &
        index )**

        This signal is emitted when the preview widget should be updated to
        provide rich information about **index**

        **See also** **previewWidget** ().
        """
        ...
