"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Dict, Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QCalendarWidget(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qcalendarwidget.html

    **Detailed Description**

    ![](images/fusion-calendarwidget.png)

    The widget is initialized with the current month and year, but
    QCalendarWidget provides several public slots to change the year and month
    that is shown.

    By default, today's date is selected, and the user can select a date using
    both mouse and keyboard. The currently selected date can be retrieved using
    the **selectedDate** () function. It is possible to constrain the user
    selection to a given date range by setting the **minimumDate**  and
    **maximumDate**  properties. Alternatively, both properties can be set in
    one go using the **setDateRange** () convenience slot. Set the
    **selectionMode**  property to **NoSelection**  to prohibit the user from
    selecting at all. Note that a date also can be selected programmatically
    using the **setSelectedDate** () slot.

    The currently displayed month and year can be retrieved using the
    **monthShown** () and **yearShown** () functions, respectively.

    A newly created calendar widget uses abbreviated day names, and both
    Saturdays and Sundays are marked in red. The calendar grid is not visible.
    The week numbers are displayed, and the first column day is the first day of
    the week for the calendar's locale.

    The notation of the days can be altered to a single letter abbreviations
    ("M" for "Monday") by setting the **horizontalHeaderFormat**  property to
    **QCalendarWidget::SingleLetterDayNames** . Setting the same property to
    **QCalendarWidget::LongDayNames**  makes the header display the complete day
    names. The week numbers can be removed by setting the
    **verticalHeaderFormat**  property to **QCalendarWidget::NoVerticalHeader**
    . The calendar grid can be turned on by setting the **gridVisible**
    property to true using the **setGridVisible** () function:

    ![](images/qcalendarwidget-grid.png)


        **QCalendarWidget**
    *calendar;
        calendar->setGridVisible(true);

    Finally, the day in the first column can be altered using the
    **setFirstDayOfWeek** () function.

    The QCalendarWidget class also provides three signals, **selectionChanged**
    (), **activated** () and **currentPageChanged** () making it possible to
    respond to user interaction.

    The rendering of the headers, weekdays or single days can be largely
    customized by setting **QTextCharFormat** 's for some special weekday, a
    special date or for the rendering of the headers.

    Only a subset of the properties in **QTextCharFormat**  are used by the
    calendar widget. Currently, the foreground, background and font properties
    are used to determine the rendering of individual cells in the widget.

    **See also** **QDate** , **QDateEdit** , and **QTextCharFormat** .
    """

    NoHorizontalHeader: QCalendarWidget.HorizontalHeaderFormat = ...
    SingleLetterDayNames: QCalendarWidget.HorizontalHeaderFormat = ...
    ShortDayNames: QCalendarWidget.HorizontalHeaderFormat = ...
    LongDayNames: QCalendarWidget.HorizontalHeaderFormat = ...
    NoSelection: QCalendarWidget.SelectionMode = ...
    SingleSelection: QCalendarWidget.SelectionMode = ...
    NoVerticalHeader: QCalendarWidget.VerticalHeaderFormat = ...
    ISOWeekNumbers: QCalendarWidget.VerticalHeaderFormat = ...

    class HorizontalHeaderFormat(Enum):
        NoHorizontalHeader: QCalendarWidget.HorizontalHeaderFormat = ...
        SingleLetterDayNames: QCalendarWidget.HorizontalHeaderFormat = ...
        ShortDayNames: QCalendarWidget.HorizontalHeaderFormat = ...
        LongDayNames: QCalendarWidget.HorizontalHeaderFormat = ...

    class SelectionMode(Enum):
        NoSelection: QCalendarWidget.SelectionMode = ...
        SingleSelection: QCalendarWidget.SelectionMode = ...

    class VerticalHeaderFormat(Enum):
        NoVerticalHeader: QCalendarWidget.VerticalHeaderFormat = ...
        ISOWeekNumbers: QCalendarWidget.VerticalHeaderFormat = ...

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#QCalendarWidget

        **QCalendarWidget::QCalendarWidget(QWidget * parent = nullptr)**

        Constructs a calendar widget with the given **parent**.

        The widget is initialized with the current month and year, and the
        currently selected date is today.

        **See also** **setCurrentPage** ().
        """
        ...

    def calendar(self) -> PySide6.QtCore.QCalendar:
        ...

    def dateEditAcceptDelay(self) -> int:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#dateEditAcceptDelay-prop

        **dateEditAcceptDelay : int**

        This property holds the time an inactive date edit is shown before its
        contents are accepted

        If the calendar widget's **date edit is enabled** , this property
        specifies the amount of time (in milliseconds) that the date edit
        remains open after the most recent user input. Once this time has
        elapsed, the date specified in the date edit is accepted and the popup
        is closed.

        By default, the delay is defined to be 1500 milliseconds (1.5 seconds).

        **Access functions:**

        int **dateEditAcceptDelay** () const
        void **setDateEditAcceptDelay**
        (int **delay** )
        """
        ...

    @overload
    def dateTextFormat(
        self,
    ) -> Dict[PySide6.QtCore.QDate, PySide6.QtGui.QTextCharFormat]:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#dateTextFormat

        **QMap<QDate, QTextCharFormat> QCalendarWidget::dateTextFormat() const**

        Returns a **QMap**  from **QDate**  to **QTextCharFormat**  showing all
        dates that use a special format that alters their rendering.

        **See also** **setDateTextFormat** ().
        """
        ...

    @overload
    def dateTextFormat(
        self, date: PySide6.QtCore.QDate
    ) -> PySide6.QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#dateTextFormat-1

        **QTextCharFormat QCalendarWidget::dateTextFormat(QDate date ) const**

        Returns a **QTextCharFormat**  for **date**. The char format can be be
        empty if the date is not renderd specially.
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#event

        **[override virtual protected] bool QCalendarWidget::event(QEvent *
        event )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def eventFilter(
        self, watched: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#eventFilter

        **[override virtual protected] bool QCalendarWidget::eventFilter(QObject
        * watched , QEvent * event )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).
        """
        ...

    def firstDayOfWeek(self) -> PySide6.QtCore.Qt.DayOfWeek:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#firstDayOfWeek-prop

        **firstDayOfWeek : Qt::DayOfWeek**

        This property holds a value identifying the day displayed in the first
        column.

        By default, the day displayed in the first column is the first day of
        the week for the calendar's locale.

        **Access functions:**

        Qt::DayOfWeek **firstDayOfWeek** () const
        void **setFirstDayOfWeek**
        (Qt::DayOfWeek **dayOfWeek** )
        """
        ...

    def headerTextFormat(self) -> PySide6.QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#headerTextFormat

        **QTextCharFormat QCalendarWidget::headerTextFormat() const**

        Returns the text char format for rendering the header.

        **See also** **setHeaderTextFormat** ().
        """
        ...

    def horizontalHeaderFormat(
        self,
    ) -> PySide6.QtWidgets.QCalendarWidget.HorizontalHeaderFormat:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#horizontalHeaderFormat-prop

        **horizontalHeaderFormat : HorizontalHeaderFormat**

        This property holds the format of the horizontal header.

        The default value is **QCalendarWidget::ShortDayNames** .

        **Access functions:**

        QCalendarWidget::HorizontalHeaderFormat **horizontalHeaderFormat** ()
        const
        void **setHorizontalHeaderFormat**
        (QCalendarWidget::HorizontalHeaderFormat **format** )
        """
        ...

    def isDateEditEnabled(self) -> bool:
        ...

    def isGridVisible(self) -> bool:
        ...

    def isNavigationBarVisible(self) -> bool:
        ...

    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#keyPressEvent

        **[override virtual protected] void
        QCalendarWidget::keyPressEvent(QKeyEvent * event )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def maximumDate(self) -> PySide6.QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#maximumDate-prop

        **maximumDate : QDate**

        This property holds the maximum date of the currently specified date
        range.

        The user will not be able to select a date which is after the currently
        set maximum date.

        ![](images/qcalendarwidget-maximum.png)
        **QCalendarWidget**  *calendar;
            calendar->setGridVisible(true);
        calendar->setMaximumDate(**QDate** (2006, 7, 3));

        By default, the maximum date is the last day the **QDate**  class can
        handle.

        When setting a maximum date, the **minimumDate**  and **selectedDate**
        properties are adjusted if the selection range becomes invalid. If the
        provided date is not a valid **QDate**  object, the setMaximumDate()
        function does nothing.

        **Access functions:**

        QDate **maximumDate** () const
        void **setMaximumDate** (QDate **date**
        )

        **See also** **setDateRange** ().
        """
        ...

    def minimumDate(self) -> PySide6.QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#minimumDate-prop

        **minimumDate : QDate**

        This property holds the minimum date of the currently specified date
        range.

        The user will not be able to select a date that is before the currently
        set minimum date.

        ![](images/qcalendarwidget-minimum.png)
        **QCalendarWidget**  *calendar;
            calendar->setGridVisible(true);
        calendar->setMinimumDate(**QDate** (2006, 6, 19));

        By default, the minimum date is the earliest date that the **QDate**
        class can handle.

        When setting a minimum date, the **maximumDate**  and **selectedDate**
        properties are adjusted if the selection range becomes invalid. If the
        provided date is not a valid **QDate**  object, the setMinimumDate()
        function does nothing.

        **Access functions:**

        QDate **minimumDate** () const
        void **setMinimumDate** (QDate **date**
        )

        **See also** **setDateRange** ().
        """
        ...

    def minimumSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#minimumSizeHint

        **[override virtual] QSize QCalendarWidget::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def monthShown(self) -> int:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#monthShown

        **int QCalendarWidget::monthShown() const**

        Returns the currently displayed month. Months are numbered from 1 to 12.

        **See also** **yearShown** () and **setCurrentPage** ().
        """
        ...

    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#mousePressEvent

        **[override virtual protected] void
        QCalendarWidget::mousePressEvent(QMouseEvent * event )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def paintCell(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: PySide6.QtCore.QRect,
        date: PySide6.QtCore.QDate,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#paintCell

        **[virtual protected] void QCalendarWidget::paintCell(QPainter * painter
        , const QRect & rect , QDate date ) const**

        Paints the cell specified by the given **date** , using the given
        **painter** and **rect**.
        """
        ...

    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#resizeEvent

        **[override virtual protected] void
        QCalendarWidget::resizeEvent(QResizeEvent * event )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def selectedDate(self) -> PySide6.QtCore.QDate:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#selectedDate-prop

        **selectedDate : QDate**

        This property holds the currently selected date.

        The selected date must be within the date range specified by the
        **minimumDate**  and **maximumDate**  properties. By default, the
        selected date is the current date.

        **Access functions:**

        QDate **selectedDate** () const
        void **setSelectedDate** (QDate
        **date** )

        **See also** **setDateRange** ().
        """
        ...

    def selectionMode(self) -> PySide6.QtWidgets.QCalendarWidget.SelectionMode:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#selectionMode-prop

        **selectionMode : SelectionMode**

        This property holds the type of selection the user can make in the
        calendar

        When this property is set to **SingleSelection** , the user can select a
        date within the minimum and maximum allowed dates, using either the
        mouse or the keyboard.

        When the property is set to **NoSelection** , the user will be unable to
        select dates, but they can still be selected programmatically. Note that
        the date that is selected when the property is set to **NoSelection**
        will still be the selected date of the calendar.

        The default value is **SingleSelection** .

        **Access functions:**

        QCalendarWidget::SelectionMode **selectionMode** () const
        void
        **setSelectionMode** (QCalendarWidget::SelectionMode **mode** )
        """
        ...

    def setCalendar(self, calendar: PySide6.QtCore.QCalendar) -> None:
        ...

    def setCurrentPage(self, year: int, month: int) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#setCurrentPage

        **[slot] void QCalendarWidget::setCurrentPage(int year , int month )**

        Displays the given **month** of the given **year** without changing the
        selected date. Use the **setSelectedDate** () function to alter the
        selected date.

        The currently displayed month and year can be retrieved using the
        **monthShown** () and **yearShown** () functions respectively.

        **See also** **yearShown** (), **monthShown** (), **showPreviousMonth**
        (), **showNextMonth** (), **showPreviousYear** (), and **showNextYear**
        ().
        """
        ...

    def setDateEditAcceptDelay(self, delay: int) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#dateEditAcceptDelay-prop

        **dateEditAcceptDelay : int**

        This property holds the time an inactive date edit is shown before its
        contents are accepted

        If the calendar widget's **date edit is enabled** , this property
        specifies the amount of time (in milliseconds) that the date edit
        remains open after the most recent user input. Once this time has
        elapsed, the date specified in the date edit is accepted and the popup
        is closed.

        By default, the delay is defined to be 1500 milliseconds (1.5 seconds).

        **Access functions:**

        int **dateEditAcceptDelay** () const
        void **setDateEditAcceptDelay**
        (int **delay** )
        """
        ...

    def setDateEditEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#dateEditEnabled-prop

        **dateEditEnabled : bool**

        This property holds whether the date edit popup is enabled

        If this property is enabled, pressing a non-modifier key will cause a
        date edit to popup if the calendar widget has focus, allowing the user
        to specify a date in the form specified by the current locale.

        By default, this property is enabled.

        The date edit is simpler in appearance than **QDateEdit** , but allows
        the user to navigate between fields using the left and right cursor
        keys, increment and decrement individual fields using the up and down
        cursor keys, and enter values directly using the number keys.

        **Access functions:**

        bool **isDateEditEnabled** () const
        void **setDateEditEnabled** (bool
        **enable** )

        **See also** **QCalendarWidget::dateEditAcceptDelay** .
        """
        ...

    def setDateRange(
        self, min: PySide6.QtCore.QDate, max: PySide6.QtCore.QDate
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#setDateRange

        **[slot] void QCalendarWidget::setDateRange(QDate min , QDate max )**

        Defines a date range by setting the **minimumDate**  and **maximumDate**
        properties.

        The date range restricts the user selection, i.e. the user can only
        select dates within the specified date range. Note that

        **QCalendarWidget**  *calendar;

            calendar->setDateRange(min,
        max);

        is analogous to

        **QCalendarWidget**  *calendar;

            calendar->setMinimumDate(min);
        calendar->setMaximumDate(max);

        If either the **min** or **max** parameters are not valid **QDate**
        objects, this function does nothing.

        **See also** **setMinimumDate** () and **setMaximumDate** ().
        """
        ...

    def setDateTextFormat(
        self, date: PySide6.QtCore.QDate, format: PySide6.QtGui.QTextCharFormat
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#setDateTextFormat

        **void QCalendarWidget::setDateTextFormat(QDate date , const
        QTextCharFormat & format )**

        Sets the format used to render the given **date** to that specified by
        **format**.

        If **date** is null, all date formats are cleared.

        **See also** **dateTextFormat** ().
        """
        ...

    def setFirstDayOfWeek(self, dayOfWeek: PySide6.QtCore.Qt.DayOfWeek) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#firstDayOfWeek-prop

        **firstDayOfWeek : Qt::DayOfWeek**

        This property holds a value identifying the day displayed in the first
        column.

        By default, the day displayed in the first column is the first day of
        the week for the calendar's locale.

        **Access functions:**

        Qt::DayOfWeek **firstDayOfWeek** () const
        void **setFirstDayOfWeek**
        (Qt::DayOfWeek **dayOfWeek** )
        """
        ...

    def setGridVisible(self, show: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#gridVisible-prop

        **gridVisible : bool**

        This property holds whether the table grid is displayed.

        ![](images/qcalendarwidget-grid.png)
        **QCalendarWidget**  *calendar;
            calendar->setGridVisible(true);

        The default value is false.

        **Access functions:**

        bool **isGridVisible** () const
        void **setGridVisible** (bool **show**
        )
        """
        ...

    def setHeaderTextFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#setHeaderTextFormat

        **void QCalendarWidget::setHeaderTextFormat(const QTextCharFormat &
        format )**

        Sets the text char format for rendering the header to **format**. If you
        also set a weekday text format, this format's foreground and background
        color will take precedence over the header's format. The other
        formatting information will still be decided by the header's format.

        **See also** **headerTextFormat** ().
        """
        ...

    def setHorizontalHeaderFormat(
        self, format: PySide6.QtWidgets.QCalendarWidget.HorizontalHeaderFormat
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#horizontalHeaderFormat-prop

        **horizontalHeaderFormat : HorizontalHeaderFormat**

        This property holds the format of the horizontal header.

        The default value is **QCalendarWidget::ShortDayNames** .

        **Access functions:**

        QCalendarWidget::HorizontalHeaderFormat **horizontalHeaderFormat** ()
        const
        void **setHorizontalHeaderFormat**
        (QCalendarWidget::HorizontalHeaderFormat **format** )
        """
        ...

    def setMaximumDate(self, date: PySide6.QtCore.QDate) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#maximumDate-prop

        **maximumDate : QDate**

        This property holds the maximum date of the currently specified date
        range.

        The user will not be able to select a date which is after the currently
        set maximum date.

        ![](images/qcalendarwidget-maximum.png)
        **QCalendarWidget**  *calendar;
            calendar->setGridVisible(true);
        calendar->setMaximumDate(**QDate** (2006, 7, 3));

        By default, the maximum date is the last day the **QDate**  class can
        handle.

        When setting a maximum date, the **minimumDate**  and **selectedDate**
        properties are adjusted if the selection range becomes invalid. If the
        provided date is not a valid **QDate**  object, the setMaximumDate()
        function does nothing.

        **Access functions:**

        QDate **maximumDate** () const
        void **setMaximumDate** (QDate **date**
        )

        **See also** **setDateRange** ().
        """
        ...

    def setMinimumDate(self, date: PySide6.QtCore.QDate) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#minimumDate-prop

        **minimumDate : QDate**

        This property holds the minimum date of the currently specified date
        range.

        The user will not be able to select a date that is before the currently
        set minimum date.

        ![](images/qcalendarwidget-minimum.png)
        **QCalendarWidget**  *calendar;
            calendar->setGridVisible(true);
        calendar->setMinimumDate(**QDate** (2006, 6, 19));

        By default, the minimum date is the earliest date that the **QDate**
        class can handle.

        When setting a minimum date, the **maximumDate**  and **selectedDate**
        properties are adjusted if the selection range becomes invalid. If the
        provided date is not a valid **QDate**  object, the setMinimumDate()
        function does nothing.

        **Access functions:**

        QDate **minimumDate** () const
        void **setMinimumDate** (QDate **date**
        )

        **See also** **setDateRange** ().
        """
        ...

    def setNavigationBarVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#navigationBarVisible-prop

        **navigationBarVisible : bool**

        This property holds whether the navigation bar is shown or not

        When this property is `true` (the default), the next month, previous
        month, month selection, year selection controls are shown on top.

        When the property is set to false, these controls are hidden.

        **Access functions:**

        bool **isNavigationBarVisible** () const
        void
        **setNavigationBarVisible** (bool **visible** )
        """
        ...

    def setSelectedDate(self, date: PySide6.QtCore.QDate) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#selectedDate-prop

        **selectedDate : QDate**

        This property holds the currently selected date.

        The selected date must be within the date range specified by the
        **minimumDate**  and **maximumDate**  properties. By default, the
        selected date is the current date.

        **Access functions:**

        QDate **selectedDate** () const
        void **setSelectedDate** (QDate
        **date** )

        **See also** **setDateRange** ().
        """
        ...

    def setSelectionMode(
        self, mode: PySide6.QtWidgets.QCalendarWidget.SelectionMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#selectionMode-prop

        **selectionMode : SelectionMode**

        This property holds the type of selection the user can make in the
        calendar

        When this property is set to **SingleSelection** , the user can select a
        date within the minimum and maximum allowed dates, using either the
        mouse or the keyboard.

        When the property is set to **NoSelection** , the user will be unable to
        select dates, but they can still be selected programmatically. Note that
        the date that is selected when the property is set to **NoSelection**
        will still be the selected date of the calendar.

        The default value is **SingleSelection** .

        **Access functions:**

        QCalendarWidget::SelectionMode **selectionMode** () const
        void
        **setSelectionMode** (QCalendarWidget::SelectionMode **mode** )
        """
        ...

    def setVerticalHeaderFormat(
        self, format: PySide6.QtWidgets.QCalendarWidget.VerticalHeaderFormat
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#verticalHeaderFormat-prop

        **verticalHeaderFormat : VerticalHeaderFormat**

        This property holds the format of the vertical header.

        The default value is QCalendarWidget::ISOWeekNumber.

        **Access functions:**

        QCalendarWidget::VerticalHeaderFormat **verticalHeaderFormat** () const
        void **setVerticalHeaderFormat** (QCalendarWidget::VerticalHeaderFormat
        **format** )

        **Member Function Documentation**
        """
        ...

    def setWeekdayTextFormat(
        self,
        dayOfWeek: PySide6.QtCore.Qt.DayOfWeek,
        format: PySide6.QtGui.QTextCharFormat,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#setWeekdayTextFormat

        **void QCalendarWidget::setWeekdayTextFormat(Qt::DayOfWeek dayOfWeek ,
        const QTextCharFormat & format )**

        Sets the text char format for rendering of day in the week **dayOfWeek**
        to **format**. The format will take precedence over the header format in
        case of foreground and background color. Other text formatting
        information is taken from the headers format.

        **See also** **weekdayTextFormat** () and **setHeaderTextFormat** ().
        """
        ...

    def showNextMonth(self) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#showNextMonth

        **[slot] void QCalendarWidget::showNextMonth()**

        Shows the next month relative to the currently displayed month. Note
        that the selected date is not changed.

        **See also** **showPreviousMonth** (), **setCurrentPage** (), and
        **setSelectedDate** ().
        """
        ...

    def showNextYear(self) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#showNextYear

        **[slot] void QCalendarWidget::showNextYear()**

        Shows the currently displayed month in the **next** year relative to the
        currently displayed year. Note that the selected date is not changed.

        **See also** **showPreviousYear** (), **setCurrentPage** (), and
        **setSelectedDate** ().
        """
        ...

    def showPreviousMonth(self) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#showPreviousMonth

        **[slot] void QCalendarWidget::showPreviousMonth()**

        Shows the previous month relative to the currently displayed month. Note
        that the selected date is not changed.

        **See also** **showNextMonth** (), **setCurrentPage** (), and
        **setSelectedDate** ().
        """
        ...

    def showPreviousYear(self) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#showPreviousYear

        **[slot] void QCalendarWidget::showPreviousYear()**

        Shows the currently displayed month in the **previous** year relative to
        the currently displayed year. Note that the selected date is not
        changed.

        **See also** **showNextYear** (), **setCurrentPage** (), and
        **setSelectedDate** ().
        """
        ...

    def showSelectedDate(self) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#showSelectedDate

        **[slot] void QCalendarWidget::showSelectedDate()**

        Shows the month of the selected date.

        **See also** **selectedDate** () and **setCurrentPage** ().
        """
        ...

    def showToday(self) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#showToday

        **[slot] void QCalendarWidget::showToday()**

        Shows the month of the today's date.

        **See also** **selectedDate** () and **setCurrentPage** ().
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#sizeHint

        **[override virtual] QSize QCalendarWidget::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def updateCell(self, date: PySide6.QtCore.QDate) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#updateCell

        **[protected] void QCalendarWidget::updateCell(QDate date )**

        Updates the cell specified by the given **date** unless updates are
        disabled or the cell is hidden.

        **See also** **updateCells** (), **yearShown** (), and **monthShown**
        ().
        """
        ...

    def updateCells(self) -> None:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#updateCells

        **[protected] void QCalendarWidget::updateCells()**

        Updates all visible cells unless updates are disabled.

        **See also** **updateCell** ().
        """
        ...

    def verticalHeaderFormat(
        self,
    ) -> PySide6.QtWidgets.QCalendarWidget.VerticalHeaderFormat:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#verticalHeaderFormat-prop

        **verticalHeaderFormat : VerticalHeaderFormat**

        This property holds the format of the vertical header.

        The default value is QCalendarWidget::ISOWeekNumber.

        **Access functions:**

        QCalendarWidget::VerticalHeaderFormat **verticalHeaderFormat** () const
        void **setVerticalHeaderFormat** (QCalendarWidget::VerticalHeaderFormat
        **format** )

        **Member Function Documentation**
        """
        ...

    def weekdayTextFormat(
        self, dayOfWeek: PySide6.QtCore.Qt.DayOfWeek
    ) -> PySide6.QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#weekdayTextFormat

        **QTextCharFormat QCalendarWidget::weekdayTextFormat(Qt::DayOfWeek
        dayOfWeek ) const**

        Returns the text char format for rendering of day in the week
        **dayOfWeek**.

        **See also** **setWeekdayTextFormat** () and **headerTextFormat** ().
        """
        ...

    def yearShown(self) -> int:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#yearShown

        **int QCalendarWidget::yearShown() const**

        Returns the year of the currently displayed month. Months are numbered
        from 1 to 12.

        **See also** **monthShown** () and **setCurrentPage** ().
        """
        ...

    @property
    def activated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#activated

        **[signal] void QCalendarWidget::activated(QDate date )**

        This signal is emitted whenever the user presses the Return or Enter key
        or double-clicks a **date** in the calendar widget.
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#clicked

        **[signal] void QCalendarWidget::clicked(QDate date )**

        This signal is emitted when a mouse button is clicked. The date the
        mouse was clicked on is specified by **date**. The signal is only
        emitted when clicked on a valid date, e.g., dates are not outside the
        **minimumDate** () and **maximumDate** (). If the selection mode is
        **NoSelection** , this signal will not be emitted.
        """
        ...

    @property
    def currentPageChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#currentPageChanged

        **[signal] void QCalendarWidget::currentPageChanged(int year , int month
        )**

        This signal is emitted when the currently shown month is changed. The
        new **year** and **month** are passed as parameters.

        **See also** **setCurrentPage** ().
        """
        ...

    @property
    def selectionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcalendarwidget.html#selectionChanged

        **[signal] void QCalendarWidget::selectionChanged()**

        This signal is emitted when the currently selected date is changed.

        The currently selected date can be changed by the user using the mouse
        or keyboard, or by the programmer using **setSelectedDate** ().

        **See also** **selectedDate** ().
        """
        ...
