"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebSockets, except for defaults which are replaced by "...".
"""
from typing import Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtWebSockets

bytes = str


class QWebSocket(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebsocket.html

    **Detailed Description**

    WebSockets is a web technology providing full-duplex communications channels
    over a single TCP connection. The WebSocket protocol was standardized by the
    IETF as **RFC 6455**  in 2011. QWebSocket can both be used in a client
    application and server application.

    This class was modeled after **QAbstractSocket** .

    QWebSocket currently does not support **WebSocket Extensions**  and
    **WebSocket Subprotocols** .

    QWebSocket only supports version 13 of the WebSocket protocol, as outlined
    in **RFC 6455** .

    **Note:** Some proxies do not understand certain HTTP headers used during a
    WebSocket handshake. In that case, non-secure WebSocket connections fail.
    The best way to mitigate against this problem is to use WebSocket over a
    secure connection.

    **Warning:** To generate masks, this implementation of WebSockets uses the
    reasonably secure **QRandomGenerator::global** ()->generate() function. For
    more information about the importance of good masking, see **"Talking to
    Yourself for Fun and Profit" by Lin-Shung Huang et al** . The best measure
    against attacks mentioned in the document above, is to use QWebSocket over a
    secure connection ( **wss://** ). In general, always be careful to not have
    3rd party script access to a QWebSocket in your application.

    **See also** **QAbstractSocket** , **QTcpSocket** , and **QWebSocket client
    example** .
    """

    def __init__(
        self,
        origin: str = ...,
        version: PySide6.QtWebSockets.QWebSocketProtocol.Version = ...,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#QWebSocket-1

        **QWebSocket::QWebSocket(const QString & origin = QString(),
        QWebSocketProtocol::Version version = QWebSocketProtocol::VersionLatest,
        QObject * parent = nullptr)**

        Creates a new QWebSocket with the given **origin** , the **version** of
        the protocol to use and **parent**.

        The **origin** of the client is as specified in **RFC 6454** . (The
        **origin** is not required for non-web browser clients (see **RFC 6455**
        )). The **origin** may not contain new line characters, otherwise the
        connection will be aborted immediately during the handshake phase.

        **Note:** Currently only V13 (**RFC 6455** ) is supported
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#abort

        **void QWebSocket::abort()**

        Aborts the current socket and resets the socket. Unlike **close** (),
        this function immediately closes the socket, discarding any pending data
        in the write buffer.
        """
        ...

    def bytesToWrite(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#bytesToWrite

        **[since 5.12] qint64 QWebSocket::bytesToWrite() const**

        Returns the number of bytes that are waiting to be written. The bytes
        are written when control goes back to the event loop or when **flush**
        () is called.

        This function was introduced in Qt 5.12.

        **See also** **flush** .
        """
        ...

    def close(
        self,
        closeCode: PySide6.QtWebSockets.QWebSocketProtocol.CloseCode = ...,
        reason: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#close

        **[slot] void QWebSocket::close(QWebSocketProtocol::CloseCode closeCode
        = QWebSocketProtocol::CloseCodeNormal, const QString & reason =
        QString())**

        Gracefully closes the socket with the given **closeCode** and
        **reason**.

        Any data in the write buffer is flushed before the socket is closed. The
        **closeCode** is a **QWebSocketProtocol::CloseCode**  indicating the
        reason to close, and **reason** describes the reason of the closure more
        in detail. All control frames, including the Close frame, are limited to
        125 bytes. Since two of these are used for **closeCode** the maximum
        length of **reason** is 123! If **reason** exceeds this limit it will be
        truncated.
        """
        ...

    def closeCode(self) -> PySide6.QtWebSockets.QWebSocketProtocol.CloseCode:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#closeCode

        **QWebSocketProtocol::CloseCode QWebSocket::closeCode() const**

        Returns the code indicating why the socket was closed.

        **See also** **QWebSocketProtocol::CloseCode**  and **closeReason** ().
        """
        ...

    def closeReason(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#closeReason

        **QString QWebSocket::closeReason() const**

        Returns the reason why the socket was closed.

        **See also** **closeCode** ().
        """
        ...

    def continueInterruptedHandshake(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#continueInterruptedHandshake

        **[since 6.2] void QWebSocket::continueInterruptedHandshake()**

        If an application wants to conclude a handshake even after receiving
        **handshakeInterruptedOnError** () signal, it must call this function.
        This call must be done from a slot function attached to the signal. The
        signal-slot connection must be direct.

        This function was introduced in Qt 6.2.

        **See also** **handshakeInterruptedOnError** () and
        **QSslConfiguration::setHandshakeMustInterruptOnError** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#errorString

        **QString QWebSocket::errorString() const**

        Returns a human-readable description of the last error that occurred

        **See also** **error** ().
        """
        ...

    def flush(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#flush

        **bool QWebSocket::flush()**

        This function writes as much as possible from the internal write buffer
        to the underlying network socket, without blocking. If any data was
        written, this function returns true; otherwise false is returned. Call
        this function if you need **QWebSocket**  to start sending buffered data
        immediately. The number of bytes successfully written depends on the
        operating system. In most cases, you do not need to call this function,
        because **QWebSocket**  will start sending data automatically once
        control goes back to the event loop.
        """
        ...

    @overload
    def ignoreSslErrors(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#ignoreSslErrors

        **[slot] void QWebSocket::ignoreSslErrors()**

        This slot tells **QWebSocket**  to ignore errors during **QWebSocket**
        's handshake phase and continue connecting. If you want to continue with
        the connection even if errors occur during the handshake phase, then you
        must call this slot, either from a slot connected to **sslErrors** (),
        or before the handshake phase. If you don't call this slot, either in
        response to errors or before the handshake, the connection will be
        dropped after the **sslErrors** () signal has been emitted.

        **Warning:** Be sure to always let the user inspect the errors reported
        by the **sslErrors** () signal, and only call this method upon
        confirmation from the user that proceeding is ok. If there are
        unexpected errors, the connection should be aborted. Calling this method
        without inspecting the actual errors will most likely pose a security
        risk for your application. Use it with great care!

        **See also** **sslErrors** (), **QSslSocket::ignoreSslErrors** (), and
        **QNetworkReply::ignoreSslErrors** ().
        """
        ...

    @overload
    def ignoreSslErrors(self, errors: Sequence[PySide6.QtNetwork.QSslError]) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#ignoreSslErrors-1

        **void QWebSocket::ignoreSslErrors(const QList<QSslError> & errors )**

        This is an overloaded function.

        This method tells **QWebSocket**  to ignore the errors given in
        **errors**.

        Note that you can set the expected certificate in the SSL error: If, for
        instance, you want to connect to a server that uses a self-signed
        certificate, consider the following snippet:

        **QList** <**QSslCertificate** > cert = **QSslCertificate**
        ::fromPath(QLatin1String("server-certificate.pem"));
            **QSslError**
        error(**QSslError** ::SelfSignedCertificate, cert.at(0));
            **QList**
        <**QSslError** > expectedSslErrors;
            expectedSslErrors.append(error);
        QWebSocket socket;
            socket.ignoreSslErrors(expectedSslErrors);
        socket.open(**QUrl** (**QStringLiteral** ("wss://myserver.at.home")));

        Multiple calls to this function will replace the list of errors that
        were passed in previous calls. You can clear the list of errors you want
        to ignore by calling this function with an empty list.

        **See also** **sslErrors** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#isValid

        **bool QWebSocket::isValid() const**

        Returns `true` if the socket is ready for reading and writing; otherwise
        returns `false`.
        """
        ...

    def localAddress(self) -> PySide6.QtNetwork.QHostAddress:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#localAddress

        **QHostAddress QWebSocket::localAddress() const**

        Returns the local address
        """
        ...

    def localPort(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#localPort

        **quint16 QWebSocket::localPort() const**

        Returns the local port
        """
        ...

    def maskGenerator(self) -> PySide6.QtWebSockets.QMaskGenerator:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#maskGenerator

        **const QMaskGenerator *QWebSocket::maskGenerator() const**

        Returns the mask generator that is currently used by this **QWebSocket**
        .

        **See also** **setMaskGenerator** ().
        """
        ...

    def maxAllowedIncomingFrameSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#maxAllowedIncomingFrameSize

        **[since 5.15] quint64 QWebSocket::maxAllowedIncomingFrameSize() const**

        Returns the maximum allowed size of an incoming websocket frame.

        This function was introduced in Qt 5.15.

        **See also** **setMaxAllowedIncomingFrameSize** ().
        """
        ...

    def maxAllowedIncomingMessageSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#maxAllowedIncomingMessageSize

        **[since 5.15] quint64 QWebSocket::maxAllowedIncomingMessageSize()
        const**

        Returns the maximum allowed size of an incoming websocket message.

        This function was introduced in Qt 5.15.

        **See also** **setMaxAllowedIncomingMessageSize** ().
        """
        ...

    @staticmethod
    def maxIncomingFrameSize() -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#maxIncomingFrameSize

        **[static, since 5.15] quint64 QWebSocket::maxIncomingFrameSize()**

        Returns the maximum supported size of an incoming websocket frame for
        this websocket implementation.

        This function was introduced in Qt 5.15.
        """
        ...

    @staticmethod
    def maxIncomingMessageSize() -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#maxIncomingMessageSize

        **[static, since 5.15] quint64 QWebSocket::maxIncomingMessageSize()**

        Returns the maximum supported size of an incoming websocket message for
        this websocket implementation.

        This function was introduced in Qt 5.15.
        """
        ...

    @staticmethod
    def maxOutgoingFrameSize() -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#maxOutgoingFrameSize

        **[static, since 5.15] quint64 QWebSocket::maxOutgoingFrameSize()**

        Returns the maximum supported size of an outgoing websocket frame for
        this websocket implementation.

        This function was introduced in Qt 5.15.
        """
        ...

    @overload
    def open(self, request: PySide6.QtNetwork.QNetworkRequest) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#open

        **[slot] void QWebSocket::open(const QUrl & url )**

        Opens a WebSocket connection using the given **url**.

        If the url contains newline characters (\\r\\n), then the error signal
        will be emitted with **QAbstractSocket::ConnectionRefusedError**  as
        error type.
        """
        ...

    @overload
    def open(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#open-1

        **[slot, since 5.6] void QWebSocket::open(const QNetworkRequest &
        request )**

        Opens a WebSocket connection using the given **request**.

        The **request** url will be used to open the WebSocket connection.
        Headers present in the request will be sent to the server in the upgrade
        request, together with the ones needed for the websocket handshake.

        This function was introduced in Qt 5.6.
        """
        ...

    def origin(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#origin

        **QString QWebSocket::origin() const**

        Returns the current origin.
        """
        ...

    def outgoingFrameSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#outgoingFrameSize

        **[since 5.15] quint64 QWebSocket::outgoingFrameSize() const**

        Returns the maximum size of an outgoing websocket frame.

        This function was introduced in Qt 5.15.

        **See also** **setOutgoingFrameSize** ().
        """
        ...

    def pauseMode(self) -> PySide6.QtNetwork.QAbstractSocket.PauseModes:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#pauseMode

        **QAbstractSocket::PauseModes QWebSocket::pauseMode() const**

        Returns the pause mode of this socket

        **See also** **setPauseMode** ().
        """
        ...

    def peerAddress(self) -> PySide6.QtNetwork.QHostAddress:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#peerAddress

        **QHostAddress QWebSocket::peerAddress() const**

        Returns the peer address
        """
        ...

    def peerName(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#peerName

        **QString QWebSocket::peerName() const**

        Returns the peerName
        """
        ...

    def peerPort(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#peerPort

        **quint16 QWebSocket::peerPort() const**

        Returns the peerport
        """
        ...

    def ping(self, payload: Union[PySide6.QtCore.QByteArray, bytes] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#ping

        **[slot] void QWebSocket::ping(const QByteArray & payload =
        QByteArray())**

        Pings the server to indicate that the connection is still alive.
        Additional **payload** can be sent along the ping message.

        The size of the **payload** cannot be bigger than 125. If it is larger,
        the **payload** is clipped to 125 bytes.

        **Note:****QWebSocket**  and **QWebSocketServer**  handles ping requests
        internally, which means they automatically send back a pong response to
        the peer.

        **See also** **pong** ().
        """
        ...

    def proxy(self) -> PySide6.QtNetwork.QNetworkProxy:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#proxy

        **QNetworkProxy QWebSocket::proxy() const**

        Returns the currently configured proxy

        **See also** **setProxy** ().
        """
        ...

    def readBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#readBufferSize

        **qint64 QWebSocket::readBufferSize() const**

        Returns the size in bytes of the readbuffer that is used by the socket.

        **See also** **setReadBufferSize** ().
        """
        ...

    def request(self) -> PySide6.QtNetwork.QNetworkRequest:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#request

        **[since 5.6] QNetworkRequest QWebSocket::request() const**

        Returns the request that was or will be used to open this socket.

        This function was introduced in Qt 5.6.
        """
        ...

    def requestUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#requestUrl

        **QUrl QWebSocket::requestUrl() const**

        Returns the url the socket is connected to or will connect to.
        """
        ...

    def resourceName(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#resourceName

        **QString QWebSocket::resourceName() const**

        Returns the name of the resource currently accessed.
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#resume

        **void QWebSocket::resume()**

        Continues data transfer on the socket. This method should only be used
        after the socket has been set to pause upon notifications and a
        notification has been received. The only notification currently
        supported is **sslErrors** (). Calling this method if the socket is not
        paused results in undefined behavior.

        **See also** **pauseMode** () and **setPauseMode** ().
        """
        ...

    def sendBinaryMessage(self, data: Union[PySide6.QtCore.QByteArray, bytes]) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#sendBinaryMessage

        **qint64 QWebSocket::sendBinaryMessage(const QByteArray & data )**

        Sends the given **data** over the socket as a binary message and returns
        the number of bytes actually sent.

        **See also** **sendTextMessage** ().
        """
        ...

    def sendTextMessage(self, message: str) -> int:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#sendTextMessage

        **qint64 QWebSocket::sendTextMessage(const QString & message )**

        Sends the given **message** over the socket as a text message and
        returns the number of bytes actually sent.

        **See also** **sendBinaryMessage** ().
        """
        ...

    def setMaskGenerator(
        self, maskGenerator: PySide6.QtWebSockets.QMaskGenerator
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#setMaskGenerator

        **void QWebSocket::setMaskGenerator(const QMaskGenerator * maskGenerator
        )**

        Sets the generator to use for creating masks to **maskGenerator**. The
        default **QWebSocket**  generator can be reset by supplying a
        **nullptr**. The mask generator can be changed at any time, even while
        the connection is open.

        **See also** **maskGenerator** ().
        """
        ...

    def setMaxAllowedIncomingFrameSize(self, maxAllowedIncomingFrameSize: int) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#setMaxAllowedIncomingFrameSize

        **[since 5.15] void QWebSocket::setMaxAllowedIncomingFrameSize(quint64
        maxAllowedIncomingFrameSize )**

        Sets the maximum allowed size of an incoming websocket frame to
        **maxAllowedIncomingFrameSize**. If an incoming frame exceeds this
        limit, the peer gets disconnected. The accepted range is between 0 and
        **maxIncomingFrameSize** (), default is **maxIncomingFrameSize** (). The
        purpose of this function is to avoid exhausting virtual memory.

        This function was introduced in Qt 5.15.

        **See also** **maxAllowedIncomingFrameSize** ().
        """
        ...

    def setMaxAllowedIncomingMessageSize(
        self, maxAllowedIncomingMessageSize: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#setMaxAllowedIncomingMessageSize

        **[since 5.15] void QWebSocket::setMaxAllowedIncomingMessageSize(quint64
        maxAllowedIncomingMessageSize )**

        Sets the maximum allowed size of an incoming websocket message to
        **maxAllowedIncomingMessageSize**. If an incoming message exceeds this
        limit, the peer gets disconnected. The accepted range is between 0 and
        **maxIncomingMessageSize** (), default is **maxIncomingMessageSize** ().
        The purpose of this function is to avoid exhausting virtual memory.

        This function was introduced in Qt 5.15.

        **See also** **maxAllowedIncomingMessageSize** ().
        """
        ...

    def setOutgoingFrameSize(self, outgoingFrameSize: int) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#setOutgoingFrameSize

        **[since 5.15] void QWebSocket::setOutgoingFrameSize(quint64
        outgoingFrameSize )**

        Sets the maximum size of an outgoing websocket frame to
        **outgoingFrameSize**. The accepted range is between 0 and
        **maxOutgoingFrameSize** (), default is 512kB. The purpose of this
        function is to adapt to the maximum allowed frame size of the receiver.

        This function was introduced in Qt 5.15.

        **See also** **outgoingFrameSize** ().
        """
        ...

    def setPauseMode(
        self, pauseMode: PySide6.QtNetwork.QAbstractSocket.PauseModes
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#setPauseMode

        **void QWebSocket::setPauseMode(QAbstractSocket::PauseModes pauseMode
        )**

        Controls whether to pause upon receiving a notification. The
        **pauseMode** parameter specifies the conditions in which the socket
        should be paused.

        The only notification currently supported is **sslErrors** (). If set to
        PauseOnSslErrors, data transfer on the socket will be paused and needs
        to be enabled explicitly again by calling **resume** (). By default,
        this option is set to PauseNever. This option must be called before
        connecting to the server, otherwise it will result in undefined
        behavior.

        **See also** **pauseMode** () and **resume** ().
        """
        ...

    def setProxy(
        self,
        networkProxy: Union[
            PySide6.QtNetwork.QNetworkProxy, PySide6.QtNetwork.QNetworkProxy.ProxyType
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#setProxy

        **void QWebSocket::setProxy(const QNetworkProxy & networkProxy )**

        Sets the proxy to **networkProxy**

        **See also** **proxy** ().
        """
        ...

    def setReadBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#setReadBufferSize

        **void QWebSocket::setReadBufferSize(qint64 size )**

        Sets the size of **QWebSocket** 's internal read buffer to be **size**
        bytes.

        If the buffer size is limited to a certain size, **QWebSocket**  won't
        buffer more than this size of data. Exceptionally, a buffer size of 0
        means that the read buffer is unlimited and all incoming data is
        buffered. This is the default. This option is useful if you only read
        the data at certain points in time (for example, in a real-time
        streaming application) or if you want to protect your socket against
        receiving too much data, which may eventually cause your application to
        run out of memory.

        **See also** **readBufferSize** ().
        """
        ...

    def setSslConfiguration(
        self, sslConfiguration: PySide6.QtNetwork.QSslConfiguration
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#setSslConfiguration

        **void QWebSocket::setSslConfiguration(const QSslConfiguration &
        sslConfiguration )**

        Sets the socket's SSL configuration to be the contents of
        **sslConfiguration**.

        This function sets the local certificate, the ciphers, the private key
        and the CA certificates to those stored in **sslConfiguration**. It is
        not possible to set the SSL-state related fields.

        **See also** **sslConfiguration** ().
        """
        ...

    def sslConfiguration(self) -> PySide6.QtNetwork.QSslConfiguration:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#sslConfiguration

        **QSslConfiguration QWebSocket::sslConfiguration() const**

        Returns the socket's SSL configuration state. The default SSL
        configuration of a socket is to use the default ciphers, default CA
        certificates, no local private key or certificate. The SSL configuration
        also contains fields that can change with time without notice.

        **See also** **setSslConfiguration** ().
        """
        ...

    def state(self) -> PySide6.QtNetwork.QAbstractSocket.SocketState:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#state

        **QAbstractSocket::SocketState QWebSocket::state() const**

        Returns the current state of the socket.
        """
        ...

    def version(self) -> PySide6.QtWebSockets.QWebSocketProtocol.Version:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#version

        **QWebSocketProtocol::Version QWebSocket::version() const**

        Returns the version the socket is currently using.
        """
        ...

    @property
    def aboutToClose(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#aboutToClose

        **[signal] void QWebSocket::aboutToClose()**

        This signal is emitted when the socket is about to close. Connect this
        signal if you have operations that need to be performed before the
        socket closes (e.g., if you have data in a separate buffer that needs to
        be written to the device).

        **See also** **close** ().
        """
        ...

    @property
    def alertReceived(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#alertReceived

        **[signal, since 6.2] void QWebSocket::alertReceived(QSsl::AlertLevel
        level , QSsl::AlertType type , const QString & description )**

        **QWebSocket**  emits this signal if an alert message was received from
        a peer. **level** tells if the alert was fatal or it was a warning.
        **type** is the code explaining why the alert was sent. When a textual
        description of the alert message is available, it is supplied in
        **description**.

        **Note:** The signal is mostly for informational and debugging purposes
        and does not require any handling in the application. If the alert was
        fatal, underlying backend will handle it and close the connection.

        **Note:** Not all backends support this functionality.

        This function was introduced in Qt 6.2.

        **See also** **alertSent** (), **QSsl::AlertLevel** , and
        **QSsl::AlertType** .
        """
        ...

    @property
    def alertSent(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#alertSent

        **[signal, since 6.2] void QWebSocket::alertSent(QSsl::AlertLevel level
        , QSsl::AlertType type , const QString & description )**

        **QWebSocket**  emits this signal if an alert message was sent to a
        peer. **level** describes if it was a warning or a fatal error. **type**
        gives the code of the alert message. When a textual description of the
        alert message is available, it is supplied in **description**.

        **Note:** This signal is mostly informational and can be used for
        debugging purposes, normally it does not require any actions from the
        application.

        **Note:** Not all backends support this functionality.

        This function was introduced in Qt 6.2.

        **See also** **alertReceived** (), **QSsl::AlertLevel** , and
        **QSsl::AlertType** .
        """
        ...

    @property
    def binaryFrameReceived(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#binaryFrameReceived

        **[signal] void QWebSocket::binaryFrameReceived(const QByteArray & frame
        , bool isLastFrame )**

        This signal is emitted whenever a binary frame is received. The
        **frame** contains the data and **isLastFrame** indicates whether this
        is the last frame of the complete message.

        This signal can be used to process large messages frame by frame,
        instead of waiting for the complete message to arrive.

        **See also** **textFrameReceived** ().
        """
        ...

    @property
    def binaryMessageReceived(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#binaryMessageReceived

        **[signal] void QWebSocket::binaryMessageReceived(const QByteArray &
        message )**

        This signal is emitted whenever a binary message is received. The
        **message** contains the received bytes.

        **See also** **textMessageReceived** ().
        """
        ...

    @property
    def bytesWritten(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#bytesWritten

        **[signal] void QWebSocket::bytesWritten(qint64 bytes )**

        This signal is emitted every time a payload of data has been written to
        the socket. The **bytes** argument is set to the number of bytes that
        were written in this payload.

        **Note:** This signal has the same meaning both for secure and non-
        secure WebSockets. As opposed to **QSslSocket** , bytesWritten() is only
        emitted when encrypted data is effectively written (see
        **QSslSocket::encryptedBytesWritten** ()).

        **See also** **close** ().
        """
        ...

    @property
    def connected(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#connected

        **[signal] void QWebSocket::connected()**

        Emitted when a connection is successfully established. A connection is
        successfully established when the socket is connected and the handshake
        was successful.

        **See also** **open** () and **disconnected** ().
        """
        ...

    @property
    def disconnected(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#disconnected

        **[signal] void QWebSocket::disconnected()**

        Emitted when the socket is disconnected.

        **See also** **close** () and **connected** ().
        """
        ...

    @property
    def error(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#error

        **QAbstractSocket::SocketError QWebSocket::error() const**

        Returns the type of error that last occurred

        **See also** **errorString** ().
        """
        ...

    @property
    def handshakeInterruptedOnError(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#handshakeInterruptedOnError

        **[signal, since 6.2] void QWebSocket::handshakeInterruptedOnError(const
        QSslError & error )**

        **QWebSocket**  emits this signal if a certificate verification error
        was found and if early error reporting was enabled in
        **QSslConfiguration** . An application is expected to inspect the
        **error** and decide if it wants to continue the handshake, or abort it
        and send an alert message to the peer. The signal-slot connection must
        be direct.

        This function was introduced in Qt 6.2.

        **See also** **continueInterruptedHandshake** (), **sslErrors** (), and
        **QSslConfiguration::setHandshakeMustInterruptOnError** ().
        """
        ...

    @property
    def peerVerifyError(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#peerVerifyError

        **[signal, since 6.2] void QWebSocket::peerVerifyError(const QSslError &
        error )**

        **QWebSocket**  can emit this signal several times during the SSL
        handshake, before encryption has been established, to indicate that an
        error has occurred while establishing the identity of the peer. The
        **error** is usually an indication that **QWebSocket**  is unable to
        securely identify the peer.

        This signal provides you with an early indication when something's
        wrong. By connecting to this signal, you can manually choose to tear
        down the connection from inside the connected slot before the handshake
        has completed. If no action is taken, **QWebSocket**  will proceed to
        emitting **QWebSocket::sslErrors** ().

        This function was introduced in Qt 6.2.

        **See also** **sslErrors** ().
        """
        ...

    @property
    def pong(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#pong

        **[signal] void QWebSocket::pong(quint64 elapsedTime , const QByteArray
        & payload )**

        Emitted when a pong message is received in reply to a previous ping.
        **elapsedTime** contains the roundtrip time in milliseconds and
        **payload** contains an optional payload that was sent with the ping.

        **See also** **ping** ().
        """
        ...

    @property
    def preSharedKeyAuthenticationRequired(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#preSharedKeyAuthenticationRequire
        d

        **[signal, since 5.8] void QWebSocket::preSharedKeyAuthenticationRequire
        d(QSslPreSharedKeyAuthenticator * authenticator )**

        This signal is emitted if the SSL/TLS handshake negotiates a PSK
        ciphersuite, and therefore a PSK authentication is then required.

        When using PSK, the client must send to the server a valid identity and
        a valid pre shared key, in order for the SSL handshake to continue.
        Applications can provide this information in a slot connected to this
        signal, by filling in the passed **authenticator** object according to
        their needs.

        **Note:** Ignoring this signal, or failing to provide the required
        credentials, will cause the handshake to fail, and therefore the
        connection to be aborted.

        **Note:** The **authenticator** object is owned by the websocket and
        must not be deleted by the application.

        This function was introduced in Qt 5.8.

        **See also** **QSslPreSharedKeyAuthenticator**  and
        **QSslSocket::preSharedKeyAuthenticationRequired** ().
        """
        ...

    @property
    def proxyAuthenticationRequired(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#proxyAuthenticationRequired

        **[signal] void QWebSocket::proxyAuthenticationRequired(const
        QNetworkProxy & proxy , QAuthenticator * authenticator )**

        This signal can be emitted when a **proxy** that requires authentication
        is used. The **authenticator** object can then be filled in with the
        required details to allow authentication and continue the connection.

        **Note:** It is not possible to use a QueuedConnection to connect to
        this signal, as the connection will fail if the authenticator has not
        been filled in with new information when the signal returns.

        **See also** **QAuthenticator**  and **QNetworkProxy** .
        """
        ...

    @property
    def readChannelFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#readChannelFinished

        **[signal] void QWebSocket::readChannelFinished()**

        This signal is emitted when the input (reading) stream is closed in this
        device. It is emitted as soon as the closing is detected.

        **See also** **close** ().
        """
        ...

    @property
    def sslErrors(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#sslErrors

        **[signal] void QWebSocket::sslErrors(const QList<QSslError> & errors
        )**

        **QWebSocket**  emits this signal after the SSL handshake to indicate
        that one or more errors have occurred while establishing the identity of
        the peer. The errors are usually an indication that **QWebSocket**  is
        unable to securely identify the peer. Unless any action is taken, the
        connection will be dropped after this signal has been emitted. If you
        want to continue connecting despite the errors that have occurred, you
        must call **QWebSocket::ignoreSslErrors** () from inside a slot
        connected to this signal. If you need to access the error list at a
        later point, you can call sslErrors() (without arguments).

        **errors** contains one or more errors that prevent **QWebSocket**  from
        verifying the identity of the peer.

        **Note:** You cannot use **Qt::QueuedConnection**  when connecting to
        this signal, or calling **QWebSocket::ignoreSslErrors** () will have no
        effect.
        """
        ...

    @property
    def stateChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#stateChanged

        **[signal] void QWebSocket::stateChanged(QAbstractSocket::SocketState
        state )**

        This signal is emitted whenever **QWebSocket** 's state changes. The
        **state** parameter is the new state.

        **Note:****QAbstractSocket::ConnectedState**  is emitted after the
        handshake with the server has succeeded.

        **QAbstractSocket::SocketState**  is not a registered metatype, so for
        queued connections, you will have to register it with
        Q_REGISTER_METATYPE() and **qRegisterMetaType** ().

        **See also** **state** ().
        """
        ...

    @property
    def textFrameReceived(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#textFrameReceived

        **[signal] void QWebSocket::textFrameReceived(const QString & frame ,
        bool isLastFrame )**

        This signal is emitted whenever a text frame is received. The **frame**
        contains the data and **isLastFrame** indicates whether this is the last
        frame of the complete message.

        This signal can be used to process large messages frame by frame,
        instead of waiting for the complete message to arrive.

        **See also** **binaryFrameReceived** ().
        """
        ...

    @property
    def textMessageReceived(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebsocket.html#textMessageReceived

        **[signal] void QWebSocket::textMessageReceived(const QString & message
        )**

        This signal is emitted whenever a text message is received. The
        **message** contains the received text.

        **See also** **binaryMessageReceived** ().
        """
        ...
