"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineSettings(object):
    """
    https://doc.qt.io/qt-6/qwebenginesettings.html

    **Detailed Description**

    QWebEngineSettings allows configuration of browser properties, such as font
    sizes and families, the location of a custom style sheet, and generic
    attributes, such as JavaScript support. Individual attributes are set using
    the **setAttribute** () function. The **WebAttribute**  enum further
    describes each attribute.

    Each **QWebEnginePage**  object has its own QWebEngineSettings object, which
    configures the settings for that page. If a setting is not configured for a
    web engine page, it is looked up in the settings of the profile the page
    belongs to.

    **See also** **QWebEnginePage::settings** () and
    **QWebEngineView::settings** ().
    """

    StandardFont: QWebEngineSettings.FontFamily = ...
    FixedFont: QWebEngineSettings.FontFamily = ...
    SerifFont: QWebEngineSettings.FontFamily = ...
    SansSerifFont: QWebEngineSettings.FontFamily = ...
    CursiveFont: QWebEngineSettings.FontFamily = ...
    FantasyFont: QWebEngineSettings.FontFamily = ...
    PictographFont: QWebEngineSettings.FontFamily = ...
    MinimumFontSize: QWebEngineSettings.FontSize = ...
    MinimumLogicalFontSize: QWebEngineSettings.FontSize = ...
    DefaultFontSize: QWebEngineSettings.FontSize = ...
    DefaultFixedFontSize: QWebEngineSettings.FontSize = ...
    InheritedUnknownUrlSchemePolicy: QWebEngineSettings.UnknownUrlSchemePolicy = ...
    DisallowUnknownUrlSchemes: QWebEngineSettings.UnknownUrlSchemePolicy = ...
    AllowUnknownUrlSchemesFromUserInteraction: QWebEngineSettings.UnknownUrlSchemePolicy = (
        ...
    )
    AllowAllUnknownUrlSchemes: QWebEngineSettings.UnknownUrlSchemePolicy = ...
    AutoLoadImages: QWebEngineSettings.WebAttribute = ...
    JavascriptEnabled: QWebEngineSettings.WebAttribute = ...
    JavascriptCanOpenWindows: QWebEngineSettings.WebAttribute = ...
    JavascriptCanAccessClipboard: QWebEngineSettings.WebAttribute = ...
    LinksIncludedInFocusChain: QWebEngineSettings.WebAttribute = ...
    LocalStorageEnabled: QWebEngineSettings.WebAttribute = ...
    LocalContentCanAccessRemoteUrls: QWebEngineSettings.WebAttribute = ...
    XSSAuditingEnabled: QWebEngineSettings.WebAttribute = ...
    SpatialNavigationEnabled: QWebEngineSettings.WebAttribute = ...
    LocalContentCanAccessFileUrls: QWebEngineSettings.WebAttribute = ...
    HyperlinkAuditingEnabled: QWebEngineSettings.WebAttribute = ...
    ScrollAnimatorEnabled: QWebEngineSettings.WebAttribute = ...
    ErrorPageEnabled: QWebEngineSettings.WebAttribute = ...
    PluginsEnabled: QWebEngineSettings.WebAttribute = ...
    FullScreenSupportEnabled: QWebEngineSettings.WebAttribute = ...
    ScreenCaptureEnabled: QWebEngineSettings.WebAttribute = ...
    WebGLEnabled: QWebEngineSettings.WebAttribute = ...
    Accelerated2dCanvasEnabled: QWebEngineSettings.WebAttribute = ...
    AutoLoadIconsForPage: QWebEngineSettings.WebAttribute = ...
    TouchIconsEnabled: QWebEngineSettings.WebAttribute = ...
    FocusOnNavigationEnabled: QWebEngineSettings.WebAttribute = ...
    PrintElementBackgrounds: QWebEngineSettings.WebAttribute = ...
    AllowRunningInsecureContent: QWebEngineSettings.WebAttribute = ...
    AllowGeolocationOnInsecureOrigins: QWebEngineSettings.WebAttribute = ...
    AllowWindowActivationFromJavaScript: QWebEngineSettings.WebAttribute = ...
    ShowScrollBars: QWebEngineSettings.WebAttribute = ...
    PlaybackRequiresUserGesture: QWebEngineSettings.WebAttribute = ...
    WebRTCPublicInterfacesOnly: QWebEngineSettings.WebAttribute = ...
    JavascriptCanPaste: QWebEngineSettings.WebAttribute = ...
    DnsPrefetchEnabled: QWebEngineSettings.WebAttribute = ...
    PdfViewerEnabled: QWebEngineSettings.WebAttribute = ...

    class FontFamily(Enum):
        StandardFont: QWebEngineSettings.FontFamily = ...
        FixedFont: QWebEngineSettings.FontFamily = ...
        SerifFont: QWebEngineSettings.FontFamily = ...
        SansSerifFont: QWebEngineSettings.FontFamily = ...
        CursiveFont: QWebEngineSettings.FontFamily = ...
        FantasyFont: QWebEngineSettings.FontFamily = ...
        PictographFont: QWebEngineSettings.FontFamily = ...

    class FontSize(Enum):
        MinimumFontSize: QWebEngineSettings.FontSize = ...
        MinimumLogicalFontSize: QWebEngineSettings.FontSize = ...
        DefaultFontSize: QWebEngineSettings.FontSize = ...
        DefaultFixedFontSize: QWebEngineSettings.FontSize = ...

    class UnknownUrlSchemePolicy(Enum):
        InheritedUnknownUrlSchemePolicy: QWebEngineSettings.UnknownUrlSchemePolicy = ...
        DisallowUnknownUrlSchemes: QWebEngineSettings.UnknownUrlSchemePolicy = ...
        AllowUnknownUrlSchemesFromUserInteraction: QWebEngineSettings.UnknownUrlSchemePolicy = (
            ...
        )
        AllowAllUnknownUrlSchemes: QWebEngineSettings.UnknownUrlSchemePolicy = ...

    class WebAttribute(Enum):
        AutoLoadImages: QWebEngineSettings.WebAttribute = ...
        JavascriptEnabled: QWebEngineSettings.WebAttribute = ...
        JavascriptCanOpenWindows: QWebEngineSettings.WebAttribute = ...
        JavascriptCanAccessClipboard: QWebEngineSettings.WebAttribute = ...
        LinksIncludedInFocusChain: QWebEngineSettings.WebAttribute = ...
        LocalStorageEnabled: QWebEngineSettings.WebAttribute = ...
        LocalContentCanAccessRemoteUrls: QWebEngineSettings.WebAttribute = ...
        XSSAuditingEnabled: QWebEngineSettings.WebAttribute = ...
        SpatialNavigationEnabled: QWebEngineSettings.WebAttribute = ...
        LocalContentCanAccessFileUrls: QWebEngineSettings.WebAttribute = ...
        HyperlinkAuditingEnabled: QWebEngineSettings.WebAttribute = ...
        ScrollAnimatorEnabled: QWebEngineSettings.WebAttribute = ...
        ErrorPageEnabled: QWebEngineSettings.WebAttribute = ...
        PluginsEnabled: QWebEngineSettings.WebAttribute = ...
        FullScreenSupportEnabled: QWebEngineSettings.WebAttribute = ...
        ScreenCaptureEnabled: QWebEngineSettings.WebAttribute = ...
        WebGLEnabled: QWebEngineSettings.WebAttribute = ...
        Accelerated2dCanvasEnabled: QWebEngineSettings.WebAttribute = ...
        AutoLoadIconsForPage: QWebEngineSettings.WebAttribute = ...
        TouchIconsEnabled: QWebEngineSettings.WebAttribute = ...
        FocusOnNavigationEnabled: QWebEngineSettings.WebAttribute = ...
        PrintElementBackgrounds: QWebEngineSettings.WebAttribute = ...
        AllowRunningInsecureContent: QWebEngineSettings.WebAttribute = ...
        AllowGeolocationOnInsecureOrigins: QWebEngineSettings.WebAttribute = ...
        AllowWindowActivationFromJavaScript: QWebEngineSettings.WebAttribute = ...
        ShowScrollBars: QWebEngineSettings.WebAttribute = ...
        PlaybackRequiresUserGesture: QWebEngineSettings.WebAttribute = ...
        WebRTCPublicInterfacesOnly: QWebEngineSettings.WebAttribute = ...
        JavascriptCanPaste: QWebEngineSettings.WebAttribute = ...
        DnsPrefetchEnabled: QWebEngineSettings.WebAttribute = ...
        PdfViewerEnabled: QWebEngineSettings.WebAttribute = ...

    def defaultTextEncoding(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#defaultTextEncoding

        **QString QWebEngineSettings::defaultTextEncoding() const**

        Returns the default text encoding.

        **See also** **setDefaultTextEncoding** ().
        """
        ...

    def fontFamily(
        self, which: PySide6.QtWebEngineCore.QWebEngineSettings.FontFamily
    ) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#fontFamily

        **QString QWebEngineSettings::fontFamily(QWebEngineSettings::FontFamily
        which ) const**

        Returns the actual font family for the specified generic font family,
        **which**.
        """
        ...

    def fontSize(
        self, type: PySide6.QtWebEngineCore.QWebEngineSettings.FontSize
    ) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#fontSize

        **int QWebEngineSettings::fontSize(QWebEngineSettings::FontSize type )
        const**

        Returns the default font size for **type** in pixels.

        **See also** **setFontSize** ().
        """
        ...

    def resetAttribute(
        self, attr: PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#resetAttribute

        **void
        QWebEngineSettings::resetAttribute(QWebEngineSettings::WebAttribute
        attribute )**

        Resets the setting of **attribute** to the value specified in the
        profile that the page belongs to.
        """
        ...

    def resetFontFamily(
        self, which: PySide6.QtWebEngineCore.QWebEngineSettings.FontFamily
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#resetFontFamily

        **void
        QWebEngineSettings::resetFontFamily(QWebEngineSettings::FontFamily which
        )**

        Resets the actual font family specified by **which** to the one
        specified in the profile that the page belongs to.
        """
        ...

    def resetFontSize(
        self, type: PySide6.QtWebEngineCore.QWebEngineSettings.FontSize
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#resetFontSize

        **void QWebEngineSettings::resetFontSize(QWebEngineSettings::FontSize
        type )**

        Resets the font size for **type** to the size specified in the profile
        that the page belongs to.
        """
        ...

    def resetUnknownUrlSchemePolicy(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#resetUnknownUrlSchemePoli
        cy

        **[since Qt 5.11] void
        QWebEngineSettings::resetUnknownUrlSchemePolicy()**

        Removes the policy for handling navigation requests to URLs with unknown
        schemes.

        This function was introduced in Qt 5.11.

        **See also** **unknownUrlSchemePolicy**  and
        **setUnknownUrlSchemePolicy** .
        """
        ...

    def setAttribute(
        self, attr: PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute, on: bool
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#setAttribute

        **void QWebEngineSettings::setAttribute(QWebEngineSettings::WebAttribute
        attribute , bool on )**

        Enables or disables the specified **attribute** feature depending on the
        value of **on**.
        """
        ...

    def setDefaultTextEncoding(self, encoding: str) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#setDefaultTextEncoding

        **void QWebEngineSettings::setDefaultTextEncoding(const QString &
        encoding )**

        Specifies the default text encoding system.

        The value of **encoding** must be a string describing an encoding such
        as "utf-8" or "iso-8859-1". If left empty, a default value will be used.
        For a more extensive list of encoding names see **QTextCodec** .

        **See also** **defaultTextEncoding** ().
        """
        ...

    def setFontFamily(
        self, which: PySide6.QtWebEngineCore.QWebEngineSettings.FontFamily, family: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#fontFamily

        **QString QWebEngineSettings::fontFamily(QWebEngineSettings::FontFamily
        which ) const**

        Returns the actual font family for the specified generic font family,
        **which**.
        """
        ...

    def setFontSize(
        self, type: PySide6.QtWebEngineCore.QWebEngineSettings.FontSize, size: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#setFontSize

        **void QWebEngineSettings::setFontSize(QWebEngineSettings::FontSize type
        , int size )**

        Sets the font size for **type** to **size** in pixels.

        **See also** **fontSize** ().
        """
        ...

    def setUnknownUrlSchemePolicy(
        self, policy: PySide6.QtWebEngineCore.QWebEngineSettings.UnknownUrlSchemePolicy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#setUnknownUrlSchemePolicy

        **[since Qt 5.11] void QWebEngineSettings::setUnknownUrlSchemePolicy(QWe
        bEngineSettings::UnknownUrlSchemePolicy policy )**

        Sets the policy for handling navigation requests to URLs with unknown
        schemes to **policy**. Default is
        **QWebEngineSettings::AllowUnknownUrlSchemesFromUserInteraction** .

        This function was introduced in Qt 5.11.

        **See also** **unknownUrlSchemePolicy**  and
        **resetUnknownUrlSchemePolicy** .
        """
        ...

    def testAttribute(
        self, attr: PySide6.QtWebEngineCore.QWebEngineSettings.WebAttribute
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#testAttribute

        **bool
        QWebEngineSettings::testAttribute(QWebEngineSettings::WebAttribute
        attribute ) const**

        Returns `true` if **attribute** is enabled; otherwise returns `false`.
        """
        ...

    def unknownUrlSchemePolicy(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineSettings.UnknownUrlSchemePolicy:
        """
        https://doc.qt.io/qt-6/qwebenginesettings.html#unknownUrlSchemePolicy

        **[since Qt 5.11] QWebEngineSettings::UnknownUrlSchemePolicy
        QWebEngineSettings::unknownUrlSchemePolicy() const**

        Returns the currently selected policy for handling navigation requests
        to URLs with unknown schemes. Default is
        **QWebEngineSettings::AllowUnknownUrlSchemesFromUserInteraction** .

        This function was introduced in Qt 5.11.

        **See also** **setUnknownUrlSchemePolicy**  and
        **resetUnknownUrlSchemePolicy** .
        """
        ...
