"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Dict, List, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineHttpRequest(object):
    """
    https://doc.qt.io/qt-6/qwebenginehttprequest.html

    **Detailed Description**

    QWebEngineHttpRequest represents an HTTP request in the **WebEngine**
    networking stack. It holds the information necessary to send a request over
    the network. It contains a URL and some ancillary information that can be
    used to modify the request. Both **QWebEnginePage::load** () and
    **QWebEngineView::load** () accept a QWebEngineHttpRequest as a parameter.
    """

    Get: QWebEngineHttpRequest.Method = ...
    Post: QWebEngineHttpRequest.Method = ...

    class Method(Enum):
        Get: QWebEngineHttpRequest.Method = ...
        Post: QWebEngineHttpRequest.Method = ...

    @overload
    def __init__(self, other: PySide6.QtWebEngineCore.QWebEngineHttpRequest) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#QWebEngineHttpRequest

        **QWebEngineHttpRequest::QWebEngineHttpRequest(const QUrl & url =
        QUrl(), const QWebEngineHttpRequest::Method & method =
        QWebEngineHttpRequest::Get)**

        Constructs a QWebEngineHttpRequest object with **url** as the URL to be
        requested and **method** as the method to be used.

        **See also** **url** () and **setUrl** ().
        """
        ...

    @overload
    def __init__(
        self,
        url: Union[PySide6.QtCore.QUrl, str] = ...,
        method: PySide6.QtWebEngineCore.QWebEngineHttpRequest.Method = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#QWebEngineHttpRequest-
        1

        **QWebEngineHttpRequest::QWebEngineHttpRequest(const
        QWebEngineHttpRequest & other )**

        Creates a copy of **other**.
        """
        ...

    def hasHeader(self, headerName: Union[PySide6.QtCore.QByteArray, bytes]) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#hasHeader

        **bool QWebEngineHttpRequest::hasHeader(const QByteArray & headerName )
        const**

        Returns `true` if the header **headerName** is present in this
        **WebEngine**  request.

        **See also** **setHeader** (), **header** (), **unsetHeader** (), and
        **headers** ().
        """
        ...

    def header(
        self, headerName: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#header

        **QByteArray QWebEngineHttpRequest::header(const QByteArray & headerName
        ) const**

        Returns the header specified by **headerName**. If no such header is
        present, an empty **QByteArray**  is returned, which may be
        indistinguishable from a header that is present but has no content (use
        **hasHeader** () to find out if the header exists or not).

        Headers can be set with **setHeader** ().

        **See also** **setHeader** (), **hasHeader** (), **unsetHeader** (), and
        **headers** ().
        """
        ...

    def headers(self) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#headers

        **QList<QByteArray> QWebEngineHttpRequest::headers() const**

        Returns a list of all headers that are set in this **WebEngine**
        request. The list is in the order that the headers were set.

        **See also** **setHeader** (), **header** (), **hasHeader** (), and
        **unsetHeader** ().
        """
        ...

    def method(self) -> PySide6.QtWebEngineCore.QWebEngineHttpRequest.Method:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#method

        **QWebEngineHttpRequest::Method QWebEngineHttpRequest::method() const**

        Returns the method this **WebEngine**  request is using.

        **See also** **setMethod** ().
        """
        ...

    def postData(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#postData

        **QByteArray QWebEngineHttpRequest::postData() const**

        Returns the (raw) POST data this **WebEngine**  request contains.

        **See also** **setPostData** ().
        """
        ...

    @staticmethod
    def postRequest(
        url: Union[PySide6.QtCore.QUrl, str], postData: Dict[str, str]
    ) -> PySide6.QtWebEngineCore.QWebEngineHttpRequest:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#postRequest

        **[static] QWebEngineHttpRequest
        QWebEngineHttpRequest::postRequest(const QUrl & url , const
        QMap<QString, QString> & postData )**

        Constructs a **QWebEngineHttpRequest**  to **url** that uses the POST
        method.

        **Note:** **postData** may contain arbitrary strings. They are
        translated to appropriate raw data.

        **See also** **postData**  and **setPostData** ().
        """
        ...

    def setHeader(
        self,
        headerName: Union[PySide6.QtCore.QByteArray, bytes],
        value: Union[PySide6.QtCore.QByteArray, bytes],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#setHeader

        **void QWebEngineHttpRequest::setHeader(const QByteArray & headerName ,
        const QByteArray & headerValue )**

        Sets the header **headerName** to be of value **headerValue**.

        **Note:** Setting the same header twice overrides the previous setting.
        To accomplish the behavior of multiple HTTP headers of the same name,
        you should concatenate the two values, separating them with a comma
        (",") and set one single header.

        **See also** **header** (), **hasHeader** (), **unsetHeader** (), and
        **headers** ().
        """
        ...

    def setMethod(
        self, method: PySide6.QtWebEngineCore.QWebEngineHttpRequest.Method
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#setMethod

        **void QWebEngineHttpRequest::setMethod(QWebEngineHttpRequest::Method
        method )**

        Sets the method this **WebEngine**  request is using to be **method**.

        **See also** **method** ().
        """
        ...

    def setPostData(self, postData: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#setPostData

        **void QWebEngineHttpRequest::setPostData(const QByteArray & postData
        )**

        Sets the (raw) POST data this **WebEngine**  request contains to be
        **postData**.

        **See also** **postData** ().
        """
        ...

    def setUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#setUrl

        **void QWebEngineHttpRequest::setUrl(const QUrl & url )**

        Sets the URL this **WebEngine**  request is referring to be **url**.

        **See also** **url** ().
        """
        ...

    def swap(self, other: PySide6.QtWebEngineCore.QWebEngineHttpRequest) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#swap

        **void QWebEngineHttpRequest::swap(QWebEngineHttpRequest & other )**

        Swaps this **WebEngine**  request with **other**. This function is very
        fast and never fails.
        """
        ...

    def unsetHeader(self, headerName: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#unsetHeader

        **void QWebEngineHttpRequest::unsetHeader(const QByteArray & key )**

        Removes the header specified by **key** , if present.

        **See also** **setHeader** (), **header** (), **hasHeader** (), and
        **headers** ().
        """
        ...

    def url(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginehttprequest.html#url

        **QUrl QWebEngineHttpRequest::url() const**

        Returns the URL this **WebEngine**  request is referring to.

        **See also** **setUrl** ().
        """
        ...
