"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineHistoryItem(object):
    """
    https://doc.qt.io/qt-6/qwebenginehistoryitem.html

    **Detailed Description**

    Each web engine history item represents an entry in the history stack of a
    web page, containing information about the page, its location, and the time
    when it was last visited.

    **See also** **QWebEngineHistory**  and **QWebEnginePage::history** ().
    """

    def __init__(self, other: PySide6.QtWebEngineCore.QWebEngineHistoryItem) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehistoryitem.html#QWebEngineHistoryItem

        **QWebEngineHistoryItem::QWebEngineHistoryItem(const
        QWebEngineHistoryItem & other )**

        Constructs a history item from **other**. The new item and **other**
        will share their data, and modifying either this item or **other** will
        modify both instances.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def iconUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginehistoryitem.html#iconUrl

        **QUrl QWebEngineHistoryItem::iconUrl() const**

        Returns the URL of the icon associated with the history item.

        **See also** **url** (), **originalUrl** (), and **title** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginehistoryitem.html#isValid

        **bool QWebEngineHistoryItem::isValid() const**

        Returns whether this is a valid history item.
        """
        ...

    def lastVisited(self) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qwebenginehistoryitem.html#lastVisited

        **QDateTime QWebEngineHistoryItem::lastVisited() const**

        Returns the date and time when the page associated with the item was
        last visited.

        **See also** **title** () and **url** ().
        """
        ...

    def originalUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginehistoryitem.html#originalUrl

        **QUrl QWebEngineHistoryItem::originalUrl() const**

        Returns the original URL associated with the history item.

        **See also** **url** ().
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginehistoryitem.html#title

        **QString QWebEngineHistoryItem::title() const**

        Returns the title of the page associated with the history item.

        **See also** **url** () and **lastVisited** ().
        """
        ...

    def url(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginehistoryitem.html#url

        **QUrl QWebEngineHistoryItem::url() const**

        Returns the URL associated with the history item.

        **See also** **originalUrl** (), **title** (), and **lastVisited** ().
        """
        ...
