"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineDownloadRequest(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebenginedownloadrequest.html

    **Detailed Description**

    QWebEngineDownloadRequest models a download throughout its life cycle,
    starting with a pending download request and finishing with a completed
    download. It can be used, for example, to get information about new
    downloads, to monitor progress, and to pause, resume, and cancel downloads.

    Downloads are usually triggered by user interaction on a web page. It is the
    **QWebEngineProfile** 's responsibility to notify the application of new
    download requests, which it does by emitting the **downloadRequested**
    signal together with a newly created QWebEngineDownloadRequest. The
    application can then examine this item and decide whether to accept it or
    not. A signal handler must explicitly call **accept** () on the item for Qt
    WebEngine to actually start downloading and writing data to disk. If no
    signal handler calls **accept** (), then the download request will be
    automatically rejected and nothing will be written to disk.

    **Note:** Some properties, such as setting the path and file name where the
    file will be saved (see **downloadDirectory** () and **downloadFileName**
    ()), can only be changed before calling **accept** ().

    **Object Life Cycle**

    All items are guaranteed to be valid during the emission of the
    **downloadRequested**  signal. If **accept** () is **not** called by any
    signal handler, then the item will be deleted **immediately** after signal
    emission. This means that the application **must not** keep references to
    rejected download items. It also means the application should not use a
    queued connection to this signal.

    If **accept** () **is** called by a signal handler, then the
    **QWebEngineProfile**  will take ownership of the item. However, it is safe
    for the application to delete the item at any time, except during the
    handling of the **downloadRequested**  signal. The **QWebEngineProfile**
    being a long-lived object, it is in fact recommended that the application
    delete any items it is no longer interested in.

    **Note:** Deleting an item will also automatically cancel a download since
    5.12.2, but it is recommended to cancel manually before deleting for
    portability.

    **Web Page Downloads**

    In addition to normal file downloads, which consist simply of retrieving
    some raw bytes from the network and writing them to disk, Qt WebEngine also
    supports saving complete web pages, which involves parsing the page's HTML,
    downloading any dependent resources, and potentially packaging everything
    into a special file format (**savePageFormat** ). To check if a download is
    for a file or a web page, use **isSavePageDownload** .

    **See also** **QWebEngineProfile** ,
    **QWebEngineProfile::downloadRequested** , **QWebEnginePage::download** ,
    and **QWebEnginePage::save** .
    """

    NoReason: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileFailed: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileAccessDenied: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileNoSpace: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileNameTooLong: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileTooLarge: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileVirusInfected: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileTransientError: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileBlocked: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileSecurityCheckFailed: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileTooShort: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    FileHashMismatch: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    NetworkFailed: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    NetworkTimeout: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    NetworkDisconnected: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    NetworkServerDown: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    NetworkInvalidRequest: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    ServerFailed: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    ServerBadContent: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    ServerUnauthorized: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    ServerCertProblem: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    ServerForbidden: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    ServerUnreachable: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    UserCanceled: QWebEngineDownloadRequest.DownloadInterruptReason = ...
    DownloadRequested: QWebEngineDownloadRequest.DownloadState = ...
    DownloadInProgress: QWebEngineDownloadRequest.DownloadState = ...
    DownloadCompleted: QWebEngineDownloadRequest.DownloadState = ...
    DownloadCancelled: QWebEngineDownloadRequest.DownloadState = ...
    DownloadInterrupted: QWebEngineDownloadRequest.DownloadState = ...
    UnknownSaveFormat: QWebEngineDownloadRequest.SavePageFormat = ...
    SingleHtmlSaveFormat: QWebEngineDownloadRequest.SavePageFormat = ...
    CompleteHtmlSaveFormat: QWebEngineDownloadRequest.SavePageFormat = ...
    MimeHtmlSaveFormat: QWebEngineDownloadRequest.SavePageFormat = ...

    class DownloadInterruptReason(Enum):
        NoReason: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileFailed: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileAccessDenied: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileNoSpace: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileNameTooLong: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileTooLarge: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileVirusInfected: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileTransientError: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileBlocked: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileSecurityCheckFailed: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileTooShort: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        FileHashMismatch: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        NetworkFailed: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        NetworkTimeout: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        NetworkDisconnected: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        NetworkServerDown: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        NetworkInvalidRequest: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        ServerFailed: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        ServerBadContent: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        ServerUnauthorized: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        ServerCertProblem: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        ServerForbidden: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        ServerUnreachable: QWebEngineDownloadRequest.DownloadInterruptReason = ...
        UserCanceled: QWebEngineDownloadRequest.DownloadInterruptReason = ...

    class DownloadState(Enum):
        DownloadRequested: QWebEngineDownloadRequest.DownloadState = ...
        DownloadInProgress: QWebEngineDownloadRequest.DownloadState = ...
        DownloadCompleted: QWebEngineDownloadRequest.DownloadState = ...
        DownloadCancelled: QWebEngineDownloadRequest.DownloadState = ...
        DownloadInterrupted: QWebEngineDownloadRequest.DownloadState = ...

    class SavePageFormat(Enum):
        UnknownSaveFormat: QWebEngineDownloadRequest.SavePageFormat = ...
        SingleHtmlSaveFormat: QWebEngineDownloadRequest.SavePageFormat = ...
        CompleteHtmlSaveFormat: QWebEngineDownloadRequest.SavePageFormat = ...
        MimeHtmlSaveFormat: QWebEngineDownloadRequest.SavePageFormat = ...

    def accept(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#accept

        **[slot] void QWebEngineDownloadRequest::accept()**

        Accepts the current download request, which will start the download.

        If the item is in the **DownloadRequested**  state, then it will
        transition into the **DownloadInProgress**  state and the downloading
        will begin. If the item is in any other state, then nothing will happen.

        **See also** **isFinished**  and **stateChanged** ().
        """
        ...

    def cancel(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#cancel

        **[slot] void QWebEngineDownloadRequest::cancel()**

        Cancels the current download.

        If the item is in the **DownloadInProgress**  state, then it will
        transition into the **DownloadCancelled**  state, the downloading will
        stop, and partially downloaded files will be deleted from disk.

        If the item is in the **DownloadCompleted**  state, then nothing will
        happen. If the item is in any other state, then it will transition into
        the **DownloadCancelled**  state without further effect.

        **See also** **isFinished**  and **stateChanged** ().
        """
        ...

    def downloadDirectory(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#downloadDirectory

        **QString QWebEngineDownloadRequest::downloadDirectory() const**

        Returns the download directory path.

        **Note:** Getter function for property downloadDirectory.

        **See also** **setDownloadDirectory** ().
        """
        ...

    def downloadFileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#downloadFileName

        **QString QWebEngineDownloadRequest::downloadFileName() const**

        Returns the file name to download the file to.

        **Note:** Getter function for property downloadFileName.

        **See also** **setDownloadFileName** ().
        """
        ...

    def id(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#id

        **quint32 QWebEngineDownloadRequest::id() const**

        Returns the download item's ID.

        **Note:** Getter function for property id.
        """
        ...

    def interruptReason(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineDownloadRequest.DownloadInterruptReason:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#interruptReason

        **QWebEngineDownloadRequest::DownloadInterruptReason
        QWebEngineDownloadRequest::interruptReason() const**

        Returns the reason why the download was interrupted.

        **Note:** Getter function for property interruptReason.

        **See also** **interruptReasonString** ().
        """
        ...

    def interruptReasonString(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#interruptReasonStr
        ing

        **QString QWebEngineDownloadRequest::interruptReasonString() const**

        Returns a human-readable description of the reason for interrupting the
        download.

        **Note:** Getter function for property interruptReasonString.

        **See also** **interruptReason** ().
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#isFinished-prop

        **[read-only] isFinished : const bool**

        This property holds whether this download is finished (completed,
        cancelled, or non-resumable interrupted state).

        **Access functions:**

        bool **isFinished** () const

        **Notifier signal:**

        void **isFinishedChanged** ()

        **See also** **state** ().
        """
        ...

    def isPaused(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#isPaused-prop

        **[read-only] isPaused : const bool**

        This property holds whether this download is paused.

        **Access functions:**

        bool **isPaused** () const

        **Notifier signal:**

        void ****isPausedChanged** ** ()

        **See also** **pause** () and **resume** ().

        **Member Function Documentation**
        """
        ...

    def isSavePageDownload(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#isSavePageDownload

        **bool QWebEngineDownloadRequest::isSavePageDownload() const**

        Returns `true` if this is a download request for saving a web page.

        **Note:** Getter function for property isSavePageDownload.

        **See also** **savePageFormat** () and **setSavePageFormat** ().
        """
        ...

    def mimeType(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#mimeType

        **QString QWebEngineDownloadRequest::mimeType() const**

        Returns the MIME type of the download.

        **Note:** Getter function for property mimeType.
        """
        ...

    def page(self) -> PySide6.QtWebEngineCore.QWebEnginePage:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#page

        **QWebEnginePage *QWebEngineDownloadRequest::page() const**

        Returns the page the download was requested on. If the download was not
        triggered by content in a page, `nullptr` is returned.
        """
        ...

    def pause(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#pause

        **[slot] void QWebEngineDownloadRequest::pause()**

        Pauses the download.

        Has no effect if the state is not **DownloadInProgress** . Does not
        change the state.

        **See also** **resume** () and **isPaused** ().
        """
        ...

    def receivedBytes(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#receivedBytes

        **qint64 QWebEngineDownloadRequest::receivedBytes() const**

        Returns the amount of data in bytes that has been downloaded so far.

        `-1` means the size is unknown.

        **Note:** Getter function for property receivedBytes.
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#resume

        **[slot] void QWebEngineDownloadRequest::resume()**

        Resumes the current download if it was paused or interrupted.

        Has no effect if the state is not **DownloadInProgress**  or
        **DownloadInterrupted** . Does not change the state.

        **See also** **pause** (), **isPaused** (), and **state** ().
        """
        ...

    def savePageFormat(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineDownloadRequest.SavePageFormat:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#savePageFormat

        **QWebEngineDownloadRequest::SavePageFormat
        QWebEngineDownloadRequest::savePageFormat() const**

        Returns the format the web page will be saved in if this is a download
        request for a web page.

        **Note:** Getter function for property savePageFormat.

        **See also** **setSavePageFormat** () and **isSavePageDownload** ().
        """
        ...

    def setDownloadDirectory(self, directory: str) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#setDownloadDirecto
        ry

        **void QWebEngineDownloadRequest::setDownloadDirectory(const QString &
        directory )**

        Sets **directory** as the directory path to download the file to.

        The download directory path can only be set in response to the
        **QWebEngineProfile::downloadRequested** () signal before the download
        is accepted. Past that point, this function has no effect on the
        download item's state.

        **Note:** Setter function for property **downloadDirectory** .

        **See also** **downloadDirectory** ().
        """
        ...

    def setDownloadFileName(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#setDownloadFileNam
        e

        **void QWebEngineDownloadRequest::setDownloadFileName(const QString &
        fileName )**

        Sets **fileName** as the file name to download the file to.

        The download file name can only be set in response to the
        **QWebEngineProfile::downloadRequested** () signal before the download
        is accepted. Past that point, this function has no effect on the
        download item's state.

        **Note:** Setter function for property **downloadFileName** .

        **See also** **downloadFileName** ().
        """
        ...

    def setSavePageFormat(
        self, format: PySide6.QtWebEngineCore.QWebEngineDownloadRequest.SavePageFormat
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#setSavePageFormat

        **void QWebEngineDownloadRequest::setSavePageFormat(QWebEngineDownloadRe
        quest::SavePageFormat format )**

        Sets the **format** the web page will be saved in if this is a download
        request for a web page.

        **Note:** Setter function for property **savePageFormat** .

        **See also** **savePageFormat** () and **isSavePageDownload** ().
        """
        ...

    def state(self) -> PySide6.QtWebEngineCore.QWebEngineDownloadRequest.DownloadState:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#state

        **QWebEngineDownloadRequest::DownloadState
        QWebEngineDownloadRequest::state() const**

        Returns the download item's current state.

        **Note:** Getter function for property state.

        **See also** **DownloadState** .
        """
        ...

    def suggestedFileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#suggestedFileName

        **QString QWebEngineDownloadRequest::suggestedFileName() const**

        Returns the suggested file name.

        **Note:** Getter function for property suggestedFileName.
        """
        ...

    def totalBytes(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#totalBytes

        **qint64 QWebEngineDownloadRequest::totalBytes() const**

        Returns the the total amount of data to download in bytes.

        `-1` means the size is unknown.

        **Note:** Getter function for property totalBytes.
        """
        ...

    def url(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#url

        **QUrl QWebEngineDownloadRequest::url() const**

        Returns the download's origin URL.

        **Note:** Getter function for property url.
        """
        ...

    @property
    def isFinishedChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def isPausedChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#isPausedChanged

        **[signal] void QWebEngineDownloadRequest::isPausedChanged()**

        This signal is emitted whenever **isPaused**  changes.

        **Note:** Notifier signal for property **isPaused** .

        **See also** **pause** () and **isPaused** .
        """
        ...

    @property
    def stateChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginedownloadrequest.html#stateChanged

        **[signal] void QWebEngineDownloadRequest::stateChanged(QWebEngineDownlo
        adRequest::DownloadState state )**

        This signal is emitted whenever the download's **state** changes.

        **Note:** Notifier signal for property **state** .

        **See also** **state** () and **DownloadState** .
        """
        ...
