"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from typing import Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineCookieStore(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebenginecookiestore.html

    **Detailed Description**

    The class allows to access HTTP cookies of Chromium for a specific profile.
    It can be used to synchronize cookies of Chromium and the
    **QNetworkAccessManager** , as well as to set, delete, and intercept cookies
    during navigation. Because cookie operations are asynchronous, the user can
    choose to provide a callback function to get notified about the success of
    the operation. The signal handlers for removal and addition should not be
    used to execute heavy tasks, because they might block the IO thread in case
    of a blocking connection.

    Use **QWebEngineProfile::cookieStore** () and
    **QQuickWebEngineProfile::cookieStore** () to access the cookie store object
    for a specific profile.
    """

    def deleteAllCookies(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginecookiestore.html#deleteAllCookies

        **void QWebEngineCookieStore::deleteAllCookies()**

        Deletes all the cookies in the cookie store.

        **Note:** This operation is asynchronous.

        **See also** **loadAllCookies** ().
        """
        ...

    def deleteCookie(
        self,
        cookie: PySide6.QtNetwork.QNetworkCookie,
        origin: Union[PySide6.QtCore.QUrl, str] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginecookiestore.html#deleteCookie

        **void QWebEngineCookieStore::deleteCookie(const QNetworkCookie & cookie
        , const QUrl & origin = QUrl())**

        Deletes **cookie** from the cookie store. It is possible to provide an
        optional **origin** URL argument to limit the scope of the cookie to be
        deleted.

        **Note:** This operation is asynchronous.
        """
        ...

    def deleteSessionCookies(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginecookiestore.html#deleteSessionCookies

        **void QWebEngineCookieStore::deleteSessionCookies()**

        Deletes all the session cookies in the cookie store. Session cookies do
        not have an expiration date assigned to them.

        **Note:** This operation is asynchronous.

        **See also** **loadAllCookies** ().
        """
        ...

    def loadAllCookies(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginecookiestore.html#loadAllCookies

        **void QWebEngineCookieStore::loadAllCookies()**

        Loads all the cookies into the cookie store. The **cookieAdded** ()
        signal is emitted on every loaded cookie. Cookies are loaded
        automatically when the store gets initialized, which in most cases
        happens on loading the first URL. However, calling this function is
        useful if cookies should be listed before entering the web content.

        **Note:** This operation is asynchronous.
        """
        ...

    def setCookie(
        self,
        cookie: PySide6.QtNetwork.QNetworkCookie,
        origin: Union[PySide6.QtCore.QUrl, str] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginecookiestore.html#setCookie

        **void QWebEngineCookieStore::setCookie(const QNetworkCookie & cookie ,
        const QUrl & origin = QUrl())**

        Adds **cookie** to the cookie store.

        **Note:** If **cookie** specifies a **QNetworkCookie::domain** () that
        does not start with a dot, a dot is automatically prepended. To limit
        the cookie to the exact server, omit **QNetworkCookie::domain** () and
        set **origin** instead.

        The provided URL should also include the scheme.

        **Note:** This operation is asynchronous.
        """
        ...

    @property
    def cookieAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginecookiestore.html#cookieAdded

        **[signal] void QWebEngineCookieStore::cookieAdded(const QNetworkCookie
        & cookie )**

        This signal is emitted whenever a new **cookie** is added to the cookie
        store.
        """
        ...

    @property
    def cookieRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginecookiestore.html#cookieRemoved

        **[signal] void QWebEngineCookieStore::cookieRemoved(const
        QNetworkCookie & cookie )**

        This signal is emitted whenever a **cookie** is deleted from the cookie
        store.
        """
        ...
