"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineContextMenuRequest(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html

    **Detailed Description**

    QWebEngineContextMenuRequest is returned by
    **QWebEngineView::lastContextMenuRequest** () after a context menu event,
    and contains information about where the context menu event took place. This
    is also in the context in which any context specific
    **QWebEnginePage::WebAction**  will be performed.
    """

    CanUndo: QWebEngineContextMenuRequest.EditFlag = ...
    CanRedo: QWebEngineContextMenuRequest.EditFlag = ...
    CanCut: QWebEngineContextMenuRequest.EditFlag = ...
    CanCopy: QWebEngineContextMenuRequest.EditFlag = ...
    CanPaste: QWebEngineContextMenuRequest.EditFlag = ...
    CanDelete: QWebEngineContextMenuRequest.EditFlag = ...
    CanSelectAll: QWebEngineContextMenuRequest.EditFlag = ...
    CanTranslate: QWebEngineContextMenuRequest.EditFlag = ...
    CanEditRichly: QWebEngineContextMenuRequest.EditFlag = ...
    MediaInError: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaPaused: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaMuted: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaLoop: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaCanSave: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaHasAudio: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaCanToggleControls: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaControls: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaCanPrint: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaCanRotate: QWebEngineContextMenuRequest.MediaFlag = ...
    MediaTypeNone: QWebEngineContextMenuRequest.MediaType = ...
    MediaTypeImage: QWebEngineContextMenuRequest.MediaType = ...
    MediaTypeVideo: QWebEngineContextMenuRequest.MediaType = ...
    MediaTypeAudio: QWebEngineContextMenuRequest.MediaType = ...
    MediaTypeCanvas: QWebEngineContextMenuRequest.MediaType = ...
    MediaTypeFile: QWebEngineContextMenuRequest.MediaType = ...
    MediaTypePlugin: QWebEngineContextMenuRequest.MediaType = ...

    class EditFlag(Enum):
        CanUndo: QWebEngineContextMenuRequest.EditFlag = ...
        CanRedo: QWebEngineContextMenuRequest.EditFlag = ...
        CanCut: QWebEngineContextMenuRequest.EditFlag = ...
        CanCopy: QWebEngineContextMenuRequest.EditFlag = ...
        CanPaste: QWebEngineContextMenuRequest.EditFlag = ...
        CanDelete: QWebEngineContextMenuRequest.EditFlag = ...
        CanSelectAll: QWebEngineContextMenuRequest.EditFlag = ...
        CanTranslate: QWebEngineContextMenuRequest.EditFlag = ...
        CanEditRichly: QWebEngineContextMenuRequest.EditFlag = ...

    class EditFlags(object):
        ...

    class MediaFlag(Enum):
        MediaInError: QWebEngineContextMenuRequest.MediaFlag = ...
        MediaPaused: QWebEngineContextMenuRequest.MediaFlag = ...
        MediaMuted: QWebEngineContextMenuRequest.MediaFlag = ...
        MediaLoop: QWebEngineContextMenuRequest.MediaFlag = ...
        MediaCanSave: QWebEngineContextMenuRequest.MediaFlag = ...
        MediaHasAudio: QWebEngineContextMenuRequest.MediaFlag = ...
        MediaCanToggleControls: QWebEngineContextMenuRequest.MediaFlag = ...
        MediaControls: QWebEngineContextMenuRequest.MediaFlag = ...
        MediaCanPrint: QWebEngineContextMenuRequest.MediaFlag = ...
        MediaCanRotate: QWebEngineContextMenuRequest.MediaFlag = ...

    class MediaFlags(object):
        ...

    class MediaType(Enum):
        MediaTypeNone: QWebEngineContextMenuRequest.MediaType = ...
        MediaTypeImage: QWebEngineContextMenuRequest.MediaType = ...
        MediaTypeVideo: QWebEngineContextMenuRequest.MediaType = ...
        MediaTypeAudio: QWebEngineContextMenuRequest.MediaType = ...
        MediaTypeCanvas: QWebEngineContextMenuRequest.MediaType = ...
        MediaTypeFile: QWebEngineContextMenuRequest.MediaType = ...
        MediaTypePlugin: QWebEngineContextMenuRequest.MediaType = ...

    def editFlags(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineContextMenuRequest.EditFlags:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#editFlags

        **QWebEngineContextMenuRequest::EditFlags
        QWebEngineContextMenuRequest::editFlags() const**

        Returns the available edit operations in the current context or
        `CanDoNone` if no actions are available.

        **Note:** Getter function for property editFlags.
        """
        ...

    def isAccepted(self) -> bool:
        ...

    def isContentEditable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#isContentEditab
        le

        **bool QWebEngineContextMenuRequest::isContentEditable() const**

        Returns `true` if the context menu request is editable by the user;
        otherwise returns `false`.

        **Note:** Getter function for property isContentEditable.
        """
        ...

    def linkText(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#linkText

        **QString QWebEngineContextMenuRequest::linkText() const**

        Returns the text of a link if the context menu request was requested for
        a link.

        **Note:** Getter function for property linkText.
        """
        ...

    def linkUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#linkUrl

        **QUrl QWebEngineContextMenuRequest::linkUrl() const**

        Returns the URL of a link if the menu context request is a link. It is
        not guaranteed to be a valid URL.

        **Note:** Getter function for property linkUrl.
        """
        ...

    def mediaFlags(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineContextMenuRequest.MediaFlags:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#mediaFlags

        **QWebEngineContextMenuRequest::MediaFlags
        QWebEngineContextMenuRequest::mediaFlags() const**

        Returns the current media element's status and its available operations.
        `MediaNone` if the selected web page content is not a media element.

        **Note:** Getter function for property mediaFlags.
        """
        ...

    def mediaType(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineContextMenuRequest.MediaType:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#mediaType

        **QWebEngineContextMenuRequest::MediaType
        QWebEngineContextMenuRequest::mediaType() const**

        Returns the type of the media element or `MediaTypeNone` if the context
        menu requestis not a media element.

        **Note:** Getter function for property mediaType.
        """
        ...

    def mediaUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#mediaUrl

        **QUrl QWebEngineContextMenuRequest::mediaUrl() const**

        If the context menu request is a media element, returns the URL of that
        media.

        **Note:** Getter function for property mediaUrl.
        """
        ...

    def misspelledWord(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#misspelledWord

        **QString QWebEngineContextMenuRequest::misspelledWord() const**

        If the menu context request is a word considered misspelled by the
        spell-checker, returns the misspelled word.

        For possible replacements of the word, see **spellCheckerSuggestions**
        ().

        **Note:** Getter function for property misspelledWord.
        """
        ...

    def position(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#position

        **QPoint QWebEngineContextMenuRequest::position() const**

        Returns the position of the context menu request, usually the mouse
        position where the context menu event was triggered.

        **Note:** Getter function for property position.
        """
        ...

    def selectedText(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#selectedText

        **QString QWebEngineContextMenuRequest::selectedText() const**

        Returns the selected text of the context menu request.

        **Note:** Getter function for property selectedText.
        """
        ...

    def setAccepted(self, accepted: bool) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#accepted-prop

        **accepted : bool**

        This property holds whether the request is accepted.

        **Access functions:**

        bool **isAccepted** () const
        void **setAccepted** (bool **accepted** )

        **Member Function Documentation**
        """
        ...

    def spellCheckerSuggestions(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qwebenginecontextmenurequest.html#spellCheckerSug
        gestions

        **QStringList QWebEngineContextMenuRequest::spellCheckerSuggestions()
        const**

        If the menu context request is a word considered misspelled by the
        spell-checker, returns a list of suggested replacements for
        **misspelledWord** ().

        **Note:** Getter function for property spellCheckerSuggestions.
        """
        ...
