"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtStateMachine, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtStateMachine

bytes = str


class QHistoryState(PySide6.QtStateMachine.QAbstractState):
    """
    https://doc.qt.io/qt-6/qhistorystate.html

    **Detailed Description**

    A history state is a pseudo-state that represents the child state that the
    parent state was in the last time the parent state was exited. A transition
    with a history state as its target is in fact a transition to one or more
    other child states of the parent state. QHistoryState is part of **Qt State
    Machine Framework** .

    Use the **setDefaultState** () function to set the state that should be
    entered if the parent state has never been entered. Example:

    **QStateMachine**  machine;

        **QState**  *s1 = new **QState** ();
    **QState**  *s11 = new **QState** (s1);
        **QState**  *s12 = new
    **QState** (s1);

        **QHistoryState**  *s1h = new **QHistoryState**
    (s1);
        s1h->setDefaultState(s11);

        machine.addState(s1);
    **QState**  *s2 = new **QState** ();
        machine.addState(s2);
    **QPushButton**  *button = new **QPushButton** ();
        // Clicking the
    button will cause the state machine to enter the child state
        // that s1
    was in the last time s1 was exited, or the history state's default
        //
    state if s1 has never been entered.
        s1->addTransition(button,
    SIGNAL(clicked()), s1h);

    If more than one default state has to be entered, or if the transition to
    the default state(s) has to be acted upon, the **defaultTransition**  should
    be set instead. Note that the eventTest() method of that transition will
    never be called: the selection and execution of the transition is done
    automatically when entering the history state.

    By default a history state is shallow, meaning that it won't remember nested
    states. This can be configured through the **historyType**  property.
    """

    ShallowHistory: QHistoryState.HistoryType = ...
    DeepHistory: QHistoryState.HistoryType = ...

    class HistoryType(Enum):
        ShallowHistory: QHistoryState.HistoryType = ...
        DeepHistory: QHistoryState.HistoryType = ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtStateMachine.QState] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#QHistoryState

        **QHistoryState::QHistoryState(QState * parent = nullptr)**

        Constructs a new shallow history state with the given **parent** state.
        """
        ...

    @overload
    def __init__(
        self,
        type: PySide6.QtStateMachine.QHistoryState.HistoryType,
        parent: Optional[PySide6.QtStateMachine.QState] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#QHistoryState-1

        **QHistoryState::QHistoryState(QHistoryState::HistoryType type , QState
        * parent = nullptr)**

        Constructs a new history state of the given **type** , with the given
        **parent** state.
        """
        ...

    def defaultState(self) -> PySide6.QtStateMachine.QAbstractState:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#defaultState

        **QAbstractState *QHistoryState::defaultState() const**

        Returns this history state's default state. The default state indicates
        the state to transition to if the parent state has never been entered
        before.

        **Note:** Getter function for property defaultState.

        **See also** **setDefaultState** ().
        """
        ...

    def defaultTransition(self) -> PySide6.QtStateMachine.QAbstractTransition:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#defaultTransition

        **[since 5.6] QAbstractTransition *QHistoryState::defaultTransition()
        const**

        Returns this history state's default transition. The default transition
        is taken when the history state has never been entered before. The
        target states of the default transition therefore make up the default
        state.

        **Note:** Getter function for property defaultTransition.

        This function was introduced in Qt 5.6.

        **See also** **setDefaultTransition** ().
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#event

        **[override virtual protected] bool QHistoryState::event(QEvent * e )**

        Reimplements: **QAbstractState::event** (QEvent *e).
        """
        ...

    def historyType(self) -> PySide6.QtStateMachine.QHistoryState.HistoryType:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#historyType

        **QHistoryState::HistoryType QHistoryState::historyType() const**

        Returns the type of history that this history state records.

        **Note:** Getter function for property historyType.

        **See also** **setHistoryType** ().
        """
        ...

    def onEntry(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#onEntry

        **[override virtual protected] void QHistoryState::onEntry(QEvent *
        event )**

        Reimplements: **QAbstractState::onEntry** (QEvent *event).
        """
        ...

    def onExit(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#onExit

        **[override virtual protected] void QHistoryState::onExit(QEvent * event
        )**

        Reimplements: **QAbstractState::onExit** (QEvent *event).
        """
        ...

    def setDefaultState(self, state: PySide6.QtStateMachine.QAbstractState) -> None:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#setDefaultState

        **void QHistoryState::setDefaultState(QAbstractState * state )**

        Sets this history state's default state to be the given **state**.
        **state** must be a sibling of this history state.

        Note that this function does not set **state** as the initial state of
        its parent.

        **Note:** Setter function for property **defaultState** .

        **See also** **defaultState** ().
        """
        ...

    def setDefaultTransition(
        self, transition: PySide6.QtStateMachine.QAbstractTransition
    ) -> None:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#setDefaultTransition

        **[since 5.6] void
        QHistoryState::setDefaultTransition(QAbstractTransition * transition )**

        Sets this history state's default transition to be the given
        **transition**. This will set the source state of the **transition** to
        the history state.

        Note that the eventTest method of the **transition** will never be
        called.

        **Note:** Setter function for property **defaultTransition** .

        This function was introduced in Qt 5.6.

        **See also** **defaultTransition** ().
        """
        ...

    def setHistoryType(
        self, type: PySide6.QtStateMachine.QHistoryState.HistoryType
    ) -> None:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#setHistoryType

        **void QHistoryState::setHistoryType(QHistoryState::HistoryType type )**

        Sets the **type** of history that this history state records.

        **Note:** Setter function for property **historyType** .

        **See also** **historyType** ().
        """
        ...

    @property
    def defaultStateChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#defaultStateChanged

        **[private signal, since 5.4] void
        QHistoryState::defaultStateChanged()**

        This signal is emitted when the **defaultState**  property is changed.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **Note:** Notifier signal for property **defaultState** .

        This function was introduced in Qt 5.4.

        **See also** **QHistoryState::defaultState** .
        """
        ...

    @property
    def defaultTransitionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#defaultTransitionChanged

        **[private signal, since 5.6] void
        QHistoryState::defaultTransitionChanged()**

        This signal is emitted when the **defaultTransition**  property is
        changed.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **Note:** Notifier signal for property **defaultTransition** .

        This function was introduced in Qt 5.6.

        **See also** **QHistoryState::defaultTransition** .
        """
        ...

    @property
    def historyTypeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhistorystate.html#historyTypeChanged

        **[private signal, since 5.4] void QHistoryState::historyTypeChanged()**

        This signal is emitted when the **historyType**  property is changed.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **Note:** Notifier signal for property **historyType** .

        This function was introduced in Qt 5.4.

        **See also** **QHistoryState::historyType** .
        """
        ...
