"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSql, except for defaults which are replaced by "...".
"""
from typing import List, overload
import PySide6.QtCore
import PySide6.QtWidgets
import PySide6.QtSql

bytes = str


class QSqlDatabase(object):
    """
    https://doc.qt.io/qt-6/qsqldatabase.html

    **Detailed Description**

    The QSqlDatabase class provides an interface for accessing a database
    through a connection. An instance of QSqlDatabase represents the connection.
    The connection provides access to the database via one of the **supported
    database drivers** , which are derived from **QSqlDriver** . Alternatively,
    you can subclass your own database driver from **QSqlDriver** . See **How to
    Write Your Own Database Driver**  for more information.

    Create a connection (i.e., an instance of QSqlDatabase) by calling one of
    the static **addDatabase** () functions, where you specify **the driver or
    type of driver**  to use (depending on the type of database) and a
    connection name. A connection is known by its own name, **not** by the name
    of the database it connects to. You can have multiple connections to one
    database. QSqlDatabase also supports the concept of a **default**
    connection, which is the unnamed connection. To create the default
    connection, don't pass the connection name argument when you call
    **addDatabase** (). Subsequently, the default connection will be assumed if
    you call any static member function without specifying the connection name.
    The following snippet shows how to create and open a default connection to a
    PostgreSQL database:

    **QSqlDatabase**  db = **QSqlDatabase** ::addDatabase("QPSQL");
    db.setHostName("acidalia");
            db.setDatabaseName("customdb");
    db.setUserName("mojito");
            db.setPassword("J0a1m8");
            bool ok
    = db.open();

    Once the QSqlDatabase object has been created, set the connection parameters
    with **setDatabaseName** (), **setUserName** (), **setPassword** (),
    **setHostName** (), **setPort** (), and **setConnectOptions** (). Then call
    **open** () to activate the physical connection to the database. The
    connection is not usable until you open it.

    The connection defined above will be the **default** connection, because we
    didn't give a connection name to **addDatabase** (). Subsequently, you can
    get the default connection by calling **database** () without the connection
    name argument:

    **QSqlDatabase**  db = **QSqlDatabase** ::database();

    QSqlDatabase is a value class. Changes made to a database connection via one
    instance of QSqlDatabase will affect other instances of QSqlDatabase that
    represent the same connection. Use **cloneDatabase** () to create an
    independent database connection based on an existing one.

    **Warning:** It is highly recommended that you do not keep a copy of the
    QSqlDatabase around as a member of a class, as this will prevent the
    instance from being correctly cleaned up on shutdown. If you need to access
    an existing QSqlDatabase, it should be accessed with **database** (). If you
    chose to have a QSqlDatabase member variable, this needs to be deleted
    before the **QCoreApplication**  instance is deleted, otherwise it may lead
    to undefined behavior.

    If you create multiple database connections, specify a unique connection
    name for each one, when you call **addDatabase** (). Use **database** ()
    with a connection name to get that connection. Use **removeDatabase** ()
    with a connection name to remove a connection. QSqlDatabase outputs a
    warning if you try to remove a connection referenced by other QSqlDatabase
    objects. Use **contains** () to see if a given connection name is in the
    list of connections.

    Some utility methods:
    **tables** ()returns the list of tables
    **primaryIndex** ()returns a table's primary index
    **record** ()returns
    meta-information about a table's fields
    **transaction** ()starts a
    transaction
    **commit** ()saves and completes a transaction
    **rollback**
    ()cancels a transaction
    hasFeature()checks if a driver supports
    transactions
    **lastError** ()returns information about the last error
    **drivers** ()returns the names of the available SQL drivers
    **isDriverAvailable** ()checks if a particular driver is available
    **registerSqlDriver** ()registers a custom-made driver

    **Note:****QSqlDatabase::exec** () is deprecated. Use **QSqlQuery::exec** ()
    instead.

    **Note:** When using transactions, you must start the transaction before you
    create your query.

    **See also** **QSqlDriver** , **QSqlQuery** , **Qt SQL** , and **Threads and
    the SQL Module** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#QSqlDatabase

        **QSqlDatabase::QSqlDatabase()**

        Creates an empty, invalid QSqlDatabase object. Use **addDatabase** (),
        **removeDatabase** (), and **database** () to get valid QSqlDatabase
        objects.
        """
        ...

    @overload
    def __init__(self, driver: PySide6.QtSql.QSqlDriver) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#QSqlDatabase-1

        **QSqlDatabase::QSqlDatabase(const QSqlDatabase & other )**

        Creates a copy of **other**.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtSql.QSqlDatabase) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#QSqlDatabase-2

        **[protected] QSqlDatabase::QSqlDatabase(const QString & type )**

        This is an overloaded function.

        Creates a QSqlDatabase connection that uses the driver referred to by
        **type**. If the **type** is not recognized, the database connection
        will have no functionality.

        The currently available driver types are:

        Driver TypeDescription
        QDB2IBM DB2
        QIBASEBorland InterBase Driver
        QMYSQLMySQL Driver
        QOCIOracle Call Interface Driver
        QODBCODBC Driver
        (includes Microsoft SQL Server)
        QPSQLPostgreSQL Driver
        QSQLITESQLite
        version 3 or above

        Additional third party drivers, including your own custom drivers, can
        be loaded dynamically.

        **See also** **SQL Database Drivers** , **registerSqlDriver** (), and
        **drivers** ().
        """
        ...

    @overload
    def __init__(self, type: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#QSqlDatabase-3

        **[protected] QSqlDatabase::QSqlDatabase(QSqlDriver * driver )**

        This is an overloaded function.

        Creates a database connection using the given **driver**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @overload
    @staticmethod
    def addDatabase(
        driver: PySide6.QtSql.QSqlDriver, connectionName: str = ...
    ) -> PySide6.QtSql.QSqlDatabase:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#addDatabase

        **[static] QSqlDatabase QSqlDatabase::addDatabase(const QString & type ,
        const QString & connectionName = QLatin1String(defaultConnection))**

        Adds a database to the list of database connections using the driver
        **type** and the connection name **connectionName**. If there already
        exists a database connection called **connectionName** , that connection
        is removed.

        The database connection is referred to by **connectionName**. The newly
        added database connection is returned.

        If **type** is not available or could not be loaded, **isValid** ()
        returns `false`.

        If **connectionName** is not specified, the new connection becomes the
        default connection for the application, and subsequent calls to
        **database** () without the connection name argument will return the
        default connection. If a **connectionName** is provided here, use
        database( **connectionName** ) to retrieve the connection.

        **Warning:** If you add a connection with the same name as an existing
        connection, the new connection replaces the old one. If you call this
        function more than once without specifying **connectionName** , the
        default connection will be the one replaced.

        Before using the connection, it must be initialized. e.g., call some or
        all of **setDatabaseName** (), **setUserName** (), **setPassword** (),
        **setHostName** (), **setPort** (), and **setConnectOptions** (), and,
        finally, **open** ().

        **Note:** This function is **thread-safe** .

        **See also** **database** (), **removeDatabase** (), and **Threads and
        the SQL Module** .
        """
        ...

    @overload
    @staticmethod
    def addDatabase(type: str, connectionName: str = ...) -> PySide6.QtSql.QSqlDatabase:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#addDatabase-1

        **[static] QSqlDatabase QSqlDatabase::addDatabase(QSqlDriver * driver ,
        const QString & connectionName = QLatin1String(defaultConnection))**

        This overload is useful when you want to create a database connection
        with a **driver**  you instantiated yourself. It might be your own
        database driver, or you might just need to instantiate one of the Qt
        drivers yourself. If you do this, it is recommended that you include the
        driver code in your application. For example, you can create a
        PostgreSQL connection with your own QPSQL driver like this:

        PGconn *con = PQconnectdb("host=server user=bart password=simpson
        dbname=springfield");
            QPSQLDriver *drv = new QPSQLDriver(con);
        **QSqlDatabase**  db = **QSqlDatabase** ::addDatabase(drv); // becomes
        the new default connection
            **QSqlQuery**  query;
        query.exec("SELECT NAME, ID FROM STAFF");

        The above code sets up a PostgreSQL connection and instantiates a
        QPSQLDriver object. Next, addDatabase() is called to add the connection
        to the known connections so that it can be used by the Qt SQL classes.
        When a driver is instantiated with a connection handle (or set of
        handles), Qt assumes that you have already opened the database
        connection.

        **Note:** We assume that `qtdir` is the directory where Qt is installed.
        This will pull in the code that is needed to use the PostgreSQL client
        library and to instantiate a QPSQLDriver object, assuming that you have
        the PostgreSQL headers somewhere in your include search path.

        Remember that you must link your application against the database client
        library. Make sure the client library is in your linker's search path,
        and add lines like these to your `.pro` file:

        unix:LIBS += -lpq
            win32:LIBS += libpqdll.lib

        The method described works for all the supplied drivers. The only
        difference will be in the driver constructor arguments. Here is a table
        of the drivers included with Qt, their source code files, and their
        constructor arguments:

        DriverClass nameConstructor argumentsFile to include
        QPSQLQPSQLDriverPGconn *connection`qsql_psql.cpp`
        QMYSQLQMYSQLDriverMYSQL *connection`qsql_mysql.cpp`
        QOCIQOCIDriverOCIEnv *environment, OCISvcCtx
        *serviceContext`qsql_oci.cpp`
        QODBCQODBCDriverSQLHANDLE environment,
        SQLHANDLE connection`qsql_odbc.cpp`
        QDB2QDB2SQLHANDLE environment,
        SQLHANDLE connection`qsql_db2.cpp`
        QSQLITEQSQLiteDriversqlite
        *connection`qsql_sqlite.cpp`
        QIBASEQIBaseDriverisc_db_handle
        connection`qsql_ibase.cpp`

        **Warning:** Adding a database connection with the same connection name
        as an existing connection, causes the existing connection to be replaced
        by the new one.

        **Warning:** The SQL framework takes ownership of the **driver**. It
        must not be deleted. To remove the connection, use **removeDatabase**
        ().

        **See also** **drivers** ().
        """
        ...

    @overload
    @staticmethod
    def cloneDatabase(
        other: PySide6.QtSql.QSqlDatabase, connectionName: str
    ) -> PySide6.QtSql.QSqlDatabase:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#cloneDatabase

        **[static] QSqlDatabase QSqlDatabase::cloneDatabase(const QSqlDatabase &
        other , const QString & connectionName )**

        Clones the database connection **other** and stores it as
        **connectionName**. All the settings from the original database, e.g.
        **databaseName** (), **hostName** (), etc., are copied across. Does
        nothing if **other** is an invalid database. Returns the newly created
        database connection.

        **Note:** The new connection has not been opened. Before using the new
        connection, you must call **open** ().
        """
        ...

    @overload
    @staticmethod
    def cloneDatabase(other: str, connectionName: str) -> PySide6.QtSql.QSqlDatabase:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#cloneDatabase-1

        **[static, since 5.13] QSqlDatabase QSqlDatabase::cloneDatabase(const
        QString & other , const QString & connectionName )**

        This is an overloaded function.

        Clones the database connection **other** and stores it as
        **connectionName**. All the settings from the original database, e.g.
        **databaseName** (), **hostName** (), etc., are copied across. Does
        nothing if **other** is an invalid database. Returns the newly created
        database connection.

        **Note:** The new connection has not been opened. Before using the new
        connection, you must call **open** ().

        This overload is useful when cloning the database in another thread to
        the one that is used by the database represented by **other**.

        This function was introduced in Qt 5.13.
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#close

        **void QSqlDatabase::close()**

        Closes the database connection, freeing any resources acquired, and
        invalidating any existing **QSqlQuery**  objects that are used with the
        database.

        This will also affect copies of this **QSqlDatabase**  object.

        **See also** **removeDatabase** ().
        """
        ...

    def commit(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#commit

        **bool QSqlDatabase::commit()**

        Commits a transaction to the database if the driver supports
        transactions and a **transaction** () has been started. Returns `true`
        if the operation succeeded. Otherwise it returns `false`.

        **Note:** For some databases, the commit will fail and return `false` if
        there is an **active query**  using the database for a `SELECT`. Make
        the query **inactive**  before doing the commit.

        Call **lastError** () to get information about errors.

        **See also** **QSqlQuery::isActive** (), **QSqlDriver::hasFeature** (),
        and **rollback** ().
        """
        ...

    def connectOptions(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#connectOptions

        **QString QSqlDatabase::connectOptions() const**

        Returns the connection options string used for this connection. The
        string may be empty.

        **See also** **setConnectOptions** ().
        """
        ...

    def connectionName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#connectionName

        **QString QSqlDatabase::connectionName() const**

        Returns the connection name, which may be empty.

        **Note:** The connection name is not the **database name** .

        **See also** **addDatabase** ().
        """
        ...

    @staticmethod
    def connectionNames() -> List[str]:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#connectionNames

        **[static] QStringList QSqlDatabase::connectionNames()**

        Returns a list containing the names of all connections.

        **Note:** This function is **thread-safe** .

        **See also** **contains** (), **database** (), and **Threads and the SQL
        Module** .
        """
        ...

    @staticmethod
    def contains(connectionName: str = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#contains

        **[static] bool QSqlDatabase::contains(const QString & connectionName =
        QLatin1String(defaultConnection))**

        Returns `true` if the list of database connections contains
        **connectionName** ; otherwise returns `false`.

        **Note:** This function is **thread-safe** .

        **See also** **connectionNames** (), **database** (), and **Threads and
        the SQL Module** .
        """
        ...

    @staticmethod
    def database(
        connectionName: str = ..., open: bool = ...
    ) -> PySide6.QtSql.QSqlDatabase:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#database

        **[static] QSqlDatabase QSqlDatabase::database(const QString &
        connectionName = QLatin1String(defaultConnection), bool open = true)**

        Returns the database connection called **connectionName**. The database
        connection must have been previously added with **addDatabase** (). If
        **open** is true (the default) and the database connection is not
        already open it is opened now. If no **connectionName** is specified the
        default connection is used. If **connectionName** does not exist in the
        list of databases, an invalid connection is returned.

        **Note:** This function is **thread-safe** .

        **See also** **isOpen** () and **Threads and the SQL Module** .
        """
        ...

    def databaseName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#databaseName

        **QString QSqlDatabase::databaseName() const**

        Returns the connection's database name, which may be empty.

        **Note:** The database name is not the connection name.

        **See also** **setDatabaseName** ().
        """
        ...

    def driver(self) -> PySide6.QtSql.QSqlDriver:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#driver

        **QSqlDriver *QSqlDatabase::driver() const**

        Returns the database driver used to access the database connection.

        **See also** **addDatabase** () and **drivers** ().
        """
        ...

    def driverName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#driverName

        **QString QSqlDatabase::driverName() const**

        Returns the connection's driver name.

        **See also** **addDatabase** () and **driver** ().
        """
        ...

    @staticmethod
    def drivers() -> List[str]:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#drivers

        **[static] QStringList QSqlDatabase::drivers()**

        Returns a list of all the available database drivers.

        **See also** **registerSqlDriver** ().
        """
        ...

    def exec(self, query: str = ...) -> PySide6.QtSql.QSqlQuery:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#exec

        **QSqlQuery QSqlDatabase::exec(const QString & query = QString())
        const**

        Executes a SQL statement on the database and returns a **QSqlQuery**
        object. Use **lastError** () to retrieve error information. If **query**
        is empty, an empty, invalid query is returned and **lastError** () is
        not affected.

        **See also** **QSqlQuery**  and **lastError** ().
        """
        ...

    def exec_(self, query: str = ...) -> PySide6.QtSql.QSqlQuery:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#exec

        **QSqlQuery QSqlDatabase::exec(const QString & query = QString())
        const**

        Executes a SQL statement on the database and returns a **QSqlQuery**
        object. Use **lastError** () to retrieve error information. If **query**
        is empty, an empty, invalid query is returned and **lastError** () is
        not affected.

        **See also** **QSqlQuery**  and **lastError** ().
        """
        ...

    def hostName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#hostName

        **QString QSqlDatabase::hostName() const**

        Returns the connection's host name; it may be empty.

        **See also** **setHostName** ().
        """
        ...

    @staticmethod
    def isDriverAvailable(name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#isDriverAvailable

        **[static] bool QSqlDatabase::isDriverAvailable(const QString & name )**

        Returns `true` if a driver called **name** is available; otherwise
        returns `false`.

        **See also** **drivers** ().
        """
        ...

    def isOpen(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#isOpen

        **bool QSqlDatabase::isOpen() const**

        Returns `true` if the database connection is currently open; otherwise
        returns `false`.
        """
        ...

    def isOpenError(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#isOpenError

        **bool QSqlDatabase::isOpenError() const**

        Returns `true` if there was an error opening the database connection;
        otherwise returns `false`. Error information can be retrieved using the
        **lastError** () function.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#isValid

        **bool QSqlDatabase::isValid() const**

        Returns `true` if the **QSqlDatabase**  has a valid driver.

        Example:

        **QSqlDatabase**  db;
            **qDebug** () << db.isValid();    // Returns
        false

            db = **QSqlDatabase** ::database("sales");
            **qDebug**
        () << db.isValid();    // Returns \\c true if "sales" connection exists
        **QSqlDatabase** ::removeDatabase("sales");
            **qDebug** () <<
        db.isValid();    // Returns false
        """
        ...

    def lastError(self) -> PySide6.QtSql.QSqlError:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#lastError

        **QSqlError QSqlDatabase::lastError() const**

        Returns information about the last error that occurred on the database.

        Failures that occur in conjunction with an individual query are reported
        by **QSqlQuery::lastError** ().

        **See also** **QSqlError**  and **QSqlQuery::lastError** ().
        """
        ...

    def numericalPrecisionPolicy(self) -> PySide6.QtSql.QSql.NumericalPrecisionPolicy:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#numericalPrecisionPolicy

        **QSql::NumericalPrecisionPolicy
        QSqlDatabase::numericalPrecisionPolicy() const**

        Returns the current default precision policy for the database
        connection.

        **See also** **QSql::NumericalPrecisionPolicy** ,
        **setNumericalPrecisionPolicy** (),
        **QSqlQuery::numericalPrecisionPolicy** (), and
        **QSqlQuery::setNumericalPrecisionPolicy** ().
        """
        ...

    @overload
    def open(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#open

        **bool QSqlDatabase::open()**

        Opens the database connection using the current connection values.
        Returns `true` on success; otherwise returns `false`. Error information
        can be retrieved using **lastError** ().

        **See also** **lastError** (), **setDatabaseName** (), **setUserName**
        (), **setPassword** (), **setHostName** (), **setPort** (), and
        **setConnectOptions** ().
        """
        ...

    @overload
    def open(self, user: str, password: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#open-1

        **bool QSqlDatabase::open(const QString & user , const QString &
        password )**

        This is an overloaded function.

        Opens the database connection using the given **user** name and
        **password**. Returns `true` on success; otherwise returns `false`.
        Error information can be retrieved using the **lastError** () function.

        This function does not store the password it is given. Instead, the
        password is passed directly to the driver for opening the connection and
        it is then discarded.

        **See also** **lastError** ().
        """
        ...

    def password(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#password

        **QString QSqlDatabase::password() const**

        Returns the connection's password. An empty string will be returned if
        the password was not set with **setPassword** (), and if the password
        was given in the **open** () call, or if no password was used.

        **See also** **setPassword** ().
        """
        ...

    def port(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#port

        **int QSqlDatabase::port() const**

        Returns the connection's port number. The value is undefined if the port
        number has not been set.

        **See also** **setPort** ().
        """
        ...

    def primaryIndex(self, tablename: str) -> PySide6.QtSql.QSqlIndex:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#primaryIndex

        **QSqlIndex QSqlDatabase::primaryIndex(const QString & tablename )
        const**

        Returns the primary index for table **tablename**. If no primary index
        exists, an empty **QSqlIndex**  is returned.

        **Note:** Some drivers, such as the **QPSQL**  driver, may may require
        you to pass **tablename** in lower case if the table was not quoted when
        created. See the **Qt SQL driver**  documentation for more information.

        **See also** **tables** () and **record** ().
        """
        ...

    def record(self, tablename: str) -> PySide6.QtSql.QSqlRecord:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#record

        **QSqlRecord QSqlDatabase::record(const QString & tablename ) const**

        Returns a **QSqlRecord**  populated with the names of all the fields in
        the table (or view) called **tablename**. The order in which the fields
        appear in the record is undefined. If no such table (or view) exists, an
        empty record is returned.

        **Note:** Some drivers, such as the **QPSQL**  driver, may may require
        you to pass **tablename** in lower case if the table was not quoted when
        created. See the **Qt SQL driver**  documentation for more information.
        """
        ...

    @staticmethod
    def registerSqlDriver(
        name: str, creator: PySide6.QtSql.QSqlDriverCreatorBase
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#registerSqlDriver

        **[static] void QSqlDatabase::registerSqlDriver(const QString & name ,
        QSqlDriverCreatorBase * creator )**

        This function registers a new SQL driver called **name** , within the
        SQL framework. This is useful if you have a custom SQL driver and don't
        want to compile it as a plugin.

        Example:

        **QSqlDatabase** ::registerSqlDriver("MYDRIVER", new
        **QSqlDriverCreator** <**QSqlDriver** >);
            QVERIFY(**QSqlDatabase**
        ::drivers().contains("MYDRIVER"));
            **QSqlDatabase**  db =
        **QSqlDatabase** ::addDatabase("MYDRIVER");
            QVERIFY(db.isValid());

        **QSqlDatabase**  takes ownership of the **creator** pointer, so you
        mustn't delete it yourself.

        **See also** **drivers** ().
        """
        ...

    @staticmethod
    def removeDatabase(connectionName: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#removeDatabase

        **[static] void QSqlDatabase::removeDatabase(const QString &
        connectionName )**

        Removes the database connection **connectionName** from the list of
        database connections.

        **Warning:** There should be no open queries on the database connection
        when this function is called, otherwise a resource leak will occur.

        Example:

        // WRONG
            **QSqlDatabase**  db = **QSqlDatabase**
        ::database("sales");
            **QSqlQuery**  query("SELECT NAME, DOB FROM
        EMPLOYEES", db);
            **QSqlDatabase** ::removeDatabase("sales"); // will
        output a warning
            // "db" is now a dangling invalid database
        connection,
            // "query" contains an invalid result set

        The correct way to do it:

        {
                **QSqlDatabase**  db = **QSqlDatabase** ::database("sales");
        **QSqlQuery**  query("SELECT NAME, DOB FROM EMPLOYEES", db);
            }
        // Both "db" and "query" are destroyed because they are out of scope
        **QSqlDatabase** ::removeDatabase("sales"); // correct

        To remove the default connection, which may have been created with a
        call to **addDatabase** () not specifying a connection name, you can
        retrieve the default connection name by calling **connectionName** () on
        the database returned by **database** (). Note that if a default
        database hasn't been created an invalid database will be returned.

        **Note:** This function is **thread-safe** .

        **See also** **database** (), **connectionName** (), and **Threads and
        the SQL Module** .
        """
        ...

    def rollback(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#rollback

        **bool QSqlDatabase::rollback()**

        Rolls back a transaction on the database, if the driver supports
        transactions and a **transaction** () has been started. Returns `true`
        if the operation succeeded. Otherwise it returns `false`.

        **Note:** For some databases, the rollback will fail and return `false`
        if there is an **active query**  using the database for a `SELECT`. Make
        the query **inactive**  before doing the rollback.

        Call **lastError** () to get information about errors.

        **See also** **QSqlQuery::isActive** (), **QSqlDriver::hasFeature** (),
        and **commit** ().
        """
        ...

    def setConnectOptions(self, options: str = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#setConnectOptions

        **void QSqlDatabase::setConnectOptions(const QString & options =
        QString())**

        Sets database-specific **options**. This must be done before the
        connection is opened, otherwise it has no effect. Another possibility is
        to close the connection, call QSqlDatabase::setConnectOptions(), and
        **open** () the connection again.

        The format of the **options** string is a semicolon separated list of
        option names or option=value pairs. The options depend on the database
        client used:

        ODBCMySQLPostgreSQL

          * SQL_ATTR_ACCESS_MODE
          *
        SQL_ATTR_LOGIN_TIMEOUT
          * SQL_ATTR_CONNECTION_TIMEOUT
          *
        SQL_ATTR_CURRENT_CATALOG
          * SQL_ATTR_METADATA_ID
          *
        SQL_ATTR_PACKET_SIZE
          * SQL_ATTR_TRACEFILE
          * SQL_ATTR_TRACE
          *
        SQL_ATTR_CONNECTION_POOLING
          * SQL_ATTR_ODBC_VERSION

          *
        CLIENT_COMPRESS
          * CLIENT_FOUND_ROWS
          * CLIENT_IGNORE_SPACE
          *
        CLIENT_ODBC
          * CLIENT_NO_SCHEMA
          * CLIENT_INTERACTIVE
          * UNIX_SOCKET
        * MYSQL_OPT_RECONNECT
          * MYSQL_OPT_CONNECT_TIMEOUT
          *
        MYSQL_OPT_READ_TIMEOUT
          * MYSQL_OPT_WRITE_TIMEOUT
          * SSL_KEY
          *
        SSL_CERT
          * SSL_CA
          * SSL_CAPATH
          * SSL_CIPHER

          * connect_timeout
        * options
          * tty
          * requiressl
          * service


        DB2OCI

          *
        SQL_ATTR_ACCESS_MODE
          * SQL_ATTR_LOGIN_TIMEOUT

          *
        OCI_ATTR_PREFETCH_ROWS
          * OCI_ATTR_PREFETCH_MEMORY


        SQLiteInterbase
        * QSQLITE_BUSY_TIMEOUT
          * QSQLITE_OPEN_READONLY
          * QSQLITE_OPEN_URI
        * QSQLITE_ENABLE_SHARED_CACHE
          * QSQLITE_ENABLE_REGEXP
          *
        QSQLITE_NO_USE_EXTENDED_RESULT_CODES

          * ISC_DPB_LC_CTYPE
          *
        ISC_DPB_SQL_ROLE_NAME

        Examples:

        db.setConnectOptions("SSL_KEY=client-key.pem;SSL_CERT=client-
        cert.pem;SSL_CA=ca-cert.pem;CLIENT_IGNORE_SPACE=1"); // use an SSL
        connection to the server
            if (!db.open()) {
        db.setConnectOptions(); // clears the connect option string
                //
        ...
            }
            // ...
            // PostgreSQL connection
        db.setConnectOptions("requiressl=1"); // enable PostgreSQL SSL
        connections
            if (!db.open()) {
                db.setConnectOptions(); //
        clear options
                // ...
            }
            // ...
            // ODBC connection
        db.setConnectOptions("SQL_ATTR_ACCESS_MODE=SQL_MODE_READ_ONLY;SQL_ATTR_T
        RACE=SQL_OPT_TRACE_ON"); // set ODBC options
            if (!db.open()) {
        db.setConnectOptions(); // don't try to set this option
                // ...
        }
            }

        Refer to the client library documentation for more information about the
        different options.

        **See also** **connectOptions** ().
        """
        ...

    def setDatabaseName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#setDatabaseName

        **void QSqlDatabase::setDatabaseName(const QString & name )**

        Sets the connection's database name to **name**. To have effect, the
        database name must be set **before** the connection is **opened** .
        Alternatively, you can **close** () the connection, set the database
        name, and call **open** () again.

        **Note:** The **database name** is not the **connection name**. The
        connection name must be passed to **addDatabase** () at connection
        object create time.

        For the QSQLITE driver, if the database name specified does not exist,
        then it will create the file for you unless the QSQLITE_OPEN_READONLY
        option is set.

        Additionally, **name** can be set to `":memory:"` which will create a
        temporary database which is only available for the lifetime of the
        application.

        For the QOCI (Oracle) driver, the database name is the TNS Service Name.

        For the QODBC driver, the **name** can either be a DSN, a DSN filename
        (in which case the file must have a `.dsn` extension), or a connection
        string.

        For example, Microsoft Access users can use the following connection
        string to open an `.mdb` file directly, instead of having to create a
        DSN entry in the ODBC manager:

        // ...
            **QSqlDatabase**  db = **QSqlDatabase**
        ::addDatabase("QODBC");
            db.setDatabaseName("DRIVER={Microsoft Access
        Driver (*.mdb, *.accdb)};FIL={MS Access};DBQ=myaccessfile.mdb");
            if
        (db.open()) {
                // success!
            }
            // ...

        There is no default value.

        **See also** **databaseName** (), **setUserName** (), **setPassword**
        (), **setHostName** (), **setPort** (), **setConnectOptions** (), and
        **open** ().
        """
        ...

    def setHostName(self, host: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#setHostName

        **void QSqlDatabase::setHostName(const QString & host )**

        Sets the connection's host name to **host**. To have effect, the host
        name must be set **before** the connection is **opened** .
        Alternatively, you can **close** () the connection, set the host name,
        and call **open** () again.

        There is no default value.

        **See also** **hostName** (), **setUserName** (), **setPassword** (),
        **setDatabaseName** (), **setPort** (), **setConnectOptions** (), and
        **open** ().
        """
        ...

    def setNumericalPrecisionPolicy(
        self, precisionPolicy: PySide6.QtSql.QSql.NumericalPrecisionPolicy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#setNumericalPrecisionPolicy

        **void
        QSqlDatabase::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy
        precisionPolicy )**

        Sets the default numerical precision policy used by queries created on
        this database connection to **precisionPolicy**.

        Note: Drivers that don't support fetching numerical values with low
        precision will ignore the precision policy. You can use
        **QSqlDriver::hasFeature** () to find out whether a driver supports this
        feature.

        Note: Setting the default precision policy to **precisionPolicy**
        doesn't affect any currently active queries.

        **See also** **QSql::NumericalPrecisionPolicy** ,
        **numericalPrecisionPolicy** (),
        **QSqlQuery::setNumericalPrecisionPolicy** (), and
        **QSqlQuery::numericalPrecisionPolicy** ().
        """
        ...

    def setPassword(self, password: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#setPassword

        **void QSqlDatabase::setPassword(const QString & password )**

        Sets the connection's password to **password**. To have effect, the
        password must be set **before** the connection is **opened** .
        Alternatively, you can **close** () the connection, set the password,
        and call **open** () again.

        There is no default value.

        **Warning:** This function stores the password in plain text within Qt.
        Use the **open** () call that takes a password as parameter to avoid
        this behavior.

        **See also** **password** (), **setUserName** (), **setDatabaseName**
        (), **setHostName** (), **setPort** (), **setConnectOptions** (), and
        **open** ().
        """
        ...

    def setPort(self, p: int) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#setPort

        **void QSqlDatabase::setPort(int port )**

        Sets the connection's port number to **port**. To have effect, the port
        number must be set **before** the connection is **opened** .
        Alternatively, you can **close** () the connection, set the port number,
        and call **open** () again..

        There is no default value.

        **See also** **port** (), **setUserName** (), **setPassword** (),
        **setHostName** (), **setDatabaseName** (), **setConnectOptions** (),
        and **open** ().
        """
        ...

    def setUserName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#setUserName

        **void QSqlDatabase::setUserName(const QString & name )**

        Sets the connection's user name to **name**. To have effect, the user
        name must be set **before** the connection is **opened** .
        Alternatively, you can **close** () the connection, set the user name,
        and call **open** () again.

        There is no default value.

        **See also** **userName** (), **setDatabaseName** (), **setPassword**
        (), **setHostName** (), **setPort** (), **setConnectOptions** (), and
        **open** ().
        """
        ...

    def tables(self, type: PySide6.QtSql.QSql.TableType = ...) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#tables

        **QStringList QSqlDatabase::tables(QSql::TableType type = QSql::Tables)
        const**

        Returns a list of the database's tables, system tables and views, as
        specified by the parameter **type**.

        **See also** **primaryIndex** () and **record** ().
        """
        ...

    def transaction(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#transaction

        **bool QSqlDatabase::transaction()**

        Begins a transaction on the database if the driver supports
        transactions. Returns `true` if the operation succeeded. Otherwise it
        returns `false`.

        **See also** **QSqlDriver::hasFeature** (), **commit** (), and
        **rollback** ().
        """
        ...

    def userName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqldatabase.html#userName

        **QString QSqlDatabase::userName() const**

        Returns the connection's user name; it may be empty.

        **See also** **setUserName** ().
        """
        ...
