"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QProximityReading(PySide6.QtSensors.QSensorReading):
    """
    https://doc.qt.io/qt-6/qproximityreading.html

    **Detailed Description**

    The proximity sensor can only indicate if an object is close or not.

    The distance at which an object is considered close is device-specific. This
    distance may be available in the **QSensor::outputRanges**  property.
    """

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    def close(self) -> bool:
        """
        https://doc.qt.io/qt-6/qproximityreading.html#close-prop

        **[read-only] close : const bool**

        This property holds a value indicating if something is close.

        Set to true if something is close. Set to false is nothing is close.

        **Access functions:**

        bool **close** () const

        **See also** **QProximityReading_Units** .

        **Member Function Documentation**
        """
        ...

    def copyValuesFrom(self, other: PySide6.QtSensors.QSensorReading) -> None:
        ...

    def setClose(self, close: bool) -> None:
        """
        https://doc.qt.io/qt-6/qproximityreading.html#setClose

        **void QProximityReading::setClose(bool close )**

        Sets the close value to **close**.

        **See also** **close** ().
        """
        ...
