"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QMagnetometerReading(PySide6.QtSensors.QSensorReading):
    """
    https://doc.qt.io/qt-6/qmagnetometerreading.html

    **Detailed Description**

    **QMagnetometerReading Units**

    The magnetometer returns magnetic flux density values along 3 axes. The
    scale of the values is teslas. The axes are arranged as follows.

    ![](images/sensors-coordinates2.jpg)

    The magnetometer can report on either raw magnetic flux values or
    geomagnetic flux values. By default it returns raw magnetic flux values. The
    **QMagnetometer::returnGeoValues**  property must be set to return
    geomagnetic flux values.

    The primary difference between raw and geomagnetic values is that extra
    processing is done to eliminate local magnetic interference from the
    geomagnetic values so they represent only the effect of the Earth's magnetic
    field. This process is not perfect and the accuracy of each reading may
    change.

    The image below shows the difference between geomagnetic (on the left) and
    raw (on the right) readings for a phone that is being subjected to magnetic
    interference.

    ![](images/sensors-geo-vs-raw-magnetism.jpg)

    The accuracy of each reading is measured as a number from 0 to 1. A value of
    1 is the highest level that the device can support and 0 is the worst.

    **Calibration**

    If the device is reporting low accuracy, then calibration might be needed
    before acceptable measurements can be provided. Basic calibration can
    usually be done by either rotating your device in a figure of eight, or by
    rotating the device along each of its three axes. For more information,
    check your device's documentation on how to calibrate the magnetic sensor.
    """

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    def calibrationLevel(self) -> float:
        """
        https://doc.qt.io/qt-6/qmagnetometerreading.html#calibrationLevel-prop

        **[read-only] calibrationLevel : const qreal**

        This property holds the accuracy of the reading.

        Measured as a value from 0 to 1 with higher values being better.

        Note that this only changes when measuring geomagnetic flux density. Raw
        magnetic flux readings will always have a value of 1.

        **Access functions:**

        qreal **calibrationLevel** () const

        **See also** **QMagnetometerReading Units**  and **Calibration** .
        """
        ...

    def copyValuesFrom(self, other: PySide6.QtSensors.QSensorReading) -> None:
        ...

    def setCalibrationLevel(self, calibrationLevel: float) -> None:
        """
        https://doc.qt.io/qt-6/qmagnetometerreading.html#setCalibrationLevel

        **void QMagnetometerReading::setCalibrationLevel(qreal calibrationLevel
        )**

        Sets the accuracy of the reading to **calibrationLevel**.

        **See also** **calibrationLevel** ().
        """
        ...

    def setX(self, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qmagnetometerreading.html#setX

        **void QMagnetometerReading::setX(qreal x )**

        Sets the raw magnetic flux density on the X axis to **x**.

        **See also** **x** ().
        """
        ...

    def setY(self, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qmagnetometerreading.html#setY

        **void QMagnetometerReading::setY(qreal y )**

        Sets the raw magnetic flux density on the Y axis to **y**.

        **See also** **y** ().
        """
        ...

    def setZ(self, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qmagnetometerreading.html#setZ

        **void QMagnetometerReading::setZ(qreal z )**

        Sets the raw magnetic flux density on the Z axis to **z**.

        **See also** **z** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-6/qmagnetometerreading.html#x-prop

        **[read-only] x : const qreal**

        This property holds the raw magnetic flux density on the X axis.

        Measured as teslas.

        **Access functions:**

        qreal **x** () const

        **See also** **QMagnetometerReading Units** .
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-6/qmagnetometerreading.html#y-prop

        **[read-only] y : const qreal**

        This property holds the raw magnetic flux density on the Y axis.

        Measured as teslas.

        **Access functions:**

        qreal **y** () const

        **See also** **QMagnetometerReading Units** .
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-6/qmagnetometerreading.html#z-prop

        **[read-only] z : const qreal**

        This property holds the raw magnetic flux density on the Z axis.

        Measured as teslas.

        **Access functions:**

        qreal **z** () const

        **See also** **QMagnetometerReading Units** .

        **Member Function Documentation**
        """
        ...
