"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtRemoteObjects, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtRemoteObjects

bytes = str


class QRemoteObjectHostBase(PySide6.QtRemoteObjects.QRemoteObjectNode):
    """
    https://doc.qt.io/qt-6/qremoteobjecthostbase.html

    **Detailed Description**

    QRemoteObjectHostBase is a base class that cannot be instantiated directly.
    It provides the **enableRemoting**  and **disableRemoting**  functionality
    shared by all host nodes (**Host**  and **RegistryHost** ) as well as the
    logic required to expose **Source**  objects on the Remote Objects network.
    """

    BuiltInSchemasOnly: QRemoteObjectHostBase.AllowedSchemas = ...
    AllowExternalRegistration: QRemoteObjectHostBase.AllowedSchemas = ...

    class AllowedSchemas(Enum):
        BuiltInSchemasOnly: QRemoteObjectHostBase.AllowedSchemas = ...
        AllowExternalRegistration: QRemoteObjectHostBase.AllowedSchemas = ...

    def addHostSideConnection(self, ioDevice: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qremoteobjecthostbase.html#addHostSideConnection

        **[since 5.12] void
        QRemoteObjectHostBase::addHostSideConnection(QIODevice * ioDevice )**

        In order to **QRemoteObjectHost::enableRemoting** () **Source**  objects
        over **External QIODevices** , Qt Remote Objects needs access to the
        communications channel (a **QIODevice** ) between the respective nodes.
        It is the addHostSideConnection() call that enables this on the
        **Source**  side, taking the **ioDevice** as input. Any
        **enableRemoting** () call will still work without calling
        addHostSideConnection, but the Node will not be able to share the
        **Source**  objects without being provided the connection to the Replica
        node. Before calling this function you must call **setHostUrl** () with
        a unique URL and **AllowExternalRegistration** .

        This function was introduced in Qt 5.12.

        **See also** **addClientSideConnection** .
        """
        ...

    def disableRemoting(self, remoteObject: PySide6.QtCore.QObject) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjecthostbase.html#disableRemoting

        **[invokable] bool QRemoteObjectHostBase::disableRemoting(QObject *
        remoteObject )**

        Disables remote access for the **QObject**  **remoteObject**. Returns
        `false` if the current node is a client node or if the **remoteObject**
        is not registered, and returns `true` if remoting is successfully
        disabled for the Source object.

        **Warning:** Replicas of this object will no longer be valid after
        calling this method.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **enableRemoting** ().
        """
        ...

    @overload
    def enableRemoting(
        self,
        model: PySide6.QtCore.QAbstractItemModel,
        name: str,
        roles: Sequence[int],
        selectionModel: Optional[PySide6.QtCore.QItemSelectionModel] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjecthostbase.html#enableRemoting

        **template <template <typename> class ApiDefinition, typename
        ObjectType> bool QRemoteObjectHostBase::enableRemoting(ObjectType *
        object )**

        This templated function overload enables a host node to provide remote
        access to a **QObject**  **object** with a specified (and compile-time
        checked) interface. Client nodes connected to the node hosting this
        object may obtain Replicas of this Source.

        This is best illustrated by example:

        #include "rep_TimeModel_source.h"
            MinuteTimer timer;
        hostNode.enableRemoting<MinuteTimerSourceAPI>(&timer);

        Here the MinuteTimerSourceAPI is the set of Signals/Slots/Properties
        defined by the TimeModel.rep file. Compile time checks are made to
        verify the input **QObject**  can expose the requested API, it will fail
        to compile otherwise. This allows a subset of **object** 's interface to
        be exposed, and allows the types of conversions supported by Signal/Slot
        connections.

        Returns `false` if the current node is a client node, or if the
        **QObject**  is already registered to be remoted, and `true` if remoting
        is successfully enabled for the **QObject** .

        **See also** **disableRemoting** ().
        """
        ...

    @overload
    def enableRemoting(self, object: PySide6.QtCore.QObject, name: str = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjecthostbase.html#enableRemoting-1

        **[invokable] bool QRemoteObjectHostBase::enableRemoting(QObject *
        object , const QString & name = QString())**

        Enables a host node to dynamically provide remote access to the
        **QObject**  **object**. Client nodes connected to the node hosting this
        object may obtain Replicas of this Source.

        The optional **name** defines the lookup-name under which the
        **QObject**  can be acquired using **QRemoteObjectNode::acquire** () .
        If not explicitly set then the name given in the
        QCLASSINFO_REMOTEOBJECT_TYPE will be used. If no such macro was defined
        for the **QObject**  then the **QObject::objectName** () is used.

        Returns `false` if the current node is a client node, or if the
        **QObject**  is already registered to be remoted, and `true` if remoting
        is successfully enabled for the dynamic **QObject** .

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **disableRemoting** ().
        """
        ...

    def hostUrl(self) -> PySide6.QtCore.QUrl:
        ...

    def proxy(
        self,
        registryUrl: Union[PySide6.QtCore.QUrl, str],
        hostUrl: Union[PySide6.QtCore.QUrl, str] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjecthostbase.html#proxy

        **[since 5.11] bool QRemoteObjectHostBase::proxy(const QUrl &
        registryUrl , const QUrl & hostUrl = {},
        QRemoteObjectHostBase::RemoteObjectNameFilter filter = [](QStringView,
        QStringView) {return true; })**

        Forward Remote Objects from another network

        The proxy functionality is useful when you want to share **Source**
        objects over multiple networks. For instance, if you have an embedded
        target using target-only connections (like local) and you want to make
        some of those same objects available externally.

        As a concrete example, say you have a set of processes talking to each
        other on your target hardware using a registry, with the **Registry**
        at "local:registry" and separate processes using a node at
        "local:MyHost" that holds **Source**  objects. If you wanted to access
        these objects, but over tcp, you could create a new proxyNode like so:

        // myInternalHost is a node only visible on the device...
        **QRemoteObjectHost**  myInternalHost("local:MyHost");
        myInternalHost.enableRemoting<SomeObject>(&someObject);

            //
        Regular host node, listening on port 12123, so visible to other
            //
        devices
            **QRemoteObjectHost**  proxyNode("tcp://localhost:12123");
        // Enable proxying objects from nodes on the local machine's internal
        // QtRO bus
            proxyNode.proxy("local:registry");

        And from another device you create another node:

        // NB: localhost resolves to a different ip address than proxyNode
        **QRemoteObjectHost**  nodeOnRemoteDevice("tcp://localhost:23234");
        // Connect to the target's proxyNode directly, or use a tcp registry...
        nodeOnRemoteDevice.connectToNode("tcp://<target device>:12123");
        // Because of the proxy, we can get the object over tcp/ip port 12123,
        // even though we can't connect directly to "local:MyHost"
        SomeObject *so = nodeOnRemoteDevice.acquire<SomeObject>();

        This would (internally) create a node in proxyNode, which (again
        internally/automatically) connects to the provided registry (given by
        the **registryUrl** parameter, "local:registry" in this example).
        Whenever local:registry emits the **remoteObjectAdded**  signal, the
        `QRemoteObjectSourceLocation` is passed to the **filter** given to the
        proxy call. If this method returns true (the default filter simply
        returns true without any filtering), the object is acquired() from the
        internal node and **enableRemoting** () (once the replica is
        initialized) is called on proxyNode.

        If a **hostUrl** is provided (which is required to enable
        **reverseProxy** , but not needed otherwise), the internal node will be
        a **QRemoteObjectHost**  node configured with the provided address. If
        no **hostUrl** is provided, the internal node will be a
        **QRemoteObjectNode**  (not HostNode).

        Returns `true` if the object is acquired from the internal node.

        This function was introduced in Qt 5.11.

        **See also** **reverseProxy** ().
        """
        ...

    def reverseProxy(self) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjecthostbase.html#reverseProxy

        **[since 5.11] bool QRemoteObjectHostBase::reverseProxy(QRemoteObjectHos
        tBase::RemoteObjectNameFilter filter = [](QStringView, QStringView)
        {return true; })**

        Forwards remote objects to another network.

        The reverseProxy() function allows the **proxy** () functionality to be
        extended, in effect mirroring the proxy functionality in the "reverse"
        direction. These are distinct, because node communication is not
        symmetric, one side calls **enableRemoting** () with a **Source**
        object, the other side calls **acquire** () to get a **Replica** . Using
        **proxy** () allows you to "observe" objects on a target device remotely
        via acquire, but it does not allow off-target **Source**  objects to be
        acquired from the device's local:* network. That is where reverseProxy()
        comes in. If a proxyNode is created like so:

        // myInternalHost is a node only visible on the device...
        **QRemoteObjectHost**  myInternalHost("local:MyHost");

            //
        RegistryHost node, listening on port 12123, so visible to other
            //
        devices.  The node must be a RegistryHost, so the Sources on
            // the
        "outside" network can be forwarded to the inner network.
        **QRemoteObjectRegistryHost**  proxyNode("tcp://localhost:12123");
        // Enable proxying objects from nodes on the local machine's internal
        // QtRO bus.  Note the hostUrl parameter is now needed.
        proxyNode.proxy("local:registry", "local:fromProxy");
        proxyNode.reverseProxy();

        And from another device you create another node:

        // NB: localhost resolves to a different ip address than proxyNode
        **QRemoteObjectHost**  nodeOnRemoteDevice("tcp://localhost:23234");
        // Connect to the target's proxyNode directly, or use a tcp registry...
        nodeOnRemoteDevice.connectToNode("tcp://<target device>:12123");
        // Because of the reverseProxy, we can expose objects on this device
        // and they will make their way to proxyNode...
        nodeOnRemoteDevice.enableRemoting<OtherObject>(&otherObject);

        // Acquire() can now see the objects on other devices through proxyNode,
        // due to the reverseProxy call.
            OtherObject *oo =
        myInternalHost.acquire<OtherObject>();

        While the **proxy** () functionality allows **Source**  objects on
        another network to be acquired(), reverseProxy() allows **Source**
        objects to be "pushed" to an otherwise inaccessible network.

        **Note:****proxy** () needs to be called before reverseProxy(), and a
        hostUrl needs to be provided to **proxy**  for reverseProxy() to work.
        The reverseProxy() method allows a separate **filter** to be applied.
        This reverseProxy specific filter will receive notifications of new
        **Source**  objects on `proxyNode` and acquire them on the internal node
        if they pass the **filter**.

        Returns `true` on success, `false` otherwise.

        **Note:** Currently the reverse proxy functionality is supported only
        for **QRemoteObjectRegistryHost** . Calling this method on a
        **QRemoteObjectHost**  node will always return `false`.

        This function was introduced in Qt 5.11.

        **See also** **proxy** ().
        """
        ...

    def setHostUrl(
        self,
        hostAddress: Union[PySide6.QtCore.QUrl, str],
        allowedSchemas: PySide6.QtRemoteObjects.QRemoteObjectHostBase.AllowedSchemas = ...,
    ) -> bool:
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qremoteobjecthostbase.html#setName

        **[override virtual] void QRemoteObjectHostBase::setName(const QString &
        name )**

        Reimplements: **QRemoteObjectNode::setName** (const QString &name).

        Similar to **QObject::setObjectName** () (which this method calls), but
        this version also applies the **name** to internal classes as well,
        which are used in some of the debugging output.
        """
        ...
