"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtRemoteObjects, except for defaults which are replaced by "...".
"""
from typing import Any, List, Optional, Sequence, Union
import PySide6.QtCore
import PySide6.QtRemoteObjects

bytes = str


class QRemoteObjectAbstractPersistedStore(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qremoteobjectabstractpersistedstore.html

    **Detailed Description**

    This can be used to provide a "reasonable" value to be displayed until the
    connection to the source is established and current values are available.

    This class must be overridden to provide an implementation for saving
    (**QRemoteObjectAbstractPersistedStore::saveProperties** ) and restoring
    (**QRemoteObjectAbstractPersistedStore::restoreProperties** ) PROP values.
    The derived type can then be set for a node, and any replica acquired from
    that node will then automatically store PERSISTED properties when the
    replica destructor is called, and retrieve the values when the replica is
    instantiated.
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qremoteobjectabstractpersistedstore.html#QRemoteO
        bjectAbstractPersistedStore

        **QRemoteObjectAbstractPersistedStore::QRemoteObjectAbstractPersistedSto
        re(QObject * parent = nullptr)**

        Constructs a QRemoteObjectAbstractPersistedStore with the given
        **parent**. The default value of **parent** is `nullptr`.
        """
        ...

    def restoreProperties(
        self, repName: str, repSig: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> List[Any]:
        """
        https://doc.qt.io/qt-6/qremoteobjectabstractpersistedstore.html#restoreP
        roperties

        **[pure virtual] QVariantList
        QRemoteObjectAbstractPersistedStore::restoreProperties(const QString &
        repName , const QByteArray & repSig )**

        This method will be provided the replica class's **repName** and
        **repSig** when the replica is being initialized. It is the
        responsibility of the inheriting class to get the last values persisted
        by **QRemoteObjectAbstractPersistedStore::saveProperties**  and return
        them. An empty QVariantList should be returned if no values are
        available.

        **See also** **QRemoteObjectAbstractPersistedStore::saveProperties** .
        """
        ...

    def saveProperties(
        self,
        repName: str,
        repSig: Union[PySide6.QtCore.QByteArray, bytes],
        values: Sequence[Any],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qremoteobjectabstractpersistedstore.html#saveProp
        erties

        **[pure virtual] void
        QRemoteObjectAbstractPersistedStore::saveProperties(const QString &
        repName , const QByteArray & repSig , const QVariantList & values )**

        This method will be provided the replica class's **repName** ,
        **repSig** and the list of **values** that PERSISTED properties have
        when the replica destructor was called. It is the responsibility of the
        inheriting class to store the information in a manner consistent for
        **QRemoteObjectAbstractPersistedStore::restoreProperties**  to retrieve.

        **See also** **QRemoteObjectAbstractPersistedStore::restoreProperties**
        .
        """
        ...
