"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick3D, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtQml
import PySide6.QtQuick3D

bytes = str


class QQuick3DInstancing(PySide6.QtQuick3D.QQuick3DObject):
    """
    https://doc.qt.io/qt-6/qquick3dinstancing.html

    **Detailed Description**

    The QQuick3DInstancing class can be inherited to specify a custom instance
    table for a Model in the Qt Quick 3D scene.

    This class is abstract: To use it, create a subclass and implement
    **getInstanceBuffer** ().
    """

    class InstanceTableEntry(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self,
            InstanceTableEntry: PySide6.QtQuick3D.QQuick3DInstancing.InstanceTableEntry,
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    def __init__(
        self, parent: Optional[PySide6.QtQuick3D.QQuick3DObject] = ...
    ) -> None:
        ...

    @staticmethod
    def calculateTableEntry(
        position: PySide6.QtGui.QVector3D,
        scale: PySide6.QtGui.QVector3D,
        eulerRotation: PySide6.QtGui.QVector3D,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        customData: PySide6.QtGui.QVector4D = ...,
    ) -> PySide6.QtQuick3D.QQuick3DInstancing.InstanceTableEntry:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#calculateTableEntry

        **[static protected] QQuick3DInstancing::InstanceTableEntry
        QQuick3DInstancing::calculateTableEntry(const QVector3D & position ,
        const QVector3D & scale , const QVector3D & eulerRotation , const QColor
        & color , const QVector4D & customData = {})**

        Converts the **position** **scale** **eulerRotation** **color** and
        **customData** to the instance table format expected by the standard
        vertex shaders. Typical pattern:

        **QByteArray**  MyInstanceTable::getInstanceBuffer(int *instanceCount)
        {
                **QByteArray**  instanceData;

                ...
        auto entry = calculateTableEntry({xPos, yPos, zPos}, {xScale, yScale,
        zScale}, {xRot, yRot, zRot}, color, {});
        instanceData.append(reinterpret_cast<const char \\*>(&entry),
        sizeof(entry));

        **See also** **calculateTableEntryFromQuaternion** .
        """
        ...

    @staticmethod
    def calculateTableEntryFromQuaternion(
        position: PySide6.QtGui.QVector3D,
        scale: PySide6.QtGui.QVector3D,
        rotation: PySide6.QtGui.QQuaternion,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        customData: PySide6.QtGui.QVector4D = ...,
    ) -> PySide6.QtQuick3D.QQuick3DInstancing.InstanceTableEntry:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#calculateTableEntryFromQu
        aternion

        **[static protected] QQuick3DInstancing::InstanceTableEntry
        QQuick3DInstancing::calculateTableEntryFromQuaternion(const QVector3D &
        position , const QVector3D & scale , const QQuaternion & rotation ,
        const QColor & color , const QVector4D & customData = {})**

        Converts the **position** **scale** **rotation** **color** and
        **customData** to the instance table format expected by the standard
        vertex shaders.

        This is the same as **calculateTableEntry** (), except for using a
        quaternion to specify the rotation.
        """
        ...

    def depthSortingEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#depthSortingEnabled-prop

        **depthSortingEnabled : bool**

        Holds the depth sorting enabled value for the instance table. When
        enabled, instances are sorted and rendered from the furthest instance
        from the camera to the nearest i.e. back-to-front. If disabled, which is
        the default, instances are rendered in the order they are specified in
        the instance table.

        **Note:** The instances are only sorted against each other. Instances
        are not sorted against other objects in the scene.

        **Note:** The sorting increases the frame preparation time especially
        with large instance counts.

        **Access functions:**

        bool **depthSortingEnabled** () const
        void **setDepthSortingEnabled**
        (bool **enabled** )

        **Notifier signal:**

        void **depthSortingEnabledChanged** ()
        """
        ...

    def getInstanceBuffer(self) -> Tuple[PySide6.QtCore.QByteArray, int]:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#getInstanceBuffer

        **[pure virtual protected] QByteArray
        QQuick3DInstancing::getInstanceBuffer(int * instanceCount )**

        Implement this function to return the contents of the instance table.
        The number of instances should be returned in **instanceCount**. The
        subclass is responsible for caching the result if necessary. If the
        instance table changes, the subclass should call **markDirty** ().
        """
        ...

    def hasTransparency(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#hasTransparency-prop

        **hasTransparency : bool**

        Set this property to true if the instancing table contains alpha values
        that should be used when rendering the model. This property only makes a
        difference if the model is opaque: If the model has a transparent
        **material** , or an **opacity**  less than one, the alpha value from
        the table will be used regardless.

        **Note:** Enabling alpha blending may cause rendering issues when
        instances overlap. See the **alpha blending and instancing**
        documentation for details.

        **Access functions:**

        bool **hasTransparency** () const
        void **setHasTransparency** (bool
        **hasTransparency** )

        **Notifier signal:**

        void **hasTransparencyChanged** ()
        """
        ...

    def instanceBuffer(self) -> Tuple[PySide6.QtCore.QByteArray, int]:
        ...

    def instanceCountOverride(self) -> int:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#instanceCountOverride-
        prop

        **instanceCountOverride : int**

        Set this property to limit the number of instances without regenerating
        or re-uploading the instance table. This allows very inexpensive
        animation of the number of instances rendered.

        **Access functions:**

        int **instanceCountOverride** () const
        void
        **setInstanceCountOverride** (int **instanceCountOverride** )

        **Notifier signal:**

        void **instanceCountOverrideChanged** ()

        **Member Function Documentation**
        """
        ...

    def markDirty(self) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#markDirty

        **[protected] void QQuick3DInstancing::markDirty()**

        Mark that the instance data has changed and must be uploaded again.

        **See also** **getInstanceBuffer**  and **instanceCountOverride** .
        """
        ...

    def setDepthSortingEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#depthSortingEnabled-prop

        **depthSortingEnabled : bool**

        Holds the depth sorting enabled value for the instance table. When
        enabled, instances are sorted and rendered from the furthest instance
        from the camera to the nearest i.e. back-to-front. If disabled, which is
        the default, instances are rendered in the order they are specified in
        the instance table.

        **Note:** The instances are only sorted against each other. Instances
        are not sorted against other objects in the scene.

        **Note:** The sorting increases the frame preparation time especially
        with large instance counts.

        **Access functions:**

        bool **depthSortingEnabled** () const
        void **setDepthSortingEnabled**
        (bool **enabled** )

        **Notifier signal:**

        void **depthSortingEnabledChanged** ()
        """
        ...

    def setHasTransparency(self, hasTransparency: bool) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#hasTransparency-prop

        **hasTransparency : bool**

        Set this property to true if the instancing table contains alpha values
        that should be used when rendering the model. This property only makes a
        difference if the model is opaque: If the model has a transparent
        **material** , or an **opacity**  less than one, the alpha value from
        the table will be used regardless.

        **Note:** Enabling alpha blending may cause rendering issues when
        instances overlap. See the **alpha blending and instancing**
        documentation for details.

        **Access functions:**

        bool **hasTransparency** () const
        void **setHasTransparency** (bool
        **hasTransparency** )

        **Notifier signal:**

        void **hasTransparencyChanged** ()
        """
        ...

    def setInstanceCountOverride(self, instanceCountOverride: int) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dinstancing.html#instanceCountOverride-
        prop

        **instanceCountOverride : int**

        Set this property to limit the number of instances without regenerating
        or re-uploading the instance table. This allows very inexpensive
        animation of the number of instances rendered.

        **Access functions:**

        int **instanceCountOverride** () const
        void
        **setInstanceCountOverride** (int **instanceCountOverride** )

        **Notifier signal:**

        void **instanceCountOverrideChanged** ()

        **Member Function Documentation**
        """
        ...

    @property
    def depthSortingEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def hasTransparencyChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def instanceCountOverrideChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
