"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from typing import Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGTransformNode(PySide6.QtQuick.QSGNode):
    """
    https://doc.qt.io/qt-6/qsgtransformnode.html

    **Detailed Description**

    Transformations apply the node's subtree and can be nested. Multiple
    transform nodes will be accumulated by intersecting all their matrices. The
    accumulation happens as part of the rendering.

    The transform nodes implement a 4x4 matrix which in theory supports full 3D
    transformations. However, because the renderer optimizes for 2D use-cases
    rather than 3D use-cases, rendering a scene with full 3D transformations
    needs to be done with some care.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgtransformnode.html#QSGTransformNode

        **QSGTransformNode::QSGTransformNode()**

        Create a new QSGTransformNode with its matrix set to the identity
        matrix.
        """
        ...

    def combinedMatrix(self) -> PySide6.QtGui.QMatrix4x4:
        ...

    def matrix(self) -> PySide6.QtGui.QMatrix4x4:
        """
        https://doc.qt.io/qt-6/qsgtransformnode.html#matrix

        **const QMatrix4x4 &QSGTransformNode::matrix() const**

        Returns this transform node's matrix.

        **See also** **setMatrix** ().
        """
        ...

    def setCombinedMatrix(
        self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]
    ) -> None:
        ...

    def setMatrix(
        self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgtransformnode.html#setMatrix

        **void QSGTransformNode::setMatrix(const QMatrix4x4 & matrix )**

        Sets this transform node's matrix to **matrix**.

        **See also** **matrix** ().
        """
        ...
