"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGOpaqueTextureMaterial(PySide6.QtQuick.QSGMaterial):
    """
    https://doc.qt.io/qt-6/qsgopaquetexturematerial.html

    **Detailed Description**

    **Warning:** This utility class is only functional when running with the
    default backend of the Qt Quick scenegraph.

    The opaque textured material will fill every pixel in a geometry with the
    supplied texture. The material does not respect the opacity of the
    **QSGMaterialShader::RenderState** , so opacity nodes in the parent chain of
    nodes using this material, have no effect.

    The geometry to be rendered with an opaque texture material requires
    vertices in attribute location 0 and texture coordinates in attribute
    location 1. The texture coordinate is a 2-dimensional floating-point tuple.
    The **QSGGeometry::defaultAttributes_TexturedPoint2D**  returns an attribute
    set compatible with this material.

    The texture to be rendered can be set using **setTexture** (). How the
    texture should be rendered can be specified using **setMipmapFiltering** (),
    **setFiltering** (), **setHorizontalWrapMode** () and
    **setVerticalWrapMode** (). The rendering state is set on the texture
    instance just before it is bound.

    The opaque textured material respects the current matrix and the alpha
    channel of the texture. It will disregard the accumulated opacity in the
    scenegraph.

    A texture material must have a texture set before it is used as a material
    in the scene graph.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#QSGOpaqueTextureMat
        erial

        **QSGOpaqueTextureMaterial::QSGOpaqueTextureMaterial()**

        Creates a new QSGOpaqueTextureMaterial.

        The default mipmap filtering and filtering mode is set to
        **QSGTexture::Nearest** . The default wrap modes is set to
        `QSGTexture::ClampToEdge`.
        """
        ...

    def anisotropyLevel(self) -> PySide6.QtQuick.QSGTexture.AnisotropyLevel:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#anisotropyLevel

        **QSGTexture::AnisotropyLevel
        QSGOpaqueTextureMaterial::anisotropyLevel() const**

        Returns this material's anistropy level.

        **See also** **setAnisotropyLevel** ().
        """
        ...

    def compare(self, other: PySide6.QtQuick.QSGMaterial) -> int:
        ...

    def createShader(
        self, renderMode: PySide6.QtQuick.QSGRendererInterface.RenderMode
    ) -> PySide6.QtQuick.QSGMaterialShader:
        ...

    def filtering(self) -> PySide6.QtQuick.QSGTexture.Filtering:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#filtering

        **QSGTexture::Filtering QSGOpaqueTextureMaterial::filtering() const**

        Returns this material's filtering mode.

        The default filtering is `QSGTexture::Nearest`.

        **See also** **setFiltering** ().
        """
        ...

    def horizontalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#horizontalWrapMode

        **QSGTexture::WrapMode QSGOpaqueTextureMaterial::horizontalWrapMode()
        const**

        Returns this material's horizontal wrap mode.

        The default horizontal wrap mode is `QSGTexture::ClampToEdge`.

        **See also** **setHorizontalWrapMode** ().
        """
        ...

    def mipmapFiltering(self) -> PySide6.QtQuick.QSGTexture.Filtering:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#mipmapFiltering

        **QSGTexture::Filtering QSGOpaqueTextureMaterial::mipmapFiltering()
        const**

        Returns this material's mipmap filtering mode.

        The default mipmap mode is `QSGTexture::Nearest`.

        **See also** **setMipmapFiltering** ().
        """
        ...

    def setAnisotropyLevel(
        self, level: PySide6.QtQuick.QSGTexture.AnisotropyLevel
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#setAnisotropyLevel

        **void
        QSGOpaqueTextureMaterial::setAnisotropyLevel(QSGTexture::AnisotropyLevel
        level )**

        Sets this material's anistropy level to **level**.

        **See also** **anisotropyLevel** ().
        """
        ...

    def setFiltering(self, filteringType: PySide6.QtQuick.QSGTexture.Filtering) -> None:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#setFiltering

        **void QSGOpaqueTextureMaterial::setFiltering(QSGTexture::Filtering
        filtering )**

        Sets the filtering to **filtering**.

        The filtering mode is set on the texture instance just before the
        texture is bound for rendering.

        **See also** **filtering** ().
        """
        ...

    def setHorizontalWrapMode(self, mode: PySide6.QtQuick.QSGTexture.WrapMode) -> None:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#setHorizontalWrapMo
        de

        **void
        QSGOpaqueTextureMaterial::setHorizontalWrapMode(QSGTexture::WrapMode
        mode )**

        Sets the horizontal wrap mode to **mode**.

        The horizontal wrap mode is set on the texture instance just before the
        texture is bound for rendering.

        **See also** **horizontalWrapMode** ().
        """
        ...

    def setMipmapFiltering(
        self, filteringType: PySide6.QtQuick.QSGTexture.Filtering
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#setMipmapFiltering

        **void
        QSGOpaqueTextureMaterial::setMipmapFiltering(QSGTexture::Filtering
        filtering )**

        Sets the mipmap mode to **filtering**.

        The mipmap filtering mode is set on the texture instance just before the
        texture is bound for rendering.

        If the texture does not have mipmapping support, enabling mipmapping has
        no effect.

        **See also** **mipmapFiltering** ().
        """
        ...

    def setTexture(self, texture: PySide6.QtQuick.QSGTexture) -> None:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#setTexture

        **void QSGOpaqueTextureMaterial::setTexture(QSGTexture * texture )**

        Sets the texture of this material to **texture**.

        The material does not take ownership of the texture.

        **See also** **texture** ().
        """
        ...

    def setVerticalWrapMode(self, mode: PySide6.QtQuick.QSGTexture.WrapMode) -> None:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#setVerticalWrapMode

        **void
        QSGOpaqueTextureMaterial::setVerticalWrapMode(QSGTexture::WrapMode mode
        )**

        Sets the vertical wrap mode to **mode**.

        The vertical wrap mode is set on the texture instance just before the
        texture is bound for rendering.

        **See also** **verticalWrapMode** ().
        """
        ...

    def texture(self) -> PySide6.QtQuick.QSGTexture:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#texture

        **QSGTexture *QSGOpaqueTextureMaterial::texture() const**

        Returns this texture material's texture.

        **See also** **setTexture** ().
        """
        ...

    def type(self) -> PySide6.QtQuick.QSGMaterialType:
        ...

    def verticalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode:
        """
        https://doc.qt.io/qt-6/qsgopaquetexturematerial.html#verticalWrapMode

        **QSGTexture::WrapMode QSGOpaqueTextureMaterial::verticalWrapMode()
        const**

        Returns this material's vertical wrap mode.

        The default vertical wrap mode is `QSGTexture::ClampToEdge`.

        **See also** **setVerticalWrapMode** ().
        """
        ...
