"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGOpacityNode(PySide6.QtQuick.QSGNode):
    """
    https://doc.qt.io/qt-6/qsgopacitynode.html

    **Detailed Description**

    Opacity applies to its subtree and can be nested. Multiple opacity nodes
    will be accumulated by multiplying their opacity. The accumulation happens
    as part of the rendering.

    When nested opacity gets below a certain threshold, the subtree might be
    marked as blocked, causing **isSubtreeBlocked** () to return true. This is
    done for performance reasons.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgopacitynode.html#QSGOpacityNode

        **QSGOpacityNode::QSGOpacityNode()**

        Constructs an opacity node with a default opacity of 1.

        Opacity accumulates downwards in the scene graph so a node with two
        QSGOpacityNode instances above it, both with opacity of 0.5, will have
        effective opacity of 0.25.

        The default opacity of nodes is 1.
        """
        ...

    def combinedOpacity(self) -> float:
        ...

    def isSubtreeBlocked(self) -> bool:
        ...

    def opacity(self) -> float:
        """
        https://doc.qt.io/qt-6/qsgopacitynode.html#opacity

        **qreal QSGOpacityNode::opacity() const**

        Returns this opacity node's opacity.

        **See also** **setOpacity** ().
        """
        ...

    def setCombinedOpacity(self, opacity: float) -> None:
        ...

    def setOpacity(self, opacity: float) -> None:
        """
        https://doc.qt.io/qt-6/qsgopacitynode.html#setOpacity

        **void QSGOpacityNode::setOpacity(qreal opacity )**

        Sets the opacity of this node to **opacity**.

        Before rendering the graph, the renderer will do an update pass over the
        subtree to propagate the opacity to its children.

        The value will be bounded to the range 0 to 1.

        **See also** **opacity** ().
        """
        ...
