"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQml, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtQml

bytes = str


class QQmlContext(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qqmlcontext.html

    **Detailed Description**

    Contexts allow data to be exposed to the QML components instantiated by the
    QML engine.

    Each QQmlContext contains a set of properties, distinct from its **QObject**
    properties, that allow data to be explicitly bound to a context by name. The
    context properties are defined and updated by calling
    **QQmlContext::setContextProperty** (). The following example shows a Qt
    model being bound to a context and then accessed from a QML file.

    **QQmlEngine**  engine;
        **QStringListModel**  modelData;
    **QQmlContext**  *context = new **QQmlContext** (engine.rootContext());
    context->setContextProperty("myModel", &modelData);
    **QQmlComponent**  component(&engine);
        component.setData("import QtQuick
    2.0; ListView { model: myModel }", **QUrl** ());
        **QObject**  *window =
    component.create(context);

    **Note:** It is the responsibility of the creator to delete any QQmlContext
    it constructs. If the `context` object in the example is no longer needed
    when the `window` component instance is destroyed, the `context` must be
    destroyed explicitly. The simplest way to ensure this is to set `window` as
    the parent of `context`.

    To simplify binding and maintaining larger data sets, a context object can
    be set on a QQmlContext. All the properties of the context object are
    available by name in the context, as though they were all individually added
    through calls to **QQmlContext::setContextProperty** (). Changes to the
    property's values are detected through the property's notify signal. Setting
    a context object is both faster and easier than manually adding and
    maintaining context property values.

    The following example has the same effect as the previous one, but it uses a
    context object.

    class MyDataSet : public **QObject**  {
            // ...
    Q_PROPERTY(**QAbstractItemModel**  *myModel READ model NOTIFY modelChanged)
    // ...
        };

        MyDataSet myDataSet;
        **QQmlEngine**  engine;
    **QQmlContext**  *context = new **QQmlContext** (engine.rootContext());
    context->setContextObject(&myDataSet);

        **QQmlComponent**
    component(&engine);
        component.setData("import QtQuick 2.0; ListView {
    model: myModel }", **QUrl** ());
        component.create(context);

    All properties added explicitly by **QQmlContext::setContextProperty** ()
    take precedence over the context object's properties.

    **The Context Hierarchy**

    Contexts form a hierarchy. The root of this hierarchy is the QML engine's
    **root context** . Child contexts inherit the context properties of their
    parents; if a child context sets a context property that already exists in
    its parent, the new context property overrides that of the parent.

    The following example defines two contexts - `context1` and `context2`. The
    second context overrides the "b" context property inherited from the first
    with a new value.

    **QQmlEngine**  engine;
        **QQmlContext**  *context1 = new **QQmlContext**
    (engine.rootContext());
        **QQmlContext**  *context2 = new **QQmlContext**
    (context1);

        context1->setContextProperty("a", 9001);
    context1->setContextProperty("b", 9001);
    context2->setContextProperty("b", 42);

    While QML objects instantiated in a context are not strictly owned by that
    context, their bindings are. If a context is destroyed, the property
    bindings of outstanding QML objects will stop evaluating.

    **Warning:** Setting the context object or adding new context properties
    after an object has been created in that context is an expensive operation
    (essentially forcing all bindings to reevaluate). Thus whenever possible you
    should complete "setup" of the context before using it to create any
    objects.

    **See also** **Exposing Attributes of C++ Types to QML** .
    """

    @overload
    def __init__(
        self,
        parent: PySide6.QtQml.QQmlContext,
        objParent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#QQmlContext

        **QQmlContext::QQmlContext(QQmlEngine * engine , QObject * parent =
        nullptr)**

        Create a new QQmlContext as a child of **engine** 's root context, and
        the **QObject**  **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        parent: PySide6.QtQml.QQmlEngine,
        objParent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#QQmlContext-1

        **QQmlContext::QQmlContext(QQmlContext * parentContext , QObject *
        parent = nullptr)**

        Create a new QQmlContext with the given **parentContext** , and the
        **QObject**  **parent**.
        """
        ...

    def baseUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#baseUrl

        **QUrl QQmlContext::baseUrl() const**

        Returns the base url of the component, or the containing component if
        none is set.

        **See also** **setBaseUrl** ().
        """
        ...

    def contextObject(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#contextObject

        **QObject *QQmlContext::contextObject() const**

        Return the context object, or `nullptr` if there is no context object.

        **See also** **setContextObject** ().
        """
        ...

    def contextProperty(self, arg__1: str) -> Any:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#contextProperty

        **QVariant QQmlContext::contextProperty(const QString & name ) const**

        Returns the value of the **name** property for this context as a
        **QVariant** . If you know that the property you're looking for is a
        **QObject**  assigned using a QML id in the current context,
        **objectForName** () is more convenient and faster. In contrast to
        **objectForName** () and **nameForObject** (), this method does traverse
        the context hierarchy and searches in parent contexts if the **name** is
        not found in the current one. It also considers any **contextObject** ()
        you may have set.

        **See also** **setContextProperty** (), **objectForName** (),
        **nameForObject** (), and **contextObject** ().
        """
        ...

    def engine(self) -> PySide6.QtQml.QQmlEngine:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#engine

        **QQmlEngine *QQmlContext::engine() const**

        Return the context's **QQmlEngine** , or `nullptr` if the context has no
        **QQmlEngine**  or the **QQmlEngine**  was destroyed.
        """
        ...

    def importedScript(self, name: str) -> PySide6.QtQml.QJSValue:
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#isValid

        **bool QQmlContext::isValid() const**

        Returns whether the context is valid.

        To be valid, a context must have a engine, and it's **contextObject**
        (), if any, must not have been deleted.
        """
        ...

    def nameForObject(self, arg__1: PySide6.QtCore.QObject) -> str:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#nameForObject

        **QString QQmlContext::nameForObject(const QObject * object ) const**

        Returns the name of **object** in this context, or an empty string if
        **object** is not named in the context. Objects are named by
        **setContextProperty** (), or as properties of a context object, or by
        ids in the case of QML created contexts.

        If the object has multiple names, the first is returned.

        In contrast to **contextProperty** (), this method does not traverse the
        context hierarchy. If the name is not found in the current context, an
        empty String is returned.

        **See also** **contextProperty** () and **objectForName** ().
        """
        ...

    def objectForName(self, arg__1: str) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#objectForName

        **[since 6.2] QObject *QQmlContext::objectForName(const QString & name )
        const**

        Returns the object for a given **name** in this context. Returns nullptr
        if **name** is not available in the context or if the value associated
        with **name** is not a **QObject** . Objects are named by
        **setContextProperty** (), or as properties of a context object, or by
        ids in the case of QML created contexts. In contrast to
        **contextProperty** (), this method does not traverse the context
        hierarchy. If the name is not found in the current context, nullptr is
        returned.

        This function was introduced in Qt 6.2.

        **See also** **contextProperty** () and **nameForObject** ().
        """
        ...

    def parentContext(self) -> PySide6.QtQml.QQmlContext:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#parentContext

        **QQmlContext *QQmlContext::parentContext() const**

        Return the context's parent **QQmlContext** , or `nullptr` if this
        context has no parent or if the parent has been destroyed.
        """
        ...

    def resolvedUrl(
        self, arg__1: Union[PySide6.QtCore.QUrl, str]
    ) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#resolvedUrl

        **QUrl QQmlContext::resolvedUrl(const QUrl & src ) const**

        Resolves the URL **src** relative to the URL of the containing
        component.

        **See also** **QQmlEngine::baseUrl** () and **setBaseUrl** ().
        """
        ...

    def setBaseUrl(self, arg__1: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#setBaseUrl

        **void QQmlContext::setBaseUrl(const QUrl & baseUrl )**

        Explicitly sets the url **resolvedUrl** () will use for relative
        references to **baseUrl**.

        Calling this function will override the url of the containing component
        used by default.

        **See also** **baseUrl** () and **resolvedUrl** ().
        """
        ...

    def setContextObject(self, arg__1: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#setContextObject

        **void QQmlContext::setContextObject(QObject * object )**

        Set the context **object**.

        **See also** **contextObject** ().
        """
        ...

    @overload
    def setContextProperty(self, arg__1: str, arg__2: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#setContextProperty

        **void QQmlContext::setContextProperty(const QString & name , QObject *
        value )**

        Set the **value** of the **name** property on this context.

        **QQmlContext**  does **not** take ownership of **value**.

        **See also** **contextProperty** ().
        """
        ...

    @overload
    def setContextProperty(self, arg__1: str, arg__2: Any) -> None:
        """
        https://doc.qt.io/qt-6/qqmlcontext.html#setContextProperty-1

        **void QQmlContext::setContextProperty(const QString & name , const
        QVariant & value )**

        Set a the **value** of the **name** property on this context.
        """
        ...
