"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPrintSupport, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtPrintSupport

bytes = str


class QPrinter(PySide6.QtGui.QPagedPaintDevice):
    """
    https://doc.qt.io/qt-6/qprinter.html

    **Detailed Description**

    This device represents a series of pages of printed output, and is used in
    almost exactly the same way as other paint devices such as **QWidget**  and
    **QPixmap** . A set of additional functions are provided to manage device-
    specific features, such as orientation and resolution, and to step through
    the pages in a document as it is generated.

    When printing directly to a printer on Windows or macOS, QPrinter uses the
    built-in printer drivers. On X11, QPrinter uses the **Common Unix Printing
    System (CUPS)**  to send PDF output to the printer. As an alternative, the
    **printProgram** () function can be used to specify the command or utility
    to use instead of the system default.

    Note that setting parameters like paper size and resolution on an invalid
    printer is undefined. You can use **QPrinter::isValid** () to verify this
    before changing any parameters.

    QPrinter supports a number of parameters, most of which can be changed by
    the end user through a **print dialog** . In general, QPrinter passes these
    functions onto the underlying **QPrintEngine** .

    The most important parameters are:

    * **setPageLayout** () tells QPrinter which page orientation to use, and
    what size to expect from the printer.
      * **setResolution** () tells
    QPrinter what resolution you wish the printer to provide, in dots per inch
    (DPI).
      * **setFullPage** () tells QPrinter whether you want to deal with
    the full page or just with the part the printer can draw on.
      *
    **setCopyCount** () tells QPrinter how many copies of the document it should
    print.

    Many of these functions can only be called before the actual printing begins
    (i.e., before **QPainter::begin** () is called). This usually makes sense
    because, for example, it's not possible to change the number of copies when
    you are halfway through printing. There are also some settings that the user
    sets (through the printer dialog) and that applications are expected to
    obey. See **QAbstractPrintDialog** 's documentation for more details.

    When **QPainter::begin** () is called, the QPrinter it operates on is
    prepared for a new page, enabling the **QPainter**  to be used immediately
    to paint the first page in a document. Once the first page has been painted,
    **newPage** () can be called to request a new blank page to paint on, or
    **QPainter::end** () can be called to finish printing. The second page and
    all following pages are prepared using a call to **newPage** () before they
    are painted.

    The first page in a document does not need to be preceded by a call to
    **newPage** (). You only need to calling **newPage** () after
    **QPainter::begin** () if you need to insert a blank page at the beginning
    of a printed document. Similarly, calling **newPage** () after the last page
    in a document is painted will result in a trailing blank page appended to
    the end of the printed document.

    If you want to abort the print job, **abort** () will try its best to stop
    printing. It may cancel the entire job or just part of it.

    Since QPrinter can print to any **QPrintEngine**  subclass, it is possible
    to extend printing support to cover new types of printing subsystem by
    subclassing **QPrintEngine**  and reimplementing its interface.

    **See also** **QPrintDialog**  and **Qt Print Support** .
    """

    GrayScale: QPrinter.ColorMode = ...
    Color: QPrinter.ColorMode = ...
    DuplexNone: QPrinter.DuplexMode = ...
    DuplexAuto: QPrinter.DuplexMode = ...
    DuplexLongSide: QPrinter.DuplexMode = ...
    DuplexShortSide: QPrinter.DuplexMode = ...
    NativeFormat: QPrinter.OutputFormat = ...
    PdfFormat: QPrinter.OutputFormat = ...
    FirstPageFirst: QPrinter.PageOrder = ...
    LastPageFirst: QPrinter.PageOrder = ...
    OnlyOne: QPrinter.PaperSource = ...
    Upper: QPrinter.PaperSource = ...
    Lower: QPrinter.PaperSource = ...
    Middle: QPrinter.PaperSource = ...
    Manual: QPrinter.PaperSource = ...
    Envelope: QPrinter.PaperSource = ...
    EnvelopeManual: QPrinter.PaperSource = ...
    Auto: QPrinter.PaperSource = ...
    Tractor: QPrinter.PaperSource = ...
    SmallFormat: QPrinter.PaperSource = ...
    LargeFormat: QPrinter.PaperSource = ...
    LargeCapacity: QPrinter.PaperSource = ...
    Cassette: QPrinter.PaperSource = ...
    FormSource: QPrinter.PaperSource = ...
    MaxPageSource: QPrinter.PaperSource = ...
    CustomSource: QPrinter.PaperSource = ...
    LastPaperSource: QPrinter.PaperSource = ...
    AllPages: QPrinter.PrintRange = ...
    Selection: QPrinter.PrintRange = ...
    PageRange: QPrinter.PrintRange = ...
    CurrentPage: QPrinter.PrintRange = ...
    ScreenResolution: QPrinter.PrinterMode = ...
    PrinterResolution: QPrinter.PrinterMode = ...
    HighResolution: QPrinter.PrinterMode = ...
    Idle: QPrinter.PrinterState = ...
    Active: QPrinter.PrinterState = ...
    Aborted: QPrinter.PrinterState = ...
    Error: QPrinter.PrinterState = ...
    Millimeter: QPrinter.Unit = ...
    Point: QPrinter.Unit = ...
    Inch: QPrinter.Unit = ...
    Pica: QPrinter.Unit = ...
    Didot: QPrinter.Unit = ...
    Cicero: QPrinter.Unit = ...
    DevicePixel: QPrinter.Unit = ...

    class ColorMode(Enum):
        GrayScale: QPrinter.ColorMode = ...
        Color: QPrinter.ColorMode = ...

    class DuplexMode(Enum):
        DuplexNone: QPrinter.DuplexMode = ...
        DuplexAuto: QPrinter.DuplexMode = ...
        DuplexLongSide: QPrinter.DuplexMode = ...
        DuplexShortSide: QPrinter.DuplexMode = ...

    class OutputFormat(Enum):
        NativeFormat: QPrinter.OutputFormat = ...
        PdfFormat: QPrinter.OutputFormat = ...

    class PageOrder(Enum):
        FirstPageFirst: QPrinter.PageOrder = ...
        LastPageFirst: QPrinter.PageOrder = ...

    class PaperSource(Enum):
        OnlyOne: QPrinter.PaperSource = ...
        Upper: QPrinter.PaperSource = ...
        Lower: QPrinter.PaperSource = ...
        Middle: QPrinter.PaperSource = ...
        Manual: QPrinter.PaperSource = ...
        Envelope: QPrinter.PaperSource = ...
        EnvelopeManual: QPrinter.PaperSource = ...
        Auto: QPrinter.PaperSource = ...
        Tractor: QPrinter.PaperSource = ...
        SmallFormat: QPrinter.PaperSource = ...
        LargeFormat: QPrinter.PaperSource = ...
        LargeCapacity: QPrinter.PaperSource = ...
        Cassette: QPrinter.PaperSource = ...
        FormSource: QPrinter.PaperSource = ...
        MaxPageSource: QPrinter.PaperSource = ...
        CustomSource: QPrinter.PaperSource = ...
        LastPaperSource: QPrinter.PaperSource = ...

    class PrintRange(Enum):
        AllPages: QPrinter.PrintRange = ...
        Selection: QPrinter.PrintRange = ...
        PageRange: QPrinter.PrintRange = ...
        CurrentPage: QPrinter.PrintRange = ...

    class PrinterMode(Enum):
        ScreenResolution: QPrinter.PrinterMode = ...
        PrinterResolution: QPrinter.PrinterMode = ...
        HighResolution: QPrinter.PrinterMode = ...

    class PrinterState(Enum):
        Idle: QPrinter.PrinterState = ...
        Active: QPrinter.PrinterState = ...
        Aborted: QPrinter.PrinterState = ...
        Error: QPrinter.PrinterState = ...

    class Unit(Enum):
        Millimeter: QPrinter.Unit = ...
        Point: QPrinter.Unit = ...
        Inch: QPrinter.Unit = ...
        Pica: QPrinter.Unit = ...
        Didot: QPrinter.Unit = ...
        Cicero: QPrinter.Unit = ...
        DevicePixel: QPrinter.Unit = ...

    @overload
    def __init__(self, mode: PySide6.QtPrintSupport.QPrinter.PrinterMode = ...) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#QPrinter

        **QPrinter::QPrinter(QPrinter::PrinterMode mode = ScreenResolution)**

        Creates a new printer object with the given **mode**.
        """
        ...

    @overload
    def __init__(
        self,
        printer: PySide6.QtPrintSupport.QPrinterInfo,
        mode: PySide6.QtPrintSupport.QPrinter.PrinterMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#QPrinter-1

        **QPrinter::QPrinter(const QPrinterInfo & printer ,
        QPrinter::PrinterMode mode = ScreenResolution)**

        Creates a new printer object with the given **printer** and **mode**.
        """
        ...

    def abort(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinter.html#abort

        **bool QPrinter::abort()**

        Aborts the current print run. Returns `true` if the print run was
        successfully aborted and **printerState** () will return
        **QPrinter::Aborted** ; otherwise returns `false`.

        It is not always possible to abort a print job. For example, all the
        data has gone to the printer but the printer cannot or will not cancel
        the job when asked to.
        """
        ...

    def collateCopies(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinter.html#collateCopies

        **bool QPrinter::collateCopies() const**

        Returns `true` if collation is turned on when multiple copies is
        selected. Returns `false` if it is turned off when multiple copies is
        selected. When collating is turned off the printing of each individual
        page will be repeated the numCopies() amount before the next page is
        started. With collating turned on all pages are printed before the next
        copy of those pages is started.

        **See also** **setCollateCopies** ().
        """
        ...

    def colorMode(self) -> PySide6.QtPrintSupport.QPrinter.ColorMode:
        """
        https://doc.qt.io/qt-6/qprinter.html#colorMode

        **QPrinter::ColorMode QPrinter::colorMode() const**

        Returns the current color mode.

        **See also** **setColorMode** ().
        """
        ...

    def copyCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qprinter.html#copyCount

        **int QPrinter::copyCount() const**

        Returns the number of copies that will be printed. The default value is
        1.

        **See also** **setCopyCount** () and **supportsMultipleCopies** ().
        """
        ...

    def creator(self) -> str:
        """
        https://doc.qt.io/qt-6/qprinter.html#creator

        **QString QPrinter::creator() const**

        Returns the name of the application that created the document.

        **See also** **setCreator** ().
        """
        ...

    def devType(self) -> int:
        ...

    def docName(self) -> str:
        """
        https://doc.qt.io/qt-6/qprinter.html#docName

        **QString QPrinter::docName() const**

        Returns the document name.

        **See also** **setDocName** () and
        **QPrintEngine::PrintEnginePropertyKey** .
        """
        ...

    def duplex(self) -> PySide6.QtPrintSupport.QPrinter.DuplexMode:
        """
        https://doc.qt.io/qt-6/qprinter.html#duplex

        **QPrinter::DuplexMode QPrinter::duplex() const**

        Returns the current duplex mode.

        **See also** **setDuplex** ().
        """
        ...

    def fontEmbeddingEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinter.html#fontEmbeddingEnabled

        **bool QPrinter::fontEmbeddingEnabled() const**

        Returns `true` if font embedding is enabled.

        **See also** **setFontEmbeddingEnabled** ().
        """
        ...

    def fromPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qprinter.html#fromPage

        **int QPrinter::fromPage() const**

        Returns the number of the first page in a range of pages to be printed
        (the "from page" setting). Pages in a document are numbered according to
        the convention that the first page is page 1.

        By default, this function returns a special value of 0, meaning that the
        "from page" setting is unset.

        **Note:** If fromPage() and **toPage** () both return 0, this indicates
        that **the whole document will be printed**.

        **See also** **setFromTo** (), **toPage** (), and **pageRanges** ().
        """
        ...

    def fullPage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinter.html#fullPage

        **bool QPrinter::fullPage() const**

        Returns `true` if the origin of the printer's coordinate system is at
        the corner of the page and false if it is at the edge of the printable
        area.

        See **setFullPage** () for details and caveats.

        **See also** **setFullPage** () and **QPagedPaintDevice::pageLayout**
        ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinter.html#isValid

        **bool QPrinter::isValid() const**

        Returns `true` if the printer currently selected is a valid printer in
        the system, or a pure PDF printer; otherwise returns `false`.

        To detect other failures check the output of **QPainter::begin** () or
        **QPrinter::newPage** ().

        **QPrinter**  printer;
                printer.setOutputFormat(**QPrinter**
        ::PdfFormat);
        printer.setOutputFileName("/foobar/nonwritable.pdf");
        **QPainter**  painter;
                if (! painter.begin(&printer)) { //
        failed to open file
                    **qWarning** ("failed to open file, is
        it writable?");
                    return 1;
                }
        painter.drawText(10, 10, "Test");
                if (! printer.newPage()) {
        **qWarning** ("failed in flushing page to disk, disk full?");
        return 1;
                }
                painter.drawText(10, 10, "Test 2");
        painter.end();

        **See also** **setPrinterName** ().
        """
        ...

    def metric(self, arg__1: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int:
        ...

    def newPage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinter.html#newPage

        **[override virtual] bool QPrinter::newPage()**

        Reimplements: **QPagedPaintDevice::newPage** ().

        Tells the printer to eject the current page and to continue printing on
        a new page. Returns `true` if this was successful; otherwise returns
        `false`.

        Calling newPage() on an inactive **QPrinter**  object will always fail.
        """
        ...

    def outputFileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qprinter.html#outputFileName

        **QString QPrinter::outputFileName() const**

        Returns the name of the output file. By default, this is an empty string
        (indicating that the printer shouldn't print to file).

        **See also** **setOutputFileName** () and
        **QPrintEngine::PrintEnginePropertyKey** .
        """
        ...

    def outputFormat(self) -> PySide6.QtPrintSupport.QPrinter.OutputFormat:
        """
        https://doc.qt.io/qt-6/qprinter.html#outputFormat

        **QPrinter::OutputFormat QPrinter::outputFormat() const**

        Returns the output format for this printer.

        **See also** **setOutputFormat** ().
        """
        ...

    def pageOrder(self) -> PySide6.QtPrintSupport.QPrinter.PageOrder:
        """
        https://doc.qt.io/qt-6/qprinter.html#pageOrder

        **QPrinter::PageOrder QPrinter::pageOrder() const**

        Returns the current page order.

        The default page order is `FirstPageFirst`.

        **See also** **setPageOrder** ().
        """
        ...

    def pageRect(
        self, arg__1: PySide6.QtPrintSupport.QPrinter.Unit
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qprinter.html#pageRect

        **QRectF QPrinter::pageRect(QPrinter::Unit unit ) const**

        Returns the page's rectangle in **unit** ; this is usually smaller than
        the **paperRect** () since the page normally has margins between its
        borders and the paper.

        **See also** **QPagedPaintDevice::pageLayout** ().
        """
        ...

    def paintEngine(self) -> PySide6.QtGui.QPaintEngine:
        """
        https://doc.qt.io/qt-6/qprinter.html#paintEngine

        **[override virtual] QPaintEngine *QPrinter::paintEngine() const**

        Reimplements: **QPaintDevice::paintEngine() const** .

        Returns the paint engine used by the printer.
        """
        ...

    def paperRect(
        self, arg__1: PySide6.QtPrintSupport.QPrinter.Unit
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qprinter.html#paperRect

        **QRectF QPrinter::paperRect(QPrinter::Unit unit ) const**

        Returns the paper's rectangle in **unit** ; this is usually larger than
        the **pageRect** ().

        **See also** **pageRect** ().
        """
        ...

    def paperSource(self) -> PySide6.QtPrintSupport.QPrinter.PaperSource:
        """
        https://doc.qt.io/qt-6/qprinter.html#paperSource

        **QPrinter::PaperSource QPrinter::paperSource() const**

        Returns the printer's paper source. This is `Manual` or a printer tray
        or paper cassette.

        **See also** **setPaperSource** ().
        """
        ...

    def pdfVersion(self) -> PySide6.QtGui.QPagedPaintDevice.PdfVersion:
        """
        https://doc.qt.io/qt-6/qprinter.html#pdfVersion

        **[since 5.10] QPagedPaintDevice::PdfVersion QPrinter::pdfVersion()
        const**

        Returns the PDF version for this printer. The default is
        `PdfVersion_1_4`.

        This function was introduced in Qt 5.10.

        **See also** **setPdfVersion** ().
        """
        ...

    def printEngine(self) -> PySide6.QtPrintSupport.QPrintEngine:
        """
        https://doc.qt.io/qt-6/qprinter.html#printEngine

        **QPrintEngine *QPrinter::printEngine() const**

        Returns the print engine used by the printer.
        """
        ...

    def printProgram(self) -> str:
        """
        https://doc.qt.io/qt-6/qprinter.html#printProgram

        **QString QPrinter::printProgram() const**

        Returns the name of the program that sends the print output to the
        printer.

        The default is to return an empty string; meaning that **QPrinter**
        will try to be smart in a system-dependent way. On X11 only, you can set
        it to something different to use a specific print program. On the other
        platforms, this returns an empty string.

        **See also** **setPrintProgram** () and **setPrinterSelectionOption**
        ().
        """
        ...

    def printRange(self) -> PySide6.QtPrintSupport.QPrinter.PrintRange:
        """
        https://doc.qt.io/qt-6/qprinter.html#printRange

        **QPrinter::PrintRange QPrinter::printRange() const**

        Returns the page range of the **QPrinter** . After the print setup
        dialog has been opened, this function returns the value selected by the
        user.

        **See also** **setPrintRange** ().
        """
        ...

    def printerName(self) -> str:
        """
        https://doc.qt.io/qt-6/qprinter.html#printerName

        **QString QPrinter::printerName() const**

        Returns the printer name. This value is initially set to the name of the
        default printer.

        **See also** **setPrinterName** ().
        """
        ...

    def printerState(self) -> PySide6.QtPrintSupport.QPrinter.PrinterState:
        """
        https://doc.qt.io/qt-6/qprinter.html#printerState

        **QPrinter::PrinterState QPrinter::printerState() const**

        Returns the current state of the printer. This may not always be
        accurate (for example if the printer doesn't have the capability of
        reporting its state to the operating system).
        """
        ...

    def resolution(self) -> int:
        """
        https://doc.qt.io/qt-6/qprinter.html#resolution

        **int QPrinter::resolution() const**

        Returns the current assumed resolution of the printer, as set by
        **setResolution** () or by the printer driver.

        **See also** **setResolution** ().
        """
        ...

    def setCollateCopies(self, collate: bool) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setCollateCopies

        **void QPrinter::setCollateCopies(bool collate )**

        Sets the default value for collation checkbox when the print dialog
        appears. If **collate** is true, it will enable
        setCollateCopiesEnabled(). The default value is false. This value will
        be changed by what the user presses in the print dialog.

        **See also** **collateCopies** ().
        """
        ...

    def setColorMode(self, arg__1: PySide6.QtPrintSupport.QPrinter.ColorMode) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setColorMode

        **void QPrinter::setColorMode(QPrinter::ColorMode newColorMode )**

        Sets the printer's color mode to **newColorMode** , which can be either
        `Color` or `GrayScale`.

        **See also** **colorMode** ().
        """
        ...

    def setCopyCount(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setCopyCount

        **void QPrinter::setCopyCount(int count )**

        Sets the number of copies to be printed to **count**.

        The printer driver reads this setting and prints the specified number of
        copies.

        **See also** **copyCount** () and **supportsMultipleCopies** ().
        """
        ...

    def setCreator(self, arg__1: str) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setCreator

        **void QPrinter::setCreator(const QString & creator )**

        Sets the name of the application that created the document to
        **creator**.

        This function is only applicable to the X11 version of Qt. If no creator
        name is specified, the creator will be set to "Qt" followed by some
        version number.

        **See also** **creator** ().
        """
        ...

    def setDocName(self, arg__1: str) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setDocName

        **void QPrinter::setDocName(const QString & name )**

        Sets the document name to **name**.

        On X11, the document name is for example used as the default output
        filename in **QPrintDialog** . Note that the document name does not
        affect the file name if the printer is printing to a file. Use the
        setOutputFile() function for this.

        **See also** **docName** () and **QPrintEngine::PrintEnginePropertyKey**
        .
        """
        ...

    def setDuplex(self, duplex: PySide6.QtPrintSupport.QPrinter.DuplexMode) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setDuplex

        **void QPrinter::setDuplex(QPrinter::DuplexMode duplex )**

        Enables double sided printing based on the **duplex** mode.

        **See also** **duplex** ().
        """
        ...

    def setEngines(
        self,
        printEngine: PySide6.QtPrintSupport.QPrintEngine,
        paintEngine: PySide6.QtGui.QPaintEngine,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setEngines

        **[protected] void QPrinter::setEngines(QPrintEngine * printEngine ,
        QPaintEngine * paintEngine )**

        This function is used by subclasses of **QPrinter**  to specify custom
        print and paint engines ( **printEngine** and **paintEngine** ,
        respectively).

        **QPrinter**  does not take ownership of the engines, so you need to
        manage these engine instances yourself.

        Note that changing the engines will reset the printer state and all its
        properties.

        **See also** **printEngine** (), **paintEngine** (), and
        **setOutputFormat** ().
        """
        ...

    def setFontEmbeddingEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setFontEmbeddingEnabled

        **void QPrinter::setFontEmbeddingEnabled(bool enable )**

        Enabled or disables font embedding depending on **enable**.

        **See also** **fontEmbeddingEnabled** ().
        """
        ...

    def setFromTo(self, fromPage: int, toPage: int) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setFromTo

        **void QPrinter::setFromTo(int from , int to )**

        Sets the range of pages to be printed to cover the pages with numbers
        specified by **from** and **to** , where **from** corresponds to the
        first page in the range and **to** corresponds to the last.

        **Note:** Pages in a document are numbered according to the convention
        that the first page is page 1. However, if **from** and **to** are both
        set to 0, the **whole document will be printed**.

        This function is mostly used to set a default value that the user can
        override in the print dialog when you call setup().

        **See also** **fromPage** (), **toPage** (), and **pageRanges** ().
        """
        ...

    def setFullPage(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setFullPage

        **void QPrinter::setFullPage(bool fp )**

        If **fp** is true, enables support for painting over the entire page;
        otherwise restricts painting to the printable area reported by the
        device.

        By default, full page printing is disabled. In this case, the origin of
        the **QPrinter** 's coordinate system coincides with the top-left corner
        of the printable area.

        If full page printing is enabled, the origin of the **QPrinter** 's
        coordinate system coincides with the top-left corner of the paper
        itself. In this case, the **device metrics**  will report the exact same
        dimensions as indicated by {**QPageSize** }. It may not be possible to
        print on the entire physical page because of the printer's margins, so
        the application must account for the margins itself.

        **See also** **fullPage** (), **QPagedPaintDevice::pageLayout** (), and
        **QPagedPaintDevice::setPageSize** ().
        """
        ...

    def setOutputFileName(self, arg__1: str) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setOutputFileName

        **void QPrinter::setOutputFileName(const QString & fileName )**

        Sets the name of the output file to **fileName**.

        Setting a null or empty name (0 or "") disables printing to a file.
        Setting a non-empty name enables printing to a file.

        This can change the value of **outputFormat** (). If the file name has
        the ".pdf" suffix PDF is generated. If the file name has a suffix other
        than ".pdf", the output format used is the one set with
        **setOutputFormat** ().

        **QPrinter**  uses Qt's cross-platform PDF print engines respectively.
        If you can produce this format natively, for example macOS can generate
        PDF's from its print engine, set the output format back to
        **NativeFormat** .

        **See also** **outputFileName** () and **setOutputFormat** ().
        """
        ...

    def setOutputFormat(
        self, format: PySide6.QtPrintSupport.QPrinter.OutputFormat
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setOutputFormat

        **void QPrinter::setOutputFormat(QPrinter::OutputFormat format )**

        Sets the output format for this printer to **format**.

        If **format** is the same value as currently set then no change will be
        made.

        If **format** is **NativeFormat**  then the **printerName**  will be set
        to the default printer. If there are no valid printers configured then
        no change will be made. If you want to set **NativeFormat**  with a
        specific **printerName**  then use **setPrinterName** ().

        **See also** **outputFormat** () and **setPrinterName** ().
        """
        ...

    def setPageOrder(self, arg__1: PySide6.QtPrintSupport.QPrinter.PageOrder) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setPageOrder

        **void QPrinter::setPageOrder(QPrinter::PageOrder pageOrder )**

        Sets the page order to **pageOrder**.

        The page order can be **QPrinter::FirstPageFirst**  or
        **QPrinter::LastPageFirst** . The application is responsible for reading
        the page order and printing accordingly.

        This function is mostly useful for setting a default value that the user
        can override in the print dialog.

        This function is only supported under X11.

        **See also** **pageOrder** ().
        """
        ...

    def setPageSize(
        self,
        arg__1: Union[
            PySide6.QtGui.QPageSize,
            PySide6.QtGui.QPageSize.PageSizeId,
            PySide6.QtCore.QSize,
        ],
    ) -> bool:
        ...

    def setPaperSource(
        self, arg__1: PySide6.QtPrintSupport.QPrinter.PaperSource
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setPaperSource

        **void QPrinter::setPaperSource(QPrinter::PaperSource source )**

        Sets the paper source setting to **source**.

        Windows only: This option can be changed while printing and will take
        effect from the next call to **newPage** ()

        **See also** **paperSource** ().
        """
        ...

    def setPdfVersion(
        self, version: PySide6.QtGui.QPagedPaintDevice.PdfVersion
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setPdfVersion

        **[since 5.10] void
        QPrinter::setPdfVersion(QPagedPaintDevice::PdfVersion version )**

        Sets the PDF version for this printer to **version**.

        If **version** is the same value as currently set then no change will be
        made.

        This function was introduced in Qt 5.10.

        **See also** **pdfVersion** ().
        """
        ...

    def setPrintProgram(self, arg__1: str) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setPrintProgram

        **void QPrinter::setPrintProgram(const QString & printProg )**

        Sets the name of the program that should do the print job to
        **printProg**.

        On X11, this function sets the program to call with the PDF output. On
        other platforms, it has no effect.

        **See also** **printProgram** ().
        """
        ...

    def setPrintRange(self, range: PySide6.QtPrintSupport.QPrinter.PrintRange) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setPrintRange

        **void QPrinter::setPrintRange(QPrinter::PrintRange range )**

        Sets the print range option in to be **range**.

        **See also** **printRange** ().
        """
        ...

    def setPrinterName(self, arg__1: str) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setPrinterName

        **void QPrinter::setPrinterName(const QString & name )**

        Sets the printer name to **name**.

        If the **name** is empty then the output format will be set to
        **PdfFormat** .

        If the **name** is not a valid printer then no change will be made.

        If the **name** is a valid printer then the output format will be set to
        **NativeFormat** .

        **See also** **printerName** (), **isValid** (), and **setOutputFormat**
        ().
        """
        ...

    def setResolution(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qprinter.html#setResolution

        **void QPrinter::setResolution(int dpi )**

        Requests that the printer prints at **dpi** or as near to **dpi** as
        possible.

        This setting affects the coordinate system as returned by, for example
        **QPainter::viewport** ().

        This function must be called before **QPainter::begin** () to have an
        effect on all platforms.

        **See also** **resolution** () and **QPagedPaintDevice::setPageSize**
        ().
        """
        ...

    def supportedPaperSources(
        self,
    ) -> List[PySide6.QtPrintSupport.QPrinter.PaperSource]:
        """
        https://doc.qt.io/qt-6/qprinter.html#supportedPaperSources

        **QList<QPrinter::PaperSource> QPrinter::supportedPaperSources() const**

        Returns the supported paper sizes for this printer.

        The values will be either a value that matches an entry in the
        **QPrinter::PaperSource**  enum or a driver spesific value. The driver
        spesific values are greater than the constant DMBIN_USER declared in
        wingdi.h.

        **Warning:** This function is only available in windows.
        """
        ...

    def supportedResolutions(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qprinter.html#supportedResolutions

        **QList<int> QPrinter::supportedResolutions() const**

        Returns a list of the resolutions (a list of dots-per-inch integers)
        that the printer says it supports.

        For X11 where all printing is directly to PDF, this function will always
        return a one item list containing only the PDF resolution, i.e., 72 (72
        dpi -- but see **PrinterMode** ).
        """
        ...

    def supportsMultipleCopies(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinter.html#supportsMultipleCopies

        **bool QPrinter::supportsMultipleCopies() const**

        Returns `true` if the printer supports printing multiple copies of the
        same document in one job; otherwise false is returned.

        On most systems this function will return true. However, on X11 systems
        that do not support CUPS, this function will return false. That means
        the application has to handle the number of copies by printing the same
        document the required number of times.

        **See also** **setCopyCount** () and **copyCount** ().
        """
        ...

    def toPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qprinter.html#toPage

        **int QPrinter::toPage() const**

        Returns the number of the last page in a range of pages to be printed
        (the "to page" setting). Pages in a document are numbered according to
        the convention that the first page is page 1.

        By default, this function returns a special value of 0, meaning that the
        "to page" setting is unset.

        **Note:** If **fromPage** () and toPage() both return 0, this indicates
        that **the whole document will be printed**.

        The programmer is responsible for reading this setting and printing
        accordingly.

        **See also** **setFromTo** (), **fromPage** (), and **pageRanges** ().
        """
        ...
