"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPositioning, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Union, overload
import PySide6.QtCore
import PySide6.QtPositioning

bytes = str


class QGeoAreaMonitorSource(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qgeoareamonitorsource.html

    **Detailed Description**

    A QGeoAreaMonitorSource emits signals when the current position is in range,
    or has moved out of range, of a specified area. Each area is specified by a
    **QGeoAreaMonitorInfo**  object. For example:

    public:
            MyClass() : **QObject** ()
            {
    **QGeoAreaMonitorSource**  *monitor = **QGeoAreaMonitorSource**
    ::createDefaultSource(this);
                if (monitor) {
    connect(monitor, SIGNAL(areaEntered(**QGeoAreaMonitorInfo**
    ,**QGeoPositionInfo** )),
                            this,
    SLOT(areaEntered(**QGeoAreaMonitorInfo** ,**QGeoPositionInfo** )));
    connect(monitor, SIGNAL(areaExited(**QGeoAreaMonitorInfo**
    ,**QGeoPositionInfo** )),
                            this,
    SLOT(areaExited(**QGeoAreaMonitorInfo** ,**QGeoPositionInfo** )));
    **QGeoAreaMonitorInfo**  bigBen("Big Ben");
    **QGeoCoordinate**  position(51.50104, -0.124632);
    bigBen.setArea(**QGeoCircle** (position, 100));
    monitor->startMonitoring(bigBen);

                } else {
    **qDebug** () << "Could not create default area monitor";
                }
    }

        public Q_SLOTS:
            void areaEntered(const
    **QGeoAreaMonitorInfo**  &mon, const **QGeoPositionInfo**  &update)
    {
                Q_UNUSED(mon);

                **qDebug** () << "Now within
    100 meters, current position is" << update.coordinate();
            }
    void areaExited(const **QGeoAreaMonitorInfo**  &mon, const
    **QGeoPositionInfo**  &update)
            {
                Q_UNUSED(mon);
    **qDebug** () << "No longer within 100 meters, current position is" <<
    update.coordinate();
            }

    `QGeoAreaMonitorSource` follows a singleton pattern. Each instance of the
    class with the same **sourceName** () shares the same area monitoring
    backend. If a new **QGeoAreaMonitorInfo**  object is added via
    **startMonitoring** () or **requestUpdate** () it can be retrieved by
    another instance of this class (provided that they are sourced from the same
    area monitor provider plug-in). The same singleton pattern applies to the
    **QGeoPositionInfoSource**  instance used by this class. The following code
    snippet emphasizes the behavior:

    **QGeoAreaMonitorSource**  *s1 = **QGeoAreaMonitorSource**
    ::createSource("blah", this);
        **QGeoAreaMonitorSource**  *s2 =
    **QGeoAreaMonitorSource** ::createSource("blah", this);
    QVERIFY(s1->positionInfoSource() == s2->positionInfoSource);
    """

    AnyAreaMonitorFeature: QGeoAreaMonitorSource.AreaMonitorFeature = ...
    PersistentAreaMonitorFeature: QGeoAreaMonitorSource.AreaMonitorFeature = ...
    AccessError: QGeoAreaMonitorSource.Error = ...
    InsufficientPositionInfo: QGeoAreaMonitorSource.Error = ...
    UnknownSourceError: QGeoAreaMonitorSource.Error = ...
    NoError: QGeoAreaMonitorSource.Error = ...

    class AreaMonitorFeature(Enum):
        AnyAreaMonitorFeature: QGeoAreaMonitorSource.AreaMonitorFeature = ...
        PersistentAreaMonitorFeature: QGeoAreaMonitorSource.AreaMonitorFeature = ...

    class AreaMonitorFeatures(object):
        ...

    class Error(Enum):
        AccessError: QGeoAreaMonitorSource.Error = ...
        InsufficientPositionInfo: QGeoAreaMonitorSource.Error = ...
        UnknownSourceError: QGeoAreaMonitorSource.Error = ...
        NoError: QGeoAreaMonitorSource.Error = ...

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#QGeoAreaMonitorSource

        **QGeoAreaMonitorSource::QGeoAreaMonitorSource(QObject * parent )**

        Creates a monitor source with the given **parent**.
        """
        ...

    @overload
    def activeMonitors(self) -> List[PySide6.QtPositioning.QGeoAreaMonitorInfo]:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#activeMonitors

        **[pure virtual] QList<QGeoAreaMonitorInfo>
        QGeoAreaMonitorSource::activeMonitors() const**

        Returns the list of all active monitors known to the
        **QGeoAreaMonitorSource**  object.

        An active monitor was started via **startMonitoring** (). For every
        active monitor the source object will emit the required signals, such as
        **areaEntered** () or **areaExited** (). Multiple
        **QGeoAreaMonitorSource**  instances within the same application share
        the same active monitor objects.

        Unless an active **QGeoAreaMonitorInfo**  **isPersistent** () an active
        **QGeoAreaMonitorInfo**  will be stopped once the current application
        terminates.
        """
        ...

    @overload
    def activeMonitors(
        self, lookupArea: PySide6.QtPositioning.QGeoShape
    ) -> List[PySide6.QtPositioning.QGeoAreaMonitorInfo]:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#activeMonitors-1

        **[pure virtual] QList<QGeoAreaMonitorInfo>
        QGeoAreaMonitorSource::activeMonitors(const QGeoShape & lookupArea )
        const**

        Returns the list of all active monitors known to the
        **QGeoAreaMonitorSource**  object whose center lies within
        **lookupArea**. If **lookupArea** is empty the returned list will be
        empty.

        An active monitor was started via **startMonitoring** (). For every
        active monitor the source object will emit the required signals, such as
        **areaEntered** () or **areaExited** (). Multiple
        **QGeoAreaMonitorSource**  instances within the same application share
        the same active monitor objects.

        Unless an active **QGeoAreaMonitorInfo**  **isPersistent** () an active
        **QGeoAreaMonitorInfo**  will be stopped once the current application
        terminates.

        **See also** **QGeoShape** .
        """
        ...

    @staticmethod
    def availableSources() -> List[str]:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#availableSources

        **[static] QStringList QGeoAreaMonitorSource::availableSources()**

        Returns a list of available monitor plugins, including the default
        system backend if one is available.
        """
        ...

    def backendProperty(self, name: str) -> Any:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#backendProperty

        **[virtual, since 6.2] QVariant
        QGeoAreaMonitorSource::backendProperty(const QString & name ) const**

        Returns the value of the backend-specific property named **name** , if
        present. Otherwise the returned value will be invalid.

        This function was introduced in Qt 6.2.

        **See also** **setBackendProperty** ().
        """
        ...

    @staticmethod
    def createDefaultSource(
        parent: PySide6.QtCore.QObject,
    ) -> PySide6.QtPositioning.QGeoAreaMonitorSource:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#createDefaultSource

        **[static] QGeoAreaMonitorSource
        *QGeoAreaMonitorSource::createDefaultSource(QObject * parent )**

        Creates and returns a monitor source with the given **parent** that
        monitors areas using resources on the underlying system.

        Returns `nullptr` if the system has no support for position monitoring.
        """
        ...

    @staticmethod
    def createSource(
        sourceName: str, parent: PySide6.QtCore.QObject
    ) -> PySide6.QtPositioning.QGeoAreaMonitorSource:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#createSource

        **[static] QGeoAreaMonitorSource
        *QGeoAreaMonitorSource::createSource(const QString & sourceName ,
        QObject * parent )**

        Creates and returns a monitor source with the given **parent** , by
        loading the plugin named **sourceName**.

        Returns `nullptr` if the plugin cannot be found.
        """
        ...

    def error(self) -> PySide6.QtPositioning.QGeoAreaMonitorSource.Error:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#error

        **[pure virtual] QGeoAreaMonitorSource::Error
        QGeoAreaMonitorSource::error() const**

        Returns the type of error that last occurred.

        **Note:** Since Qt6 the last error is always reset when calling
        **startMonitoring** () or **requestUpdate** ().
        """
        ...

    def positionInfoSource(self) -> PySide6.QtPositioning.QGeoPositionInfoSource:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#positionInfoSource

        **[virtual] QGeoPositionInfoSource
        *QGeoAreaMonitorSource::positionInfoSource() const**

        Returns the current **QGeoPositionInfoSource**  used by this
        **QGeoAreaMonitorSource**  object. The function will return
        **QGeoPositionInfoSource::createDefaultSource** () if no other object
        has been set.

        The function returns `nullptr` if not even a default
        **QGeoPositionInfoSource**  exists.

        Any usage of the returned **QGeoPositionInfoSource**  instance should
        account for the fact that it may reside in a different thread.

        **See also** **QGeoPositionInfoSource**  and **setPositionInfoSource**
        ().
        """
        ...

    def requestUpdate(
        self,
        monitor: Union[PySide6.QtPositioning.QGeoAreaMonitorInfo, str],
        signal: bytes,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#requestUpdate

        **[pure virtual] bool QGeoAreaMonitorSource::requestUpdate(const
        QGeoAreaMonitorInfo & monitor , const char * signal )**

        Enables single shot area monitoring. Area monitoring for **monitor**
        will be performed until this **QGeoAreaMonitorSource**  instance emits
        **signal** for the first time. Once the signal was emitted, **monitor**
        is automatically removed from the list of **activeMonitors** (). If
        **monitor** is invalid or has an expiry date that has been passed, this
        function returns `false`.

        QGeoAreaMonitor singleShotMonitor;
            **QGeoAreaMonitorSource**  *
        source = **QGeoAreaMonitorSource** ::createDefaultSource(this);
        //...
            bool ret = source->requestUpdate(singleShotMonitor,
        SIGNAL(areaExited(QGeoAreaMonitor,**QGeoPositionInfo** )));

        The above `singleShotMonitor` object will cease to send updates once the
        **areaExited** () signal was emitted for the first time. Until this
        point in time any other signal may be emitted zero or more times
        depending on the area context.

        It is not possible to simultanously request updates for more than one
        signal of the same monitor object. The last call to this function
        determines the signal upon which the updates cease to continue. At this
        stage only the **areaEntered** () and **areaExited** () signals can be
        used to terminate the monitoring process.

        Requesting persistent monitoring on a **QGeoAreaMonitorSource**
        instance fails if the area monitoring backend doesn't support
        **QGeoAreaMonitorSource::PersistentAreaMonitorFeature** .

        If **monitor** was already registered via **startMonitoring** () it is
        converted to a single shot behavior.

        **Note:** Since Qt6 this method always resets the last error to
        **NoError**  before starting monitoring.

        **See also** **startMonitoring** () and **stopMonitoring** ().
        """
        ...

    def setBackendProperty(self, name: str, value: Any) -> bool:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#setBackendProperty

        **[virtual, since 6.2] bool
        QGeoAreaMonitorSource::setBackendProperty(const QString & name , const
        QVariant & value )**

        Sets the backend-specific property named **name** to **value**. Returns
        `true` on success, otherwise returns `false`. Backend-specific
        properties can be used to configure the area monitoring subsystem
        behavior at runtime.

        This function was introduced in Qt 6.2.

        **See also** **backendProperty** ().
        """
        ...

    def setPositionInfoSource(
        self, source: PySide6.QtPositioning.QGeoPositionInfoSource
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#setPositionInfoSource

        **[virtual] void
        QGeoAreaMonitorSource::setPositionInfoSource(QGeoPositionInfoSource *
        newSource )**

        Sets the new **QGeoPositionInfoSource**  to be used by this
        **QGeoAreaMonitorSource**  object. The area monitoring backend becomes
        the new **QObject**  parent for **newSource**. The previous
        **QGeoPositionInfoSource**  object will be deleted. All
        **QGeoAreaMonitorSource**  instances based on the same **sourceName** ()
        share the same **QGeoPositionInfoSource**  instance.

        This may be useful when it is desirable to manipulate the positioning
        system used by the area monitoring engine.

        Note that ownership must be taken care of by subclasses of
        **QGeoAreaMonitorSource** . Due to the singleton pattern behind this
        class **newSource** may be moved to a new thread.

        **See also** **positionInfoSource** ().
        """
        ...

    def sourceName(self) -> str:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#sourceName

        **QString QGeoAreaMonitorSource::sourceName() const**

        Returns the unique name of the area monitor source implementation in
        use.

        This is the same name that can be passed to **createSource** () in order
        to create a new instance of a particular area monitor source
        implementation.
        """
        ...

    def startMonitoring(
        self, monitor: Union[PySide6.QtPositioning.QGeoAreaMonitorInfo, str]
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#startMonitoring

        **[pure virtual] bool QGeoAreaMonitorSource::startMonitoring(const
        QGeoAreaMonitorInfo & monitor )**

        Returns `true` if the monitoring of **monitor** could be successfully
        started; otherwise returns `false`. A reason for not being able to start
        monitoring could be the unavailability of an appropriate default
        position info source while no alternative **QGeoPositionInfoSource**
        has been set via **setPositionInfoSource** ().

        If **monitor** is already active, the existing monitor object will be
        replaced by the new **monitor** reference. The identification of
        **QGeoAreaMonitorInfo**  instances happens via
        **QGeoAreaMonitorInfo::identifier** (). Therefore this function can also
        be used to update active monitors.

        If **monitor** has an expiry date that has been passed this function
        returns false. Calling this function for an already via
        **requestUpdate** () registered single shot monitor switches the monitor
        to a permanent monitoring mode.

        Requesting persistent monitoring on a **QGeoAreaMonitorSource**
        instance fails if the area monitoring backend doesn't support
        **QGeoAreaMonitorSource::PersistentAreaMonitorFeature** .

        **Note:** Since Qt6 this method always resets the last error to
        **NoError**  before starting monitoring.

        **See also** **stopMonitoring** ().
        """
        ...

    def stopMonitoring(
        self, monitor: Union[PySide6.QtPositioning.QGeoAreaMonitorInfo, str]
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#stopMonitoring

        **[pure virtual] bool QGeoAreaMonitorSource::stopMonitoring(const
        QGeoAreaMonitorInfo & monitor )**

        Returns true if **monitor** was successfully removed from the list of
        **activeMonitors** (); otherwise returns false. This behavior is
        independent on whether **monitor** was registered via
        **startMonitoring** () or **requestUpdate** ().
        """
        ...

    def supportedAreaMonitorFeatures(
        self,
    ) -> PySide6.QtPositioning.QGeoAreaMonitorSource.AreaMonitorFeatures:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#supportedAreaMonitorFe
        atures

        **[pure virtual] QGeoAreaMonitorSource::AreaMonitorFeatures
        QGeoAreaMonitorSource::supportedAreaMonitorFeatures() const**

        Returns the area monitoring features available to this source.
        """
        ...

    @property
    def areaEntered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#areaEntered

        **[signal] void QGeoAreaMonitorSource::areaEntered(const
        QGeoAreaMonitorInfo & monitor , const QGeoPositionInfo & update )**

        Emitted when the current position has moved from a position outside of
        the active **monitor** to a position within the monitored area.

        The **update** holds the new position.
        """
        ...

    @property
    def areaExited(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#areaExited

        **[signal] void QGeoAreaMonitorSource::areaExited(const
        QGeoAreaMonitorInfo & monitor , const QGeoPositionInfo & update )**

        Emitted when the current position has moved from a position within the
        active **monitor** to a position outside the monitored area.

        The **update** holds the new position.
        """
        ...

    @property
    def errorOccurred(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#errorOccurred

        **[signal] void
        QGeoAreaMonitorSource::errorOccurred(QGeoAreaMonitorSource::Error
        areaMonitoringError )**

        This signal is emitted after an error occurred. The
        **areaMonitoringError** parameter describes the type of error that
        occurred.
        """
        ...

    @property
    def monitorExpired(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgeoareamonitorsource.html#monitorExpired

        **[signal] void QGeoAreaMonitorSource::monitorExpired(const
        QGeoAreaMonitorInfo & monitor )**

        Emitted when **monitor** has expired. An expired area monitor is
        automatically removed from the list of **activeMonitors** ().

        **See also** **activeMonitors** ().
        """
        ...
