"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtOpenGL, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL

bytes = str


class QOpenGLFramebufferObjectFormat(object):
    """
    https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html

    **Detailed Description**

    A framebuffer object has several characteristics:

    * **Number of samples per pixels.**
      * **Depth and/or stencil
    attachments.**
      * **Texture target.**
      * **Internal texture format.**

    Note that the desired attachments or number of samples per pixels might not
    be supported by the hardware driver. Call
    **QOpenGLFramebufferObject::format** () after creating a
    **QOpenGLFramebufferObject**  to find the exact format that was used to
    create the frame buffer object.

    **See also** **QOpenGLFramebufferObject** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#QOpenGLFrameb
        ufferObjectFormat

        **QOpenGLFramebufferObjectFormat::QOpenGLFramebufferObjectFormat()**

        Creates a QOpenGLFramebufferObjectFormat object for specifying the
        format of an OpenGL framebuffer object.

        By default the format specifies a non-multisample framebuffer object
        with no depth/stencil attachments, texture target `GL_TEXTURE_2D`, and
        internal format `GL_RGBA8`. On OpenGL/ES systems, the default internal
        format is `GL_RGBA`.

        **See also** **samples** (), **attachment** (), and
        **internalTextureFormat** ().
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtOpenGL.QOpenGLFramebufferObjectFormat) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#QOpenGLFrameb
        ufferObjectFormat-1

        **QOpenGLFramebufferObjectFormat::QOpenGLFramebufferObjectFormat(const
        QOpenGLFramebufferObjectFormat & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def attachment(self) -> PySide6.QtOpenGL.QOpenGLFramebufferObject.Attachment:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#attachment

        **QOpenGLFramebufferObject::Attachment
        QOpenGLFramebufferObjectFormat::attachment() const**

        Returns the configuration of the depth and stencil buffers attached to a
        framebuffer object. The default is
        **QOpenGLFramebufferObject::NoAttachment** .

        **See also** **setAttachment** ().
        """
        ...

    def internalTextureFormat(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#internalTextu
        reFormat

        **GLenum QOpenGLFramebufferObjectFormat::internalTextureFormat() const**

        Returns the internal format of a framebuffer object's texture or
        multisample framebuffer object's color buffer. The default is `GL_RGBA8`
        on desktop OpenGL systems, and `GL_RGBA` on OpenGL/ES systems.

        **See also** **setInternalTextureFormat** ().
        """
        ...

    def mipmap(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#mipmap

        **bool QOpenGLFramebufferObjectFormat::mipmap() const**

        Returns `true` if mipmapping is enabled.

        **See also** **setMipmap** ().
        """
        ...

    def samples(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#samples

        **int QOpenGLFramebufferObjectFormat::samples() const**

        Returns the number of samples per pixel if a framebuffer object is a
        multisample framebuffer object. Otherwise, returns 0. The default value
        is 0.

        **See also** **setSamples** ().
        """
        ...

    def setAttachment(
        self, attachment: PySide6.QtOpenGL.QOpenGLFramebufferObject.Attachment
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#setAttachment

        **void QOpenGLFramebufferObjectFormat::setAttachment(QOpenGLFramebufferO
        bject::Attachment attachment )**

        Sets the attachment configuration of a framebuffer object to
        **attachment**.

        **See also** **attachment** ().
        """
        ...

    def setInternalTextureFormat(self, internalTextureFormat: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#setInternalTe
        xtureFormat

        **void QOpenGLFramebufferObjectFormat::setInternalTextureFormat(GLenum
        internalTextureFormat )**

        Sets the internal format of a framebuffer object's texture or
        multisample framebuffer object's color buffer to
        **internalTextureFormat**.

        **See also** **internalTextureFormat** ().
        """
        ...

    def setMipmap(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#setMipmap

        **void QOpenGLFramebufferObjectFormat::setMipmap(bool enabled )**

        Enables mipmapping if **enabled** is true; otherwise disables it.

        Mipmapping is disabled by default.

        If mipmapping is enabled, additional memory will be allocated for the
        mipmap levels. The mipmap levels can be updated by binding the texture
        and calling glGenerateMipmap(). Mipmapping cannot be enabled for
        multisampled framebuffer objects.

        **See also** **mipmap** () and **QOpenGLFramebufferObject::texture** ().
        """
        ...

    def setSamples(self, samples: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#setSamples

        **void QOpenGLFramebufferObjectFormat::setSamples(int samples )**

        Sets the number of samples per pixel for a multisample framebuffer
        object to **samples**. The default sample count of 0 represents a
        regular non-multisample framebuffer object.

        If the desired amount of samples per pixel is not supported by the
        hardware then the maximum number of samples per pixel will be used. Note
        that multisample framebuffer objects cannot be bound as textures. Also,
        the `GL_EXT_framebuffer_multisample` extension is required to create a
        framebuffer with more than one sample per pixel.

        **See also** **samples** ().
        """
        ...

    def setTextureTarget(self, target: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#setTextureTar
        get

        **void QOpenGLFramebufferObjectFormat::setTextureTarget(GLenum target
        )**

        Sets the texture target of the texture attached to a framebuffer object
        to **target**. Ignored for multisample framebuffer objects.

        **See also** **textureTarget** () and **samples** ().
        """
        ...

    def textureTarget(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobjectformat.html#textureTarget

        **GLenum QOpenGLFramebufferObjectFormat::textureTarget() const**

        Returns the texture target of the texture attached to a framebuffer
        object. Ignored for multisample framebuffer objects. The default is
        `GL_TEXTURE_2D`.

        **See also** **setTextureTarget** () and **samples** ().
        """
        ...
