"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetworkAuth, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, Optional, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtNetworkAuth

bytes = str


class QOAuth1(PySide6.QtNetworkAuth.QAbstractOAuth):
    """
    https://doc.qt.io/qt-6/qoauth1.html

    **Detailed Description**

    QOAuth1 provides a method for clients to access server resources on behalf
    of a resource owner (such as a different client or an end-user). It also
    provides a process for end-users to authorize third-party access to their
    server resources without sharing their credentials (typically, a username
    and password pair), using user-agent redirections.

    QOAuth1 uses tokens to represent the authorization granted to the client by
    the resource owner. Typically, token credentials are issued by the server at
    the resource owner's request, after authenticating the resource owner's
    identity (usually using a username and password).

    When making the temporary credentials request, the client authenticates
    using only the client credentials. When making the token request, the client
    authenticates using the client credentials as well as the temporary
    credentials. Once the client receives and stores the token credentials, it
    can proceed to access protected resources on behalf of the resource owner by
    making authenticated requests using the client credentials together with the
    token credentials received.
    """

    class SignatureMethod(Enum):
        Hmac_Sha1: QOAuth1.SignatureMethod = ...
        Rsa_Sha1: QOAuth1.SignatureMethod = ...
        PlainText: QOAuth1.SignatureMethod = ...

    @overload
    def __init__(
        self,
        clientIdentifier: str,
        clientSharedSecret: str,
        manager: PySide6.QtNetwork.QNetworkAccessManager,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#QOAuth1

        **QOAuth1::QOAuth1(QObject * parent = nullptr)**

        Constructs a QOAuth1 object with parent object **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        manager: PySide6.QtNetwork.QNetworkAccessManager,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#QOAuth1-1

        **QOAuth1::QOAuth1(QNetworkAccessManager * manager , QObject * parent =
        nullptr)**

        Constructs a QOAuth1 object with parent object **parent** , using
        **manager** to access the network.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#QOAuth1-2

        **QOAuth1::QOAuth1(const QString & clientIdentifier , const QString &
        clientSharedSecret , QNetworkAccessManager * manager , QObject * parent
        = nullptr)**

        Constructs a QOAuth1 object with parent object **parent** , using
        **manager** to access the network. Also sets **clientIdentifier** and
        **clientSharedSecret** to sign the calls to the web server and identify
        the application.
        """
        ...

    def clientCredentials(self) -> Tuple[str, str]:
        """
        https://doc.qt.io/qt-6/qoauth1.html#clientCredentials

        **QPair<QString, QString> QOAuth1::clientCredentials() const**

        Returns the pair of **QString**  used to identify the application and
        sign requests to the web server.

        **See also** **setClientCredentials** ().
        """
        ...

    def clientSharedSecret(self) -> str:
        """
        https://doc.qt.io/qt-6/qoauth1.html#clientSharedSecret

        **QString QOAuth1::clientSharedSecret() const**

        Returns the current shared secret used to sign requests to the web
        server.

        **See also** **setClientSharedSecret** () and **clientCredentials** ().
        """
        ...

    def continueGrantWithVerifier(self, verifier: str) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#continueGrantWithVerifier

        **[slot] void QOAuth1::continueGrantWithVerifier(const QString &
        verifier )**

        Continues the Redirection-Based Authorization flow using **verifier**.
        Call this function when using an Out-of-band reply handler to supply the
        verifier provided by the web server.
        """
        ...

    def deleteResource(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qoauth1.html#deleteResource

        **[override virtual] QNetworkReply *QOAuth1::deleteResource(const QUrl &
        url , const QVariantMap & parameters = QVariantMap())**

        Reimplements: **QAbstractOAuth::deleteResource** (const QUrl &url, const
        QVariantMap &parameters).

        Sends an authenticated DELETE request and returns a new
        **QNetworkReply** . The **url** and **parameters** are used to create
        the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: DELETE**
        """
        ...

    @staticmethod
    def generateAuthorizationHeader(
        oauthParams: Dict[str, Any]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qoauth1.html#generateAuthorizationHeader

        **[static protected] QByteArray
        QOAuth1::generateAuthorizationHeader(const QVariantMap & oauthParams )**

        Generates an authorization header using **oauthParams**.

        **See also**  : **The OAuth 1.0 Protocol: Authorization Header**
        """
        ...

    def get(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qoauth1.html#get

        **[override virtual] QNetworkReply *QOAuth1::get(const QUrl & url ,
        const QVariantMap & parameters = QVariantMap())**

        Reimplements: **QAbstractOAuth::get** (const QUrl &url, const
        QVariantMap &parameters).

        Sends an authenticated GET request and returns a new **QNetworkReply** .
        The **url** and **parameters** are used to create the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: GET**
        """
        ...

    def grant(self) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#grant

        **[override virtual slot] void QOAuth1::grant()**

        Reimplements: **QAbstractOAuth::grant** ().

        Starts the Redirection-Based Authorization flow.

        **Note:** For an out-of-band reply handler, a verifier string is
        received after the call to this function; pass that to
        **continueGrantWithVerifier** () to continue the grant process.

        **See also**  : **The OAuth 1.0 Protocol: Redirection-Based
        Authorization**

        **See also** **continueGrantWithVerifier** ().
        """
        ...

    def head(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qoauth1.html#head

        **[override virtual] QNetworkReply *QOAuth1::head(const QUrl & url ,
        const QVariantMap & parameters = QVariantMap())**

        Reimplements: **QAbstractOAuth::head** (const QUrl &url, const
        QVariantMap &parameters).

        Sends an authenticated HEAD request and returns a new **QNetworkReply**
        . The **url** and **parameters** are used to create the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: HEAD**
        """
        ...

    @staticmethod
    def nonce() -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qoauth1.html#nonce

        **[static protected] QByteArray QOAuth1::nonce()**

        Generates a nonce.

        **See also**  : **The OAuth 1.0 Protocol: Nonce and Timestamp**
        """
        ...

    def post(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qoauth1.html#post

        **[override virtual] QNetworkReply *QOAuth1::post(const QUrl & url ,
        const QVariantMap & parameters = QVariantMap())**

        Reimplements: **QAbstractOAuth::post** (const QUrl &url, const
        QVariantMap &parameters).

        Sends an authenticated POST request and returns a new **QNetworkReply**
        . The **url** and **parameters** are used to create the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: POST**
        """
        ...

    def prepareRequest(
        self,
        request: PySide6.QtNetwork.QNetworkRequest,
        verb: Union[PySide6.QtCore.QByteArray, bytes],
        body: Union[PySide6.QtCore.QByteArray, bytes] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#prepareRequest

        **[override virtual] void QOAuth1::prepareRequest(QNetworkRequest *
        request , const QByteArray & verb , const QByteArray & body =
        QByteArray())**

        Reimplements: **QAbstractOAuth::prepareRequest** (QNetworkRequest
        *request, const QByteArray &verb, const QByteArray &body).
        """
        ...

    def put(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qoauth1.html#put

        **[override virtual] QNetworkReply *QOAuth1::put(const QUrl & url ,
        const QVariantMap & parameters = QVariantMap())**

        Reimplements: **QAbstractOAuth::put** (const QUrl &url, const
        QVariantMap &parameters).

        Sends an authenticated PUT request and returns a new **QNetworkReply** .
        The **url** and **parameters** are used to create the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: PUT**
        """
        ...

    def requestTemporaryCredentials(
        self,
        operation: PySide6.QtNetwork.QNetworkAccessManager.Operation,
        url: Union[PySide6.QtCore.QUrl, str],
        parameters: Dict[str, Any] = ...,
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qoauth1.html#requestTemporaryCredentials

        **[protected] QNetworkReply
        *QOAuth1::requestTemporaryCredentials(QNetworkAccessManager::Operation
        operation , const QUrl & url , const QVariantMap & parameters =
        QVariantMap())**

        Starts the a request for temporary credentials using the request method
        **operation**. The request URL is **url** and the **parameters** shall
        encoded and sent during the request.

        **See also**  : **The OAuth 1.0 Protocol: Temporary Credentials**
        """
        ...

    def requestTokenCredentials(
        self,
        operation: PySide6.QtNetwork.QNetworkAccessManager.Operation,
        url: Union[PySide6.QtCore.QUrl, str],
        temporaryToken: Tuple[str, str],
        parameters: Dict[str, Any] = ...,
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qoauth1.html#requestTokenCredentials

        **[protected] QNetworkReply
        *QOAuth1::requestTokenCredentials(QNetworkAccessManager::Operation
        operation , const QUrl & url , const QPair<QString, QString> &
        temporaryToken , const QVariantMap & parameters = QVariantMap())**

        Starts a request for token credentials using the request method
        **operation**. The request URL is **url** and the **parameters** shall
        be encoded and sent during the request. The **temporaryToken** pair of
        string is used to identify and sign the request.

        **See also**  : **The OAuth 1.0 Protocol: Token Credentials**
        """
        ...

    @overload
    def setClientCredentials(self, clientCredentials: Tuple[str, str]) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setClientCredentials

        **void QOAuth1::setClientCredentials(const QPair<QString, QString> &
        clientCredentials )**

        Sets **clientCredentials** as the pair of **QString**  used to identify
        the application and sign requests to the web server.

        **See also** **clientCredentials** ().
        """
        ...

    @overload
    def setClientCredentials(
        self, clientIdentifier: str, clientSharedSecret: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setClientCredentials-1

        **void QOAuth1::setClientCredentials(const QString & clientIdentifier ,
        const QString & clientSharedSecret )**

        Sets **clientIdentifier** and **clientSharedSecret** as the pair of
        **QString**  used to identify the application and sign requests to the
        web server. **clientIdentifier** identifies the application and
        **clientSharedSecret** is used to sign requests.

        **See also** **clientCredentials** ().
        """
        ...

    def setClientSharedSecret(self, clientSharedSecret: str) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setClientSharedSecret

        **void QOAuth1::setClientSharedSecret(const QString & clientSharedSecret
        )**

        Sets **clientSharedSecret** as the string used to sign the requests to
        the web server.

        **See also** **clientSharedSecret** () and **setClientCredentials** ().
        """
        ...

    def setSignatureMethod(
        self, value: PySide6.QtNetworkAuth.QOAuth1.SignatureMethod
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setSignatureMethod

        **void QOAuth1::setSignatureMethod(QOAuth1::SignatureMethod value )**

        Sets **value** as the method used to sign requests to the web server.

        **See also** **signatureMethod** ().
        """
        ...

    def setTemporaryCredentialsUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setTemporaryCredentialsUrl

        **void QOAuth1::setTemporaryCredentialsUrl(const QUrl & url )**

        Sets **url** as the URL to request temporary credentials to start the
        authentication process.

        **See also** **temporaryCredentialsUrl** ().
        """
        ...

    @overload
    def setTokenCredentials(self, token: str, tokenSecret: str) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setTokenCredentials

        **void QOAuth1::setTokenCredentials(const QPair<QString, QString> &
        tokenCredentials )**

        Sets **tokenCredentials** as the pair of **QString**  used to identify
        and sign authenticated requests to the web server.

        **See also** **tokenCredentials** ().
        """
        ...

    @overload
    def setTokenCredentials(self, tokenCredentials: Tuple[str, str]) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setTokenCredentials-1

        **void QOAuth1::setTokenCredentials(const QString & token , const
        QString & tokenSecret )**

        Sets **token** and **tokenSecret** as the pair of **QString**  used to
        identify and sign authenticated requests to the web server. Once the
        client receives and stores the token credentials, it can proceed to
        access protected resources on behalf of the resource owner by making
        authenticated requests using the client credentials together with the
        token credentials received.

        **See also** **tokenCredentials** ().
        """
        ...

    def setTokenCredentialsUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setTokenCredentialsUrl

        **void QOAuth1::setTokenCredentialsUrl(const QUrl & url )**

        Sets **url** as the URL to request the token credentials to continue the
        authentication process.

        **See also** **tokenCredentialsUrl** ().
        """
        ...

    def setTokenSecret(self, tokenSecret: str) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setTokenSecret

        **void QOAuth1::setTokenSecret(const QString & tokenSecret )**

        Sets **tokenSecret** as the current token secret used to sign
        authenticated calls to the web server.

        **See also** **tokenSecret** () and **setTokenCredentials** ().
        """
        ...

    @overload
    def setup(
        self,
        request: PySide6.QtNetwork.QNetworkRequest,
        signingParameters: Dict[str, Any],
        operation: PySide6.QtNetwork.QNetworkAccessManager.Operation,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setup

        **[protected] void QOAuth1::setup(QNetworkRequest * request , const
        QVariantMap & signingParameters , QNetworkAccessManager::Operation
        operation )**

        Signs the **request** using **signingParameters** and **operation**.

        This is an overloaded function.
        """
        ...

    @overload
    def setup(
        self,
        request: PySide6.QtNetwork.QNetworkRequest,
        signingParameters: Dict[str, Any],
        operationVerb: Union[PySide6.QtCore.QByteArray, bytes],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth1.html#setup-1

        **[protected, since 5.13] void QOAuth1::setup(QNetworkRequest * request
        , const QVariantMap & signingParameters , const QByteArray &
        operationVerb )**

        Signs the **request** using **signingParameters** and **operationVerb**.

        This is an overloaded function.

        This function was introduced in Qt 5.13.
        """
        ...

    def signatureMethod(self) -> PySide6.QtNetworkAuth.QOAuth1.SignatureMethod:
        """
        https://doc.qt.io/qt-6/qoauth1.html#signatureMethod

        **QOAuth1::SignatureMethod QOAuth1::signatureMethod() const**

        Returns the method used to sign the request to the web server.

        **See also** **setSignatureMethod** ().
        """
        ...

    def temporaryCredentialsUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qoauth1.html#temporaryCredentialsUrl

        **QUrl QOAuth1::temporaryCredentialsUrl() const**

        Returns the url used to request temporary credentials to start the
        authentication process.

        **See also** **setTemporaryCredentialsUrl** ().
        """
        ...

    def tokenCredentials(self) -> Tuple[str, str]:
        """
        https://doc.qt.io/qt-6/qoauth1.html#tokenCredentials

        **QPair<QString, QString> QOAuth1::tokenCredentials() const**

        Returns the pair of **QString**  used to identify and sign authenticated
        requests to the web server.

        **See also** **setTokenCredentials** ().
        """
        ...

    def tokenCredentialsUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qoauth1.html#tokenCredentialsUrl

        **QUrl QOAuth1::tokenCredentialsUrl() const**

        Returns the url used to request token credentials to continue the
        authentication process.

        **See also** **setTokenCredentialsUrl** ().
        """
        ...

    def tokenSecret(self) -> str:
        """
        https://doc.qt.io/qt-6/qoauth1.html#tokenSecret

        **QString QOAuth1::tokenSecret() const**

        Returns the current token secret used to sign authenticated requests to
        the web server.

        **See also** **setTokenSecret** () and **tokenCredentials** ().
        """
        ...
