"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetworkAuth, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtNetworkAuth

bytes = str


class QAbstractOAuthReplyHandler(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qabstractoauthreplyhandler.html

    **Detailed Description**

    The QAbstractOAuthReplyHandler class handles the answers to all OAuth
    authentication requests. This class is designed as a base whose subclasses
    implement custom behavior in the **callback** () and
    **networkReplyFinished** () methods.
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauthreplyhandler.html#QAbstractOAuthRep
        lyHandler

        **QAbstractOAuthReplyHandler::QAbstractOAuthReplyHandler(QObject *
        parent = nullptr)**

        Constructs a reply handler as a child of **parent**.
        """
        ...

    def callback(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstractoauthreplyhandler.html#callback

        **[pure virtual] QString QAbstractOAuthReplyHandler::callback() const**

        Returns an absolute URI that the server will redirect the resource owner
        back to when the Resource Owner Authorization step is completed. If the
        client is unable to receive callbacks or a callback URI has been
        established via other means, the parameter value **must** be set to
        "oob" (all lower-case), to indicate an out-of-band configuration.

        Derived classes should implement this function to provide the expected
        callback type.
        """
        ...

    def networkReplyFinished(self, reply: PySide6.QtNetwork.QNetworkReply) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauthreplyhandler.html#networkReplyFinis
        hed

        **[pure virtual slot] void
        QAbstractOAuthReplyHandler::networkReplyFinished(QNetworkReply * reply
        )**

        After the server determines whether the request is valid this function
        will be called. Reimplement it to get the data received from the server
        wrapped in **reply**.
        """
        ...

    @property
    def callbackDataReceived(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractoauthreplyhandler.html#callbackDataRecei
        ved

        **[signal] void QAbstractOAuthReplyHandler::callbackDataReceived(const
        QByteArray & data )**

        This signal is emitted when a callback request is received: **data**
        contains the information before parsing.
        """
        ...

    @property
    def callbackReceived(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractoauthreplyhandler.html#callbackReceived

        **[signal] void QAbstractOAuthReplyHandler::callbackReceived(const
        QVariantMap & values )**

        This signal is emitted when the reply from the server is received, with
        **values** containing the token credentials and any additional
        information the server may have returned. When this signal is emitted,
        the authorization process is complete.
        """
        ...

    @property
    def replyDataReceived(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractoauthreplyhandler.html#replyDataReceived

        **[signal] void QAbstractOAuthReplyHandler::replyDataReceived(const
        QByteArray & data )**

        This signal is emitted when an HTTP request finishes and the data is
        available. **data** contains the response before parsing.
        """
        ...

    @property
    def tokensReceived(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractoauthreplyhandler.html#tokensReceived

        **[signal] void QAbstractOAuthReplyHandler::tokensReceived(const
        QVariantMap & tokens )**

        This signal is emitted when new **tokens** are received from the server.
        """
        ...
