"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QSslError(object):
    """
    https://doc.qt.io/qt-6/qsslerror.html

    **Detailed Description**

    QSslError provides a simple API for managing errors during **QSslSocket** 's
    SSL handshake.

    **See also** **QSslSocket** , **QSslCertificate** , and **QSslCipher** .
    """

    UnspecifiedError: QSslError.SslError = ...
    NoError: QSslError.SslError = ...
    UnableToGetIssuerCertificate: QSslError.SslError = ...
    UnableToDecryptCertificateSignature: QSslError.SslError = ...
    UnableToDecodeIssuerPublicKey: QSslError.SslError = ...
    CertificateSignatureFailed: QSslError.SslError = ...
    CertificateNotYetValid: QSslError.SslError = ...
    CertificateExpired: QSslError.SslError = ...
    InvalidNotBeforeField: QSslError.SslError = ...
    InvalidNotAfterField: QSslError.SslError = ...
    SelfSignedCertificate: QSslError.SslError = ...
    SelfSignedCertificateInChain: QSslError.SslError = ...
    UnableToGetLocalIssuerCertificate: QSslError.SslError = ...
    UnableToVerifyFirstCertificate: QSslError.SslError = ...
    CertificateRevoked: QSslError.SslError = ...
    InvalidCaCertificate: QSslError.SslError = ...
    PathLengthExceeded: QSslError.SslError = ...
    InvalidPurpose: QSslError.SslError = ...
    CertificateUntrusted: QSslError.SslError = ...
    CertificateRejected: QSslError.SslError = ...
    SubjectIssuerMismatch: QSslError.SslError = ...
    AuthorityIssuerSerialNumberMismatch: QSslError.SslError = ...
    NoPeerCertificate: QSslError.SslError = ...
    HostNameMismatch: QSslError.SslError = ...
    NoSslSupport: QSslError.SslError = ...
    CertificateBlacklisted: QSslError.SslError = ...
    CertificateStatusUnknown: QSslError.SslError = ...
    OcspNoResponseFound: QSslError.SslError = ...
    OcspMalformedRequest: QSslError.SslError = ...
    OcspMalformedResponse: QSslError.SslError = ...
    OcspInternalError: QSslError.SslError = ...
    OcspTryLater: QSslError.SslError = ...
    OcspSigRequred: QSslError.SslError = ...
    OcspUnauthorized: QSslError.SslError = ...
    OcspResponseCannotBeTrusted: QSslError.SslError = ...
    OcspResponseCertIdUnknown: QSslError.SslError = ...
    OcspResponseExpired: QSslError.SslError = ...
    OcspStatusUnknown: QSslError.SslError = ...

    class SslError(Enum):
        UnspecifiedError: QSslError.SslError = ...
        NoError: QSslError.SslError = ...
        UnableToGetIssuerCertificate: QSslError.SslError = ...
        UnableToDecryptCertificateSignature: QSslError.SslError = ...
        UnableToDecodeIssuerPublicKey: QSslError.SslError = ...
        CertificateSignatureFailed: QSslError.SslError = ...
        CertificateNotYetValid: QSslError.SslError = ...
        CertificateExpired: QSslError.SslError = ...
        InvalidNotBeforeField: QSslError.SslError = ...
        InvalidNotAfterField: QSslError.SslError = ...
        SelfSignedCertificate: QSslError.SslError = ...
        SelfSignedCertificateInChain: QSslError.SslError = ...
        UnableToGetLocalIssuerCertificate: QSslError.SslError = ...
        UnableToVerifyFirstCertificate: QSslError.SslError = ...
        CertificateRevoked: QSslError.SslError = ...
        InvalidCaCertificate: QSslError.SslError = ...
        PathLengthExceeded: QSslError.SslError = ...
        InvalidPurpose: QSslError.SslError = ...
        CertificateUntrusted: QSslError.SslError = ...
        CertificateRejected: QSslError.SslError = ...
        SubjectIssuerMismatch: QSslError.SslError = ...
        AuthorityIssuerSerialNumberMismatch: QSslError.SslError = ...
        NoPeerCertificate: QSslError.SslError = ...
        HostNameMismatch: QSslError.SslError = ...
        NoSslSupport: QSslError.SslError = ...
        CertificateBlacklisted: QSslError.SslError = ...
        CertificateStatusUnknown: QSslError.SslError = ...
        OcspNoResponseFound: QSslError.SslError = ...
        OcspMalformedRequest: QSslError.SslError = ...
        OcspMalformedResponse: QSslError.SslError = ...
        OcspInternalError: QSslError.SslError = ...
        OcspTryLater: QSslError.SslError = ...
        OcspSigRequred: QSslError.SslError = ...
        OcspUnauthorized: QSslError.SslError = ...
        OcspResponseCannotBeTrusted: QSslError.SslError = ...
        OcspResponseCertIdUnknown: QSslError.SslError = ...
        OcspResponseExpired: QSslError.SslError = ...
        OcspStatusUnknown: QSslError.SslError = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#QSslError

        **QSslError::QSslError()**

        Constructs a QSslError object with no error and default certificate.
        """
        ...

    @overload
    def __init__(self, error: PySide6.QtNetwork.QSslError.SslError) -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#QSslError-1

        **QSslError::QSslError(QSslError::SslError error )**

        Constructs a QSslError object. The argument specifies the **error** that
        occurred.
        """
        ...

    @overload
    def __init__(
        self,
        error: PySide6.QtNetwork.QSslError.SslError,
        certificate: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#QSslError-2

        **QSslError::QSslError(QSslError::SslError error , const QSslCertificate
        & certificate )**

        Constructs a QSslError object. The two arguments specify the **error**
        that occurred, and which **certificate** the error relates to.

        **See also** **QSslCertificate** .
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtNetwork.QSslError) -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#QSslError-3

        **QSslError::QSslError(const QSslError & other )**

        Constructs an identical copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def certificate(self) -> PySide6.QtNetwork.QSslCertificate:
        """
        https://doc.qt.io/qt-6/qsslerror.html#certificate

        **QSslCertificate QSslError::certificate() const**

        Returns the certificate associated with this error, or a null
        certificate if the error does not relate to any certificate.

        **See also** **error** () and **errorString** ().
        """
        ...

    def error(self) -> PySide6.QtNetwork.QSslError.SslError:
        """
        https://doc.qt.io/qt-6/qsslerror.html#error

        **QSslError::SslError QSslError::error() const**

        Returns the type of the error.

        **See also** **errorString** () and **certificate** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qsslerror.html#errorString

        **QString QSslError::errorString() const**

        Returns a short localized human-readable description of the error.

        **See also** **error** () and **certificate** ().
        """
        ...

    def swap(self, other: PySide6.QtNetwork.QSslError) -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#swap

        **[since 5.0] void QSslError::swap(QSslError & other )**

        Swaps this error instance with **other**. This function is very fast and
        never fails.

        This function was introduced in Qt 5.0.
        """
        ...
