"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from typing import List, overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QDnsTextRecord(object):
    """
    https://doc.qt.io/qt-6/qdnstextrecord.html

    **Detailed Description**

    When performing a text lookup, zero or more records will be returned. Each
    record is represented by a QDnsTextRecord instance.

    The meaning of the fields is defined in **RFC 1035** .

    **See also** **QDnsLookup** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdnstextrecord.html#QDnsTextRecord

        **QDnsTextRecord::QDnsTextRecord()**

        Constructs an empty text record object.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtNetwork.QDnsTextRecord) -> None:
        """
        https://doc.qt.io/qt-6/qdnstextrecord.html#QDnsTextRecord-1

        **QDnsTextRecord::QDnsTextRecord(const QDnsTextRecord & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qdnstextrecord.html#name

        **QString QDnsTextRecord::name() const**

        Returns the name for this text record.
        """
        ...

    def swap(self, other: PySide6.QtNetwork.QDnsTextRecord) -> None:
        """
        https://doc.qt.io/qt-6/qdnstextrecord.html#swap

        **void QDnsTextRecord::swap(QDnsTextRecord & other )**

        Swaps this text record instance with **other**. This function is very
        fast and never fails.
        """
        ...

    def timeToLive(self) -> int:
        """
        https://doc.qt.io/qt-6/qdnstextrecord.html#timeToLive

        **quint32 QDnsTextRecord::timeToLive() const**

        Returns the duration in seconds for which this record is valid.
        """
        ...

    def values(self) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qdnstextrecord.html#values

        **QList<QByteArray> QDnsTextRecord::values() const**

        Returns the values for this text record.
        """
        ...
