"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimediaWidgets, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtMultimedia
import PySide6.QtMultimediaWidgets

bytes = str


class QGraphicsVideoItem(PySide6.QtWidgets.QGraphicsObject):
    """
    https://doc.qt.io/qt-6/qgraphicsvideoitem.html

    **Detailed Description**

    Attaching a QGraphicsVideoItem to a **QMediaPlayer**  or **QCamera**  allows
    it to display the video or image output of that media object.

    player = new **QMediaPlayer** (this);

        **QGraphicsVideoItem**  *item
    = new **QGraphicsVideoItem** ;
        player->setVideoOutput(item);
    graphicsView->scene()->addItem(item);
        graphicsView->show();
    player->setSource(**QUrl** ("http://example.com/myclip4.ogv"));
    player->play();

    **Note** : Only a single display output can be attached to a media object at
    one time.

    **See also** **QMediaPlayer** , **QVideoWidget** , and **QCamera** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#QGraphicsVideoItem

        **QGraphicsVideoItem::QGraphicsVideoItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a graphics item that displays video.

        The **parent** is passed to **QGraphicsItem** .
        """
        ...

    def aspectRatioMode(self) -> PySide6.QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how a video is scaled to fit the graphics item's size.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def boundingRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#boundingRect

        **[override virtual] QRectF QGraphicsVideoItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect() const** .
        """
        ...

    def itemChange(
        self, change: PySide6.QtWidgets.QGraphicsItem.GraphicsItemChange, value: Any
    ) -> Any:
        ...

    def nativeSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#nativeSize-prop

        **[read-only] nativeSize : const QSizeF**

        This property holds the native size of the video.

        **Access functions:**

        QSizeF **nativeSize** () const

        **Notifier signal:**

        void ****nativeSizeChanged** ** (const QSizeF & **size** )
        """
        ...

    def offset(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#offset-prop

        **offset : QPointF**

        This property holds the video item's offset.

        **QGraphicsVideoItem**  will draw video using the offset for its top
        left corner.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **offset** )
        """
        ...

    def paint(
        self,
        painter: PySide6.QtGui.QPainter,
        option: PySide6.QtWidgets.QStyleOptionGraphicsItem,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#paint

        **[override virtual] void QGraphicsVideoItem::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def setAspectRatioMode(self, mode: PySide6.QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how a video is scaled to fit the graphics item's size.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def setOffset(
        self,
        offset: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#offset-prop

        **offset : QPointF**

        This property holds the video item's offset.

        **QGraphicsVideoItem**  will draw video using the offset for its top
        left corner.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **offset** )
        """
        ...

    def setSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#size-prop

        **size : QSizeF**

        This property holds the video item's size.

        **QGraphicsVideoItem**  will draw video scaled to fit size according to
        its fillMode.

        **Access functions:**

        QSizeF **size** () const
        void **setSize** (const QSizeF & **size** )
        """
        ...

    def size(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#size-prop

        **size : QSizeF**

        This property holds the video item's size.

        **QGraphicsVideoItem**  will draw video scaled to fit size according to
        its fillMode.

        **Access functions:**

        QSizeF **size** () const
        void **setSize** (const QSizeF & **size** )
        """
        ...

    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None:
        ...

    def type(self) -> int:
        ...

    def videoSink(self) -> PySide6.QtMultimedia.QVideoSink:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#videoSink-prop

        **[read-only] videoSink : QVideoSink* const**

        Returns the underlying video sink that can render video frames to the
        current item. This property is never `nullptr`. Example of how to render
        video frames to **QGraphicsVideoItem** :

        **QGraphicsVideoItem**  *item = new **QGraphicsVideoItem** ;
        graphicsView->scene()->addItem(item);
            graphicsView->show();
        **QImage**  img = **QImage** ("images/qt-
        logo.png").convertToFormat(**QImage** ::Format_ARGB32);
        item->videoSink()->setVideoFrame(**QVideoFrame** (img));

        **Access functions:**

        QVideoSink * **videoSink** () const[see note below]

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QMediaPlayer::setVideoOutput** .

        **Member Function Documentation**
        """
        ...

    @property
    def nativeSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#nativeSizeChanged

        **[signal] void QGraphicsVideoItem::nativeSizeChanged(const QSizeF &
        size )**

        Signals that the native **size** of the video has changed.

        **Note:** Notifier signal for property **nativeSize** .
        """
        ...
