"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimedia, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtMultimedia

bytes = str


class QMediaMetaData(object):
    """
    https://doc.qt.io/qt-6/qmediametadata.html

    **Detailed Description**

    **Note:** Not all identifiers are supported on all platforms.

    Common attributes
    ValueDescriptionType
    TitleThe title of the
    media.**QString**
    AuthorThe authors of the media.**QStringList**
    CommentA user comment about the media.**QString**
    DescriptionA description
    of the media.**QString**
    GenreThe genre of the media.**QStringList**
    DateThe date of the media.**QDate** .
    LanguageThe language of
    media.**QLocale::Language**
    PublisherThe publisher of the
    media.**QString**
    CopyrightThe media's copyright notice.**QString**
    UrlA
    Url pointing to the origin of the media.**QUrl**
    Media attributes
    MediaTypeThe type of the media (audio, video, etc).**QString**
    FileFormatThe file format of the media.**QMediaFormat::FileFormat**
    DurationThe duration in millseconds of the media.qint64
    Audio attributes
    AudioBitRateThe bit rate of the media's audio stream in bits per second.int
    AudioCodecThe codec of the media's audio stream.QMediaForma::AudioCodec
    Video attributes
    VideoFrameRateThe frame rate of the media's video
    stream.qreal
    VideoBitRateThe bit rate of the media's video stream in bits
    per second.int
    VideoCodecThe codec of the media's video
    stream.**QMediaFormat::VideoCodec**
    Music attributes
    AlbumTitleThe title
    of the album the media belongs to.**QString**
    AlbumArtistThe principal
    artist of the album the media belongs to.**QString**
    ContributingArtistThe
    artists contributing to the media.**QStringList**
    TrackNumberThe track
    number of the media.int
    ComposerThe composer of the media.**QStringList**
    LeadPerformerThe lead performer in the media.**QStringList**
    ThumbnailImageAn embedded thumbnail image.**QImage**
    CoverArtImageAn
    embedded cover art image.**QImage**
    Image and video attributes
    ResolutionThe dimensions of an image or video.**QSize**
    """

    Title: QMediaMetaData.Key = ...
    Author: QMediaMetaData.Key = ...
    Comment: QMediaMetaData.Key = ...
    Description: QMediaMetaData.Key = ...
    Genre: QMediaMetaData.Key = ...
    Date: QMediaMetaData.Key = ...
    Language: QMediaMetaData.Key = ...
    Publisher: QMediaMetaData.Key = ...
    Copyright: QMediaMetaData.Key = ...
    Url: QMediaMetaData.Key = ...
    Duration: QMediaMetaData.Key = ...
    MediaType: QMediaMetaData.Key = ...
    FileFormat: QMediaMetaData.Key = ...
    AudioBitRate: QMediaMetaData.Key = ...
    AudioCodec: QMediaMetaData.Key = ...
    VideoBitRate: QMediaMetaData.Key = ...
    VideoCodec: QMediaMetaData.Key = ...
    VideoFrameRate: QMediaMetaData.Key = ...
    AlbumTitle: QMediaMetaData.Key = ...
    AlbumArtist: QMediaMetaData.Key = ...
    ContributingArtist: QMediaMetaData.Key = ...
    TrackNumber: QMediaMetaData.Key = ...
    Composer: QMediaMetaData.Key = ...
    LeadPerformer: QMediaMetaData.Key = ...
    ThumbnailImage: QMediaMetaData.Key = ...
    CoverArtImage: QMediaMetaData.Key = ...
    Orientation: QMediaMetaData.Key = ...
    Resolution: QMediaMetaData.Key = ...

    class Key(Enum):
        Title: QMediaMetaData.Key = ...
        Author: QMediaMetaData.Key = ...
        Comment: QMediaMetaData.Key = ...
        Description: QMediaMetaData.Key = ...
        Genre: QMediaMetaData.Key = ...
        Date: QMediaMetaData.Key = ...
        Language: QMediaMetaData.Key = ...
        Publisher: QMediaMetaData.Key = ...
        Copyright: QMediaMetaData.Key = ...
        Url: QMediaMetaData.Key = ...
        Duration: QMediaMetaData.Key = ...
        MediaType: QMediaMetaData.Key = ...
        FileFormat: QMediaMetaData.Key = ...
        AudioBitRate: QMediaMetaData.Key = ...
        AudioCodec: QMediaMetaData.Key = ...
        VideoBitRate: QMediaMetaData.Key = ...
        VideoCodec: QMediaMetaData.Key = ...
        VideoFrameRate: QMediaMetaData.Key = ...
        AlbumTitle: QMediaMetaData.Key = ...
        AlbumArtist: QMediaMetaData.Key = ...
        ContributingArtist: QMediaMetaData.Key = ...
        TrackNumber: QMediaMetaData.Key = ...
        Composer: QMediaMetaData.Key = ...
        LeadPerformer: QMediaMetaData.Key = ...
        ThumbnailImage: QMediaMetaData.Key = ...
        CoverArtImage: QMediaMetaData.Key = ...
        Orientation: QMediaMetaData.Key = ...
        Resolution: QMediaMetaData.Key = ...

    def __init__(self, QMediaMetaData: PySide6.QtMultimedia.QMediaMetaData) -> None:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#clear

        **[invokable] void QMediaMetaData::clear()**

        Removes all data from the meta data object.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def insert(self, k: PySide6.QtMultimedia.QMediaMetaData.Key, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#insert

        **[invokable] void QMediaMetaData::insert(QMediaMetaData::Key k , const
        QVariant & value )**

        Inserts a **value** into a Key: **k**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#isEmpty

        **[invokable] bool QMediaMetaData::isEmpty() const**

        Returns `true` if the meta data contains no items: otherwise returns
        `false`.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def keys(self) -> List[PySide6.QtMultimedia.QMediaMetaData.Key]:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#keys

        **[invokable] QList<QMediaMetaData::Key> QMediaMetaData::keys() const**

        Returns a **QList**  of QMediaMetaData::Keys.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @staticmethod
    def metaDataKeyToString(k: PySide6.QtMultimedia.QMediaMetaData.Key) -> str:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#metaDataKeyToString

        **[static invokable] QString
        QMediaMetaData::metaDataKeyToString(QMediaMetaData::Key key )**

        returns a string representation of **key** that can be used when
        presenting meta data to users.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def remove(self, k: PySide6.QtMultimedia.QMediaMetaData.Key) -> None:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#remove

        **[invokable] void QMediaMetaData::remove(QMediaMetaData::Key k )**

        Removes meta data from a Key: **k**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def stringValue(self, k: PySide6.QtMultimedia.QMediaMetaData.Key) -> str:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#stringValue

        **[invokable] QString QMediaMetaData::stringValue(QMediaMetaData::Key
        key ) const**

        Returns the meta data for key **key** as a **QString** .

        This is mainly meant to simplify presenting the meta data to a user.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def value(self, k: PySide6.QtMultimedia.QMediaMetaData.Key) -> Any:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#value

        **[invokable] QVariant QMediaMetaData::value(QMediaMetaData::Key key )
        const**

        Returns the meta data value for Key **key** , or a null **QVariant**  if
        no meta data for the key is available.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...
