"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtHelp, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Sequence
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtHelp

bytes = str


class QHelpSearchQueryWidget(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qhelpsearchquerywidget.html

    **Detailed Description**
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchquerywidget.html#QHelpSearchQueryWidge
        t

        **QHelpSearchQueryWidget::QHelpSearchQueryWidget(QWidget * parent =
        nullptr)**

        Constructs a new search query widget with the given **parent**.
        """
        ...

    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None:
        ...

    def collapseExtendedSearch(self) -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchquerywidget.html#collapseExtendedSearc
        h

        **void QHelpSearchQueryWidget::collapseExtendedSearch()**

        Collapses the search query widget so that only the default search field
        is shown.
        """
        ...

    def expandExtendedSearch(self) -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchquerywidget.html#expandExtendedSearch

        **void QHelpSearchQueryWidget::expandExtendedSearch()**

        Expands the search query widget so that the extended search fields are
        shown.
        """
        ...

    def focusInEvent(self, focusEvent: PySide6.QtGui.QFocusEvent) -> None:
        ...

    def isCompactMode(self) -> bool:
        ...

    def query(self) -> List[PySide6.QtHelp.QHelpSearchQuery]:
        ...

    def searchInput(self) -> str:
        """
        https://doc.qt.io/qt-6/qhelpsearchquerywidget.html#searchInput

        **[since 5.9] QString QHelpSearchQueryWidget::searchInput() const**

        Returns a search phrase to use in combination with the
        QHelpSearchEngine::search(const **QString**  &searchInput) function.

        This function was introduced in Qt 5.9.

        **See also** **setSearchInput** ().
        """
        ...

    def setCompactMode(self, on: bool) -> None:
        ...

    def setQuery(self, queryList: Sequence[PySide6.QtHelp.QHelpSearchQuery]) -> None:
        ...

    def setSearchInput(self, searchInput: str) -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchquerywidget.html#setSearchInput

        **[since 5.9] void QHelpSearchQueryWidget::setSearchInput(const QString
        & searchInput )**

        Sets the **QHelpSearchQueryWidget**  input field to the value specified
        by **searchInput**.

        **Note:** The QHelpSearchEngine::search(const **QString**
        &**searchInput** ) function has to be called to perform the actual
        search.

        This function was introduced in Qt 5.9.

        **See also** **searchInput** ().
        """
        ...

    @property
    def search(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhelpsearchquerywidget.html#search

        **[signal] void QHelpSearchQueryWidget::search()**

        This signal is emitted when a the user has the search button invoked.
        After receiving the signal you can ask the **QHelpSearchQueryWidget**
        for the search input that you may pass to the
        QHelpSearchEngine::search() function.
        """
        ...
