"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QVector4D(object):
    """
    https://doc.qt.io/qt-6/qvector4d.html

    **Detailed Description**

    Vectors are one of the main building blocks of 4D affine representations of
    3D space. They consist of four finite floating-point coordinates,
    traditionally called x, y, z and w.

    The QVector4D class can also be used to represent vertices in 4D space. We
    therefore do not need to provide a separate vertex class.

    **See also** **QQuaternion** , **QVector2D** , and **QVector3D** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#QVector4D

        **QVector4D::QVector4D()**

        Constructs a null vector, i.e. with coordinates (0, 0, 0, 0).
        """
        ...

    @overload
    def __init__(self, point: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#QVector4D-2

        **QVector4D::QVector4D(float xpos , float ypos , float zpos , float wpos
        )**

        Constructs a vector with coordinates ( **xpos** , **ypos** , **zpos** ,
        **wpos** ). All parameters must be finite.
        """
        ...

    @overload
    def __init__(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#QVector4D-3

        **QVector4D::QVector4D(QPoint point )**

        Constructs a vector with x and y coordinates from a 2D **point** , and z
        and w coordinates of 0.
        """
        ...

    @overload
    def __init__(self, vector: PySide6.QtGui.QVector2D) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#QVector4D-4

        **QVector4D::QVector4D(QPointF point )**

        Constructs a vector with x and y coordinates from a 2D **point** , and z
        and w coordinates of 0.
        """
        ...

    @overload
    def __init__(
        self, vector: PySide6.QtGui.QVector2D, zpos: float, wpos: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#QVector4D-5

        **QVector4D::QVector4D(QVector2D vector )**

        Constructs a 4D vector from the specified 2D **vector**. The z and w
        coordinates are set to zero.

        **See also** **toVector2D** ().
        """
        ...

    @overload
    def __init__(self, vector: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#QVector4D-6

        **QVector4D::QVector4D(QVector2D vector , float zpos , float wpos )**

        Constructs a 4D vector from the specified 2D **vector**. The z and w
        coordinates are set to **zpos** and **wpos** respectively, each of which
        must be finite.

        **See also** **toVector2D** ().
        """
        ...

    @overload
    def __init__(self, vector: PySide6.QtGui.QVector3D, wpos: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#QVector4D-7

        **QVector4D::QVector4D(QVector3D vector )**

        Constructs a 4D vector from the specified 3D **vector**. The w
        coordinate is set to zero.

        **See also** **toVector3D** ().
        """
        ...

    @overload
    def __init__(self, xpos: float, ypos: float, zpos: float, wpos: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#QVector4D-8

        **QVector4D::QVector4D(QVector3D vector , float wpos )**

        Constructs a 4D vector from the specified 3D **vector**. The w
        coordinate is set to **wpos** , which must be finite.

        **See also** **toVector3D** ().
        """
        ...

    def __add__(self, v2: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(self, vector: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D:
        ...

    @overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QVector4D:
        ...

    @overload
    def __imul__(self, vector: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D:
        ...

    def __isub__(self, vector: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    @overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QVector4D:
        ...

    @overload
    def __mul__(
        self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]
    ) -> PySide6.QtGui.QVector4D:
        ...

    @overload
    def __mul__(self, v2: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D:
        ...

    def __neg__(self) -> PySide6.QtGui.QVector4D:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __sub__(self, v2: PySide6.QtGui.QVector4D) -> PySide6.QtGui.QVector4D:
        ...

    @staticmethod
    def dotProduct(v1: PySide6.QtGui.QVector4D, v2: PySide6.QtGui.QVector4D) -> float:
        """
        https://doc.qt.io/qt-6/qvector4d.html#dotProduct

        **[static] float QVector4D::dotProduct(QVector4D v1 , QVector4D v2 )**

        Returns the dot product of **v1** and **v2**.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvector4d.html#isNull

        **bool QVector4D::isNull() const**

        Returns `true` if the x, y, z, and w coordinates are set to 0.0,
        otherwise returns `false`.
        """
        ...

    def length(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector4d.html#length

        **float QVector4D::length() const**

        Returns the length of the vector from the origin.

        **See also** **lengthSquared** () and **normalized** ().
        """
        ...

    def lengthSquared(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector4d.html#lengthSquared

        **float QVector4D::lengthSquared() const**

        Returns the squared length of the vector from the origin. This is
        equivalent to the dot product of the vector with itself.

        **See also** **length** () and **dotProduct** ().
        """
        ...

    def normalize(self) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#normalize

        **void QVector4D::normalize()**

        Normalizes the currect vector in place. Nothing happens if this vector
        is a null vector or the length of the vector is very close to 1.

        **See also** **length** () and **normalized** ().
        """
        ...

    def normalized(self) -> PySide6.QtGui.QVector4D:
        """
        https://doc.qt.io/qt-6/qvector4d.html#normalized

        **QVector4D QVector4D::normalized() const**

        Returns the normalized unit vector form of this vector.

        If this vector is null, then a null vector is returned. If the length of
        the vector is very close to 1, then the vector will be returned as-is.
        Otherwise the normalized form of the vector of length 1 will be
        returned.

        **See also** **length** () and **normalize** ().
        """
        ...

    def setW(self, w: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#setW

        **void QVector4D::setW(float w )**

        Sets the w coordinate of this point to the given finite **w**
        coordinate.

        **See also** **w** (), **setX** (), **setY** (), and **setZ** ().
        """
        ...

    def setX(self, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#setX

        **void QVector4D::setX(float x )**

        Sets the x coordinate of this point to the given finite **x**
        coordinate.

        **See also** **x** (), **setY** (), **setZ** (), and **setW** ().
        """
        ...

    def setY(self, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#setY

        **void QVector4D::setY(float y )**

        Sets the y coordinate of this point to the given finite **y**
        coordinate.

        **See also** **y** (), **setX** (), **setZ** (), and **setW** ().
        """
        ...

    def setZ(self, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qvector4d.html#setZ

        **void QVector4D::setZ(float z )**

        Sets the z coordinate of this point to the given finite **z**
        coordinate.

        **See also** **z** (), **setX** (), **setY** (), and **setW** ().
        """
        ...

    def toPoint(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qvector4d.html#toPoint

        **QPoint QVector4D::toPoint() const**

        Returns the **QPoint**  form of this 4D vector. The z and w coordinates
        are dropped. The x and y coordinates are rounded to nearest integers.

        **See also** **toPointF** () and **toVector2D** ().
        """
        ...

    def toPointF(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qvector4d.html#toPointF

        **QPointF QVector4D::toPointF() const**

        Returns the **QPointF**  form of this 4D vector. The z and w coordinates
        are dropped.

        **See also** **toPoint** () and **toVector2D** ().
        """
        ...

    def toTuple(self) -> object:
        ...

    def toVector2D(self) -> PySide6.QtGui.QVector2D:
        """
        https://doc.qt.io/qt-6/qvector4d.html#toVector2D

        **QVector2D QVector4D::toVector2D() const**

        Returns the 2D vector form of this 4D vector, dropping the z and w
        coordinates.

        **See also** **toVector2DAffine** (), **toVector3D** (), and **toPoint**
        ().
        """
        ...

    def toVector2DAffine(self) -> PySide6.QtGui.QVector2D:
        """
        https://doc.qt.io/qt-6/qvector4d.html#toVector2DAffine

        **QVector2D QVector4D::toVector2DAffine() const**

        Returns the 2D vector form of this 4D vector, dividing the x and y
        coordinates by the w coordinate and dropping the z coordinate. Returns a
        null vector if w is zero.

        **See also** **toVector2D** (), **toVector3DAffine** (), and **toPoint**
        ().
        """
        ...

    def toVector3D(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qvector4d.html#toVector3D

        **QVector3D QVector4D::toVector3D() const**

        Returns the 3D vector form of this 4D vector, dropping the w coordinate.

        **See also** **toVector3DAffine** (), **toVector2D** (), and **toPoint**
        ().
        """
        ...

    def toVector3DAffine(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qvector4d.html#toVector3DAffine

        **QVector3D QVector4D::toVector3DAffine() const**

        Returns the 3D vector form of this 4D vector, dividing the x, y, and z
        coordinates by the w coordinate. Returns a null vector if w is zero.

        **See also** **toVector3D** (), **toVector2DAffine** (), and **toPoint**
        ().
        """
        ...

    def w(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector4d.html#w

        **float QVector4D::w() const**

        Returns the w coordinate of this point.

        **See also** **setW** (), **x** (), **y** (), and **z** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector4d.html#x

        **float QVector4D::x() const**

        Returns the x coordinate of this point.

        **See also** **setX** (), **y** (), **z** (), and **w** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector4d.html#y

        **float QVector4D::y() const**

        Returns the y coordinate of this point.

        **See also** **setY** (), **x** (), **z** (), and **w** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-6/qvector4d.html#z

        **float QVector4D::z() const**

        Returns the z coordinate of this point.

        **See also** **setZ** (), **x** (), **y** (), and **w** ().
        """
        ...
