"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextFrameFormat(PySide6.QtGui.QTextFormat):
    """
    https://doc.qt.io/qt-6/qtextframeformat.html

    **Detailed Description**

    A text frame groups together one or more blocks of text, providing a layer
    of structure larger than the paragraph. The format of a frame specifies how
    it is rendered and positioned on the screen. It does not directly specify
    the behavior of the text formatting within, but provides constraints on the
    layout of its children.

    The frame format defines the **width** () and **height** () of the frame on
    the screen. Each frame can have a **border** () that surrounds its contents
    with a rectangular box. The border is surrounded by a **margin** () around
    the frame, and the contents of the frame are kept separate from the border
    by the frame's **padding** (). This scheme is similar to the box model used
    by Cascading Style Sheets for HTML pages.

    ![](images/qtextframe-style.png)

    The **position** () of a frame is set using **setPosition** () and
    determines how it is located relative to the surrounding text.

    The validity of a QTextFrameFormat object can be determined with the
    **isValid** () function.

    **See also** **QTextFrame**  and **QTextBlockFormat** .
    """

    BorderStyle_None: QTextFrameFormat.BorderStyle = ...
    BorderStyle_Dotted: QTextFrameFormat.BorderStyle = ...
    BorderStyle_Dashed: QTextFrameFormat.BorderStyle = ...
    BorderStyle_Solid: QTextFrameFormat.BorderStyle = ...
    BorderStyle_Double: QTextFrameFormat.BorderStyle = ...
    BorderStyle_DotDash: QTextFrameFormat.BorderStyle = ...
    BorderStyle_DotDotDash: QTextFrameFormat.BorderStyle = ...
    BorderStyle_Groove: QTextFrameFormat.BorderStyle = ...
    BorderStyle_Ridge: QTextFrameFormat.BorderStyle = ...
    BorderStyle_Inset: QTextFrameFormat.BorderStyle = ...
    BorderStyle_Outset: QTextFrameFormat.BorderStyle = ...
    InFlow: QTextFrameFormat.Position = ...
    FloatLeft: QTextFrameFormat.Position = ...
    FloatRight: QTextFrameFormat.Position = ...

    class BorderStyle(Enum):
        BorderStyle_None: QTextFrameFormat.BorderStyle = ...
        BorderStyle_Dotted: QTextFrameFormat.BorderStyle = ...
        BorderStyle_Dashed: QTextFrameFormat.BorderStyle = ...
        BorderStyle_Solid: QTextFrameFormat.BorderStyle = ...
        BorderStyle_Double: QTextFrameFormat.BorderStyle = ...
        BorderStyle_DotDash: QTextFrameFormat.BorderStyle = ...
        BorderStyle_DotDotDash: QTextFrameFormat.BorderStyle = ...
        BorderStyle_Groove: QTextFrameFormat.BorderStyle = ...
        BorderStyle_Ridge: QTextFrameFormat.BorderStyle = ...
        BorderStyle_Inset: QTextFrameFormat.BorderStyle = ...
        BorderStyle_Outset: QTextFrameFormat.BorderStyle = ...

    class Position(Enum):
        InFlow: QTextFrameFormat.Position = ...
        FloatLeft: QTextFrameFormat.Position = ...
        FloatRight: QTextFrameFormat.Position = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#QTextFrameFormat

        **QTextFrameFormat::QTextFrameFormat()**

        Constructs a text frame format object with the default properties.
        """
        ...

    @overload
    def __init__(self, QTextFrameFormat: PySide6.QtGui.QTextFrameFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#QTextFrameFormat

        **QTextFrameFormat::QTextFrameFormat()**

        Constructs a text frame format object with the default properties.
        """
        ...

    @overload
    def __init__(self, fmt: PySide6.QtGui.QTextFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#QTextFrameFormat

        **QTextFrameFormat::QTextFrameFormat()**

        Constructs a text frame format object with the default properties.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def border(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#border

        **qreal QTextFrameFormat::border() const**

        Returns the width of the border in pixels.

        **See also** **setBorder** ().
        """
        ...

    def borderBrush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#borderBrush

        **QBrush QTextFrameFormat::borderBrush() const**

        Returns the brush used for the frame's border.

        **See also** **setBorderBrush** ().
        """
        ...

    def borderStyle(self) -> PySide6.QtGui.QTextFrameFormat.BorderStyle:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#borderStyle

        **QTextFrameFormat::BorderStyle QTextFrameFormat::borderStyle() const**

        Returns the style of the frame's border.

        **See also** **setBorderStyle** ().
        """
        ...

    def bottomMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#bottomMargin

        **qreal QTextFrameFormat::bottomMargin() const**

        Returns the width of the frame's bottom margin in pixels.

        **See also** **setBottomMargin** ().
        """
        ...

    def height(self) -> PySide6.QtGui.QTextLength:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#height

        **QTextLength QTextFrameFormat::height() const**

        Returns the height of the frame's border rectangle.

        **See also** **setHeight** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#isValid

        **bool QTextFrameFormat::isValid() const**

        Returns `true` if the format description is valid; otherwise returns
        `false`.
        """
        ...

    def leftMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#leftMargin

        **qreal QTextFrameFormat::leftMargin() const**

        Returns the width of the frame's left margin in pixels.

        **See also** **setLeftMargin** ().
        """
        ...

    def margin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#margin

        **qreal QTextFrameFormat::margin() const**

        Returns the width of the frame's external margin in pixels.

        **See also** **setMargin** ().
        """
        ...

    def padding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#padding

        **qreal QTextFrameFormat::padding() const**

        Returns the width of the frame's internal padding in pixels.

        **See also** **setPadding** ().
        """
        ...

    def pageBreakPolicy(self) -> PySide6.QtGui.QTextFormat.PageBreakFlags:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#pageBreakPolicy

        **QTextFormat::PageBreakFlags QTextFrameFormat::pageBreakPolicy()
        const**

        Returns the currently set page break policy for the frame/table. The
        default is **QTextFormat::PageBreak_Auto** .

        **See also** **setPageBreakPolicy** ().
        """
        ...

    def position(self) -> PySide6.QtGui.QTextFrameFormat.Position:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#position

        **QTextFrameFormat::Position QTextFrameFormat::position() const**

        Returns the positioning policy for frames with this frame format.

        **See also** **setPosition** ().
        """
        ...

    def rightMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#rightMargin

        **qreal QTextFrameFormat::rightMargin() const**

        Returns the width of the frame's right margin in pixels.

        **See also** **setRightMargin** ().
        """
        ...

    def setBorder(self, border: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setBorder

        **void QTextFrameFormat::setBorder(qreal width )**

        Sets the **width** (in pixels) of the frame's border.

        **See also** **border** ().
        """
        ...

    def setBorderBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setBorderBrush

        **void QTextFrameFormat::setBorderBrush(const QBrush & brush )**

        Sets the **brush** used for the frame's border.

        **See also** **borderBrush** ().
        """
        ...

    def setBorderStyle(self, style: PySide6.QtGui.QTextFrameFormat.BorderStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setBorderStyle

        **void QTextFrameFormat::setBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the **style** of the frame's border.

        **See also** **borderStyle** ().
        """
        ...

    def setBottomMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setBottomMargin

        **void QTextFrameFormat::setBottomMargin(qreal margin )**

        Sets the frame's bottom **margin** in pixels.

        **See also** **bottomMargin** ().
        """
        ...

    @overload
    def setHeight(self, height: PySide6.QtGui.QTextLength) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setHeight

        **void QTextFrameFormat::setHeight(const QTextLength & height )**

        Sets the frame's **height**.

        **See also** **height** ().
        """
        ...

    @overload
    def setHeight(self, height: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setHeight-1

        **void QTextFrameFormat::setHeight(qreal height )**

        This is an overloaded function.

        Sets the frame's **height**.
        """
        ...

    def setLeftMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setLeftMargin

        **void QTextFrameFormat::setLeftMargin(qreal margin )**

        Sets the frame's left **margin** in pixels.

        **See also** **leftMargin** ().
        """
        ...

    def setMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setMargin

        **void QTextFrameFormat::setMargin(qreal margin )**

        Sets the frame's **margin** in pixels. This method also sets the left,
        right, top and bottom margins of the frame to the same value. The
        individual margins override the general margin.

        **See also** **margin** ().
        """
        ...

    def setPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setPadding

        **void QTextFrameFormat::setPadding(qreal width )**

        Sets the **width** of the frame's internal padding in pixels.

        **See also** **padding** ().
        """
        ...

    def setPageBreakPolicy(
        self, flags: PySide6.QtGui.QTextFormat.PageBreakFlags
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setPageBreakPolicy

        **void QTextFrameFormat::setPageBreakPolicy(QTextFormat::PageBreakFlags
        policy )**

        Sets the page break policy for the frame/table to **policy**.

        **See also** **pageBreakPolicy** ().
        """
        ...

    def setPosition(self, f: PySide6.QtGui.QTextFrameFormat.Position) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setPosition

        **void QTextFrameFormat::setPosition(QTextFrameFormat::Position policy
        )**

        Sets the **policy** for positioning frames with this frame format.

        **See also** **position** ().
        """
        ...

    def setRightMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setRightMargin

        **void QTextFrameFormat::setRightMargin(qreal margin )**

        Sets the frame's right **margin** in pixels.

        **See also** **rightMargin** ().
        """
        ...

    def setTopMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setTopMargin

        **void QTextFrameFormat::setTopMargin(qreal margin )**

        Sets the frame's top **margin** in pixels.

        **See also** **topMargin** ().
        """
        ...

    @overload
    def setWidth(self, length: PySide6.QtGui.QTextLength) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setWidth

        **void QTextFrameFormat::setWidth(const QTextLength & width )**

        Sets the frame's border rectangle's **width**.

        **See also** **width** () and **QTextLength** .
        """
        ...

    @overload
    def setWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setWidth-1

        **void QTextFrameFormat::setWidth(qreal width )**

        This is an overloaded function.

        Convenience method that sets the width of the frame's border rectangle's
        width to the specified fixed **width**.
        """
        ...

    def topMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#topMargin

        **qreal QTextFrameFormat::topMargin() const**

        Returns the width of the frame's top margin in pixels.

        **See also** **setTopMargin** ().
        """
        ...

    def width(self) -> PySide6.QtGui.QTextLength:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#width

        **QTextLength QTextFrameFormat::width() const**

        Returns the width of the frame's border rectangle.

        **See also** **setWidth** () and **QTextLength** .
        """
        ...
