"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import List, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextFragment(object):
    """
    https://doc.qt.io/qt-6/qtextfragment.html

    **Detailed Description**

    A text fragment describes a piece of text that is stored with a single
    character format. Text in which the character format changes can be
    represented by sequences of text fragments with different formats.

    If the user edits the text in a fragment and introduces a different
    character format, the fragment's text will be split at each point where the
    format changes, and new fragments will be created. For example, changing the
    style of some text in the middle of a sentence will cause the fragment to be
    broken into three separate fragments: the first and third with the same
    format as before, and the second with the new style. The first fragment will
    contain the text from the beginning of the sentence, the second will contain
    the text from the middle, and the third takes the text from the end of the
    sentence.

    ![](images/qtextfragment-split.png)

    A fragment's text and character format can be obtained with the **text** ()
    and **charFormat** () functions. The **length** () function gives the length
    of the text in the fragment. **position** () gives the position in the
    document of the start of the fragment. To determine whether the fragment
    contains a particular position within the document, use the **contains** ()
    function.

    **See also** **QTextDocument**  and **Rich Text Document Structure** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#QTextFragment-1

        **QTextFragment::QTextFragment()**

        Creates a new empty text fragment.
        """
        ...

    @overload
    def __init__(self, o: PySide6.QtGui.QTextFragment) -> None:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#QTextFragment-2

        **QTextFragment::QTextFragment(const QTextFragment & other )**

        Copies the content (text and format) of the **other** text fragment to
        this text fragment.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def charFormat(self) -> PySide6.QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#charFormat

        **QTextCharFormat QTextFragment::charFormat() const**

        Returns the text fragment's character format.

        **See also** **text** ().
        """
        ...

    def charFormatIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#charFormatIndex

        **int QTextFragment::charFormatIndex() const**

        Returns an index into the document's internal list of character formats
        for the text fragment's character format.

        **See also** **QTextDocument::allFormats** ().
        """
        ...

    def contains(self, position: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#contains

        **bool QTextFragment::contains(int position ) const**

        Returns `true` if the text fragment contains the text at the given
        **position** in the document; otherwise returns `false`.
        """
        ...

    def glyphRuns(
        self, from_: int = ..., length: int = ...
    ) -> List[PySide6.QtGui.QGlyphRun]:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#glyphRuns

        **QList<QGlyphRun> QTextFragment::glyphRuns(int pos = -1, int len = -1)
        const**

        Returns the glyphs corresponding to **len** characters of this text
        fragment starting at position **pos**. The positions of the glyphs are
        relative to the position of the **QTextBlock** 's layout.

        If **pos** is less than zero, it will default to the start of the
        **QTextFragment** . If **len** is less than zero, it will default to the
        length of the fragment.

        **See also** **QGlyphRun** , **QTextBlock::layout** (),
        **QTextLayout::position** (), and **QPainter::drawGlyphRun** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#isValid

        **bool QTextFragment::isValid() const**

        Returns `true` if this is a valid text fragment (i.e. has a valid
        position in a document); otherwise returns `false`.
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#length

        **int QTextFragment::length() const**

        Returns the number of characters in the text fragment.

        **See also** **text** ().
        """
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#position

        **int QTextFragment::position() const**

        Returns the position of this text fragment in the document.
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextfragment.html#text

        **QString QTextFragment::text() const**

        Returns the text fragment's as plain text.

        **See also** **length** () and **charFormat** ().
        """
        ...
