"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import List, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextDocumentWriter(object):
    """
    https://doc.qt.io/qt-6/qtextdocumentwriter.html

    **Detailed Description**

    To write a document, construct a QTextDocumentWriter object with either a
    file name or a device object, and specify the document format to be written.
    You can construct a writer and set the format using **setFormat** () later.

    Call **write** () to write the document to the device. If the document is
    successfully written, this function returns `true`. However, if an error
    occurs when writing the document, it will return false.

    Call **supportedDocumentFormats** () for a list of formats that
    QTextDocumentWriter can write.

    Since the capabilities of the supported output formats vary considerably,
    the writer simply outputs the appropriate subset of objects for each format.
    This typically includes the formatted text and images contained in a
    document.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#QTextDocumentWriter

        **QTextDocumentWriter::QTextDocumentWriter()**

        Constructs an empty QTextDocumentWriter object. Before writing, you must
        call **setFormat** () to set a document format, then **setDevice** () or
        **setFileName** ().
        """
        ...

    @overload
    def __init__(
        self,
        device: PySide6.QtCore.QIODevice,
        format: Union[PySide6.QtCore.QByteArray, bytes],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#QTextDocumentWriter-1

        **QTextDocumentWriter::QTextDocumentWriter(QIODevice * device , const
        QByteArray & format )**

        Constructs a QTextDocumentWriter object to write to the given **device**
        in the document format specified by **format**.
        """
        ...

    @overload
    def __init__(
        self, fileName: str, format: Union[PySide6.QtCore.QByteArray, bytes] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#QTextDocumentWriter-2

        **QTextDocumentWriter::QTextDocumentWriter(const QString & fileName ,
        const QByteArray & format = QByteArray())**

        Constructs an QTextDocumentWriter object that will write to a file with
        the name **fileName** , using the document format specified by
        **format**. If **format** is not provided, QTextDocumentWriter will
        detect the document format by inspecting the extension of **fileName**.
        """
        ...

    def device(self) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#device

        **QIODevice *QTextDocumentWriter::device() const**

        Returns the device currently assigned, or `nullptr` if no device has
        been assigned.

        **See also** **setDevice** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#fileName

        **QString QTextDocumentWriter::fileName() const**

        If the currently assigned device is a **QFile** , or if **setFileName**
        () has been called, this function returns the name of the file to be
        written to. In all other cases, it returns an empty string.

        **See also** **setFileName** () and **setDevice** ().
        """
        ...

    def format(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#format

        **QByteArray QTextDocumentWriter::format() const**

        Returns the format used for writing documents.

        **See also** **setFormat** ().
        """
        ...

    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#setDevice

        **void QTextDocumentWriter::setDevice(QIODevice * device )**

        Sets the writer's device to the **device** specified. If a device has
        already been set, the old device is removed but otherwise left
        unchanged.

        If the device is not already open, **QTextDocumentWriter**  will attempt
        to open the device in **WriteOnly**  mode by calling open().

        **Note:** This will not work for certain devices, such as **QProcess** ,
        **QTcpSocket**  and **QUdpSocket** , where some configuration is
        required before the device can be opened.

        **See also** **device** () and **setFileName** ().
        """
        ...

    def setFileName(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#setFileName

        **void QTextDocumentWriter::setFileName(const QString & fileName )**

        Sets the name of the file to be written to **fileName**. Internally,
        **QTextDocumentWriter**  will create a **QFile**  and open it in
        **WriteOnly**  mode, and use this file when writing the document.

        **See also** **fileName** () and **setDevice** ().
        """
        ...

    def setFormat(self, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#setFormat

        **void QTextDocumentWriter::setFormat(const QByteArray & format )**

        Sets the format used to write documents to the **format** specified.
        **format** is a case insensitive text string. For example:

        **QTextDocumentWriter**  writer;
                    writer.setFormat("odf"); //
        same as writer.setFormat("ODF");

        You can call **supportedDocumentFormats** () for the full list of
        formats **QTextDocumentWriter**  supports.

        **See also** **format** ().
        """
        ...

    @staticmethod
    def supportedDocumentFormats() -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#supportedDocumentFormats

        **[static] QList<QByteArray>
        QTextDocumentWriter::supportedDocumentFormats()**

        Returns the list of document formats supported by
        **QTextDocumentWriter** .

        By default, Qt can write the following formats:

        FormatDescription
        plaintextPlain text
        HTMLHyperText Markup Language
        markdownMarkdown (CommonMark or GitHub dialects)
        ODFOpenDocument
        Format

        **See also** **setFormat** ().
        """
        ...

    @overload
    def write(self, document: PySide6.QtGui.QTextDocument) -> bool:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#write

        **bool QTextDocumentWriter::write(const QTextDocument * document )**

        Writes the given **document** to the assigned device or file and returns
        `true` if successful; otherwise returns `false`.
        """
        ...

    @overload
    def write(self, fragment: PySide6.QtGui.QTextDocumentFragment) -> bool:
        """
        https://doc.qt.io/qt-6/qtextdocumentwriter.html#write-1

        **bool QTextDocumentWriter::write(const QTextDocumentFragment & fragment
        )**

        Writes the document fragment specified by **fragment** to the assigned
        device or file and returns `true` if successful; otherwise returns
        `false`.
        """
        ...
