"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextDocumentFragment(object):
    """
    https://doc.qt.io/qt-6/qtextdocumentfragment.html

    **Detailed Description**

    A QTextDocumentFragment is a fragment of rich text, that can be inserted
    into a **QTextDocument** . A document fragment can be created from a
    **QTextDocument** , from a **QTextCursor** 's selection, or from another
    document fragment. Document fragments can also be created by the static
    functions, **fromPlainText** () and **fromHtml** ().

    The contents of a document fragment can be obtained as plain text by using
    the **toPlainText** () function, or it can be obtained as HTML with
    **toHtml** ().
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentfragment.html#QTextDocumentFragment

        **QTextDocumentFragment::QTextDocumentFragment()**

        Constructs an empty QTextDocumentFragment.

        **See also** **isEmpty** ().
        """
        ...

    @overload
    def __init__(self, document: PySide6.QtGui.QTextDocument) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentfragment.html#QTextDocumentFragment-
        1

        **QTextDocumentFragment::QTextDocumentFragment(const QTextDocument *
        document )**

        Converts the given **document** into a QTextDocumentFragment. Note that
        the QTextDocumentFragment only stores the document contents, not meta
        information like the document's title.
        """
        ...

    @overload
    def __init__(self, range: PySide6.QtGui.QTextCursor) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentfragment.html#QTextDocumentFragment-
        2

        **QTextDocumentFragment::QTextDocumentFragment(const QTextCursor &
        cursor )**

        Creates a QTextDocumentFragment from the **cursor** 's selection. If the
        cursor doesn't have a selection, the created fragment is empty.

        **See also** **isEmpty** () and **QTextCursor::selection** ().
        """
        ...

    @overload
    def __init__(self, rhs: PySide6.QtGui.QTextDocumentFragment) -> None:
        """
        https://doc.qt.io/qt-6/qtextdocumentfragment.html#QTextDocumentFragment-
        3

        **QTextDocumentFragment::QTextDocumentFragment(const
        QTextDocumentFragment & other )**

        Copy constructor. Creates a copy of the **other** fragment.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def fromHtml(
        html: str, resourceProvider: Optional[PySide6.QtGui.QTextDocument] = ...
    ) -> PySide6.QtGui.QTextDocumentFragment:
        """
        https://doc.qt.io/qt-6/qtextdocumentfragment.html#fromHtml

        **[static] QTextDocumentFragment QTextDocumentFragment::fromHtml(const
        QString & text , const QTextDocument * resourceProvider = nullptr)**

        Returns a **QTextDocumentFragment**  based on the arbitrary piece of
        HTML in the given **text**. The formatting is preserved as much as
        possible; for example, "<b>bold</b>" will become a document fragment
        with the text "bold" with a bold character format.

        If the provided HTML contains references to external resources such as
        imported style sheets, then they will be loaded through the
        **resourceProvider**.
        """
        ...

    @staticmethod
    def fromPlainText(plainText: str) -> PySide6.QtGui.QTextDocumentFragment:
        """
        https://doc.qt.io/qt-6/qtextdocumentfragment.html#fromPlainText

        **[static] QTextDocumentFragment
        QTextDocumentFragment::fromPlainText(const QString & plainText )**

        Returns a document fragment that contains the given **plainText**.

        When inserting such a fragment into a **QTextDocument**  the current
        char format of the **QTextCursor**  used for insertion is used as format
        for the text.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextdocumentfragment.html#isEmpty

        **bool QTextDocumentFragment::isEmpty() const**

        Returns `true` if the fragment is empty; otherwise returns `false`.
        """
        ...

    def toHtml(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocumentfragment.html#toHtml

        **QString QTextDocumentFragment::toHtml() const**

        Returns the contents of the document fragment as HTML.

        **See also** **toPlainText** () and **QTextDocument::toHtml** ().
        """
        ...

    def toPlainText(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextdocumentfragment.html#toPlainText

        **QString QTextDocumentFragment::toPlainText() const**

        Returns the document fragment's text as plain text (i.e. with no
        formatting information).

        **See also** **toHtml** ().
        """
        ...
