"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextCursor(object):
    """
    https://doc.qt.io/qt-6/qtextcursor.html

    **Detailed Description**

    Text cursors are objects that are used to access and modify the contents and
    underlying structure of text documents via a programming interface that
    mimics the behavior of a cursor in a text editor. QTextCursor contains
    information about both the cursor's position within a **QTextDocument**  and
    any selection that it has made.

    QTextCursor is modeled on the way a text cursor behaves in a text editor,
    providing a programmatic means of performing standard actions through the
    user interface. A document can be thought of as a single string of
    characters. The cursor's current **position** () then is always either
    **between** two consecutive characters in the string, or else **before** the
    very first character or **after** the very last character in the string.
    Documents can also contain tables, lists, images, and other objects in
    addition to text but, from the developer's point of view, the document can
    be treated as one long string. Some portions of that string can be
    considered to lie within particular blocks (e.g. paragraphs), or within a
    table's cell, or a list's item, or other structural elements. When we refer
    to "current character" we mean the character immediately **before** the
    cursor **position** () in the document. Similarly, the "current block" is
    the block that contains the cursor **position** ().

    A QTextCursor also has an **anchor** () position. The text that is between
    the **anchor** () and the **position** () is the selection. If **anchor** ()
    == **position** () there is no selection.

    The cursor position can be changed programmatically using **setPosition** ()
    and **movePosition** (); the latter can also be used to select text. For
    selections see **selectionStart** (), **selectionEnd** (), **hasSelection**
    (), **clearSelection** (), and **removeSelectedText** ().

    If the **position** () is at the start of a block, **atBlockStart** ()
    returns `true`; and if it is at the end of a block, **atBlockEnd** ()
    returns true. The format of the current character is returned by
    **charFormat** (), and the format of the current block is returned by
    **blockFormat** ().

    Formatting can be applied to the current text document using the
    **setCharFormat** (), **mergeCharFormat** (), **setBlockFormat** () and
    **mergeBlockFormat** () functions. The 'set' functions will replace the
    cursor's current character or block format, while the 'merge' functions add
    the given format properties to the cursor's current format. If the cursor
    has a selection, the given format is applied to the current selection. Note
    that when only a part of a block is selected, the block format is applied to
    the entire block. The text at the current character position can be turned
    into a list using **createList** ().

    Deletions can be achieved using **deleteChar** (), **deletePreviousChar**
    (), and **removeSelectedText** ().

    Text strings can be inserted into the document with the **insertText** ()
    function, blocks (representing new paragraphs) can be inserted with
    **insertBlock** ().

    Existing fragments of text can be inserted with **insertFragment** () but,
    if you want to insert pieces of text in various formats, it is usually still
    easier to use **insertText** () and supply a character format.

    Various types of higher-level structure can also be inserted into the
    document with the cursor:

    * Lists are ordered sequences of block elements that are decorated with
    bullet points or symbols. These are inserted in a specified format with
    **insertList** ().
      * Tables are inserted with the **insertTable** ()
    function, and can be given an optional format. These contain an array of
    cells that can be traversed using the cursor.
      * Inline images are inserted
    with **insertImage** (). The image to be used can be specified in an image
    format, or by name.
      * Frames are inserted by calling **insertFrame** ()
    with a specified format.

    Actions can be grouped (i.e. treated as a single action for undo/redo) using
    **beginEditBlock** () and **endEditBlock** ().

    Cursor movements are limited to valid cursor positions. In Latin writing
    this is between any two consecutive characters in the text, before the first
    character, or after the last character. In some other writing systems cursor
    movements are limited to "clusters" (e.g. a syllable in Devanagari, or a
    base letter plus diacritics). Functions such as **movePosition** () and
    **deleteChar** () limit cursor movement to these valid positions.

    **See also** **Rich Text Processing** .
    """

    MoveAnchor: QTextCursor.MoveMode = ...
    KeepAnchor: QTextCursor.MoveMode = ...
    NoMove: QTextCursor.MoveOperation = ...
    Start: QTextCursor.MoveOperation = ...
    Up: QTextCursor.MoveOperation = ...
    StartOfLine: QTextCursor.MoveOperation = ...
    StartOfBlock: QTextCursor.MoveOperation = ...
    StartOfWord: QTextCursor.MoveOperation = ...
    PreviousBlock: QTextCursor.MoveOperation = ...
    PreviousCharacter: QTextCursor.MoveOperation = ...
    PreviousWord: QTextCursor.MoveOperation = ...
    Left: QTextCursor.MoveOperation = ...
    WordLeft: QTextCursor.MoveOperation = ...
    End: QTextCursor.MoveOperation = ...
    Down: QTextCursor.MoveOperation = ...
    EndOfLine: QTextCursor.MoveOperation = ...
    EndOfWord: QTextCursor.MoveOperation = ...
    EndOfBlock: QTextCursor.MoveOperation = ...
    NextBlock: QTextCursor.MoveOperation = ...
    NextCharacter: QTextCursor.MoveOperation = ...
    NextWord: QTextCursor.MoveOperation = ...
    Right: QTextCursor.MoveOperation = ...
    WordRight: QTextCursor.MoveOperation = ...
    NextCell: QTextCursor.MoveOperation = ...
    PreviousCell: QTextCursor.MoveOperation = ...
    NextRow: QTextCursor.MoveOperation = ...
    PreviousRow: QTextCursor.MoveOperation = ...
    WordUnderCursor: QTextCursor.SelectionType = ...
    LineUnderCursor: QTextCursor.SelectionType = ...
    BlockUnderCursor: QTextCursor.SelectionType = ...
    Document: QTextCursor.SelectionType = ...

    class MoveMode(Enum):
        MoveAnchor: QTextCursor.MoveMode = ...
        KeepAnchor: QTextCursor.MoveMode = ...

    class MoveOperation(Enum):
        NoMove: QTextCursor.MoveOperation = ...
        Start: QTextCursor.MoveOperation = ...
        Up: QTextCursor.MoveOperation = ...
        StartOfLine: QTextCursor.MoveOperation = ...
        StartOfBlock: QTextCursor.MoveOperation = ...
        StartOfWord: QTextCursor.MoveOperation = ...
        PreviousBlock: QTextCursor.MoveOperation = ...
        PreviousCharacter: QTextCursor.MoveOperation = ...
        PreviousWord: QTextCursor.MoveOperation = ...
        Left: QTextCursor.MoveOperation = ...
        WordLeft: QTextCursor.MoveOperation = ...
        End: QTextCursor.MoveOperation = ...
        Down: QTextCursor.MoveOperation = ...
        EndOfLine: QTextCursor.MoveOperation = ...
        EndOfWord: QTextCursor.MoveOperation = ...
        EndOfBlock: QTextCursor.MoveOperation = ...
        NextBlock: QTextCursor.MoveOperation = ...
        NextCharacter: QTextCursor.MoveOperation = ...
        NextWord: QTextCursor.MoveOperation = ...
        Right: QTextCursor.MoveOperation = ...
        WordRight: QTextCursor.MoveOperation = ...
        NextCell: QTextCursor.MoveOperation = ...
        PreviousCell: QTextCursor.MoveOperation = ...
        NextRow: QTextCursor.MoveOperation = ...
        PreviousRow: QTextCursor.MoveOperation = ...

    class SelectionType(Enum):
        WordUnderCursor: QTextCursor.SelectionType = ...
        LineUnderCursor: QTextCursor.SelectionType = ...
        BlockUnderCursor: QTextCursor.SelectionType = ...
        Document: QTextCursor.SelectionType = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#QTextCursor

        **QTextCursor::QTextCursor()**

        Constructs a null cursor.
        """
        ...

    @overload
    def __init__(self, block: PySide6.QtGui.QTextBlock) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#QTextCursor-1

        **QTextCursor::QTextCursor(QTextDocument * document )**

        Constructs a cursor pointing to the beginning of the **document**.
        """
        ...

    @overload
    def __init__(self, cursor: PySide6.QtGui.QTextCursor) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#QTextCursor-2

        **QTextCursor::QTextCursor(QTextFrame * frame )**

        Constructs a cursor pointing to the beginning of the **frame**.
        """
        ...

    @overload
    def __init__(self, document: PySide6.QtGui.QTextDocument) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#QTextCursor-3

        **QTextCursor::QTextCursor(const QTextBlock & block )**

        Constructs a cursor pointing to the beginning of the **block**.
        """
        ...

    @overload
    def __init__(self, frame: PySide6.QtGui.QTextFrame) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#QTextCursor-4

        **QTextCursor::QTextCursor(const QTextCursor & cursor )**

        Constructs a new cursor that is a copy of **cursor**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def anchor(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#anchor

        **int QTextCursor::anchor() const**

        Returns the anchor position; this is the same as **position** () unless
        there is a selection in which case **position** () marks one end of the
        selection and anchor() marks the other end. Just like the cursor
        position, the anchor position is between characters.

        **See also** **position** (), **setPosition** (), **movePosition** (),
        **selectionStart** (), and **selectionEnd** ().
        """
        ...

    def atBlockEnd(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#atBlockEnd

        **bool QTextCursor::atBlockEnd() const**

        Returns `true` if the cursor is at the end of a block; otherwise returns
        `false`.

        **See also** **atBlockStart** () and **atEnd** ().
        """
        ...

    def atBlockStart(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#atBlockStart

        **bool QTextCursor::atBlockStart() const**

        Returns `true` if the cursor is at the start of a block; otherwise
        returns `false`.

        **See also** **atBlockEnd** () and **atStart** ().
        """
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#atEnd

        **bool QTextCursor::atEnd() const**

        Returns `true` if the cursor is at the end of the document; otherwise
        returns `false`.

        **See also** **atStart** () and **atBlockEnd** ().
        """
        ...

    def atStart(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#atStart

        **bool QTextCursor::atStart() const**

        Returns `true` if the cursor is at the start of the document; otherwise
        returns `false`.

        **See also** **atBlockStart** () and **atEnd** ().
        """
        ...

    def beginEditBlock(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#beginEditBlock

        **void QTextCursor::beginEditBlock()**

        Indicates the start of a block of editing operations on the document
        that should appear as a single operation from an undo/redo point of
        view.

        For example:

        **QTextCursor**  cursor(textDocument);
            cursor.beginEditBlock();
        cursor.insertText("Hello");
            cursor.insertText("World");
        cursor.endEditBlock();

            textDocument->undo();

        The call to undo() will cause both insertions to be undone, causing both
        "World" and "Hello" to be removed.

        It is possible to nest calls to beginEditBlock and **endEditBlock** .
        The top-most pair will determine the scope of the undo/redo operation.

        **See also** **endEditBlock** ().
        """
        ...

    def block(self) -> PySide6.QtGui.QTextBlock:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#block

        **QTextBlock QTextCursor::block() const**

        Returns the block that contains the cursor.
        """
        ...

    def blockCharFormat(self) -> PySide6.QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#blockCharFormat

        **QTextCharFormat QTextCursor::blockCharFormat() const**

        Returns the block character format of the block the cursor is in.

        The block char format is the format used when inserting text at the
        beginning of an empty block.

        **See also** **setBlockCharFormat** ().
        """
        ...

    def blockFormat(self) -> PySide6.QtGui.QTextBlockFormat:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#blockFormat

        **QTextBlockFormat QTextCursor::blockFormat() const**

        Returns the block format of the block the cursor is in.

        **See also** **setBlockFormat** () and **charFormat** ().
        """
        ...

    def blockNumber(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#blockNumber

        **int QTextCursor::blockNumber() const**

        Returns the number of the block the cursor is in, or 0 if the cursor is
        invalid.

        Note that this function only makes sense in documents without complex
        objects such as tables or frames.
        """
        ...

    def charFormat(self) -> PySide6.QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#charFormat

        **QTextCharFormat QTextCursor::charFormat() const**

        Returns the format of the character immediately before the cursor
        **position** (). If the cursor is positioned at the beginning of a text
        block that is not empty then the format of the character immediately
        after the cursor is returned.

        **See also** **setCharFormat** (), **insertText** (), and
        **blockFormat** ().
        """
        ...

    def clearSelection(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#clearSelection

        **void QTextCursor::clearSelection()**

        Clears the current selection by setting the anchor to the cursor
        position.

        Note that it does **not** delete the text of the selection.

        **See also** **removeSelectedText** () and **hasSelection** ().
        """
        ...

    def columnNumber(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#columnNumber

        **int QTextCursor::columnNumber() const**

        Returns the position of the cursor within its containing line.

        Note that this is the column number relative to a wrapped line, not
        relative to the block (i.e. the paragraph).

        You probably want to call **positionInBlock** () instead.

        **See also** **positionInBlock** ().
        """
        ...

    @overload
    def createList(
        self, format: PySide6.QtGui.QTextListFormat
    ) -> PySide6.QtGui.QTextList:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#createList

        **QTextList *QTextCursor::createList(const QTextListFormat & format )**

        Creates and returns a new list with the given **format** , and makes the
        current paragraph the cursor is in the first list item.

        **See also** **insertList** () and **currentList** ().
        """
        ...

    @overload
    def createList(
        self, style: PySide6.QtGui.QTextListFormat.Style
    ) -> PySide6.QtGui.QTextList:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#createList-1

        **QTextList *QTextCursor::createList(QTextListFormat::Style style )**

        This is an overloaded function.

        Creates and returns a new list with the given **style** , making the
        cursor's current paragraph the first list item.

        The style to be used is defined by the **QTextListFormat::Style**  enum.

        **See also** **insertList** () and **currentList** ().
        """
        ...

    def currentFrame(self) -> PySide6.QtGui.QTextFrame:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#currentFrame

        **QTextFrame *QTextCursor::currentFrame() const**

        Returns a pointer to the current frame. Returns `nullptr` if the cursor
        is invalid.

        **See also** **insertFrame** ().
        """
        ...

    def currentList(self) -> PySide6.QtGui.QTextList:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#currentList

        **QTextList *QTextCursor::currentList() const**

        Returns the current list if the cursor **position** () is inside a block
        that is part of a list; otherwise returns `nullptr`.

        **See also** **insertList** () and **createList** ().
        """
        ...

    def currentTable(self) -> PySide6.QtGui.QTextTable:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#currentTable

        **QTextTable *QTextCursor::currentTable() const**

        Returns a pointer to the current table if the cursor **position** () is
        inside a block that is part of a table; otherwise returns `nullptr`.

        **See also** **insertTable** ().
        """
        ...

    def deleteChar(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#deleteChar

        **void QTextCursor::deleteChar()**

        If there is no selected text, deletes the character **at** the current
        cursor position; otherwise deletes the selected text.

        **See also** **deletePreviousChar** (), **hasSelection** (), and
        **clearSelection** ().
        """
        ...

    def deletePreviousChar(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#deletePreviousChar

        **void QTextCursor::deletePreviousChar()**

        If there is no selected text, deletes the character **before** the
        current cursor position; otherwise deletes the selected text.

        **See also** **deleteChar** (), **hasSelection** (), and
        **clearSelection** ().
        """
        ...

    def document(self) -> PySide6.QtGui.QTextDocument:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#document

        **QTextDocument *QTextCursor::document() const**

        Returns the document this cursor is associated with.
        """
        ...

    def endEditBlock(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#endEditBlock

        **void QTextCursor::endEditBlock()**

        Indicates the end of a block of editing operations on the document that
        should appear as a single operation from an undo/redo point of view.

        **See also** **beginEditBlock** ().
        """
        ...

    def hasComplexSelection(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#hasComplexSelection

        **bool QTextCursor::hasComplexSelection() const**

        Returns `true` if the cursor contains a selection that is not simply a
        range from **selectionStart** () to **selectionEnd** (); otherwise
        returns `false`.

        Complex selections are ones that span at least two cells in a table;
        their extent is specified by **selectedTableCells** ().
        """
        ...

    def hasSelection(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#hasSelection

        **bool QTextCursor::hasSelection() const**

        Returns `true` if the cursor contains a selection; otherwise returns
        `false`.
        """
        ...

    @overload
    def insertBlock(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertBlock

        **void QTextCursor::insertBlock()**

        Inserts a new empty block at the cursor **position** () with the current
        **blockFormat** () and **charFormat** ().

        **See also** **setBlockFormat** ().
        """
        ...

    @overload
    def insertBlock(self, format: PySide6.QtGui.QTextBlockFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertBlock-1

        **void QTextCursor::insertBlock(const QTextBlockFormat & format )**

        This is an overloaded function.

        Inserts a new empty block at the cursor **position** () with block
        format **format** and the current **charFormat** () as block char
        format.

        **See also** **setBlockFormat** ().
        """
        ...

    @overload
    def insertBlock(
        self,
        format: PySide6.QtGui.QTextBlockFormat,
        charFormat: PySide6.QtGui.QTextCharFormat,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertBlock-2

        **void QTextCursor::insertBlock(const QTextBlockFormat & format , const
        QTextCharFormat & charFormat )**

        This is an overloaded function.

        Inserts a new empty block at the cursor **position** () with block
        format **format** and **charFormat** as block char format.

        **See also** **setBlockFormat** ().
        """
        ...

    def insertFragment(self, fragment: PySide6.QtGui.QTextDocumentFragment) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertFragment

        **void QTextCursor::insertFragment(const QTextDocumentFragment &
        fragment )**

        Inserts the text **fragment** at the current **position** ().
        """
        ...

    def insertFrame(
        self, format: PySide6.QtGui.QTextFrameFormat
    ) -> PySide6.QtGui.QTextFrame:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertFrame

        **QTextFrame *QTextCursor::insertFrame(const QTextFrameFormat & format
        )**

        Inserts a frame with the given **format** at the current cursor
        **position** (), moves the cursor **position** () inside the frame, and
        returns the frame.

        If the cursor holds a selection, the whole selection is moved inside the
        frame.

        **See also** **hasSelection** ().
        """
        ...

    def insertHtml(self, html: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertHtml

        **void QTextCursor::insertHtml(const QString & html )**

        Inserts the text **html** at the current **position** (). The text is
        interpreted as HTML.

        **Note:** When using this function with a style sheet, the style sheet
        will only apply to the current block in the document. In order to apply
        a style sheet throughout a document, use
        **QTextDocument::setDefaultStyleSheet** () instead.
        """
        ...

    @overload
    def insertImage(self, format: PySide6.QtGui.QTextImageFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertImage

        **void QTextCursor::insertImage(const QTextImageFormat & format )**

        Inserts the image defined by **format** at the current **position** ().
        """
        ...

    @overload
    def insertImage(
        self,
        format: PySide6.QtGui.QTextImageFormat,
        alignment: PySide6.QtGui.QTextFrameFormat.Position,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertImage-1

        **void QTextCursor::insertImage(const QTextImageFormat & format ,
        QTextFrameFormat::Position alignment )**

        This is an overloaded function.

        Inserts the image defined by the given **format** at the cursor's
        current position with the specified **alignment**.

        **See also** **position** ().
        """
        ...

    @overload
    def insertImage(
        self, image: Union[PySide6.QtGui.QImage, str], name: str = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertImage-2

        **void QTextCursor::insertImage(const QString & name )**

        This is an overloaded function.

        Convenience method for inserting the image with the given **name** at
        the current **position** ().

        **QImage**  img;
            textDocument->addResource(**QTextDocument**
        ::ImageResource, **QUrl** ("myimage"), img);
        cursor.insertImage("myimage");
        """
        ...

    @overload
    def insertImage(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertImage-3

        **void QTextCursor::insertImage(const QImage & image , const QString &
        name = QString())**

        This is an overloaded function.

        Convenience function for inserting the given **image** with an optional
        **name** at the current **position** ().
        """
        ...

    @overload
    def insertList(
        self, format: PySide6.QtGui.QTextListFormat
    ) -> PySide6.QtGui.QTextList:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertList

        **QTextList *QTextCursor::insertList(const QTextListFormat & format )**

        Inserts a new block at the current position and makes it the first list
        item of a newly created list with the given **format**. Returns the
        created list.

        **See also** **currentList** (), **createList** (), and **insertBlock**
        ().
        """
        ...

    @overload
    def insertList(
        self, style: PySide6.QtGui.QTextListFormat.Style
    ) -> PySide6.QtGui.QTextList:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertList-1

        **QTextList *QTextCursor::insertList(QTextListFormat::Style style )**

        This is an overloaded function.

        Inserts a new block at the current position and makes it the first list
        item of a newly created list with the given **style**. Returns the
        created list.

        **See also** **currentList** (), **createList** (), and **insertBlock**
        ().
        """
        ...

    @overload
    def insertTable(self, rows: int, cols: int) -> PySide6.QtGui.QTextTable:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertTable

        **QTextTable *QTextCursor::insertTable(int rows , int columns , const
        QTextTableFormat & format )**

        Creates a new table with the given number of **rows** and **columns** in
        the specified **format** , inserts it at the current cursor **position**
        () in the document, and returns the table object. The cursor is moved to
        the beginning of the first cell.

        There must be at least one row and one column in the table.

        **See also** **currentTable** ().
        """
        ...

    @overload
    def insertTable(
        self, rows: int, cols: int, format: PySide6.QtGui.QTextTableFormat
    ) -> PySide6.QtGui.QTextTable:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertTable-1

        **QTextTable *QTextCursor::insertTable(int rows , int columns )**

        This is an overloaded function.

        Creates a new table with the given number of **rows** and **columns** ,
        inserts it at the current cursor **position** () in the document, and
        returns the table object. The cursor is moved to the beginning of the
        first cell.

        There must be at least one row and one column in the table.

        **See also** **currentTable** ().
        """
        ...

    @overload
    def insertText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertText

        **void QTextCursor::insertText(const QString & text )**

        Inserts **text** at the current position, using the current character
        format.

        If there is a selection, the selection is deleted and replaced by
        **text** , for example:

        cursor.clearSelection();
            cursor.movePosition(**QTextCursor**
        ::NextWord, **QTextCursor** ::KeepAnchor);
            cursor.insertText("Hello
        World");

        This clears any existing selection, selects the word at the cursor (i.e.
        from **position** () forward), and replaces the selection with the
        phrase "Hello World".

        Any ASCII linefeed characters (\\n) in the inserted text are transformed
        into unicode block separators, corresponding to **insertBlock** ()
        calls.

        **See also** **charFormat** () and **hasSelection** ().
        """
        ...

    @overload
    def insertText(self, text: str, format: PySide6.QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#insertText-1

        **void QTextCursor::insertText(const QString & text , const
        QTextCharFormat & format )**

        This is an overloaded function.

        Inserts **text** at the current position with the given **format**.
        """
        ...

    def isCopyOf(self, other: PySide6.QtGui.QTextCursor) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#isCopyOf

        **bool QTextCursor::isCopyOf(const QTextCursor & other ) const**

        Returns `true` if this cursor and **other** are copies of each other,
        i.e. one of them was created as a copy of the other and neither has
        moved since. This is much stricter than equality.

        **See also** **operator=** () and **operator==** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#isNull

        **bool QTextCursor::isNull() const**

        Returns `true` if the cursor is null; otherwise returns `false`. A null
        cursor is created by the default constructor.
        """
        ...

    def joinPreviousEditBlock(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#joinPreviousEditBlock

        **void QTextCursor::joinPreviousEditBlock()**

        Like **beginEditBlock** () indicates the start of a block of editing
        operations that should appear as a single operation for undo/redo.
        However unlike **beginEditBlock** () it does not start a new block but
        reverses the previous call to **endEditBlock** () and therefore makes
        following operations part of the previous edit block created.

        For example:

        **QTextCursor**  cursor(textDocument);
            cursor.beginEditBlock();
        cursor.insertText("Hello");
            cursor.insertText("World");
        cursor.endEditBlock();

            // ...
        cursor.joinPreviousEditBlock();
            cursor.insertText("Hey");
        cursor.endEditBlock();

            textDocument->undo();

        The call to undo() will cause all three insertions to be undone.

        **See also** **beginEditBlock** () and **endEditBlock** ().
        """
        ...

    def keepPositionOnInsert(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#keepPositionOnInsert

        **bool QTextCursor::keepPositionOnInsert() const**

        Returns whether the cursor should keep its current position when text
        gets inserted at the position of the cursor.

        The default is false;

        **See also** **setKeepPositionOnInsert** ().
        """
        ...

    def mergeBlockCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#mergeBlockCharFormat

        **void QTextCursor::mergeBlockCharFormat(const QTextCharFormat &
        modifier )**

        Modifies the block char format of the current block (or all blocks that
        are contained in the selection) with the block format specified by
        **modifier**.

        **See also** **setBlockCharFormat** ().
        """
        ...

    def mergeBlockFormat(self, modifier: PySide6.QtGui.QTextBlockFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#mergeBlockFormat

        **void QTextCursor::mergeBlockFormat(const QTextBlockFormat & modifier
        )**

        Modifies the block format of the current block (or all blocks that are
        contained in the selection) with the block format specified by
        **modifier**.

        **See also** **setBlockFormat** () and **blockFormat** ().
        """
        ...

    def mergeCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#mergeCharFormat

        **void QTextCursor::mergeCharFormat(const QTextCharFormat & modifier )**

        Merges the cursor's current character format with the properties
        described by format **modifier**. If the cursor has a selection, this
        function applies all the properties set in **modifier** to all the
        character formats that are part of the selection.

        **See also** **hasSelection** () and **setCharFormat** ().
        """
        ...

    def movePosition(
        self,
        op: PySide6.QtGui.QTextCursor.MoveOperation,
        arg__2: PySide6.QtGui.QTextCursor.MoveMode = ...,
        n: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#movePosition

        **bool QTextCursor::movePosition(QTextCursor::MoveOperation operation ,
        QTextCursor::MoveMode mode = MoveAnchor, int n = 1)**

        Moves the cursor by performing the given **operation** **n** times,
        using the specified **mode** , and returns `true` if all operations were
        completed successfully; otherwise returns `false`.

        For example, if this function is repeatedly used to seek to the end of
        the next word, it will eventually fail when the end of the document is
        reached.

        By default, the move operation is performed once ( **n** = 1).

        If **mode** is `KeepAnchor`, the cursor selects the text it moves over.
        This is the same effect that the user achieves when they hold down the
        Shift key and move the cursor with the cursor keys.

        **See also** **setVisualNavigation** ().
        """
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#position

        **int QTextCursor::position() const**

        Returns the absolute position of the cursor within the document. The
        cursor is positioned between characters.

        **Note:** The "characters" in this case refer to the string of **QChar**
        objects, i.e. 16-bit Unicode characters, and the position is considered
        an index into this string. This does not necessarily correspond to
        individual graphemes in the writing system, as a single grapheme may be
        represented by multiple Unicode characters, such as in the case of
        surrogate pairs, linguistic ligatures or diacritics.

        **See also** **setPosition** (), **movePosition** (), **anchor** (), and
        **positionInBlock** ().
        """
        ...

    def positionInBlock(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#positionInBlock

        **int QTextCursor::positionInBlock() const**

        Returns the relative position of the cursor within the block. The cursor
        is positioned between characters.

        This is equivalent to `position() - block().position()`.

        **Note:** The "characters" in this case refer to the string of **QChar**
        objects, i.e. 16-bit Unicode characters, and the position is considered
        an index into this string. This does not necessarily correspond to
        individual graphemes in the writing system, as a single grapheme may be
        represented by multiple Unicode characters, such as in the case of
        surrogate pairs, linguistic ligatures or diacritics.

        **See also** **position** ().
        """
        ...

    def removeSelectedText(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#removeSelectedText

        **void QTextCursor::removeSelectedText()**

        If there is a selection, its content is deleted; otherwise does nothing.

        **See also** **hasSelection** ().
        """
        ...

    def select(self, selection: PySide6.QtGui.QTextCursor.SelectionType) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#select

        **void QTextCursor::select(QTextCursor::SelectionType selection )**

        Selects text in the document according to the given **selection**.
        """
        ...

    def selectedTableCells(self) -> Tuple[int, int, int, int]:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#selectedTableCells

        **void QTextCursor::selectedTableCells(int * firstRow , int * numRows ,
        int * firstColumn , int * numColumns ) const**

        If the selection spans over table cells, **firstRow** is populated with
        the number of the first row in the selection, **firstColumn** with the
        number of the first column in the selection, and **numRows** and
        **numColumns** with the number of rows and columns in the selection. If
        the selection does not span any table cells the results are harmless but
        undefined.
        """
        ...

    def selectedText(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#selectedText

        **QString QTextCursor::selectedText() const**

        Returns the current selection's text (which may be empty). This only
        returns the text, with no rich text formatting information. If you want
        a document fragment (i.e. formatted rich text) use **selection** ()
        instead.

        **Note:** If the selection obtained from an editor spans a line break,
        the text will contain a Unicode U+2029 paragraph separator character
        instead of a newline `\\n` character. Use **QString::replace** () to
        replace these characters with newlines.
        """
        ...

    def selection(self) -> PySide6.QtGui.QTextDocumentFragment:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#selection

        **QTextDocumentFragment QTextCursor::selection() const**

        Returns the current selection (which may be empty) with all its
        formatting information. If you just want the selected text (i.e. plain
        text) use **selectedText** () instead.

        **Note:** Unlike **QTextDocumentFragment::toPlainText** (),
        **selectedText** () may include special unicode characters such as
        **QChar::ParagraphSeparator** .

        **See also** **QTextDocumentFragment::toPlainText** ().
        """
        ...

    def selectionEnd(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#selectionEnd

        **int QTextCursor::selectionEnd() const**

        Returns the end of the selection or **position** () if the cursor
        doesn't have a selection.

        **See also** **selectionStart** (), **position** (), and **anchor** ().
        """
        ...

    def selectionStart(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#selectionStart

        **int QTextCursor::selectionStart() const**

        Returns the start of the selection or **position** () if the cursor
        doesn't have a selection.

        **See also** **selectionEnd** (), **position** (), and **anchor** ().
        """
        ...

    def setBlockCharFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#setBlockCharFormat

        **void QTextCursor::setBlockCharFormat(const QTextCharFormat & format
        )**

        Sets the block char format of the current block (or all blocks that are
        contained in the selection) to **format**.

        **See also** **blockCharFormat** ().
        """
        ...

    def setBlockFormat(self, format: PySide6.QtGui.QTextBlockFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#setBlockFormat

        **void QTextCursor::setBlockFormat(const QTextBlockFormat & format )**

        Sets the block format of the current block (or all blocks that are
        contained in the selection) to **format**.

        **See also** **blockFormat** () and **mergeBlockFormat** ().
        """
        ...

    def setCharFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#setCharFormat

        **void QTextCursor::setCharFormat(const QTextCharFormat & format )**

        Sets the cursor's current character format to the given **format**. If
        the cursor has a selection, the given **format** is applied to the
        current selection.

        **See also** **charFormat** (), **hasSelection** (), and
        **mergeCharFormat** ().
        """
        ...

    def setKeepPositionOnInsert(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#setKeepPositionOnInsert

        **void QTextCursor::setKeepPositionOnInsert(bool b )**

        Defines whether the cursor should keep its current position when text
        gets inserted at the current position of the cursor.

        If **b** is true, the cursor keeps its current position when text gets
        inserted at the positing of the cursor. If **b** is false, the cursor
        moves along with the inserted text.

        The default is false.

        Note that a cursor always moves when text is inserted before the current
        position of the cursor, and it always keeps its position when text is
        inserted after the current position of the cursor.

        **See also** **keepPositionOnInsert** ().
        """
        ...

    def setPosition(
        self, pos: int, mode: PySide6.QtGui.QTextCursor.MoveMode = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#setPosition

        **void QTextCursor::setPosition(int pos , QTextCursor::MoveMode m =
        MoveAnchor)**

        Moves the cursor to the absolute position in the document specified by
        **pos** using a `MoveMode` specified by **m**. The cursor is positioned
        between characters.

        **Note:** The "characters" in this case refer to the string of **QChar**
        objects, i.e. 16-bit Unicode characters, and **pos** is considered an
        index into this string. This does not necessarily correspond to
        individual graphemes in the writing system, as a single grapheme may be
        represented by multiple Unicode characters, such as in the case of
        surrogate pairs, linguistic ligatures or diacritics. For a more generic
        approach to navigating the document, use **movePosition** (), which will
        respect the actual grapheme boundaries in the text.

        **See also** **position** (), **movePosition** (), and **anchor** ().
        """
        ...

    def setVerticalMovementX(self, x: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#setVerticalMovementX

        **void QTextCursor::setVerticalMovementX(int x )**

        Sets the visual x position for vertical cursor movements to **x**.

        The vertical movement x position is cleared automatically when the
        cursor moves horizontally, and kept unchanged when the cursor moves
        vertically. The mechanism allows the cursor to move up and down on a
        visually straight line with proportional fonts, and to gently "jump"
        over short lines.

        A value of -1 indicates no predefined x position. It will then be set
        automatically the next time the cursor moves up or down.

        **See also** **verticalMovementX** ().
        """
        ...

    def setVisualNavigation(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#setVisualNavigation

        **void QTextCursor::setVisualNavigation(bool b )**

        Sets visual navigation to **b**.

        Visual navigation means skipping over hidden text paragraphs. The
        default is false.

        **See also** **visualNavigation** () and **movePosition** ().
        """
        ...

    def swap(self, other: PySide6.QtGui.QTextCursor) -> None:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#swap

        **[since 5.0] void QTextCursor::swap(QTextCursor & other )**

        Swaps this text cursor instance with **other**. This function is very
        fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def verticalMovementX(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#verticalMovementX

        **int QTextCursor::verticalMovementX() const**

        Returns the visual x position for vertical cursor movements.

        A value of -1 indicates no predefined x position. It will then be set
        automatically the next time the cursor moves up or down.

        **See also** **setVerticalMovementX** ().
        """
        ...

    def visualNavigation(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextcursor.html#visualNavigation

        **bool QTextCursor::visualNavigation() const**

        Returns `true` if the cursor does visual navigation; otherwise returns
        `false`.

        Visual navigation means skipping over hidden text paragraphs. The
        default is false.

        **See also** **setVisualNavigation** () and **movePosition** ().
        """
        ...
