"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QSurface(object):
    """
    https://doc.qt.io/qt-6/qsurface.html

    **Detailed Description**

    The size of the surface is accessible with the **size** () function. The
    rendering specific attributes of the surface are accessible through the
    **format** () function.
    """

    Window: QSurface.SurfaceClass = ...
    Offscreen: QSurface.SurfaceClass = ...
    RasterSurface: QSurface.SurfaceType = ...
    OpenGLSurface: QSurface.SurfaceType = ...
    RasterGLSurface: QSurface.SurfaceType = ...
    OpenVGSurface: QSurface.SurfaceType = ...
    VulkanSurface: QSurface.SurfaceType = ...
    MetalSurface: QSurface.SurfaceType = ...
    Direct3DSurface: QSurface.SurfaceType = ...

    class SurfaceClass(Enum):
        Window: QSurface.SurfaceClass = ...
        Offscreen: QSurface.SurfaceClass = ...

    class SurfaceType(Enum):
        RasterSurface: QSurface.SurfaceType = ...
        OpenGLSurface: QSurface.SurfaceType = ...
        RasterGLSurface: QSurface.SurfaceType = ...
        OpenVGSurface: QSurface.SurfaceType = ...
        VulkanSurface: QSurface.SurfaceType = ...
        MetalSurface: QSurface.SurfaceType = ...
        Direct3DSurface: QSurface.SurfaceType = ...

    def __init__(self, type: PySide6.QtGui.QSurface.SurfaceClass) -> None:
        """
        https://doc.qt.io/qt-6/qsurface.html#QSurface

        **[protected] QSurface::QSurface(QSurface::SurfaceClass type )**

        Creates a surface with the given **type**.
        """
        ...

    def format(self) -> PySide6.QtGui.QSurfaceFormat:
        """
        https://doc.qt.io/qt-6/qsurface.html#format

        **[pure virtual] QSurfaceFormat QSurface::format() const**

        Returns the format of the surface.
        """
        ...

    def size(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qsurface.html#size

        **[pure virtual] QSize QSurface::size() const**

        Returns the size of the surface in pixels.
        """
        ...

    def supportsOpenGL(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsurface.html#supportsOpenGL

        **[since 5.3] bool QSurface::supportsOpenGL() const**

        Returns true if the surface is OpenGL compatible and can be used in
        conjunction with **QOpenGLContext** ; otherwise returns false.

        This function was introduced in Qt 5.3.
        """
        ...

    def surfaceClass(self) -> PySide6.QtGui.QSurface.SurfaceClass:
        """
        https://doc.qt.io/qt-6/qsurface.html#surfaceClass

        **QSurface::SurfaceClass QSurface::surfaceClass() const**

        Returns the surface class of this surface.
        """
        ...

    def surfaceHandle(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurface.html#surfaceHandle

        **[pure virtual] QPlatformSurface *QSurface::surfaceHandle() const**

        Returns a handle to the platform-specific implementation of the surface.
        """
        ...

    def surfaceType(self) -> PySide6.QtGui.QSurface.SurfaceType:
        """
        https://doc.qt.io/qt-6/qsurface.html#surfaceType

        **[pure virtual] QSurface::SurfaceType QSurface::surfaceType() const**

        Returns the type of the surface.
        """
        ...
