"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QRegion(object):
    """
    https://doc.qt.io/qt-6/qregion.html

    **Detailed Description**

    QRegion is used with **QPainter::setClipRegion** () to limit the paint area
    to what needs to be painted. There is also a **QWidget::repaint** ()
    function that takes a QRegion parameter. QRegion is the best tool for
    minimizing the amount of screen area to be updated by a repaint.

    This class is not suitable for constructing shapes for rendering, especially
    as outlines. Use **QPainterPath**  to create paths and shapes for use with
    **QPainter** .

    QRegion is an **implicitly shared**  class.

    **Creating and Using Regions**

    A region can be created from a rectangle, an ellipse, a polygon or a bitmap.
    Complex regions may be created by combining simple regions using **united**
    (), **intersected** (), **subtracted** (), or **xored** () (exclusive or).
    You can move a region using **translate** ().

    You can test whether a region **isEmpty** () or if it **contains** () a
    **QPoint**  or **QRect** . The bounding rectangle can be found with
    **boundingRect** ().

    Iteration over the region (with **begin** (), **end** (), or C++11 ranged-
    for loops) gives a decomposition of the region into rectangles.

    Example of using complex regions:

    void MyWidget::paintEvent(**QPaintEvent**  *)
        {
            **QRegion**
    r1(**QRect** (100, 100, 200, 80),    // r1: elliptic region
    **QRegion** ::Ellipse);
            **QRegion**  r2(**QRect** (100, 120, 90,
    30));    // r2: rectangular region
            **QRegion**  r3 =
    r1.intersected(r2);        // r3: intersection

            **QPainter**
    painter(this);
            painter.setClipRegion(r3);
            // ...
    // paint clipped graphics
        }

    **See also** **QPainter::setClipRegion** (), **QPainter::setClipRect** (),
    and **QPainterPath** .
    """

    Rectangle: QRegion.RegionType = ...
    Ellipse: QRegion.RegionType = ...

    class RegionType(Enum):
        Rectangle: QRegion.RegionType = ...
        Ellipse: QRegion.RegionType = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#QRegion

        **QRegion::QRegion()**

        Constructs an empty region.

        **See also** **isEmpty** ().
        """
        ...

    @overload
    def __init__(self, bitmap: Union[PySide6.QtGui.QBitmap, str]) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#QRegion-1

        **QRegion::QRegion(int x , int y , int w , int h , QRegion::RegionType t
        = Rectangle)**

        Constructs a rectangular or elliptic region.

        If **t** is `Rectangle`, the region is the filled rectangle ( **x** ,
        **y** , **w** , **h** ). If **t** is `Ellipse`, the region is the filled
        ellipse with center at ( **x** \\+ **w** / 2, **y** \\+ **h** / 2) and
        size ( **w** , **h** ).
        """
        ...

    @overload
    def __init__(
        self,
        pa: Union[
            PySide6.QtGui.QPolygon,
            Sequence[PySide6.QtCore.QPoint],
            PySide6.QtCore.QRect,
        ],
        fillRule: PySide6.QtCore.Qt.FillRule = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#QRegion-2

        **QRegion::QRegion(const QRect & r , QRegion::RegionType t =
        Rectangle)**

        This is an overloaded function.

        Create a region based on the rectangle **r** with region type **t**.

        If the rectangle is invalid a null region will be created.

        **See also** **QRegion::RegionType** .
        """
        ...

    @overload
    def __init__(
        self, r: PySide6.QtCore.QRect, t: PySide6.QtGui.QRegion.RegionType = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#QRegion-3

        **QRegion::QRegion(const QPolygon & a , Qt::FillRule fillRule =
        Qt::OddEvenFill)**

        Constructs a polygon region from the point array **a** with the fill
        rule specified by **fillRule**.

        If **fillRule** is **Qt::WindingFill** , the polygon region is defined
        using the winding algorithm; if it is **Qt::OddEvenFill** , the odd-even
        fill algorithm is used.

        **Warning:** This constructor can be used to create complex regions that
        will slow down painting when used.
        """
        ...

    @overload
    def __init__(
        self,
        region: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#QRegion-4

        **QRegion::QRegion(const QRegion & r )**

        Constructs a new region which is equal to region **r**.
        """
        ...

    @overload
    def __init__(
        self, x: int, y: int, w: int, h: int, t: PySide6.QtGui.QRegion.RegionType = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#QRegion-5

        **[since 5.7] QRegion::QRegion(QRegion && other )**

        Move-constructs a new region from region **other**. After the call,
        **other** is null.

        This function was introduced in Qt 5.7.

        **See also** **isNull** ().
        """
        ...

    @overload
    def __add__(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion:
        ...

    @overload
    def __add__(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        ...

    @overload
    def __and__(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion:
        ...

    @overload
    def __and__(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @overload
    def __iadd__(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion:
        ...

    @overload
    def __iadd__(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        ...

    def __ior__(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        ...

    def __isub__(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        ...

    def __ixor__(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QRegion:
        ...

    def __or__(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __sub__(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        ...

    def __xor__(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        ...

    def begin(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qregion.html#begin

        **[since 5.8] QRegion::const_iterator QRegion::begin() const**

        Returns a **const_iterator**  pointing to the beginning of the range of
        non-overlapping rectangles that make up the region.

        The union of all the rectangles is equal to the original region.

        This function was introduced in Qt 5.8.

        **See also** **rbegin** (), **cbegin** (), and **end** ().
        """
        ...

    def boundingRect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qregion.html#boundingRect

        **QRect QRegion::boundingRect() const**

        Returns the bounding rectangle of this region. An empty region gives a
        rectangle that is **QRect::isNull** ().
        """
        ...

    def cbegin(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qregion.html#cbegin

        **[since 5.8] QRegion::const_iterator QRegion::cbegin() const**

        Same as **begin** ().

        This function was introduced in Qt 5.8.
        """
        ...

    def cend(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qregion.html#cend

        **[since 5.8] QRegion::const_iterator QRegion::cend() const**

        Same as **end** ().

        This function was introduced in Qt 5.8.
        """
        ...

    @overload
    def contains(self, p: PySide6.QtCore.QPoint) -> bool:
        """
        https://doc.qt.io/qt-6/qregion.html#contains

        **bool QRegion::contains(const QPoint & p ) const**

        Returns `true` if the region contains the point **p** ; otherwise
        returns `false`.
        """
        ...

    @overload
    def contains(self, r: PySide6.QtCore.QRect) -> bool:
        """
        https://doc.qt.io/qt-6/qregion.html#contains-1

        **bool QRegion::contains(const QRect & r ) const**

        This is an overloaded function.

        Returns `true` if the region overlaps the rectangle **r** ; otherwise
        returns `false`.
        """
        ...

    def end(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qregion.html#end

        **[since 5.8] QRegion::const_iterator QRegion::end() const**

        Returns a **const_iterator**  pointing to one past the end of non-
        overlapping rectangles that make up the region.

        The union of all the rectangles is equal to the original region.

        This function was introduced in Qt 5.8.

        **See also** **rend** (), **cend** (), and **begin** ().
        """
        ...

    @overload
    def intersected(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qregion.html#intersected

        **QRegion QRegion::intersected(const QRegion & r ) const**

        Returns a region which is the intersection of this region and **r**.

        ![Region Intersection](images/rintersect.png)

        The figure shows the intersection of two elliptical regions.

        **See also** **subtracted** (), **united** (), and **xored** ().
        """
        ...

    @overload
    def intersected(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qregion.html#intersected-1

        **QRegion QRegion::intersected(const QRect & rect ) const**

        Returns a region which is the intersection of this region and the given
        **rect**.

        **See also** **subtracted** (), **united** (), and **xored** ().
        """
        ...

    @overload
    def intersects(self, r: PySide6.QtCore.QRect) -> bool:
        """
        https://doc.qt.io/qt-6/qregion.html#intersects

        **bool QRegion::intersects(const QRegion & region ) const**

        Returns `true` if this region intersects with **region** , otherwise
        returns `false`.
        """
        ...

    @overload
    def intersects(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qregion.html#intersects-1

        **bool QRegion::intersects(const QRect & rect ) const**

        Returns `true` if this region intersects with **rect** , otherwise
        returns `false`.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qregion.html#isEmpty

        **bool QRegion::isEmpty() const**

        Returns `true` if the region is empty; otherwise returns `false`. An
        empty region is a region that contains no points.

        Example:

        **QRegion**  r1(10, 10, 20, 20);
            r1.isEmpty();               //
        false

            **QRegion**  r3;
            r3.isEmpty();               // true
        **QRegion**  r2(40, 40, 20, 20);
            r3 = r1.intersected(r2);    // r3:
        intersection of r1 and r2
            r3.isEmpty();               // true
        r3 = r1.united(r2);         // r3: union of r1 and r2
            r3.isEmpty();
        // false
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qregion.html#isNull

        **[since 5.0] bool QRegion::isNull() const**

        Returns `true` if the region is empty; otherwise returns `false`. An
        empty region is a region that contains no points. This function is the
        same as **isEmpty**

        This function was introduced in Qt 5.0.

        **See also** **isEmpty** ().
        """
        ...

    def rectCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qregion.html#rectCount

        **int QRegion::rectCount() const**

        Returns the number of rectangles that this region is composed of. Same
        as `end() - begin()`.
        """
        ...

    def setRects(self, rect: PySide6.QtCore.QRect, num: int) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#setRects

        **void QRegion::setRects(const QRect * rects , int number )**

        Sets the region using the array of rectangles specified by **rects** and
        **number**. The rectangles **must** be optimally Y-X sorted and follow
        these restrictions:

        * The rectangles must not intersect.
          * All rectangles with a given top
        coordinate must have the same height.
          * No two rectangles may abut
        horizontally (they should be combined into a single wider rectangle in
        that case).
          * The rectangles must be sorted in ascending order, with Y
        as the major sort key and X as the minor sort key.
        """
        ...

    def subtracted(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qregion.html#subtracted

        **QRegion QRegion::subtracted(const QRegion & r ) const**

        Returns a region which is **r** subtracted from this region.

        ![Region Subtraction](images/rsubtract.png)

        The figure shows the result when the ellipse on the right is subtracted
        from the ellipse on the left (`left - right`).

        **See also** **intersected** (), **united** (), and **xored** ().
        """
        ...

    def swap(
        self,
        other: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#swap

        **void QRegion::swap(QRegion & other )**

        Swaps region **other** with this region. This operation is very fast and
        never fails.
        """
        ...

    @overload
    def translate(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#translate

        **void QRegion::translate(int dx , int dy )**

        Translates (moves) the region **dx** along the X axis and **dy** along
        the Y axis.
        """
        ...

    @overload
    def translate(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qregion.html#translate-1

        **void QRegion::translate(const QPoint & point )**

        This is an overloaded function.

        Translates the region **point** **.x()** along the x axis and **point**
        **.y()** along the y axis, relative to the current position. Positive
        values move the region to the right and down.

        Translates to the given **point**.
        """
        ...

    @overload
    def translated(self, dx: int, dy: int) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qregion.html#translated

        **QRegion QRegion::translated(int dx , int dy ) const**

        Returns a copy of the region that is translated **dx** along the x axis
        and **dy** along the y axis, relative to the current position. Positive
        values move the region to the right and down.

        **See also** **translate** ().
        """
        ...

    @overload
    def translated(self, p: PySide6.QtCore.QPoint) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qregion.html#translated-1

        **QRegion QRegion::translated(const QPoint & p ) const**

        This is an overloaded function.

        Returns a copy of the regtion that is translated **p** **.x()** along
        the x axis and **p** **.y()** along the y axis, relative to the current
        position. Positive values move the rectangle to the right and down.

        **See also** **translate** ().
        """
        ...

    @overload
    def united(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qregion.html#united

        **QRegion QRegion::united(const QRegion & r ) const**

        Returns a region which is the union of this region and **r**.

        ![Region Union](images/runion.png)

        The figure shows the union of two elliptical regions.

        **See also** **intersected** (), **subtracted** (), and **xored** ().
        """
        ...

    @overload
    def united(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qregion.html#united-1

        **QRegion QRegion::united(const QRect & rect ) const**

        Returns a region which is the union of this region and the given
        **rect**.

        **See also** **intersected** (), **subtracted** (), and **xored** ().
        """
        ...

    def xored(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qregion.html#xored

        **QRegion QRegion::xored(const QRegion & r ) const**

        Returns a region which is the exclusive or (XOR) of this region and
        **r**.

        ![Region XORed](images/rxor.png)

        The figure shows the exclusive or of two elliptical regions.

        **See also** **intersected** (), **united** (), and **subtracted** ().
        """
        ...
