"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPointingDevice(PySide6.QtGui.QInputDevice):
    """
    https://doc.qt.io/qt-6/qpointingdevice.html

    **Detailed Description**

    Each **QPointerEvent**  contains a QPointingDevice pointer to allow
    accessing device-specific properties like type and capabilities. It is the
    responsibility of the platform or generic plug-ins to register the available
    pointing devices via QWindowSystemInterface before generating any pointer
    events. Applications do not need to instantiate this class, they should just
    access the global instances pointed to by **QPointerEvent::device** ().
    """

    GrabPassive: QPointingDevice.GrabTransition = ...
    UngrabPassive: QPointingDevice.GrabTransition = ...
    CancelGrabPassive: QPointingDevice.GrabTransition = ...
    OverrideGrabPassive: QPointingDevice.GrabTransition = ...
    GrabExclusive: QPointingDevice.GrabTransition = ...
    UngrabExclusive: QPointingDevice.GrabTransition = ...
    CancelGrabExclusive: QPointingDevice.GrabTransition = ...

    class GrabTransition(Enum):
        GrabPassive: QPointingDevice.GrabTransition = ...
        UngrabPassive: QPointingDevice.GrabTransition = ...
        CancelGrabPassive: QPointingDevice.GrabTransition = ...
        OverrideGrabPassive: QPointingDevice.GrabTransition = ...
        GrabExclusive: QPointingDevice.GrabTransition = ...
        UngrabExclusive: QPointingDevice.GrabTransition = ...
        CancelGrabExclusive: QPointingDevice.GrabTransition = ...

    class PointerType(Enum):
        Unknown: QPointingDevice.PointerType = ...
        Generic: QPointingDevice.PointerType = ...
        Finger: QPointingDevice.PointerType = ...
        Pen: QPointingDevice.PointerType = ...
        Eraser: QPointingDevice.PointerType = ...
        Cursor: QPointingDevice.PointerType = ...
        AllPointerTypes: QPointingDevice.PointerType = ...

    class PointerTypes(object):
        ...

    @overload
    def __init__(
        self,
        name: str,
        systemId: int,
        devType: PySide6.QtGui.QInputDevice.DeviceType,
        pType: PySide6.QtGui.QPointingDevice.PointerType,
        caps: PySide6.QtGui.QInputDevice.Capabilities,
        maxPoints: int,
        buttonCount: int,
        seatName: str = ...,
        uniqueId: PySide6.QtGui.QPointingDeviceUniqueId = ...,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpointingdevice.html#QPointingDevice

        **QPointingDevice::QPointingDevice(QObject * parent = nullptr)**

        Creates a new invalid pointing device instance as a child of **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpointingdevice.html#QPointingDevice-1

        **QPointingDevice::QPointingDevice(const QString & name , qint64 id ,
        QInputDevice::DeviceType deviceType , QPointingDevice::PointerType
        pointerType , QInputDevice::Capabilities capabilities , int maxPoints ,
        int buttonCount , const QString & seatName = QString(),
        QPointingDeviceUniqueId uniqueId = QPointingDeviceUniqueId(), QObject *
        parent = nullptr)**

        Creates a new pointing device instance with the given **name** ,
        **deviceType** , **pointerType** , **capabilities** , **maxPoints** ,
        **buttonCount** , **seatName** , **uniqueId** and **parent**.
        """
        ...

    def buttonCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qpointingdevice.html#buttonCount

        **int QPointingDevice::buttonCount() const**

        Returns the maximum number of on-device buttons that can be detected.

        **Note:** Getter function for property buttonCount.
        """
        ...

    def maximumPoints(self) -> int:
        """
        https://doc.qt.io/qt-6/qpointingdevice.html#maximumPoints

        **int QPointingDevice::maximumPoints() const**

        Returns the maximum number of simultaneous touch points (fingers) that
        can be detected.

        **Note:** Getter function for property maximumPoints.
        """
        ...

    def pointerType(self) -> PySide6.QtGui.QPointingDevice.PointerType:
        """
        https://doc.qt.io/qt-6/qpointingdevice.html#pointerType

        **QPointingDevice::PointerType QPointingDevice::pointerType() const**

        Returns the pointer type.

        **Note:** Getter function for property pointerType.
        """
        ...

    @staticmethod
    def primaryPointingDevice(seatName: str = ...) -> PySide6.QtGui.QPointingDevice:
        """
        https://doc.qt.io/qt-6/qpointingdevice.html#primaryPointingDevice

        **[static] const QPointingDevice
        *QPointingDevice::primaryPointingDevice(const QString & seatName =
        QString())**

        Returns the primary pointing device (the core pointer, traditionally
        assumed to be a mouse) on the given seat **seatName**.

        If multiple pointing devices are registered, this function prefers a
        mouse or touchpad that matches the given **seatName** and that does not
        have another device as its parent. Usually only one master or core
        device does not have a parent device. But if such a device is not found,
        this function creates a new virtual "core pointer" mouse. Thus Qt
        continues to work on platforms that are not yet doing input device
        discovery and registration.
        """
        ...

    def setCapabilities(self, caps: PySide6.QtGui.QInputDevice.Capabilities) -> None:
        ...

    def setMaximumTouchPoints(self, c: int) -> None:
        ...

    def setType(self, devType: PySide6.QtGui.QInputDevice.DeviceType) -> None:
        ...

    def uniqueId(self) -> PySide6.QtGui.QPointingDeviceUniqueId:
        """
        https://doc.qt.io/qt-6/qpointingdevice.html#uniqueId

        **QPointingDeviceUniqueId QPointingDevice::uniqueId() const**

        Returns a unique ID (of dubious utility) for the device.

        You probably should rather be concerned with
        QPointerEventPoint::uniqueId().

        **Note:** Getter function for property uniqueId.
        """
        ...
