"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
import os
from typing import Any, Iterable, Iterable, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPixmap(PySide6.QtGui.QPaintDevice):
    """
    https://doc.qt.io/qt-6/qpixmap.html

    **Detailed Description**

    Qt provides four classes for handling image data: **QImage** , QPixmap,
    **QBitmap**  and **QPicture** . **QImage**  is designed and optimized for
    I/O, and for direct pixel access and manipulation, while QPixmap is designed
    and optimized for showing images on screen. **QBitmap**  is only a
    convenience class that inherits QPixmap, ensuring a depth of 1. The
    **isQBitmap** () function returns `true` if a QPixmap object is really a
    bitmap, otherwise returns `false`. Finally, the **QPicture**  class is a
    paint device that records and replays **QPainter**  commands.

    A QPixmap can easily be displayed on the screen using **QLabel**  or one of
    **QAbstractButton** 's subclasses (such as **QPushButton**  and
    **QToolButton** ). **QLabel**  has a pixmap property, whereas
    **QAbstractButton**  has an icon property.

    QPixmap objects can be passed around by value since the QPixmap class uses
    implicit data sharing. For more information, see the **Implicit Data
    Sharing**  documentation. QPixmap objects can also be streamed.

    Note that the pixel data in a pixmap is internal and is managed by the
    underlying window system. Because QPixmap is a **QPaintDevice**  subclass,
    **QPainter**  can be used to draw directly onto pixmaps. Pixels can only be
    accessed through **QPainter**  functions or by converting the QPixmap to a
    **QImage** . However, the **fill** () function is available for initializing
    the entire pixmap with a given color.

    There are functions to convert between **QImage**  and QPixmap. Typically,
    the **QImage**  class is used to load an image file, optionally manipulating
    the image data, before the **QImage**  object is converted into a QPixmap to
    be shown on screen. Alternatively, if no manipulation is desired, the image
    file can be loaded directly into a QPixmap.

    QPixmap provides a collection of functions that can be used to obtain a
    variety of information about the pixmap. In addition, there are several
    functions that enables transformation of the pixmap.

    **Reading and Writing Image Files**

    QPixmap provides several ways of reading an image file: The file can be
    loaded when constructing the QPixmap object, or by using the **load** () or
    **loadFromData** () functions later on. When loading an image, the file name
    can either refer to an actual file on disk or to one of the application's
    embedded resources. See **The Qt Resource System**  overview for details on
    how to embed images and other resource files in the application's
    executable.

    Simply call the **save** () function to save a QPixmap object.

    The complete list of supported file formats are available through the
    **QImageReader::supportedImageFormats** () and
    **QImageWriter::supportedImageFormats** () functions. New file formats can
    be added as plugins. By default, Qt supports the following formats:

    FormatDescriptionQt's support
    BMPWindows BitmapRead/write
    GIFGraphic
    Interchange Format (optional)Read
    JPGJoint Photographic Experts
    GroupRead/write
    JPEGJoint Photographic Experts GroupRead/write
    PNGPortable Network GraphicsRead/write
    PBMPortable BitmapRead
    PGMPortable GraymapRead
    PPMPortable PixmapRead/write
    XBMX11
    BitmapRead/write
    XPMX11 PixmapRead/write

    **Pixmap Information**

    QPixmap provides a collection of functions that can be used to obtain a
    variety of information about the pixmap:

    Available Functions
    GeometryThe **size** (), **width** () and **height**
    () functions provide information about the pixmap's size. The **rect** ()
    function returns the image's enclosing rectangle.
    Alpha componentThe
    **hasAlphaChannel** () returns `true` if the pixmap has a format that
    respects the alpha channel, otherwise returns `false`. The **hasAlpha** (),
    **setMask** () and **mask** () functions are legacy and should not be used.
    They are potentially very slow.

    The **createHeuristicMask** () function
    creates and returns a 1-bpp heuristic mask (i.e. a **QBitmap** ) for this
    pixmap. It works by selecting a color from one of the corners and then
    chipping away pixels of that color, starting at all the edges. The
    **createMaskFromColor** () function creates and returns a mask (i.e. a
    **QBitmap** ) for the pixmap based on a given color.

    Low-level
    informationThe **depth** () function returns the depth of the pixmap. The
    **defaultDepth** () function returns the default depth, i.e. the depth used
    by the application on the given screen.

    The **cacheKey** () function
    returns a number that uniquely identifies the contents of the QPixmap
    object.

    **Pixmap Conversion**

    A QPixmap object can be converted into a **QImage**  using the **toImage**
    () function. Likewise, a **QImage**  can be converted into a QPixmap using
    the **fromImage** (). If this is too expensive an operation, you can use
    **QBitmap::fromImage** () instead.

    To convert a QPixmap to and from HICON you can use the QtWinExtras functions
    QtWin::toHICON() and QtWin::fromHICON() respectively.

    **Pixmap Transformations**

    QPixmap supports a number of functions for creating a new pixmap that is a
    transformed version of the original:

    The **scaled** (), **scaledToWidth** () and **scaledToHeight** () functions
    return scaled copies of the pixmap, while the **copy** () function creates a
    QPixmap that is a plain copy of the original one.

    The **transformed** () function returns a copy of the pixmap that is
    transformed with the given transformation matrix and transformation mode:
    Internally, the transformation matrix is adjusted to compensate for unwanted
    translation, i.e. **transformed** () returns the smallest pixmap containing
    all transformed points of the original pixmap. The static **trueMatrix** ()
    function returns the actual matrix used for transforming the pixmap.

    **See also** **QBitmap** , **QImage** , **QImageReader** , and
    **QImageWriter** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#QPixmap

        **QPixmap::QPixmap()**

        Constructs a null pixmap.

        **See also** **isNull** ().
        """
        ...

    @overload
    def __init__(self, arg__1: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#QPixmap-1

        **QPixmap::QPixmap(const QSize & size )**

        This is an overloaded function.

        Constructs a pixmap of the given **size**.

        **Warning:** This will create a QPixmap with uninitialized data. Call
        **fill** () to fill the pixmap with an appropriate color before drawing
        onto it with **QPainter** .
        """
        ...

    @overload
    def __init__(
        self, arg__1: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#QPixmap-2

        **QPixmap::QPixmap(const QString & fileName , const char * format =
        nullptr, Qt::ImageConversionFlags flags = Qt::AutoColor)**

        Constructs a pixmap from the file with the given **fileName**. If the
        file does not exist or is of an unknown format, the pixmap becomes a
        null pixmap.

        The loader attempts to read the pixmap using the specified **format**.
        If the **format** is not specified (which is the default), the loader
        probes the file for a header to guess the file format.

        The file name can either refer to an actual file on disk or to one of
        the application's embedded resources. See the **Resource System**
        overview for details on how to embed images and other resource files in
        the application's executable.

        If the image needs to be modified to fit in a lower-resolution result
        (e.g. converting from 32-bit to 8-bit), use the **flags** to control the
        conversion.

        The **fileName** , **format** and **flags** parameters are passed on to
        **load** (). This means that the data in **fileName** is not compiled
        into the binary. If **fileName** contains a relative path (e.g. the
        filename only) the relevant file must be found relative to the runtime
        working directory.

        **See also** **Reading and Writing Image Files** .
        """
        ...

    @overload
    def __init__(
        self,
        fileName: Union[str, bytes, os.PathLike],
        format: Optional[bytes] = ...,
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#QPixmap-3

        **QPixmap::QPixmap(const char *const [] xpm )**

        Constructs a pixmap from the given **xpm** data, which must be a valid
        XPM image.

        Errors are silently ignored.

        Note that it's possible to squeeze the XPM variable a little bit by
        using an unusual declaration:

        static const char * const start_xpm[] = {
                "16 15 8 1",
        "a c #cec6bd",
                // etc.
            };

        The extra `const` makes the entire definition read-only, which is
        slightly more efficient (for example, when the code is in a shared
        library) and ROMable when the application is to be stored in ROM.
        """
        ...

    @overload
    def __init__(self, image: Union[PySide6.QtGui.QImage, str]) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#QPixmap-4

        **QPixmap::QPixmap(const QPixmap & pixmap )**

        Constructs a pixmap that is a copy of the given **pixmap**.

        **See also** **copy** ().
        """
        ...

    @overload
    def __init__(self, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#QPixmap-5

        **QPixmap::QPixmap(QPixmap && other )**

        Move-constructs a QPixmap instance from **other**.

        **See also** **swap** () and **operator=** (QPixmap&&).
        """
        ...

    @overload
    def __init__(self, xpm: Iterable) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#QPixmap

        **QPixmap::QPixmap()**

        Constructs a null pixmap.

        **See also** **isNull** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def cacheKey(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixmap.html#cacheKey

        **qint64 QPixmap::cacheKey() const**

        Returns a number that identifies this **QPixmap** . Distinct **QPixmap**
        objects can only have the same cache key if they refer to the same
        contents.

        The cacheKey() will change when the pixmap is altered.
        """
        ...

    def convertFromImage(
        self,
        img: Union[PySide6.QtGui.QImage, str],
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#convertFromImage

        **bool QPixmap::convertFromImage(const QImage & image ,
        Qt::ImageConversionFlags flags = Qt::AutoColor)**

        Replaces this pixmap's data with the given **image** using the specified
        **flags** to control the conversion. The **flags** argument is a
        bitwise-OR of the **Qt::ImageConversionFlags** . Passing 0 for **flags**
        sets all the default options. Returns `true` if the result is that this
        pixmap is not null.

        Note: this function was part of Qt 3 support in Qt 4.6 and earlier. It
        has been promoted to official API status in 4.7 to support updating the
        pixmap's image without creating a new **QPixmap**  as **fromImage** ()
        would.

        **See also** **fromImage** ().
        """
        ...

    @overload
    def copy(self, rect: PySide6.QtCore.QRect = ...) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#copy

        **QPixmap QPixmap::copy(const QRect & rectangle = QRect()) const**

        Returns a deep copy of the subset of the pixmap that is specified by the
        given **rectangle**. For more information on deep copies, see the
        **Implicit Data Sharing**  documentation.

        If the given **rectangle** is empty, the whole image is copied.

        **See also** **operator=** (), **QPixmap** (), and **Pixmap
        Transformations** .
        """
        ...

    @overload
    def copy(self, x: int, y: int, width: int, height: int) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#copy-1

        **QPixmap QPixmap::copy(int x , int y , int width , int height ) const**

        This is an overloaded function.

        Returns a deep copy of the subset of the pixmap that is specified by the
        rectangle **QRect** ( **x** , **y** , **width** , **height** ).
        """
        ...

    def createHeuristicMask(self, clipTight: bool = ...) -> PySide6.QtGui.QBitmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#createHeuristicMask

        **QBitmap QPixmap::createHeuristicMask(bool clipTight = true) const**

        Creates and returns a heuristic mask for this pixmap.

        The function works by selecting a color from one of the corners and then
        chipping away pixels of that color, starting at all the edges. If
        **clipTight** is true (the default) the mask is just large enough to
        cover the pixels; otherwise, the mask is larger than the data pixels.

        The mask may not be perfect but it should be reasonable, so you can do
        things such as the following:

        **QPixmap**  myPixmap;
        myPixmap.setMask(myPixmap.createHeuristicMask());

        This function is slow because it involves converting to/from a
        **QImage** , and non-trivial computations.

        **See also** **QImage::createHeuristicMask** () and
        **createMaskFromColor** ().
        """
        ...

    def createMaskFromColor(
        self,
        maskColor: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
        mode: PySide6.QtCore.Qt.MaskMode = ...,
    ) -> PySide6.QtGui.QBitmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#createMaskFromColor

        **QBitmap QPixmap::createMaskFromColor(const QColor & maskColor ,
        Qt::MaskMode mode = Qt::MaskInColor) const**

        Creates and returns a mask for this pixmap based on the given
        **maskColor**. If the **mode** is **Qt::MaskInColor** , all pixels
        matching the maskColor will be transparent. If **mode** is
        **Qt::MaskOutColor** , all pixels matching the maskColor will be opaque.

        This function is slow because it involves converting to/from a
        **QImage** .

        **See also** **createHeuristicMask** () and
        **QImage::createMaskFromColor** ().
        """
        ...

    @staticmethod
    def defaultDepth() -> int:
        """
        https://doc.qt.io/qt-6/qpixmap.html#defaultDepth

        **[static] int QPixmap::defaultDepth()**

        Returns the default pixmap depth used by the application.

        On all platforms the depth of the primary screen will be returned.

        **Note:****QGuiApplication**  must be created before calling this
        function.

        **See also** **depth** (), **QColormap::depth** (), and **Pixmap
        Information** .
        """
        ...

    def depth(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixmap.html#depth

        **int QPixmap::depth() const**

        Returns the depth of the pixmap.

        The pixmap depth is also called bits per pixel (bpp) or bit planes of a
        pixmap. A null pixmap has depth 0.

        **See also** **defaultDepth** () and **Pixmap Information** .
        """
        ...

    def devType(self) -> int:
        ...

    def deviceIndependentSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qpixmap.html#deviceIndependentSize

        **QSizeF QPixmap::deviceIndependentSize() const**

        Returns the size of the pixmap in device independent pixels.

        This value should be used when using the pixmap size in user interface
        size calculations.

        The return value is equivalent to pixmap.**size** () /
        pixmap.**devicePixelRatio** (),
        """
        ...

    def devicePixelRatio(self) -> float:
        """
        https://doc.qt.io/qt-6/qpixmap.html#devicePixelRatio

        **qreal QPixmap::devicePixelRatio() const**

        Returns the device pixel ratio for the pixmap. This is the ratio between
        **device pixels** and **device independent pixels**.

        Use this function when calculating layout geometry based on the pixmap
        size: **QSize**  layoutSize = image.**size** () /
        image.devicePixelRatio()

        The default value is 1.0.

        **See also** **setDevicePixelRatio** () and **QImageReader** .
        """
        ...

    def fill(
        self,
        fillColor: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#fill

        **void QPixmap::fill(const QColor & color = Qt::white)**

        Fills the pixmap with the given **color**.

        The effect of this function is undefined when the pixmap is being
        painted on.

        **See also** **Pixmap Transformations** .
        """
        ...

    @staticmethod
    def fromImage(
        image: Union[PySide6.QtGui.QImage, str],
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#fromImage

        **[static] QPixmap QPixmap::fromImage(const QImage & image ,
        Qt::ImageConversionFlags flags = Qt::AutoColor)**

        Converts the given **image** to a pixmap using the specified **flags**
        to control the conversion. The **flags** argument is a bitwise-OR of the
        **Qt::ImageConversionFlags** . Passing 0 for **flags** sets all the
        default options.

        In case of monochrome and 8-bit images, the image is first converted to
        a 32-bit pixmap and then filled with the colors in the color table. If
        this is too expensive an operation, you can use **QBitmap::fromImage**
        () instead.

        **See also** **fromImageReader** (), **toImage** (), and **Pixmap
        Conversion** .
        """
        ...

    @staticmethod
    def fromImageInPlace(
        image: Union[PySide6.QtGui.QImage, str],
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> PySide6.QtGui.QPixmap:
        ...

    @staticmethod
    def fromImageReader(
        imageReader: PySide6.QtGui.QImageReader,
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#fromImageReader

        **[static] QPixmap QPixmap::fromImageReader(QImageReader * imageReader ,
        Qt::ImageConversionFlags flags = Qt::AutoColor)**

        Create a **QPixmap**  from an image read directly from an
        **imageReader**. The **flags** argument is a bitwise-OR of the
        **Qt::ImageConversionFlags** . Passing 0 for **flags** sets all the
        default options.

        On some systems, reading an image directly to **QPixmap**  can use less
        memory than reading a **QImage**  to convert it to **QPixmap** .

        **See also** **fromImage** (), **toImage** (), and **Pixmap Conversion**
        .
        """
        ...

    def hasAlpha(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#hasAlpha

        **bool QPixmap::hasAlpha() const**

        Returns `true` if this pixmap has an alpha channel, **or** has a mask,
        otherwise returns `false`.

        **See also** **hasAlphaChannel** () and **mask** ().
        """
        ...

    def hasAlphaChannel(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#hasAlphaChannel

        **bool QPixmap::hasAlphaChannel() const**

        Returns `true` if the pixmap has a format that respects the alpha
        channel, otherwise returns `false`.

        **See also** **hasAlpha** ().
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixmap.html#height

        **int QPixmap::height() const**

        Returns the height of the pixmap.

        **See also** **size** () and **Pixmap Information** .
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#isNull

        **bool QPixmap::isNull() const**

        Returns `true` if this is a null pixmap; otherwise returns `false`.

        A null pixmap has zero width, zero height and no contents. You cannot
        draw in a null pixmap.
        """
        ...

    def isQBitmap(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#isQBitmap

        **bool QPixmap::isQBitmap() const**

        Returns `true` if this is a **QBitmap** ; otherwise returns `false`.
        """
        ...

    def load(
        self,
        fileName: str,
        format: Optional[bytes] = ...,
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#load

        **bool QPixmap::load(const QString & fileName , const char * format =
        nullptr, Qt::ImageConversionFlags flags = Qt::AutoColor)**

        Loads a pixmap from the file with the given **fileName**. Returns true
        if the pixmap was successfully loaded; otherwise invalidates the pixmap
        and returns `false`.

        The loader attempts to read the pixmap using the specified **format**.
        If the **format** is not specified (which is the default), the loader
        probes the file for a header to guess the file format.

        The file name can either refer to an actual file on disk or to one of
        the application's embedded resources. See the **Resource System**
        overview for details on how to embed pixmaps and other resource files in
        the application's executable.

        If the data needs to be modified to fit in a lower-resolution result
        (e.g. converting from 32-bit to 8-bit), use the **flags** to control the
        conversion.

        Note that QPixmaps are automatically added to the **QPixmapCache**  when
        loaded from a file in main thread; the key used is internal and cannot
        be acquired.

        **See also** **loadFromData** () and **Reading and Writing Image Files**
        .
        """
        ...

    @overload
    def loadFromData(
        self,
        buf: bytes,
        len: int,
        format: Optional[bytes] = ...,
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#loadFromData

        **bool QPixmap::loadFromData(const uchar * data , uint len , const char
        * format = nullptr, Qt::ImageConversionFlags flags = Qt::AutoColor)**

        Loads a pixmap from the **len** first bytes of the given binary
        **data**. Returns `true` if the pixmap was loaded successfully;
        otherwise invalidates the pixmap and returns `false`.

        The loader attempts to read the pixmap using the specified **format**.
        If the **format** is not specified (which is the default), the loader
        probes the file for a header to guess the file format.

        If the data needs to be modified to fit in a lower-resolution result
        (e.g. converting from 32-bit to 8-bit), use the **flags** to control the
        conversion.

        **See also** **load** () and **Reading and Writing Image Files** .
        """
        ...

    @overload
    def loadFromData(
        self,
        data: Union[PySide6.QtCore.QByteArray, bytes],
        format: Optional[bytes] = ...,
        flags: PySide6.QtCore.Qt.ImageConversionFlags = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#loadFromData-1

        **bool QPixmap::loadFromData(const QByteArray & data , const char *
        format = nullptr, Qt::ImageConversionFlags flags = Qt::AutoColor)**

        This is an overloaded function.

        Loads a pixmap from the binary **data** using the specified **format**
        and conversion **flags**.
        """
        ...

    def mask(self) -> PySide6.QtGui.QBitmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#mask

        **QBitmap QPixmap::mask() const**

        Extracts a bitmap mask from the pixmap's alpha channel.

        **Warning:** This is potentially an expensive operation. The mask of the
        pixmap is extracted dynamically from the pixeldata.

        **See also** **setMask** () and **Pixmap Information** .
        """
        ...

    def metric(self, arg__1: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int:
        ...

    def paintEngine(self) -> PySide6.QtGui.QPaintEngine:
        ...

    def rect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpixmap.html#rect

        **QRect QPixmap::rect() const**

        Returns the pixmap's enclosing rectangle.

        **See also** **Pixmap Information** .
        """
        ...

    @overload
    def save(
        self,
        device: PySide6.QtCore.QIODevice,
        format: Optional[bytes] = ...,
        quality: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#save

        **bool QPixmap::save(const QString & fileName , const char * format =
        nullptr, int quality = -1) const**

        Saves the pixmap to the file with the given **fileName** using the
        specified image file **format** and **quality** factor. Returns `true`
        if successful; otherwise returns `false`.

        The **quality** factor must be in the range [0,100] or -1. Specify 0 to
        obtain small compressed files, 100 for large uncompressed files, and -1
        to use the default settings.

        If **format** is `nullptr`, an image format will be chosen from
        **fileName** 's suffix.

        **See also** **Reading and Writing Image Files** .
        """
        ...

    @overload
    def save(
        self, fileName: str, format: Optional[bytes] = ..., quality: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmap.html#save-1

        **bool QPixmap::save(QIODevice * device , const char * format = nullptr,
        int quality = -1) const**

        This is an overloaded function.

        This function writes a **QPixmap**  to the given **device** using the
        specified image file **format** and **quality** factor. This can be
        used, for example, to save a pixmap directly into a **QByteArray** :

        **QPixmap**  pixmap;
            **QByteArray**  bytes;
            **QBuffer**
        buffer(&bytes);
            buffer.open(**QIODevice** ::WriteOnly);
        pixmap.save(&buffer, "PNG"); // writes pixmap into bytes in PNG format
        """
        ...

    @overload
    def scaled(
        self,
        s: PySide6.QtCore.QSize,
        aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ...,
        mode: PySide6.QtCore.Qt.TransformationMode = ...,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#scaled

        **QPixmap QPixmap::scaled(const QSize & size , Qt::AspectRatioMode
        aspectRatioMode = Qt::IgnoreAspectRatio, Qt::TransformationMode
        transformMode = Qt::FastTransformation) const**

        Scales the pixmap to the given **size** , using the aspect ratio and
        transformation modes specified by **aspectRatioMode** and
        **transformMode**.

        ![](images/qimage-scaling.png)

        * If **aspectRatioMode** is **Qt::IgnoreAspectRatio** , the pixmap is
        scaled to **size**.
          * If **aspectRatioMode** is
        **Qt::KeepAspectRatio** , the pixmap is scaled to a rectangle as large
        as possible inside **size** , preserving the aspect ratio.
          * If
        **aspectRatioMode** is **Qt::KeepAspectRatioByExpanding** , the pixmap
        is scaled to a rectangle as small as possible outside **size** ,
        preserving the aspect ratio.

        If the given **size** is empty, this function returns a null pixmap.

        In some cases it can be more beneficial to draw the pixmap to a painter
        with a scale set rather than scaling the pixmap. This is the case when
        the painter is for instance based on OpenGL or when the scale factor
        changes rapidly.

        **See also** **isNull** () and **Pixmap Transformations** .
        """
        ...

    @overload
    def scaled(
        self,
        w: int,
        h: int,
        aspectMode: PySide6.QtCore.Qt.AspectRatioMode = ...,
        mode: PySide6.QtCore.Qt.TransformationMode = ...,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#scaled-1

        **QPixmap QPixmap::scaled(int width , int height , Qt::AspectRatioMode
        aspectRatioMode = Qt::IgnoreAspectRatio, Qt::TransformationMode
        transformMode = Qt::FastTransformation) const**

        This is an overloaded function.

        Returns a copy of the pixmap scaled to a rectangle with the given
        **width** and **height** according to the given **aspectRatioMode** and
        **transformMode**.

        If either the **width** or the **height** is zero or negative, this
        function returns a null pixmap.
        """
        ...

    def scaledToHeight(
        self, h: int, mode: PySide6.QtCore.Qt.TransformationMode = ...
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#scaledToHeight

        **QPixmap QPixmap::scaledToHeight(int height , Qt::TransformationMode
        mode = Qt::FastTransformation) const**

        Returns a scaled copy of the image. The returned image is scaled to the
        given **height** using the specified transformation **mode**. The width
        of the pixmap is automatically calculated so that the aspect ratio of
        the pixmap is preserved.

        If **height** is 0 or negative, a null pixmap is returned.

        **See also** **isNull** () and **Pixmap Transformations** .
        """
        ...

    def scaledToWidth(
        self, w: int, mode: PySide6.QtCore.Qt.TransformationMode = ...
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#scaledToWidth

        **QPixmap QPixmap::scaledToWidth(int width , Qt::TransformationMode mode
        = Qt::FastTransformation) const**

        Returns a scaled copy of the image. The returned image is scaled to the
        given **width** using the specified transformation **mode**. The height
        of the pixmap is automatically calculated so that the aspect ratio of
        the pixmap is preserved.

        If **width** is 0 or negative, a null pixmap is returned.

        **See also** **isNull** () and **Pixmap Transformations** .
        """
        ...

    @overload
    def scroll(
        self,
        dx: int,
        dy: int,
        rect: PySide6.QtCore.QRect,
        exposed: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
            NoneType,
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#scroll

        **void QPixmap::scroll(int dx , int dy , int x , int y , int width , int
        height , QRegion * exposed = nullptr)**

        This convenience function is equivalent to calling QPixmap::scroll(
        **dx** , **dy** , **QRect** ( **x** , **y** , **width** , **height** ),
        **exposed** ).

        **See also** **QWidget::scroll** () and **QGraphicsItem::scroll** ().
        """
        ...

    @overload
    def scroll(
        self,
        dx: int,
        dy: int,
        x: int,
        y: int,
        width: int,
        height: int,
        exposed: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
            NoneType,
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#scroll-1

        **void QPixmap::scroll(int dx , int dy , const QRect & rect , QRegion *
        exposed = nullptr)**

        Scrolls the area **rect** of this pixmap by ( **dx** , **dy** ). The
        exposed region is left unchanged. You can optionally pass a pointer to
        an empty **QRegion**  to get the region that is **exposed** by the
        scroll operation.

        **QPixmap**  pixmap("background.png");
            **QRegion**  exposed;
        pixmap.scroll(10, 10, pixmap.rect(), &exposed);

        You cannot scroll while there is an active painter on the pixmap.

        **See also** **QWidget::scroll** () and **QGraphicsItem::scroll** ().
        """
        ...

    def setDevicePixelRatio(self, scaleFactor: float) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#setDevicePixelRatio

        **void QPixmap::setDevicePixelRatio(qreal scaleFactor )**

        Sets the device pixel ratio for the pixmap. This is the ratio between
        image pixels and device-independent pixels.

        The default **scaleFactor** is 1.0. Setting it to something else has two
        effects:

        QPainters that are opened on the pixmap will be scaled. For example,
        painting on a 200x200 image if with a ratio of 2.0 will result in
        effective (device-independent) painting bounds of 100x100.

        Code paths in Qt that calculate layout geometry based on the pixmap size
        will take the ratio into account: **QSize**  layoutSize =
        pixmap.**size** () / pixmap.**devicePixelRatio** () The net effect of
        this is that the pixmap is displayed as high-DPI pixmap rather than a
        large pixmap (see **Drawing High Resolution Versions of Pixmaps and
        Images** ).

        **See also** **devicePixelRatio** () and **deviceIndependentSize** ().
        """
        ...

    def setMask(self, arg__1: Union[PySide6.QtGui.QBitmap, str]) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#setMask

        **void QPixmap::setMask(const QBitmap & mask )**

        Sets a mask bitmap.

        This function merges the **mask** with the pixmap's alpha channel. A
        pixel value of 1 on the mask means the pixmap's pixel is unchanged; a
        value of 0 means the pixel is transparent. The mask must have the same
        size as this pixmap.

        Setting a null mask resets the mask, leaving the previously transparent
        pixels black. The effect of this function is undefined when the pixmap
        is being painted on.

        **Warning:** This is potentially an expensive operation.

        **See also** **mask** (), **Pixmap Transformations** , and **QBitmap** .
        """
        ...

    def size(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qpixmap.html#size

        **QSize QPixmap::size() const**

        Returns the size of the pixmap.

        **See also** **width** (), **height** (), and **Pixmap Information** .
        """
        ...

    def swap(
        self, other: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpixmap.html#swap

        **void QPixmap::swap(QPixmap & other )**

        Swaps pixmap **other** with this pixmap. This operation is very fast and
        never fails.
        """
        ...

    def toImage(self) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qpixmap.html#toImage

        **QImage QPixmap::toImage() const**

        Converts the pixmap to a **QImage** . Returns a null image if the
        conversion fails.

        If the pixmap has 1-bit depth, the returned image will also be 1 bit
        deep. Images with more bits will be returned in a format closely
        represents the underlying system. Usually this will be
        **QImage::Format_ARGB32_Premultiplied**  for pixmaps with an alpha and
        **QImage::Format_RGB32**  or **QImage::Format_RGB16**  for pixmaps
        without alpha.

        Note that for the moment, alpha masks on monochrome images are ignored.

        **See also** **fromImage** () and **Image Formats** .
        """
        ...

    def transformed(
        self,
        arg__1: PySide6.QtGui.QTransform,
        mode: PySide6.QtCore.Qt.TransformationMode = ...,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmap.html#transformed

        **QPixmap QPixmap::transformed(const QTransform & transform ,
        Qt::TransformationMode mode = Qt::FastTransformation) const**

        Returns a copy of the pixmap that is transformed using the given
        transformation **transform** and transformation **mode**. The original
        pixmap is not changed.

        The transformation **transform** is internally adjusted to compensate
        for unwanted translation; i.e. the pixmap produced is the smallest
        pixmap that contains all the transformed points of the original pixmap.
        Use the **trueMatrix** () function to retrieve the actual matrix used
        for transforming the pixmap.

        This function is slow because it involves transformation to a **QImage**
        , non-trivial computations and a transformation back to a **QPixmap** .

        **See also** **trueMatrix** () and **Pixmap Transformations** .
        """
        ...

    @staticmethod
    def trueMatrix(
        m: PySide6.QtGui.QTransform, w: int, h: int
    ) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qpixmap.html#trueMatrix

        **[static] QTransform QPixmap::trueMatrix(const QTransform & matrix ,
        int width , int height )**

        Returns the actual matrix used for transforming a pixmap with the given
        **width** , **height** and **matrix**.

        When transforming a pixmap using the **transformed** () function, the
        transformation matrix is internally adjusted to compensate for unwanted
        translation, i.e. **transformed** () returns the smallest pixmap
        containing all transformed points of the original pixmap. This function
        returns the modified matrix, which maps points correctly from the
        original pixmap into the new pixmap.

        **See also** **transformed** () and **Pixmap Transformations** .
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-6/qpixmap.html#width

        **int QPixmap::width() const**

        Returns the width of the pixmap.

        **See also** **size** () and **Pixmap Information** .
        """
        ...
