"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPainterPath(object):
    """
    https://doc.qt.io/qt-6/qpainterpath.html

    **Detailed Description**

    A painter path is an object composed of a number of graphical building
    blocks, such as rectangles, ellipses, lines, and curves. Building blocks can
    be joined in closed subpaths, for example as a rectangle or an ellipse. A
    closed path has coinciding start and end points. Or they can exist
    independently as unclosed subpaths, such as lines and curves.

    A QPainterPath object can be used for filling, outlining, and clipping. To
    generate fillable outlines for a given painter path, use the
    **QPainterPathStroker**  class. The main advantage of painter paths over
    normal drawing operations is that complex shapes only need to be created
    once; then they can be drawn many times using only calls to the
    **QPainter::drawPath** () function.

    QPainterPath provides a collection of functions that can be used to obtain
    information about the path and its elements. In addition it is possible to
    reverse the order of the elements using the **toReversed** () function.
    There are also several functions to convert this painter path object into a
    polygon representation.

    **Composing a QPainterPath**

    A QPainterPath object can be constructed as an empty path, with a given
    start point, or as a copy of another QPainterPath object. Once created,
    lines and curves can be added to the path using the **lineTo** (), **arcTo**
    (), **cubicTo** () and **quadTo** () functions. The lines and curves stretch
    from the **currentPosition** () to the position passed as argument.

    The **currentPosition** () of the QPainterPath object is always the end
    position of the last subpath that was added (or the initial start point).
    Use the **moveTo** () function to move the **currentPosition** () without
    adding a component. The **moveTo** () function implicitly starts a new
    subpath, and closes the previous one. Another way of starting a new subpath
    is to call the **closeSubpath** () function which closes the current path by
    adding a line from the **currentPosition** () back to the path's start
    position. Note that the new path will have (0, 0) as its initial
    **currentPosition** ().

    QPainterPath class also provides several convenience functions to add closed
    subpaths to a painter path: **addEllipse** (), **addPath** (), **addRect**
    (), **addRegion** () and **addText** (). The **addPolygon** () function adds
    an **unclosed** subpath. In fact, these functions are all collections of
    **moveTo** (), **lineTo** () and **cubicTo** () operations.

    In addition, a path can be added to the current path using the
    **connectPath** () function. But note that this function will connect the
    last element of the current path to the first element of given one by adding
    a line.

    Below is a code snippet that shows how a QPainterPath object can be used:

    ![](images/qpainterpath-construction.png)



        **QPainterPath**
    path;
        path.addRect(20, 20, 60, 60);

        path.moveTo(0, 0);
    path.cubicTo(99, 0,  50, 50,  99, 99);
        path.cubicTo(0, 99,  50, 50,  0,
    0);

        **QPainter**  painter(this);
        painter.fillRect(0, 0, 100,
    100, Qt::white);
        painter.setPen(**QPen** (**QColor** (79, 106, 25), 1,
    Qt::SolidLine,
                            Qt::FlatCap, Qt::MiterJoin));
    painter.setBrush(**QColor** (122, 163, 39));
    painter.drawPath(path);

    The painter path is initially empty when constructed. We first add a
    rectangle, which is a closed subpath. Then we add two bezier curves which
    together form a closed subpath even though they are not closed individually.
    Finally we draw the entire path. The path is filled using the default fill
    rule, **Qt::OddEvenFill** . Qt provides two methods for filling paths:

    **Qt::OddEvenFill** **Qt::WindingFill**
    ![](images/qt-fillrule-
    oddeven.png)![](images/qt-fillrule-winding.png)

    See the **Qt::FillRule**  documentation for the definition of the rules. A
    painter path's currently set fill rule can be retrieved using the
    **fillRule** () function, and altered using the **setFillRule** () function.

    **QPainterPath Information**

    The QPainterPath class provides a collection of functions that returns
    information about the path and its elements.

    The **currentPosition** () function returns the end point of the last
    subpath that was added (or the initial start point). The **elementAt** ()
    function can be used to retrieve the various subpath elements, the
    **number** of elements can be retrieved using the **elementCount** ()
    function, and the **isEmpty** () function tells whether this QPainterPath
    object contains any elements at all.

    The **controlPointRect** () function returns the rectangle containing all
    the points and control points in this path. This function is significantly
    faster to compute than the exact **boundingRect** () which returns the
    bounding rectangle of this painter path with floating point precision.

    Finally, QPainterPath provides the **contains** () function which can be
    used to determine whether a given point or rectangle is inside the path, and
    the **intersects** () function which determines if any of the points inside
    a given rectangle also are inside this path.

    **QPainterPath Conversion**

    For compatibility reasons, it might be required to simplify the
    representation of a painter path: QPainterPath provides the
    **toFillPolygon** (), **toFillPolygons** () and **toSubpathPolygons** ()
    functions which convert the painter path into a polygon. The
    **toFillPolygon** () returns the painter path as one single polygon, while
    the two latter functions return a list of polygons.

    The **toFillPolygons** () and **toSubpathPolygons** () functions are
    provided because it is usually faster to draw several small polygons than to
    draw one large polygon, even though the total number of points drawn is the
    same. The difference between the two is the **number** of polygons they
    return: The **toSubpathPolygons** () creates one polygon for each subpath
    regardless of intersecting subpaths (i.e. overlapping bounding rectangles),
    while the **toFillPolygons** () functions creates only one polygon for
    overlapping subpaths.

    The **toFillPolygon** () and **toFillPolygons** () functions first convert
    all the subpaths to polygons, then uses a rewinding technique to make sure
    that overlapping subpaths can be filled using the correct fill rule. Note
    that rewinding inserts additional lines in the polygon so the outline of the
    fill polygon does not match the outline of the path.

    **Examples**

    Qt provides the **Painter Paths Example**  and the **Vector Deformation
    example**  which are located in Qt's example directory.

    The **Painter Paths Example**  shows how painter paths can be used to build
    complex shapes for rendering and lets the user experiment with the filling
    and stroking. The **Vector Deformation Example**  shows how to use
    QPainterPath to draw text.

    **Painter Paths Example** **Vector Deformation Example**
    ![](images/qpainterpath-example.png)![](images/qpainterpath-demo.png)

    **See also** **QPainterPathStroker** , **QPainter** , **QRegion** , and
    **Painter Paths Example** .
    """

    MoveToElement: QPainterPath.ElementType = ...
    LineToElement: QPainterPath.ElementType = ...
    CurveToElement: QPainterPath.ElementType = ...
    CurveToDataElement: QPainterPath.ElementType = ...

    class Element(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(self, Element: PySide6.QtGui.QPainterPath.Element) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def isCurveTo(self) -> bool:
            ...

        def isLineTo(self) -> bool:
            ...

        def isMoveTo(self) -> bool:
            ...

    class ElementType(Enum):
        MoveToElement: QPainterPath.ElementType = ...
        LineToElement: QPainterPath.ElementType = ...
        CurveToElement: QPainterPath.ElementType = ...
        CurveToDataElement: QPainterPath.ElementType = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#QPainterPath

        **QPainterPath::QPainterPath()**

        Constructs an empty QPainterPath object.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtGui.QPainterPath) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#QPainterPath-1

        **QPainterPath::QPainterPath(const QPointF & startPoint )**

        Creates a QPainterPath object with the given **startPoint** as its
        current position.
        """
        ...

    @overload
    def __init__(
        self,
        startPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#QPainterPath-2

        **QPainterPath::QPainterPath(const QPainterPath & path )**

        Creates a QPainterPath object that is a copy of the given **path**.

        **See also** **operator=** ().
        """
        ...

    def __add__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        ...

    def __and__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        ...

    def __iand__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        ...

    def __ior__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        ...

    def __isub__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QPainterPath:
        ...

    def __or__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __sub__(self, other: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        ...

    @overload
    def addEllipse(
        self,
        center: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        rx: float,
        ry: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addEllipse

        **void QPainterPath::addEllipse(const QRectF & boundingRectangle )**

        Creates an ellipse within the specified **boundingRectangle** and adds
        it to the painter path as a closed subpath.

        The ellipse is composed of a clockwise curve, starting and finishing at
        zero degrees (the 3 o'clock position).

        ![](images/qpainterpath-addellipse.png)
        **QLinearGradient**  myGradient;
            **QPen**  myPen;
            **QRectF**
        boundingRectangle;

            **QPainterPath**  myPath;
        myPath.addEllipse(boundingRectangle);

            **QPainter**
        painter(this);
            painter.setBrush(myGradient);
        painter.setPen(myPen);
            painter.drawPath(myPath);

        **See also** **arcTo** (), **QPainter::drawEllipse** (), and **Composing
        a QPainterPath** .
        """
        ...

    @overload
    def addEllipse(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addEllipse-1

        **void QPainterPath::addEllipse(qreal x , qreal y , qreal width , qreal
        height )**

        This is an overloaded function.

        Creates an ellipse within the bounding rectangle defined by its top-left
        corner at ( **x** , **y** ), **width** and **height** , and adds it to
        the painter path as a closed subpath.
        """
        ...

    @overload
    def addEllipse(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addEllipse-2

        **void QPainterPath::addEllipse(const QPointF & center , qreal rx ,
        qreal ry )**

        This is an overloaded function.

        Creates an ellipse positioned at **center** with radii **rx** and **ry**
        , and adds it to the painter path as a closed subpath.
        """
        ...

    def addPath(self, path: PySide6.QtGui.QPainterPath) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addPath

        **void QPainterPath::addPath(const QPainterPath & path )**

        Adds the given **path** to **this** path as a closed subpath.

        **See also** **connectPath** () and **Composing a QPainterPath** .
        """
        ...

    def addPolygon(
        self,
        polygon: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addPolygon

        **void QPainterPath::addPolygon(const QPolygonF & polygon )**

        Adds the given **polygon** to the path as an (unclosed) subpath.

        Note that the current position after the polygon has been added, is the
        last point in **polygon**. To draw a line back to the first point, use
        the **closeSubpath** () function.

        ![](images/qpainterpath-addpolygon.png)
        **QLinearGradient**  myGradient;
            **QPen**  myPen;
            **QPolygonF**
        myPolygon;

            **QPainterPath**  myPath;
        myPath.addPolygon(myPolygon);

            **QPainter**  painter(this);
        painter.setBrush(myGradient);
            painter.setPen(myPen);
        painter.drawPath(myPath);

        **See also** **lineTo** () and **Composing a QPainterPath** .
        """
        ...

    @overload
    def addRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addRect

        **void QPainterPath::addRect(const QRectF & rectangle )**

        Adds the given **rectangle** to this path as a closed subpath.

        The **rectangle** is added as a clockwise set of lines. The painter
        path's current position after the **rectangle** has been added is at the
        top-left corner of the rectangle.

        ![](images/qpainterpath-addrectangle.png)
        **QLinearGradient**  myGradient;
            **QPen**  myPen;
            **QRectF**
        myRectangle;

            **QPainterPath**  myPath;
        myPath.addRect(myRectangle);

            **QPainter**  painter(this);
        painter.setBrush(myGradient);
            painter.setPen(myPen);
        painter.drawPath(myPath);

        **See also** **addRegion** (), **lineTo** (), and **Composing a
        QPainterPath** .
        """
        ...

    @overload
    def addRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addRect-1

        **void QPainterPath::addRect(qreal x , qreal y , qreal width , qreal
        height )**

        This is an overloaded function.

        Adds a rectangle at position ( **x** , **y** ), with the given **width**
        and **height** , as a closed subpath.
        """
        ...

    def addRegion(
        self,
        region: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addRegion

        **void QPainterPath::addRegion(const QRegion & region )**

        Adds the given **region** to the path by adding each rectangle in the
        region as a separate closed subpath.

        **See also** **addRect** () and **Composing a QPainterPath** .
        """
        ...

    @overload
    def addRoundedRect(
        self,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
        xRadius: float,
        yRadius: float,
        mode: PySide6.QtCore.Qt.SizeMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addRoundedRect

        **void QPainterPath::addRoundedRect(const QRectF & rect , qreal xRadius
        , qreal yRadius , Qt::SizeMode mode = Qt::AbsoluteSize)**

        Adds the given rectangle **rect** with rounded corners to the path.

        The **xRadius** and **yRadius** arguments specify the radii of the
        ellipses defining the corners of the rounded rectangle. When **mode** is
        **Qt::RelativeSize** , **xRadius** and **yRadius** are specified in
        percentage of half the rectangle's width and height respectively, and
        should be in the range 0.0 to 100.0.

        **See also** **addRect** ().
        """
        ...

    @overload
    def addRoundedRect(
        self,
        x: float,
        y: float,
        w: float,
        h: float,
        xRadius: float,
        yRadius: float,
        mode: PySide6.QtCore.Qt.SizeMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addRoundedRect-1

        **void QPainterPath::addRoundedRect(qreal x , qreal y , qreal w , qreal
        h , qreal xRadius , qreal yRadius , Qt::SizeMode mode =
        Qt::AbsoluteSize)**

        This is an overloaded function.

        Adds the given rectangle **x** , **y** , **w** , **h** with rounded
        corners to the path.
        """
        ...

    @overload
    def addText(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        f: Union[PySide6.QtGui.QFont, str, Sequence[str]],
        text: str,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addText

        **void QPainterPath::addText(const QPointF & point , const QFont & font
        , const QString & text )**

        Adds the given **text** to this path as a set of closed subpaths created
        from the **font** supplied. The subpaths are positioned so that the left
        end of the text's baseline lies at the specified **point**.

        ![](images/qpainterpath-addtext.png)



            **QLinearGradient**
        myGradient;
            **QPen**  myPen;
            **QFont**  myFont;
            **QPointF**
        baseline(x, y);

            **QPainterPath**  myPath;
        myPath.addText(baseline, myFont, tr("Qt"));

            **QPainter**
        painter(this);
            painter.setBrush(myGradient);
        painter.setPen(myPen);
            painter.drawPath(myPath);

        **See also** **QPainter::drawText** () and **Composing a QPainterPath**
        .
        """
        ...

    @overload
    def addText(
        self,
        x: float,
        y: float,
        f: Union[PySide6.QtGui.QFont, str, Sequence[str]],
        text: str,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#addText-1

        **void QPainterPath::addText(qreal x , qreal y , const QFont & font ,
        const QString & text )**

        This is an overloaded function.

        Adds the given **text** to this path as a set of closed subpaths created
        from the **font** supplied. The subpaths are positioned so that the left
        end of the text's baseline lies at the point specified by ( **x** ,
        **y** ).
        """
        ...

    def angleAtPercent(self, t: float) -> float:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#angleAtPercent

        **qreal QPainterPath::angleAtPercent(qreal t ) const**

        Returns the angle of the path tangent at the percentage **t**. The
        argument **t** has to be between 0 and 1.

        Positive values for the angles mean counter-clockwise while negative
        values mean the clockwise direction. Zero degrees is at the 3 o'clock
        position.

        Note that similarly to the other percent methods, the percentage
        measurement is not linear with regards to the length if curves are
        present in the path. When curves are present the percentage argument is
        mapped to the t parameter of the Bezier equations.
        """
        ...

    @overload
    def arcMoveTo(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], angle: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#arcMoveTo

        **void QPainterPath::arcMoveTo(const QRectF & rectangle , qreal angle
        )**

        Creates a move to that lies on the arc that occupies the given
        **rectangle** at **angle**.

        Angles are specified in degrees. Clockwise arcs can be specified using
        negative angles.

        **See also** **moveTo** () and **arcTo** ().
        """
        ...

    @overload
    def arcMoveTo(self, x: float, y: float, w: float, h: float, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#arcMoveTo-1

        **void QPainterPath::arcMoveTo(qreal x , qreal y , qreal width , qreal
        height , qreal angle )**

        This is an overloaded function.

        Creates a move to that lies on the arc that occupies the **QRectF** (
        **x** , **y** , **width** , **height** ) at **angle**.
        """
        ...

    @overload
    def arcTo(
        self,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
        startAngle: float,
        arcLength: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#arcTo

        **void QPainterPath::arcTo(const QRectF & rectangle , qreal startAngle ,
        qreal sweepLength )**

        Creates an arc that occupies the given **rectangle** , beginning at the
        specified **startAngle** and extending **sweepLength** degrees counter-
        clockwise.

        Angles are specified in degrees. Clockwise arcs can be specified using
        negative angles.

        Note that this function connects the starting point of the arc to the
        current position if they are not already connected. After the arc has
        been added, the current position is the last point in arc. To draw a
        line back to the first point, use the **closeSubpath** () function.

        ![](images/qpainterpath-arcto.png)



            **QPainterPath**
        myPath;
            myPath.moveTo(center);
            myPath.arcTo(boundingRect,
        startAngle,
                         sweepLength);

            **QPainter**
        painter(this);
            painter.setBrush(myGradient);
        painter.setPen(myPen);
            painter.drawPath(myPath);

        **See also** **arcMoveTo** (), **addEllipse** (), **QPainter::drawArc**
        (), **QPainter::drawPie** (), and **Composing a QPainterPath** .
        """
        ...

    @overload
    def arcTo(
        self,
        x: float,
        y: float,
        w: float,
        h: float,
        startAngle: float,
        arcLength: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#arcTo-1

        **void QPainterPath::arcTo(qreal x , qreal y , qreal width , qreal
        height , qreal startAngle , qreal sweepLength )**

        This is an overloaded function.

        Creates an arc that occupies the rectangle **QRectF** ( **x** , **y** ,
        **width** , **height** ), beginning at the specified **startAngle** and
        extending **sweepLength** degrees counter-clockwise.
        """
        ...

    def boundingRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#boundingRect

        **QRectF QPainterPath::boundingRect() const**

        Returns the bounding rectangle of this painter path as a rectangle with
        floating point precision.

        **See also** **controlPointRect** ().
        """
        ...

    def capacity(self) -> int:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#capacity

        **[since 5.13] int QPainterPath::capacity() const**

        Returns the number of elements allocated by the **QPainterPath** .

        This function was introduced in Qt 5.13.

        **See also** **clear** () and **reserve** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#clear

        **[since 5.13] void QPainterPath::clear()**

        Clears the path elements stored.

        This allows the path to reuse previous memory allocations.

        This function was introduced in Qt 5.13.

        **See also** **reserve** () and **capacity** ().
        """
        ...

    def closeSubpath(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#closeSubpath

        **void QPainterPath::closeSubpath()**

        Closes the current subpath by drawing a line to the beginning of the
        subpath, automatically starting a new path. The current point of the new
        path is (0, 0).

        If the subpath does not contain any elements, this function does
        nothing.

        **See also** **moveTo** () and **Composing a QPainterPath** .
        """
        ...

    def connectPath(self, path: PySide6.QtGui.QPainterPath) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#connectPath

        **void QPainterPath::connectPath(const QPainterPath & path )**

        Connects the given **path** to **this** path by adding a line from the
        last element of this path to the first element of the given path.

        **See also** **addPath** () and **Composing a QPainterPath** .
        """
        ...

    @overload
    def contains(self, p: PySide6.QtGui.QPainterPath) -> bool:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#contains

        **bool QPainterPath::contains(const QPointF & point ) const**

        Returns `true` if the given **point** is inside the path, otherwise
        returns `false`.

        **See also** **intersects** ().
        """
        ...

    @overload
    def contains(
        self,
        pt: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#contains-1

        **bool QPainterPath::contains(const QRectF & rectangle ) const**

        Returns `true` if the given **rectangle** is inside the path, otherwise
        returns `false`.
        """
        ...

    @overload
    def contains(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#contains-2

        **bool QPainterPath::contains(const QPainterPath & p ) const**

        Returns `true` if the given path **p** is contained within the current
        path. Returns `false` if any edges of the current path and **p**
        intersect.

        Set operations on paths will treat the paths as areas. Non-closed paths
        will be treated as implicitly closed.

        **See also** **intersects** ().
        """
        ...

    def controlPointRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#controlPointRect

        **QRectF QPainterPath::controlPointRect() const**

        Returns the rectangle containing all the points and control points in
        this path.

        This function is significantly faster to compute than the exact
        **boundingRect** (), and the returned rectangle is always a superset of
        the rectangle returned by **boundingRect** ().

        **See also** **boundingRect** ().
        """
        ...

    @overload
    def cubicTo(
        self,
        ctrlPt1: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        ctrlPt2: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        endPt: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#cubicTo

        **void QPainterPath::cubicTo(const QPointF & c1 , const QPointF & c2 ,
        const QPointF & endPoint )**

        Adds a cubic Bezier curve between the current position and the given
        **endPoint** using the control points specified by **c1** , and **c2**.

        After the curve is added, the current position is updated to be at the
        end point of the curve.

        ![](images/qpainterpath-cubicto.png)



            **QLinearGradient**
        myGradient;
            **QPen**  myPen;

            **QPainterPath**  myPath;
        myPath.cubicTo(c1, c2, endPoint);

            **QPainter**  painter(this);
        painter.setBrush(myGradient);
            painter.setPen(myPen);
        painter.drawPath(myPath);

        **See also** **quadTo** () and **Composing a QPainterPath** .
        """
        ...

    @overload
    def cubicTo(
        self,
        ctrlPt1x: float,
        ctrlPt1y: float,
        ctrlPt2x: float,
        ctrlPt2y: float,
        endPtx: float,
        endPty: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#cubicTo-1

        **void QPainterPath::cubicTo(qreal c1X , qreal c1Y , qreal c2X , qreal
        c2Y , qreal endPointX , qreal endPointY )**

        This is an overloaded function.

        Adds a cubic Bezier curve between the current position and the end point
        ( **endPointX** , **endPointY** ) with control points specified by (
        **c1X** , **c1Y** ) and ( **c2X** , **c2Y** ).
        """
        ...

    def currentPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#currentPosition

        **QPointF QPainterPath::currentPosition() const**

        Returns the current position of the path.
        """
        ...

    def elementAt(self, i: int) -> PySide6.QtGui.QPainterPath.Element:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#elementAt

        **QPainterPath::Element QPainterPath::elementAt(int index ) const**

        Returns the element at the given **index** in the painter path.

        **See also** **ElementType** , **elementCount** (), and **isEmpty** ().
        """
        ...

    def elementCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#elementCount

        **int QPainterPath::elementCount() const**

        Returns the number of path elements in the painter path.

        **See also** **ElementType** , **elementAt** (), and **isEmpty** ().
        """
        ...

    def fillRule(self) -> PySide6.QtCore.Qt.FillRule:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#fillRule

        **Qt::FillRule QPainterPath::fillRule() const**

        Returns the painter path's currently set fill rule.

        **See also** **setFillRule** ().
        """
        ...

    def intersected(self, r: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#intersected

        **QPainterPath QPainterPath::intersected(const QPainterPath & p )
        const**

        Returns a path which is the intersection of this path's fill area and
        **p** 's fill area. Bezier curves may be flattened to line segments due
        to numerical instability of doing bezier curve intersections.
        """
        ...

    @overload
    def intersects(self, p: PySide6.QtGui.QPainterPath) -> bool:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#intersects

        **bool QPainterPath::intersects(const QRectF & rectangle ) const**

        Returns `true` if any point in the given **rectangle** intersects the
        path; otherwise returns `false`.

        There is an intersection if any of the lines making up the rectangle
        crosses a part of the path or if any part of the rectangle overlaps with
        any area enclosed by the path. This function respects the current
        **fillRule**  to determine what is considered inside the path.

        **See also** **contains** ().
        """
        ...

    @overload
    def intersects(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#intersects-1

        **bool QPainterPath::intersects(const QPainterPath & p ) const**

        Returns `true` if the current path intersects at any point the given
        path **p**. Also returns `true` if the current path contains or is
        contained by any part of **p**.

        Set operations on paths will treat the paths as areas. Non-closed paths
        will be treated as implicitly closed.

        **See also** **contains** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#isEmpty

        **bool QPainterPath::isEmpty() const**

        Returns `true` if either there are no elements in this path, or if the
        only element is a **MoveToElement** ; otherwise returns `false`.

        **See also** **elementCount** ().
        """
        ...

    def length(self) -> float:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#length

        **qreal QPainterPath::length() const**

        Returns the length of the current path.
        """
        ...

    @overload
    def lineTo(
        self,
        p: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#lineTo

        **void QPainterPath::lineTo(const QPointF & endPoint )**

        Adds a straight line from the current position to the given
        **endPoint**. After the line is drawn, the current position is updated
        to be at the end point of the line.

        **See also** **addPolygon** (), **addRect** (), and **Composing a
        QPainterPath** .
        """
        ...

    @overload
    def lineTo(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#lineTo-1

        **void QPainterPath::lineTo(qreal x , qreal y )**

        This is an overloaded function.

        Draws a line from the current position to the point ( **x** , **y** ).
        """
        ...

    @overload
    def moveTo(
        self,
        p: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#moveTo

        **void QPainterPath::moveTo(const QPointF & point )**

        Moves the current point to the given **point** , implicitly starting a
        new subpath and closing the previous one.

        **See also** **closeSubpath** () and **Composing a QPainterPath** .
        """
        ...

    @overload
    def moveTo(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#moveTo-1

        **void QPainterPath::moveTo(qreal x , qreal y )**

        This is an overloaded function.

        Moves the current position to ( **x** , **y** ) and starts a new
        subpath, implicitly closing the previous path.
        """
        ...

    def percentAtLength(self, t: float) -> float:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#percentAtLength

        **qreal QPainterPath::percentAtLength(qreal len ) const**

        Returns percentage of the whole path at the specified length **len**.

        Note that similarly to other percent methods, the percentage measurement
        is not linear with regards to the length, if curves are present in the
        path. When curves are present the percentage argument is mapped to the t
        parameter of the Bezier equations.
        """
        ...

    def pointAtPercent(self, t: float) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#pointAtPercent

        **QPointF QPainterPath::pointAtPercent(qreal t ) const**

        Returns the point at at the percentage **t** of the current path. The
        argument **t** has to be between 0 and 1.

        Note that similarly to other percent methods, the percentage measurement
        is not linear with regards to the length, if curves are present in the
        path. When curves are present the percentage argument is mapped to the t
        parameter of the Bezier equations.
        """
        ...

    @overload
    def quadTo(
        self,
        ctrlPt: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        endPt: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#quadTo

        **void QPainterPath::quadTo(const QPointF & c , const QPointF & endPoint
        )**

        Adds a quadratic Bezier curve between the current position and the given
        **endPoint** with the control point specified by **c**.

        After the curve is added, the current point is updated to be at the end
        point of the curve.

        **See also** **cubicTo** () and **Composing a QPainterPath** .
        """
        ...

    @overload
    def quadTo(
        self, ctrlPtx: float, ctrlPty: float, endPtx: float, endPty: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#quadTo-1

        **void QPainterPath::quadTo(qreal cx , qreal cy , qreal endPointX ,
        qreal endPointY )**

        This is an overloaded function.

        Adds a quadratic Bezier curve between the current point and the endpoint
        ( **endPointX** , **endPointY** ) with the control point specified by (
        **cx** , **cy** ).
        """
        ...

    def reserve(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#reserve

        **[since 5.13] void QPainterPath::reserve(int size )**

        Reserves a given amount of elements in **QPainterPath** 's internal
        memory.

        Attempts to allocate memory for at least **size** elements.

        This function was introduced in Qt 5.13.

        **See also** **clear** (), **capacity** (), and **QList::reserve** ().
        """
        ...

    def setElementPositionAt(self, i: int, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#setElementPositionAt

        **void QPainterPath::setElementPositionAt(int index , qreal x , qreal y
        )**

        Sets the x and y coordinate of the element at index **index** to **x**
        and **y**.
        """
        ...

    def setFillRule(self, fillRule: PySide6.QtCore.Qt.FillRule) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#setFillRule

        **void QPainterPath::setFillRule(Qt::FillRule fillRule )**

        Sets the fill rule of the painter path to the given **fillRule**. Qt
        provides two methods for filling paths:

        **Qt::OddEvenFill**  (default)**Qt::WindingFill**
        ![](images/qt-
        fillrule-oddeven.png)![](images/qt-fillrule-winding.png)

        **See also** **fillRule** ().
        """
        ...

    def simplified(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#simplified

        **QPainterPath QPainterPath::simplified() const**

        Returns a simplified version of this path. This implies merging all
        subpaths that intersect, and returning a path containing no intersecting
        edges. Consecutive parallel lines will also be merged. The simplified
        path will always use the default fill rule, **Qt::OddEvenFill** . Bezier
        curves may be flattened to line segments due to numerical instability of
        doing bezier curve intersections.
        """
        ...

    def slopeAtPercent(self, t: float) -> float:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#slopeAtPercent

        **qreal QPainterPath::slopeAtPercent(qreal t ) const**

        Returns the slope of the path at the percentage **t**. The argument
        **t** has to be between 0 and 1.

        Note that similarly to other percent methods, the percentage measurement
        is not linear with regards to the length, if curves are present in the
        path. When curves are present the percentage argument is mapped to the t
        parameter of the Bezier equations.
        """
        ...

    def subtracted(self, r: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#subtracted

        **QPainterPath QPainterPath::subtracted(const QPainterPath & p ) const**

        Returns a path which is **p** 's fill area subtracted from this path's
        fill area.

        Set operations on paths will treat the paths as areas. Non-closed paths
        will be treated as implicitly closed. Bezier curves may be flattened to
        line segments due to numerical instability of doing bezier curve
        intersections.
        """
        ...

    def swap(self, other: PySide6.QtGui.QPainterPath) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#swap

        **void QPainterPath::swap(QPainterPath & other )**

        Swaps painter path **other** with this painter path. This operation is
        very fast and never fails.
        """
        ...

    def toFillPolygon(
        self, matrix: PySide6.QtGui.QTransform = ...
    ) -> PySide6.QtGui.QPolygonF:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#toFillPolygon

        **QPolygonF QPainterPath::toFillPolygon(const QTransform & matrix =
        QTransform()) const**

        Converts the path into a polygon using the **QTransform**  **matrix** ,
        and returns the polygon.

        The polygon is created by first converting all subpaths to polygons,
        then using a rewinding technique to make sure that overlapping subpaths
        can be filled using the correct fill rule.

        Note that rewinding inserts addition lines in the polygon so the outline
        of the fill polygon does not match the outline of the path.

        **See also** **toSubpathPolygons** (), **toFillPolygons** (), and
        **QPainterPath Conversion** .
        """
        ...

    def toFillPolygons(
        self, matrix: PySide6.QtGui.QTransform = ...
    ) -> List[PySide6.QtGui.QPolygonF]:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#toFillPolygons

        **QList<QPolygonF> QPainterPath::toFillPolygons(const QTransform &
        matrix = QTransform()) const**

        Converts the path into a list of polygons using the **QTransform**
        **matrix** , and returns the list.

        The function differs from the **toFillPolygon** () function in that it
        creates several polygons. It is provided because it is usually faster to
        draw several small polygons than to draw one large polygon, even though
        the total number of points drawn is the same.

        The toFillPolygons() function differs from the **toSubpathPolygons** ()
        function in that it create only polygon for subpaths that have
        overlapping bounding rectangles.

        Like the **toFillPolygon** () function, this function uses a rewinding
        technique to make sure that overlapping subpaths can be filled using the
        correct fill rule. Note that rewinding inserts addition lines in the
        polygons so the outline of the fill polygon does not match the outline
        of the path.

        **See also** **toSubpathPolygons** (), **toFillPolygon** (), and
        **QPainterPath Conversion** .
        """
        ...

    def toReversed(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#toReversed

        **QPainterPath QPainterPath::toReversed() const**

        Creates and returns a reversed copy of the path.

        It is the order of the elements that is reversed: If a **QPainterPath**
        is composed by calling the **moveTo** (), **lineTo** () and **cubicTo**
        () functions in the specified order, the reversed copy is composed by
        calling **cubicTo** (), **lineTo** () and **moveTo** ().
        """
        ...

    def toSubpathPolygons(
        self, matrix: PySide6.QtGui.QTransform = ...
    ) -> List[PySide6.QtGui.QPolygonF]:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#toSubpathPolygons

        **QList<QPolygonF> QPainterPath::toSubpathPolygons(const QTransform &
        matrix = QTransform()) const**

        Converts the path into a list of polygons using the **QTransform**
        **matrix** , and returns the list.

        This function creates one polygon for each subpath regardless of
        intersecting subpaths (i.e. overlapping bounding rectangles). To make
        sure that such overlapping subpaths are filled correctly, use the
        **toFillPolygons** () function instead.

        **See also** **toFillPolygons** (), **toFillPolygon** (), and
        **QPainterPath Conversion** .
        """
        ...

    @overload
    def translate(self, dx: float, dy: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#translate

        **void QPainterPath::translate(qreal dx , qreal dy )**

        Translates all elements in the path by ( **dx** , **dy** ).

        **See also** **translated** ().
        """
        ...

    @overload
    def translate(
        self,
        offset: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#translate-1

        **void QPainterPath::translate(const QPointF & offset )**

        This is an overloaded function.

        Translates all elements in the path by the given **offset**.

        **See also** **translated** ().
        """
        ...

    @overload
    def translated(self, dx: float, dy: float) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#translated

        **QPainterPath QPainterPath::translated(qreal dx , qreal dy ) const**

        Returns a copy of the path that is translated by ( **dx** , **dy** ).

        **See also** **translate** ().
        """
        ...

    @overload
    def translated(
        self,
        offset: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#translated-1

        **QPainterPath QPainterPath::translated(const QPointF & offset ) const**

        This is an overloaded function.

        Returns a copy of the path that is translated by the given **offset**.

        **See also** **translate** ().
        """
        ...

    def united(self, r: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qpainterpath.html#united

        **QPainterPath QPainterPath::united(const QPainterPath & p ) const**

        Returns a path which is the union of this path's fill area and **p** 's
        fill area.

        Set operations on paths will treat the paths as areas. Non-closed paths
        will be treated as implicitly closed. Bezier curves may be flattened to
        line segments due to numerical instability of doing bezier curve
        intersections.

        **See also** **intersected** () and **subtracted** ().
        """
        ...
