"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Set, Union
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QOpenGLContext(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qopenglcontext.html

    **Detailed Description**

    QOpenGLContext represents the OpenGL state of an underlying OpenGL context.
    To set up a context, set its screen and format such that they match those of
    the surface or surfaces with which the context is meant to be used, if
    necessary make it share resources with other contexts with
    **setShareContext** (), and finally call **create** (). Use the return value
    or **isValid** () to check if the context was successfully initialized.

    A context can be made current against a given surface by calling
    **makeCurrent** (). When OpenGL rendering is done, call **swapBuffers** ()
    to swap the front and back buffers of the surface, so that the newly
    rendered content becomes visible. To be able to support certain platforms,
    QOpenGLContext requires that you call **makeCurrent** () again before
    starting rendering a new frame, after calling **swapBuffers** ().

    If the context is temporarily not needed, such as when the application is
    not rendering, it can be useful to delete it in order to free resources. You
    can connect to the **aboutToBeDestroyed** () signal to clean up any
    resources that have been allocated with different ownership from the
    QOpenGLContext itself.

    Once a QOpenGLContext has been made current, you can render to it in a
    platform independent way by using Qt's OpenGL enablers such as
    **QOpenGLFunctions** , **QOpenGLBuffer** , **QOpenGLShaderProgram** , and
    **QOpenGLFramebufferObject** . It is also possible to use the platform's
    OpenGL API directly, without using the Qt enablers, although potentially at
    the cost of portability. The latter is necessary when wanting to use OpenGL
    1.x or OpenGL ES 1.x.

    For more information about the OpenGL API, refer to the official **OpenGL
    documentation** .

    For an example of how to use QOpenGLContext see the **OpenGL Window**
    example.

    **Thread Affinity**

    QOpenGLContext can be moved to a different thread with **moveToThread** ().
    Do not call **makeCurrent** () from a different thread than the one to which
    the QOpenGLContext object belongs. A context can only be current in one
    thread and against one surface at a time, and a thread only has one context
    current at a time.

    **Context Resource Sharing**

    Resources such as textures and vertex buffer objects can be shared between
    contexts. Use **setShareContext** () before calling **create** () to specify
    that the contexts should share these resources. QOpenGLContext internally
    keeps track of a **QOpenGLContextGroup**  object which can be accessed with
    **shareGroup** (), and which can be used to find all the contexts in a given
    share group. A share group consists of all contexts that have been
    successfully initialized and are sharing with an existing context in the
    share group. A non-sharing context has a share group consisting of a single
    context.

    **Default Framebuffer**

    On certain platforms, a framebuffer other than 0 might be the default frame
    buffer depending on the current surface. Instead of calling
    glBindFramebuffer(0), it is recommended that you use
    glBindFramebuffer(ctx->**defaultFramebufferObject** ()), to ensure that your
    application is portable between different platforms. However, if you use
    **QOpenGLFunctions::glBindFramebuffer** (), this is done automatically for
    you.

    **See also** **QOpenGLFunctions** , **QOpenGLBuffer** ,
    **QOpenGLShaderProgram** , and **QOpenGLFramebufferObject** .
    """

    LibGL: QOpenGLContext.OpenGLModuleType = ...
    LibGLES: QOpenGLContext.OpenGLModuleType = ...

    class OpenGLModuleType(Enum):
        LibGL: QOpenGLContext.OpenGLModuleType = ...
        LibGLES: QOpenGLContext.OpenGLModuleType = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#QOpenGLContext

        **QOpenGLContext::QOpenGLContext(QObject * parent = nullptr)**

        Creates a new OpenGL context instance with parent object **parent**.

        Before it can be used you need to set the proper format and call
        **create** ().

        **See also** **create** () and **makeCurrent** ().
        """
        ...

    @staticmethod
    def areSharing(
        first: PySide6.QtGui.QOpenGLContext, second: PySide6.QtGui.QOpenGLContext
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#areSharing

        **[static] bool QOpenGLContext::areSharing(QOpenGLContext * first ,
        QOpenGLContext * second )**

        Returns `true` if the **first** and **second** contexts are sharing
        OpenGL resources.
        """
        ...

    def create(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#create

        **bool QOpenGLContext::create()**

        Attempts to create the OpenGL context with the current configuration.

        The current configuration includes the format, the share context, and
        the screen.

        If the OpenGL implementation on your system does not support the
        requested version of OpenGL context, then **QOpenGLContext**  will try
        to create the closest matching version. The actual created context
        properties can be queried using the **QSurfaceFormat**  returned by the
        **format** () function. For example, if you request a context that
        supports OpenGL 4.3 Core profile but the driver and/or hardware only
        supports version 3.2 Core profile contexts then you will get a 3.2 Core
        profile context.

        Returns `true` if the native context was successfully created and is
        ready to be used with **makeCurrent** (), **swapBuffers** (), etc.

        **Note:** If the context already exists, this function destroys the
        existing context first, and then creates a new one.

        **See also** **makeCurrent** () and **format** ().
        """
        ...

    @staticmethod
    def currentContext() -> PySide6.QtGui.QOpenGLContext:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#currentContext

        **[static] QOpenGLContext *QOpenGLContext::currentContext()**

        Returns the last context which called **makeCurrent**  in the current
        thread, or `nullptr`, if no context is current.
        """
        ...

    def defaultFramebufferObject(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#defaultFramebufferObject

        **GLuint QOpenGLContext::defaultFramebufferObject() const**

        Call this to get the default framebuffer object for the current surface.

        On some platforms (for instance, iOS) the default framebuffer object
        depends on the surface being rendered to, and might be different from 0.
        Thus, instead of calling glBindFramebuffer(0), you should call
        glBindFramebuffer(ctx->defaultFramebufferObject()) if you want your
        application to work across different Qt platforms.

        If you use the glBindFramebuffer() in **QOpenGLFunctions**  you do not
        have to worry about this, as it automatically binds the current
        context's defaultFramebufferObject() when 0 is passed.

        **Note:** Widgets that render via framebuffer objects, like
        **QOpenGLWidget**  and **QQuickWidget** , will override the value
        returned from this function when painting is active, because at that
        time the correct "default" framebuffer is the widget's associated
        backing framebuffer, not the platform-specific one belonging to the top-
        level window's surface. This ensures the expected behavior for this
        function and other classes relying on it (for example,
        **QOpenGLFramebufferObject::bindDefault** () or
        **QOpenGLFramebufferObject::release** ()).

        **See also** **QOpenGLFramebufferObject** .
        """
        ...

    def doneCurrent(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#doneCurrent

        **void QOpenGLContext::doneCurrent()**

        Convenience function for calling **makeCurrent**  with a 0 surface.

        This results in no context being current in the current thread.

        **See also** **makeCurrent** () and **currentContext** ().
        """
        ...

    def extensions(self) -> Set[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#extensions

        **QSet<QByteArray> QOpenGLContext::extensions() const**

        Returns the set of OpenGL extensions supported by this context.

        The context or a sharing context must be current.

        **See also** **hasExtension** ().
        """
        ...

    def extraFunctions(self) -> PySide6.QtGui.QOpenGLExtraFunctions:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#extraFunctions

        **QOpenGLExtraFunctions *QOpenGLContext::extraFunctions() const**

        Get the **QOpenGLExtraFunctions**  instance for this context.

        **QOpenGLContext**  offers this as a convenient way to access
        **QOpenGLExtraFunctions**  without having to manage it manually.

        The context or a sharing context must be current.

        The returned **QOpenGLExtraFunctions**  instance is ready to be used and
        it does not need initializeOpenGLFunctions() to be called.

        **Note:****QOpenGLExtraFunctions**  contains functionality that is not
        guaranteed to be available at runtime. Runtime availability depends on
        the platform, graphics driver, and the OpenGL version requested by the
        application.

        **See also** **QOpenGLFunctions**  and **QOpenGLExtraFunctions** .
        """
        ...

    def format(self) -> PySide6.QtGui.QSurfaceFormat:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#format

        **QSurfaceFormat QOpenGLContext::format() const**

        Returns the format of the underlying platform context, if **create** ()
        has been called.

        Otherwise, returns the requested format.

        The requested and the actual format may differ. Requesting a given
        OpenGL version does not mean the resulting context will target exactly
        the requested version. It is only guaranteed that the
        version/profile/options combination for the created context is
        compatible with the request, as long as the driver is able to provide
        such a context.

        For example, requesting an OpenGL version 3.x core profile context may
        result in an OpenGL 4.x core profile context. Similarly, a request for
        OpenGL 2.1 may result in an OpenGL 3.0 context with deprecated functions
        enabled. Finally, depending on the driver, unsupported versions may
        result in either a context creation failure or in a context for the
        highest supported version.

        Similar differences are possible in the buffer sizes, for example, the
        resulting context may have a larger depth buffer than requested. This is
        perfectly normal.

        **See also** **setFormat** ().
        """
        ...

    def functions(self) -> PySide6.QtGui.QOpenGLFunctions:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#functions

        **QOpenGLFunctions *QOpenGLContext::functions() const**

        Get the **QOpenGLFunctions**  instance for this context.

        **QOpenGLContext**  offers this as a convenient way to access
        **QOpenGLFunctions**  without having to manage it manually.

        The context or a sharing context must be current.

        The returned **QOpenGLFunctions**  instance is ready to be used and it
        does not need initializeOpenGLFunctions() to be called.
        """
        ...

    @staticmethod
    def globalShareContext() -> PySide6.QtGui.QOpenGLContext:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#globalShareContext

        **[static, since 5.5] QOpenGLContext
        *QOpenGLContext::globalShareContext()**

        Returns the application-wide shared OpenGL context, if present.
        Otherwise, returns `nullptr`.

        This is useful if you need to upload OpenGL objects (buffers, textures,
        etc.) before creating or showing a **QOpenGLWidget**  or
        **QQuickWidget** .

        **Note:** You must set the **Qt::AA_ShareOpenGLContexts**  flag on
        **QGuiApplication**  before creating the **QGuiApplication**  object,
        otherwise Qt may not create a global shared context.

        **Warning:** Do not attempt to make the context returned by this
        function current on any surface. Instead, you can create a new context
        which shares with the global one, and then make the new context current.

        This function was introduced in Qt 5.5.

        **See also** **Qt::AA_ShareOpenGLContexts** , **setShareContext** (),
        and **makeCurrent** ().
        """
        ...

    def hasExtension(self, extension: Union[PySide6.QtCore.QByteArray, bytes]) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#hasExtension

        **bool QOpenGLContext::hasExtension(const QByteArray & extension )
        const**

        Returns `true` if this OpenGL context supports the specified OpenGL
        **extension** , `false` otherwise.

        The context or a sharing context must be current.

        **See also** **extensions** ().
        """
        ...

    def isOpenGLES(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#isOpenGLES

        **[since 5.3] bool QOpenGLContext::isOpenGLES() const**

        Returns true if the context is an OpenGL ES context.

        If the context has not yet been created, the result is based on the
        requested format set via **setFormat** ().

        This function was introduced in Qt 5.3.

        **See also** **create** (), **format** (), and **setFormat** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#isValid

        **bool QOpenGLContext::isValid() const**

        Returns if this context is valid, i.e. has been successfully created.

        On some platforms the return value of `false` for a context that was
        successfully created previously indicates that the OpenGL context was
        lost.

        The typical way to handle context loss scenarios in applications is to
        check via this function whenever **makeCurrent** () fails and returns
        `false`. If this function then returns `false`, recreate the underlying
        native OpenGL context by calling **create** (), call **makeCurrent** ()
        again and then reinitialize all OpenGL resources.

        On some platforms context loss situations is not something that can
        avoided. On others however, they may need to be opted-in to. This can be
        done by enabling **ResetNotification**  in the **QSurfaceFormat** . This
        will lead to setting `RESET_NOTIFICATION_STRATEGY_EXT` to
        `LOSE_CONTEXT_ON_RESET_EXT` in the underlying native OpenGL context.
        **QOpenGLContext**  will then monitor the status via
        `glGetGraphicsResetStatusEXT()` in every **makeCurrent** ().

        **See also** **create** ().
        """
        ...

    def makeCurrent(self, surface: PySide6.QtGui.QSurface) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#makeCurrent

        **bool QOpenGLContext::makeCurrent(QSurface * surface )**

        Makes the context current in the current thread, against the given
        **surface**. Returns `true` if successful; otherwise returns `false`.
        The latter may happen if the surface is not exposed, or the graphics
        hardware is not available due to e.g. the application being suspended.

        If **surface** is `nullptr` this is equivalent to calling
        **doneCurrent** ().

        Avoid calling this function from a different thread than the one the
        **QOpenGLContext**  instance lives in. If you wish to use
        **QOpenGLContext**  from a different thread you should first make sure
        it's not current in the current thread, by calling **doneCurrent** () if
        necessary. Then call moveToThread(otherThread) before using it in the
        other thread.

        By default Qt employs a check that enforces the above condition on the
        thread affinity. It is still possible to disable this check by setting
        the `Qt::AA_DontCheckOpenGLContextThreadAffinity` application attribute.
        Be sure to understand the consequences of using QObjects from outside
        the thread they live in, as explained in the **QObject thread affinity**
        documentation.

        **See also** **functions** (), **doneCurrent** (), and
        **Qt::AA_DontCheckOpenGLContextThreadAffinity** .
        """
        ...

    @staticmethod
    def openGLModuleType() -> PySide6.QtGui.QOpenGLContext.OpenGLModuleType:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#openGLModuleType

        **[static, since 5.3] QOpenGLContext::OpenGLModuleType
        QOpenGLContext::openGLModuleType()**

        Returns the underlying OpenGL implementation type.

        On platforms where the OpenGL implementation is not dynamically loaded,
        the return value is determined during compile time and never changes.

        **Note:** A desktop OpenGL implementation may be capable of creating ES-
        compatible contexts too. Therefore in most cases it is more appropriate
        to check **QSurfaceFormat::renderableType** () or use the convenience
        function **isOpenGLES** ().

        **Note:** This function requires that the **QGuiApplication**  instance
        is already created.

        This function was introduced in Qt 5.3.
        """
        ...

    def resolveInterface(self, name: bytes, revision: int) -> int:
        ...

    def screen(self) -> PySide6.QtGui.QScreen:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#screen

        **QScreen *QOpenGLContext::screen() const**

        Returns the screen the context was created for.

        **See also** **setScreen** ().
        """
        ...

    def setFormat(
        self,
        format: Union[
            PySide6.QtGui.QSurfaceFormat, PySide6.QtGui.QSurfaceFormat.FormatOptions
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#setFormat

        **void QOpenGLContext::setFormat(const QSurfaceFormat & format )**

        Sets the **format** the OpenGL context should be compatible with. You
        need to call **create** () before it takes effect.

        When the format is not explicitly set via this function, the format
        returned by **QSurfaceFormat::defaultFormat** () will be used. This
        means that when having multiple contexts, individual calls to this
        function can be replaced by one single call to
        **QSurfaceFormat::setDefaultFormat** () before creating the first
        context.

        **See also** **format** ().
        """
        ...

    def setScreen(self, screen: PySide6.QtGui.QScreen) -> None:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#setScreen

        **void QOpenGLContext::setScreen(QScreen * screen )**

        Sets the **screen** the OpenGL context should be valid for. You need to
        call **create** () before it takes effect.

        **See also** **screen** ().
        """
        ...

    def setShareContext(self, shareContext: PySide6.QtGui.QOpenGLContext) -> None:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#setShareContext

        **void QOpenGLContext::setShareContext(QOpenGLContext * shareContext )**

        Makes this context share textures, shaders, and other OpenGL resources
        with **shareContext**. You need to call **create** () before it takes
        effect.

        **See also** **shareContext** ().
        """
        ...

    def shareContext(self) -> PySide6.QtGui.QOpenGLContext:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#shareContext

        **QOpenGLContext *QOpenGLContext::shareContext() const**

        Returns the share context this context was created with.

        If the underlying platform was not able to support the requested
        sharing, this will return 0.

        **See also** **setShareContext** ().
        """
        ...

    def shareGroup(self) -> PySide6.QtGui.QOpenGLContextGroup:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#shareGroup

        **QOpenGLContextGroup *QOpenGLContext::shareGroup() const**

        Returns the share group this context belongs to.
        """
        ...

    @staticmethod
    def supportsThreadedOpenGL() -> bool:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#supportsThreadedOpenGL

        **[static, since 5.5] bool QOpenGLContext::supportsThreadedOpenGL()**

        Returns `true` if the platform supports OpenGL rendering outside the
        main (gui) thread.

        The value is controlled by the platform plugin in use and may also
        depend on the graphics drivers.

        This function was introduced in Qt 5.5.
        """
        ...

    def surface(self) -> PySide6.QtGui.QSurface:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#surface

        **QSurface *QOpenGLContext::surface() const**

        Returns the surface the context has been made current with.

        This is the surface passed as an argument to **makeCurrent** ().
        """
        ...

    def swapBuffers(self, surface: PySide6.QtGui.QSurface) -> None:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#swapBuffers

        **void QOpenGLContext::swapBuffers(QSurface * surface )**

        Swap the back and front buffers of **surface**.

        Call this to finish a frame of OpenGL rendering, and make sure to call
        **makeCurrent** () again before issuing any further OpenGL commands, for
        example as part of a new frame.
        """
        ...

    @property
    def aboutToBeDestroyed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qopenglcontext.html#aboutToBeDestroyed

        **[signal] void QOpenGLContext::aboutToBeDestroyed()**

        This signal is emitted before the underlying native OpenGL context is
        destroyed, such that users may clean up OpenGL resources that might
        otherwise be left dangling in the case of shared OpenGL contexts.

        If you wish to make the context current in order to do clean-up, make
        sure to only connect to the signal using a direct connection.
        """
        ...
