"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QKeySequence(object):
    """
    https://doc.qt.io/qt-6/qkeysequence.html

    **Detailed Description**

    In its most common form, a key sequence describes a combination of keys that
    must be used together to perform some action. Key sequences are used with
    **QAction**  objects to specify which keyboard shortcuts can be used to
    trigger actions.

    Key sequences can be constructed for use as keyboard shortcuts in three
    different ways:

    * For standard shortcuts, a **standard key**  can be used to request the
    platform-specific key sequence associated with each shortcut.
      * For custom
    shortcuts, human-readable strings such as "Ctrl+X" can be used, and these
    can be translated into the appropriate shortcuts for users of different
    languages. Translations are made in the "**QShortcut** " context.
      * For
    hard-coded shortcuts, integer key codes can be specified with a combination
    of values defined by the **Qt::Key**  and **Qt::Modifier**  enum values.
    Each key code consists of a single **Qt::Key**  value and zero or more
    modifiers, such as **Qt::SHIFT** , **Qt::CTRL** , **Qt::ALT**  and
    **Qt::META** .

    For example, **Ctrl P** might be a sequence used as a shortcut for printing
    a document, and can be specified in any of the following ways:

    QKeySequence(QKeySequence::Print);
        QKeySequence(tr("Ctrl+P"));
    QKeySequence(tr("Ctrl+p"));
        QKeySequence(Qt::CTRL | Qt::Key_P);
    QKeySequence(Qt::CTRL + Qt::Key_P); // deprecated

    Note that, for letters, the case used in the specification string does not
    matter. In the above examples, the user does not need to hold down the
    **Shift** key to activate a shortcut specified with "Ctrl+P". However, for
    other keys, the use of **Shift** as an unspecified extra modifier key can
    lead to confusion for users of an application whose keyboards have different
    layouts to those used by the developers. See the **Keyboard Layout Issues**
    section below for more details.

    It is preferable to use standard shortcuts where possible. When creating key
    sequences for non-standard shortcuts, you should use human-readable strings
    in preference to hard-coded integer values.

    QKeySequence objects can be cast to a **QString**  to obtain a human-
    readable translated version of the sequence. Similarly, the **toString** ()
    function produces human-readable strings for use in menus. On macOS, the
    appropriate symbols are used to describe keyboard shortcuts using special
    keys on the Macintosh keyboard.

    An alternative way to specify hard-coded key codes is to use the Unicode
    code point of the character; for example, 'A' gives the same key sequence as
    **Qt::Key_A** .

    **Note:** On macOS, references to "Ctrl", **Qt::CTRL** , **Qt::Key_Control**
    and **Qt::ControlModifier**  correspond to the **Command** keys on the
    Macintosh keyboard, and references to "Meta", **Qt::META** ,
    **Qt::Key_Meta**  and **Qt::MetaModifier**  correspond to the **Control**
    keys. Developers on macOS can use the same shortcut descriptions across all
    platforms, and their applications will automatically work as expected on
    macOS.

    **Standard Shortcuts**

    QKeySequence defines many **standard keyboard shortcuts**  to reduce the
    amount of effort required when setting up actions in a typical application.
    The table below shows some common key sequences that are often used for
    these standard shortcuts by applications on four widely-used platforms. Note
    that on macOS, the **Ctrl** value corresponds to the **Command** keys on the
    Macintosh keyboard, and the **Meta** value corresponds to the **Control**
    keys.

    **StandardKey** WindowsmacOSKDE PlasmaGNOME
    **HelpContents** F1Ctrl+?F1F1
    **WhatsThis** Shift+F1Shift+F1Shift+F1Shift+F1
    OpenCtrl+OCtrl+OCtrl+OCtrl+O
    CloseCtrl+F4, Ctrl+WCtrl+W,
    Ctrl+F4Ctrl+WCtrl+W
    SaveCtrl+SCtrl+SCtrl+SCtrl+S
    QuitCtrl+QCtrl+QCtrl+Q
    **SaveAs** Ctrl+Shift+SCtrl+Shift+S
    NewCtrl+NCtrl+NCtrl+NCtrl+N
    DeleteDelDel, Meta+DDel, Ctrl+DDel, Ctrl+D
    CutCtrl+X, Shift+DelCtrl+X,
    Meta+KCtrl+X, F20, Shift+DelCtrl+X, F20, Shift+Del
    CopyCtrl+C,
    Ctrl+InsCtrl+CCtrl+C, F16, Ctrl+InsCtrl+C, F16, Ctrl+Ins
    PasteCtrl+V,
    Shift+InsCtrl+V, Meta+YCtrl+V, F18, Shift+InsCtrl+V, F18, Shift+Ins
    PreferencesCtrl+,
    UndoCtrl+Z, Alt+BackspaceCtrl+ZCtrl+Z, F14Ctrl+Z, F14
    RedoCtrl+Y, Shift+Ctrl+Z,
    Alt+Shift+BackspaceCtrl+Shift+ZCtrl+Shift+ZCtrl+Shift+Z
    BackAlt+Left,
    BackspaceCtrl+[Alt+LeftAlt+Left
    ForwardAlt+Right,
    Shift+BackspaceCtrl+]Alt+RightAlt+Right
    RefreshF5F5F5Ctrl+R, F5
    **ZoomIn** Ctrl+PlusCtrl+PlusCtrl+PlusCtrl+Plus
    **ZoomOut**
    Ctrl+MinusCtrl+MinusCtrl+MinusCtrl+Minus
    **FullScreen** F11,
    Alt+EnterCtrl+Meta+FF11, Ctrl+Shift+FCtrl+F11
    PrintCtrl+PCtrl+PCtrl+PCtrl+P
    **AddTab** Ctrl+TCtrl+TCtrl+Shift+N,
    Ctrl+TCtrl+T
    **NextChild** Ctrl+Tab, Forward, Ctrl+F6Ctrl+}, Forward,
    Ctrl+TabCtrl+Tab, Forward, Ctrl+CommaCtrl+Tab, Forward
    **PreviousChild**
    Ctrl+Shift+Tab, Back, Ctrl+Shift+F6Ctrl+{, Back,
    Ctrl+Shift+TabCtrl+Shift+Tab, Back, Ctrl+PeriodCtrl+Shift+Tab, Back
    FindCtrl+FCtrl+FCtrl+FCtrl+F
    **FindNext** F3, Ctrl+GCtrl+GF3Ctrl+G, F3
    **FindPrevious** Shift+F3, Ctrl+Shift+GCtrl+Shift+GShift+F3Ctrl+Shift+G,
    Shift+F3
    ReplaceCtrl+H(none)Ctrl+RCtrl+H
    **SelectAll**
    Ctrl+ACtrl+ACtrl+ACtrl+A
    DeselectCtrl+Shift+ACtrl+Shift+A
    BoldCtrl+BCtrl+BCtrl+BCtrl+B
    ItalicCtrl+ICtrl+ICtrl+ICtrl+I
    UnderlineCtrl+UCtrl+UCtrl+UCtrl+U
    **MoveToNextChar** RightRight,
    Meta+FRightRight
    **MoveToPreviousChar** LeftLeft, Meta+BLeftLeft
    **MoveToNextWord** Ctrl+RightAlt+RightCtrl+RightCtrl+Right
    **MoveToPreviousWord** Ctrl+LeftAlt+LeftCtrl+LeftCtrl+Left
    **MoveToNextLine** DownDown, Meta+NDownDown
    **MoveToPreviousLine** UpUp,
    Meta+PUpUp
    **MoveToNextPage** PgDownPgDown, Alt+PgDown, Meta+Down,
    Meta+PgDown, Meta+VPgDownPgDown
    **MoveToPreviousPage** PgUpPgUp, Alt+PgUp,
    Meta+Up, Meta+PgUpPgUpPgUp
    **MoveToStartOfLine** HomeCtrl+Left,
    Meta+LeftHomeHome
    **MoveToEndOfLine** EndCtrl+Right, Meta+RightEnd,
    Ctrl+EEnd, Ctrl+E
    **MoveToStartOfBlock** (none)Alt+Up, Meta+A(none)(none)
    **MoveToEndOfBlock** (none)Alt+Down, Meta+E(none)(none)
    **MoveToStartOfDocument** Ctrl+HomeCtrl+Up, HomeCtrl+HomeCtrl+Home
    **MoveToEndOfDocument** Ctrl+EndCtrl+Down, EndCtrl+EndCtrl+End
    **SelectNextChar** Shift+RightShift+RightShift+RightShift+Right
    **SelectPreviousChar** Shift+LeftShift+LeftShift+LeftShift+Left
    **SelectNextWord**
    Ctrl+Shift+RightAlt+Shift+RightCtrl+Shift+RightCtrl+Shift+Right
    **SelectPreviousWord**
    Ctrl+Shift+LeftAlt+Shift+LeftCtrl+Shift+LeftCtrl+Shift+Left
    **SelectNextLine** Shift+DownShift+DownShift+DownShift+Down
    **SelectPreviousLine** Shift+UpShift+UpShift+UpShift+Up
    **SelectNextPage**
    Shift+PgDownShift+PgDownShift+PgDownShift+PgDown
    **SelectPreviousPage**
    Shift+PgUpShift+PgUpShift+PgUpShift+PgUp
    **SelectStartOfLine**
    Shift+HomeCtrl+Shift+LeftShift+HomeShift+Home
    **SelectEndOfLine**
    Shift+EndCtrl+Shift+RightShift+EndShift+End
    **SelectStartOfBlock**
    (none)Alt+Shift+Up, Meta+Shift+A(none)(none)
    **SelectEndOfBlock**
    (none)Alt+Shift+Down, Meta+Shift+E(none)(none)
    **SelectStartOfDocument**
    Ctrl+Shift+HomeCtrl+Shift+Up, Shift+HomeCtrl+Shift+HomeCtrl+Shift+Home
    **SelectEndOfDocument** Ctrl+Shift+EndCtrl+Shift+Down,
    Shift+EndCtrl+Shift+EndCtrl+Shift+End
    **DeleteStartOfWord**
    Ctrl+BackspaceAlt+BackspaceCtrl+BackspaceCtrl+Backspace
    **DeleteEndOfWord** Ctrl+Del(none)Ctrl+DelCtrl+Del
    **DeleteEndOfLine**
    (none)(none)Ctrl+KCtrl+K
    **DeleteCompleteLine** (none)(none)Ctrl+UCtrl+U
    **InsertParagraphSeparator** EnterEnterEnterEnter
    **InsertLineSeparator**
    Shift+EnterMeta+Enter, Meta+OShift+EnterShift+Enter
    Backspace(none)Meta+H(none)(none)
    CancelEscapeEscape, Ctrl+.EscapeEscape

    Note that, since the key sequences used for the standard shortcuts differ
    between platforms, you still need to test your shortcuts on each platform to
    ensure that you do not unintentionally assign the same key sequence to many
    actions.

    **Keyboard Layout Issues**

    Many key sequence specifications are chosen by developers based on the
    layout of certain types of keyboard, rather than choosing keys that
    represent the first letter of an action's name, such as **Ctrl S**
    ("Ctrl+S") or **Ctrl C** ("Ctrl+C"). Additionally, because certain symbols
    can only be entered with the help of modifier keys on certain keyboard
    layouts, key sequences intended for use with one keyboard layout may map to
    a different key, map to no keys at all, or require an additional modifier
    key to be used on different keyboard layouts.

    For example, the shortcuts, **Ctrl plus** and **Ctrl minus** , are often
    used as shortcuts for zoom operations in graphics applications, and these
    may be specified as "Ctrl++" and "Ctrl+-" respectively. However, the way
    these shortcuts are specified and interpreted depends on the keyboard
    layout. Users of Norwegian keyboards will note that the **+** and **-** keys
    are not adjacent on the keyboard, but will still be able to activate both
    shortcuts without needing to press the **Shift** key. However, users with
    British keyboards will need to hold down the **Shift** key to enter the
    **+** symbol, making the shortcut effectively the same as "Ctrl+Shift+=".

    Although some developers might resort to fully specifying all the modifiers
    they use on their keyboards to activate a shortcut, this will also result in
    unexpected behavior for users of different keyboard layouts.

    For example, a developer using a British keyboard may decide to specify
    "Ctrl+Shift+=" as the key sequence in order to create a shortcut that
    coincidentally behaves in the same way as **Ctrl plus**. However, the **=**
    key needs to be accessed using the **Shift** key on Norwegian keyboard,
    making the required shortcut effectively **Ctrl Shift Shift =** (an
    impossible key combination).

    As a result, both human-readable strings and hard-coded key codes can both
    be problematic to use when specifying a key sequence that can be used on a
    variety of different keyboard layouts. Only the use of **standard
    shortcuts**  guarantees that the user will be able to use the shortcuts that
    the developer intended.

    Despite this, we can address this issue by ensuring that human-readable
    strings are used, making it possible for translations of key sequences to be
    made for users of different languages. This approach will be successful for
    users whose keyboards have the most typical layout for the language they are
    using.

    **GNU Emacs Style Key Sequences**

    Key sequences similar to those used in **GNU Emacs** , allowing up to four
    key codes, can be created by using the multiple argument constructor, or by
    passing a human-readable string of comma-separated key sequences.

    For example, the key sequence, **Ctrl X** followed by **Ctrl C** , can be
    specified using either of the following ways:

    QKeySequence(tr("Ctrl+X, Ctrl+C"));
        QKeySequence(Qt::CTRL | Qt::Key_X,
    Qt::CTRL | Qt::Key_C);
        QKeySequence(Qt::CTRL + Qt::Key_X, Qt::CTRL +
    Qt::Key_C); // deprecated

    **Warning:** A **QApplication**  instance must have been constructed before
    a QKeySequence is created; otherwise, your application may crash.

    **See also** **QShortcut** .
    """

    NativeText: QKeySequence.SequenceFormat = ...
    PortableText: QKeySequence.SequenceFormat = ...
    NoMatch: QKeySequence.SequenceMatch = ...
    PartialMatch: QKeySequence.SequenceMatch = ...
    ExactMatch: QKeySequence.SequenceMatch = ...
    UnknownKey: QKeySequence.StandardKey = ...
    HelpContents: QKeySequence.StandardKey = ...
    WhatsThis: QKeySequence.StandardKey = ...
    Open: QKeySequence.StandardKey = ...
    Close: QKeySequence.StandardKey = ...
    Save: QKeySequence.StandardKey = ...
    New: QKeySequence.StandardKey = ...
    Delete: QKeySequence.StandardKey = ...
    Cut: QKeySequence.StandardKey = ...
    Copy: QKeySequence.StandardKey = ...
    Paste: QKeySequence.StandardKey = ...
    Undo: QKeySequence.StandardKey = ...
    Redo: QKeySequence.StandardKey = ...
    Back: QKeySequence.StandardKey = ...
    Forward: QKeySequence.StandardKey = ...
    Refresh: QKeySequence.StandardKey = ...
    ZoomIn: QKeySequence.StandardKey = ...
    ZoomOut: QKeySequence.StandardKey = ...
    Print: QKeySequence.StandardKey = ...
    AddTab: QKeySequence.StandardKey = ...
    NextChild: QKeySequence.StandardKey = ...
    PreviousChild: QKeySequence.StandardKey = ...
    Find: QKeySequence.StandardKey = ...
    FindNext: QKeySequence.StandardKey = ...
    FindPrevious: QKeySequence.StandardKey = ...
    Replace: QKeySequence.StandardKey = ...
    SelectAll: QKeySequence.StandardKey = ...
    Bold: QKeySequence.StandardKey = ...
    Italic: QKeySequence.StandardKey = ...
    Underline: QKeySequence.StandardKey = ...
    MoveToNextChar: QKeySequence.StandardKey = ...
    MoveToPreviousChar: QKeySequence.StandardKey = ...
    MoveToNextWord: QKeySequence.StandardKey = ...
    MoveToPreviousWord: QKeySequence.StandardKey = ...
    MoveToNextLine: QKeySequence.StandardKey = ...
    MoveToPreviousLine: QKeySequence.StandardKey = ...
    MoveToNextPage: QKeySequence.StandardKey = ...
    MoveToPreviousPage: QKeySequence.StandardKey = ...
    MoveToStartOfLine: QKeySequence.StandardKey = ...
    MoveToEndOfLine: QKeySequence.StandardKey = ...
    MoveToStartOfBlock: QKeySequence.StandardKey = ...
    MoveToEndOfBlock: QKeySequence.StandardKey = ...
    MoveToStartOfDocument: QKeySequence.StandardKey = ...
    MoveToEndOfDocument: QKeySequence.StandardKey = ...
    SelectNextChar: QKeySequence.StandardKey = ...
    SelectPreviousChar: QKeySequence.StandardKey = ...
    SelectNextWord: QKeySequence.StandardKey = ...
    SelectPreviousWord: QKeySequence.StandardKey = ...
    SelectNextLine: QKeySequence.StandardKey = ...
    SelectPreviousLine: QKeySequence.StandardKey = ...
    SelectNextPage: QKeySequence.StandardKey = ...
    SelectPreviousPage: QKeySequence.StandardKey = ...
    SelectStartOfLine: QKeySequence.StandardKey = ...
    SelectEndOfLine: QKeySequence.StandardKey = ...
    SelectStartOfBlock: QKeySequence.StandardKey = ...
    SelectEndOfBlock: QKeySequence.StandardKey = ...
    SelectStartOfDocument: QKeySequence.StandardKey = ...
    SelectEndOfDocument: QKeySequence.StandardKey = ...
    DeleteStartOfWord: QKeySequence.StandardKey = ...
    DeleteEndOfWord: QKeySequence.StandardKey = ...
    DeleteEndOfLine: QKeySequence.StandardKey = ...
    InsertParagraphSeparator: QKeySequence.StandardKey = ...
    InsertLineSeparator: QKeySequence.StandardKey = ...
    SaveAs: QKeySequence.StandardKey = ...
    Preferences: QKeySequence.StandardKey = ...
    Quit: QKeySequence.StandardKey = ...
    FullScreen: QKeySequence.StandardKey = ...
    Deselect: QKeySequence.StandardKey = ...
    DeleteCompleteLine: QKeySequence.StandardKey = ...
    Backspace: QKeySequence.StandardKey = ...
    Cancel: QKeySequence.StandardKey = ...

    class SequenceFormat(Enum):
        NativeText: QKeySequence.SequenceFormat = ...
        PortableText: QKeySequence.SequenceFormat = ...

    class SequenceMatch(Enum):
        NoMatch: QKeySequence.SequenceMatch = ...
        PartialMatch: QKeySequence.SequenceMatch = ...
        ExactMatch: QKeySequence.SequenceMatch = ...

    class StandardKey(Enum):
        UnknownKey: QKeySequence.StandardKey = ...
        HelpContents: QKeySequence.StandardKey = ...
        WhatsThis: QKeySequence.StandardKey = ...
        Open: QKeySequence.StandardKey = ...
        Close: QKeySequence.StandardKey = ...
        Save: QKeySequence.StandardKey = ...
        New: QKeySequence.StandardKey = ...
        Delete: QKeySequence.StandardKey = ...
        Cut: QKeySequence.StandardKey = ...
        Copy: QKeySequence.StandardKey = ...
        Paste: QKeySequence.StandardKey = ...
        Undo: QKeySequence.StandardKey = ...
        Redo: QKeySequence.StandardKey = ...
        Back: QKeySequence.StandardKey = ...
        Forward: QKeySequence.StandardKey = ...
        Refresh: QKeySequence.StandardKey = ...
        ZoomIn: QKeySequence.StandardKey = ...
        ZoomOut: QKeySequence.StandardKey = ...
        Print: QKeySequence.StandardKey = ...
        AddTab: QKeySequence.StandardKey = ...
        NextChild: QKeySequence.StandardKey = ...
        PreviousChild: QKeySequence.StandardKey = ...
        Find: QKeySequence.StandardKey = ...
        FindNext: QKeySequence.StandardKey = ...
        FindPrevious: QKeySequence.StandardKey = ...
        Replace: QKeySequence.StandardKey = ...
        SelectAll: QKeySequence.StandardKey = ...
        Bold: QKeySequence.StandardKey = ...
        Italic: QKeySequence.StandardKey = ...
        Underline: QKeySequence.StandardKey = ...
        MoveToNextChar: QKeySequence.StandardKey = ...
        MoveToPreviousChar: QKeySequence.StandardKey = ...
        MoveToNextWord: QKeySequence.StandardKey = ...
        MoveToPreviousWord: QKeySequence.StandardKey = ...
        MoveToNextLine: QKeySequence.StandardKey = ...
        MoveToPreviousLine: QKeySequence.StandardKey = ...
        MoveToNextPage: QKeySequence.StandardKey = ...
        MoveToPreviousPage: QKeySequence.StandardKey = ...
        MoveToStartOfLine: QKeySequence.StandardKey = ...
        MoveToEndOfLine: QKeySequence.StandardKey = ...
        MoveToStartOfBlock: QKeySequence.StandardKey = ...
        MoveToEndOfBlock: QKeySequence.StandardKey = ...
        MoveToStartOfDocument: QKeySequence.StandardKey = ...
        MoveToEndOfDocument: QKeySequence.StandardKey = ...
        SelectNextChar: QKeySequence.StandardKey = ...
        SelectPreviousChar: QKeySequence.StandardKey = ...
        SelectNextWord: QKeySequence.StandardKey = ...
        SelectPreviousWord: QKeySequence.StandardKey = ...
        SelectNextLine: QKeySequence.StandardKey = ...
        SelectPreviousLine: QKeySequence.StandardKey = ...
        SelectNextPage: QKeySequence.StandardKey = ...
        SelectPreviousPage: QKeySequence.StandardKey = ...
        SelectStartOfLine: QKeySequence.StandardKey = ...
        SelectEndOfLine: QKeySequence.StandardKey = ...
        SelectStartOfBlock: QKeySequence.StandardKey = ...
        SelectEndOfBlock: QKeySequence.StandardKey = ...
        SelectStartOfDocument: QKeySequence.StandardKey = ...
        SelectEndOfDocument: QKeySequence.StandardKey = ...
        DeleteStartOfWord: QKeySequence.StandardKey = ...
        DeleteEndOfWord: QKeySequence.StandardKey = ...
        DeleteEndOfLine: QKeySequence.StandardKey = ...
        InsertParagraphSeparator: QKeySequence.StandardKey = ...
        InsertLineSeparator: QKeySequence.StandardKey = ...
        SaveAs: QKeySequence.StandardKey = ...
        Preferences: QKeySequence.StandardKey = ...
        Quit: QKeySequence.StandardKey = ...
        FullScreen: QKeySequence.StandardKey = ...
        Deselect: QKeySequence.StandardKey = ...
        DeleteCompleteLine: QKeySequence.StandardKey = ...
        Backspace: QKeySequence.StandardKey = ...
        Cancel: QKeySequence.StandardKey = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#QKeySequence

        **QKeySequence::QKeySequence()**

        Constructs an empty key sequence.
        """
        ...

    @overload
    def __init__(self, k1: int, k2: int = ..., k3: int = ..., k4: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#QKeySequence-1

        **QKeySequence::QKeySequence(const QString & key ,
        QKeySequence::SequenceFormat format = NativeText)**

        Creates a key sequence from the **key** string, based on **format**.

        For example "Ctrl+O" gives CTRL+'O'. The strings "Ctrl", "Shift", "Alt"
        and "Meta" are recognized, as well as their translated equivalents in
        the "**QShortcut** " context (using **QObject::tr** ()).

        Up to four key codes may be entered by separating them with commas, e.g.
        "Alt+X,Ctrl+S,Q".

        This constructor is typically used with **tr** (), so that shortcut keys
        can be replaced in translations:

        **QMenu**  *file = new **QMenu** (this);
        file->addAction(tr("&Open..."), this, SLOT(open()),
        **QKeySequence** (tr("Ctrl+O", "File|Open")));

        Note the "File|Open" translator comment. It is by no means necessary,
        but it provides some context for the human translator.
        """
        ...

    @overload
    def __init__(
        self,
        k1: Union[
            PySide6.QtCore.QKeyCombination,
            PySide6.QtCore.Qt.KeyboardModifiers,
            PySide6.QtCore.Qt.Key,
        ],
        k2: Union[
            PySide6.QtCore.QKeyCombination,
            PySide6.QtCore.Qt.KeyboardModifiers,
            PySide6.QtCore.Qt.Key,
        ] = ...,
        k3: Union[
            PySide6.QtCore.QKeyCombination,
            PySide6.QtCore.Qt.KeyboardModifiers,
            PySide6.QtCore.Qt.Key,
        ] = ...,
        k4: Union[
            PySide6.QtCore.QKeyCombination,
            PySide6.QtCore.Qt.KeyboardModifiers,
            PySide6.QtCore.Qt.Key,
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#QKeySequence-2

        **QKeySequence::QKeySequence(int k1 , int k2 = 0, int k3 = 0, int k4 =
        0)**

        Constructs a key sequence with up to 4 keys **k1** , **k2** , **k3** and
        **k4**.

        The key codes are listed in **Qt::Key**  and can be combined with
        modifiers (see **Qt::Modifier** ) such as **Qt::SHIFT** , **Qt::CTRL** ,
        **Qt::ALT** , or **Qt::META** .
        """
        ...

    @overload
    def __init__(self, key: PySide6.QtGui.QKeySequence.StandardKey) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#QKeySequence-3

        **QKeySequence::QKeySequence(QKeyCombination k1 , QKeyCombination k2 =
        QKeyCombination::fromCombined(0), QKeyCombination k3 =
        QKeyCombination::fromCombined(0), QKeyCombination k4 =
        QKeyCombination::fromCombined(0))**

        Constructs a key sequence with up to 4 keys **k1** , **k2** , **k3** and
        **k4**.

        **See also** **QKeyCombination** .
        """
        ...

    @overload
    def __init__(
        self, key: str, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#QKeySequence-4

        **QKeySequence::QKeySequence(const QKeySequence & keysequence )**

        Copy constructor. Makes a copy of **keysequence**.
        """
        ...

    @overload
    def __init__(
        self,
        ks: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#QKeySequence-5

        **QKeySequence::QKeySequence(QKeySequence::StandardKey key )**

        Constructs a QKeySequence object for the given **key**. The result will
        depend on the currently running platform.

        The resulting object will be based on the first element in the list of
        key bindings for the **key**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(self, in_: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __rshift__(self, out: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#count

        **int QKeySequence::count() const**

        Returns the number of keys in the key sequence. The maximum is 4.
        """
        ...

    @staticmethod
    def fromString(
        str: str, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...
    ) -> PySide6.QtGui.QKeySequence:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#fromString

        **[static] QKeySequence QKeySequence::fromString(const QString & str ,
        QKeySequence::SequenceFormat format = PortableText)**

        Return a **QKeySequence**  from the string **str** based on **format**.

        **See also** **toString** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#isEmpty

        **bool QKeySequence::isEmpty() const**

        Returns `true` if the key sequence is empty; otherwise returns false.
        """
        ...

    @staticmethod
    def keyBindings(
        key: PySide6.QtGui.QKeySequence.StandardKey,
    ) -> List[PySide6.QtGui.QKeySequence]:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#keyBindings

        **[static] QList<QKeySequence>
        QKeySequence::keyBindings(QKeySequence::StandardKey key )**

        Returns a list of key bindings for the given **key**. The result of
        calling this function will vary based on the target platform. The first
        element of the list indicates the primary shortcut for the given
        platform. If the result contains more than one result, these can be
        considered alternative shortcuts on the same platform for the given
        **key**.
        """
        ...

    @staticmethod
    def listFromString(
        str: str, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...
    ) -> List[PySide6.QtGui.QKeySequence]:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#listFromString

        **[static, since 5.1] QList<QKeySequence>
        QKeySequence::listFromString(const QString & str ,
        QKeySequence::SequenceFormat format = PortableText)**

        Return a list of **QKeySequence**  from the string **str** based on
        **format**.

        This function was introduced in Qt 5.1.

        **See also** **fromString** () and **listToString** ().
        """
        ...

    @staticmethod
    def listToString(
        list: Sequence[PySide6.QtGui.QKeySequence],
        format: PySide6.QtGui.QKeySequence.SequenceFormat = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#listToString

        **[static, since 5.1] QString QKeySequence::listToString(const
        QList<QKeySequence> & list , QKeySequence::SequenceFormat format =
        PortableText)**

        Return a string representation of **list** based on **format**.

        This function was introduced in Qt 5.1.

        **See also** **toString** () and **listFromString** ().
        """
        ...

    def matches(
        self,
        seq: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
    ) -> PySide6.QtGui.QKeySequence.SequenceMatch:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#matches

        **QKeySequence::SequenceMatch QKeySequence::matches(const QKeySequence &
        seq ) const**

        Matches the sequence with **seq**. Returns **ExactMatch**  if
        successful, **PartialMatch**  if **seq** matches incompletely, and
        **NoMatch**  if the sequences have nothing in common. Returns
        **NoMatch**  if **seq** is shorter.
        """
        ...

    @staticmethod
    def mnemonic(text: str) -> PySide6.QtGui.QKeySequence:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#mnemonic

        **[static] QKeySequence QKeySequence::mnemonic(const QString & text )**

        Returns the shortcut key sequence for the mnemonic in **text** , or an
        empty key sequence if no mnemonics are found.

        For example, mnemonic("E&xit") returns `Qt::ALT+Qt::Key_X`,
        mnemonic("&Quit") returns `ALT+Key_Q`, and mnemonic("Quit") returns an
        empty **QKeySequence** .

        We provide a **list of common mnemonics**  in English. At the time of
        writing, Microsoft and Open Group do not appear to have issued
        equivalent recommendations for other languages.
        """
        ...

    def swap(
        self,
        other: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#swap

        **void QKeySequence::swap(QKeySequence & other )**

        Swaps key sequence **other** with this key sequence. This operation is
        very fast and never fails.
        """
        ...

    def toString(self, format: PySide6.QtGui.QKeySequence.SequenceFormat = ...) -> str:
        """
        https://doc.qt.io/qt-6/qkeysequence.html#toString

        **QString QKeySequence::toString(QKeySequence::SequenceFormat format =
        PortableText) const**

        Return a string representation of the key sequence, based on **format**.

        For example, the value **Qt::CTRL** +**Qt::Key_O**  results in "Ctrl+O".
        If the key sequence has multiple key codes, each is separated by commas
        in the string returned, such as "Alt+X, Ctrl+Y, Z". The strings, "Ctrl",
        "Shift", etc. are translated using **QObject::tr** () in the
        "**QShortcut** " context.

        If the key sequence has no keys, an empty string is returned.

        On macOS, the string returned resembles the sequence that is shown in
        the menu bar if **format** is **QKeySequence::NativeText** ; otherwise,
        the string uses the "portable" format, suitable for writing to a file.

        **See also** **fromString** ().
        """
        ...
