"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QInputMethodEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qinputmethodevent.html

    **Detailed Description**

    Input method events are sent to widgets when an input method is used to
    enter text into a widget. Input methods are widely used to enter text for
    languages with non-Latin alphabets.

    Note that when creating custom text editing widgets, the
    **Qt::WA_InputMethodEnabled**  window attribute must be set explicitly
    (using the **QWidget::setAttribute** () function) in order to receive input
    method events.

    The events are of interest to authors of keyboard entry widgets who want to
    be able to correctly handle languages with complex character input. Text
    input in such languages is usually a three step process:

    1.  **Starting to Compose**

    When the user presses the first key on a
    keyboard, an input context is created. This input context will contain a
    string of the typed characters.

      2. **Composing**

    With every new key
    pressed, the input method will try to create a matching string for the text
    typed so far called preedit string. While the input context is active, the
    user can only move the cursor inside the string belonging to this input
    context.

      3. **Completing**

    At some point, the user will activate a user
    interface component (perhaps using a particular key) where they can choose
    from a number of strings matching the text they have typed so far. The user
    can either confirm their choice cancel the input; in either case the input
    context will be closed.

    QInputMethodEvent models these three stages, and transfers the information
    needed to correctly render the intermediate result. A QInputMethodEvent has
    two main parameters: **preeditString** () and **commitString** (). The
    **preeditString** () parameter gives the currently active preedit string.
    The **commitString** () parameter gives a text that should get added to (or
    replace parts of) the text of the editor widget. It usually is a result of
    the input operations and has to be inserted to the widgets text directly
    before the preedit string.

    If the **commitString** () should replace parts of the of the text in the
    editor, **replacementLength** () will contain the number of characters to be
    replaced. **replacementStart** () contains the position at which characters
    are to be replaced relative from the start of the preedit string.

    A number of attributes control the visual appearance of the preedit string
    (the visual appearance of text outside the preedit string is controlled by
    the widget only). The **AttributeType**  enum describes the different
    attributes that can be set.

    A class implementing **QWidget::inputMethodEvent** () or
    **QGraphicsItem::inputMethodEvent** () should at least understand and honor
    the **TextFormat**  and **Cursor**  attributes.

    Since input methods need to be able to query certain properties from the
    widget or graphics item, subclasses must also implement
    **QWidget::inputMethodQuery** () and **QGraphicsItem::inputMethodQuery** (),
    respectively.

    When receiving an input method event, the text widget has to performs the
    following steps:

    1. If the widget has selected text, the selected text should get removed.
    2. Remove the text starting at **replacementStart** () with length
    **replacementLength** () and replace it by the **commitString** (). If
    **replacementLength** () is 0, **replacementStart** () gives the insertion
    position for the **commitString** ().

    When doing replacement the area of
    the preedit string is ignored, thus a replacement starting at -1 with a
    length of 2 will remove the last character before the preedit string and the
    first character afterwards, and insert the commit string directly before the
    preedit string.

    If the widget implements undo/redo, this operation gets
    added to the undo stack.

      3. If there is no current preedit string, insert
    the **preeditString** () at the current cursor position; otherwise replace
    the previous **preeditString**  with the one received from this event.

    If
    the widget implements undo/redo, the **preeditString** () should not
    influence the undo/redo stack in any way.

    The widget should examine the
    list of attributes to apply to the preedit string. It has to understand at
    least the **TextFormat**  and Cursor attributes and render them as
    specified.

    **See also** **QInputMethod** .
    """

    TextFormat: QInputMethodEvent.AttributeType = ...
    Cursor: QInputMethodEvent.AttributeType = ...
    Language: QInputMethodEvent.AttributeType = ...
    Ruby: QInputMethodEvent.AttributeType = ...
    Selection: QInputMethodEvent.AttributeType = ...

    class Attribute(object):
        @overload
        def __init__(
            self, Attribute: PySide6.QtGui.QInputMethodEvent.Attribute
        ) -> None:
            ...

        @overload
        def __init__(
            self, typ: PySide6.QtGui.QInputMethodEvent.AttributeType, s: int, l: int
        ) -> None:
            ...

        @overload
        def __init__(
            self,
            typ: PySide6.QtGui.QInputMethodEvent.AttributeType,
            s: int,
            l: int,
            val: Any,
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    class AttributeType(Enum):
        TextFormat: QInputMethodEvent.AttributeType = ...
        Cursor: QInputMethodEvent.AttributeType = ...
        Language: QInputMethodEvent.AttributeType = ...
        Ruby: QInputMethodEvent.AttributeType = ...
        Selection: QInputMethodEvent.AttributeType = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethodevent.html#QInputMethodEvent-2

        **QInputMethodEvent::QInputMethodEvent()**

        Constructs an event of type **QEvent::InputMethod** . The **attributes**
        (), **preeditString** (), **commitString** (), **replacementStart** (),
        and **replacementLength** () are initialized to default values.

        **See also** **setCommitString** ().
        """
        ...

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethodevent.html#QInputMethodEvent-3

        **QInputMethodEvent::QInputMethodEvent(const QString & preeditText ,
        const QList<QInputMethodEvent::Attribute> & attributes )**

        Constructs an event of type **QEvent::InputMethod** . The preedit text
        is set to **preeditText** , the attributes to **attributes**.

        The **commitString** (), **replacementStart** (), and
        **replacementLength** () values can be set using **setCommitString** ().

        **See also** **preeditString** () and **attributes** ().
        """
        ...

    @overload
    def __init__(
        self,
        preeditText: str,
        attributes: Sequence[PySide6.QtGui.QInputMethodEvent.Attribute],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethodevent.html#QInputMethodEvent-2

        **QInputMethodEvent::QInputMethodEvent()**

        Constructs an event of type **QEvent::InputMethod** . The **attributes**
        (), **preeditString** (), **commitString** (), **replacementStart** (),
        and **replacementLength** () are initialized to default values.

        **See also** **setCommitString** ().
        """
        ...

    def attributes(self) -> List[PySide6.QtGui.QInputMethodEvent.Attribute]:
        """
        https://doc.qt.io/qt-6/qinputmethodevent.html#attributes

        **const QList<QInputMethodEvent::Attribute>
        &QInputMethodEvent::attributes() const**

        Returns the list of attributes passed to the **QInputMethodEvent**
        constructor. The attributes control the visual appearance of the preedit
        string (the visual appearance of text outside the preedit string is
        controlled by the widget only).

        **See also** **preeditString** () and **Attribute** .
        """
        ...

    def clone(self) -> PySide6.QtGui.QInputMethodEvent:
        ...

    def commitString(self) -> str:
        """
        https://doc.qt.io/qt-6/qinputmethodevent.html#commitString

        **const QString &QInputMethodEvent::commitString() const**

        Returns the text that should get added to (or replace parts of) the text
        of the editor widget. It usually is a result of the input operations and
        has to be inserted to the widgets text directly before the preedit
        string.

        **See also** **setCommitString** (), **preeditString** (),
        **replacementStart** (), and **replacementLength** ().
        """
        ...

    def preeditString(self) -> str:
        """
        https://doc.qt.io/qt-6/qinputmethodevent.html#preeditString

        **const QString &QInputMethodEvent::preeditString() const**

        Returns the preedit text, i.e. the text before the user started editing
        it.

        **See also** **commitString** () and **attributes** ().
        """
        ...

    def replacementLength(self) -> int:
        """
        https://doc.qt.io/qt-6/qinputmethodevent.html#replacementLength

        **int QInputMethodEvent::replacementLength() const**

        Returns the number of characters to be replaced in the preedit string.

        **See also** **replacementStart** () and **setCommitString** ().
        """
        ...

    def replacementStart(self) -> int:
        """
        https://doc.qt.io/qt-6/qinputmethodevent.html#replacementStart

        **int QInputMethodEvent::replacementStart() const**

        Returns the position at which characters are to be replaced relative
        from the start of the preedit string.

        **See also** **replacementLength** () and **setCommitString** ().
        """
        ...

    def setCommitString(
        self, commitString: str, replaceFrom: int = ..., replaceLength: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qinputmethodevent.html#setCommitString

        **void QInputMethodEvent::setCommitString(const QString & commitString ,
        int replaceFrom = 0, int replaceLength = 0)**

        Sets the commit string to **commitString**.

        The commit string is the text that should get added to (or replace parts
        of) the text of the editor widget. It usually is a result of the input
        operations and has to be inserted to the widgets text directly before
        the preedit string.

        If the commit string should replace parts of the of the text in the
        editor, **replaceLength** specifies the number of characters to be
        replaced. **replaceFrom** specifies the position at which characters are
        to be replaced relative from the start of the preedit string.

        **See also** **commitString** (), **replacementStart** (), and
        **replacementLength** ().
        """
        ...
